package clmedit;

import java.awt.*;
import javax.swing.*;
import java.awt.event.*;

public class DrawPanel extends JPanel{
    
    int hmarg=20*48;
    int vmarg=22*24;
    int pom=0;
    
    Point mark1 = new Point();
    Point mark2 = new Point();
    
    private int currentElement=29;
    private int currentCave=0;
    private final Image[] images = new Image[30];
    private int[][][] caveData;
    
    public void setCaveData(int[][][] data) {
        caveData=data;
    }
    
    public void setCurrentCave(int cave) {
        currentCave = cave;
        repaint();
    }
    
    public void setCurrentElement(int element) {
        currentElement= element;
        repaint();
    }
    
    public void placeCurrentElementAt(int x,int y) {
        caveData[currentCave][y][x]=currentElement;
        repaint();
    }
    
    public void paintComponent(Graphics g) {
        
        
        g.setColor(Color.black);
        g.fillRect(0,0,20*48,22*24+60);
        
        for (int y=0;y<22;y++) {
            for (int x=0;x<20;x++) {
                int elem = caveData[currentCave][y][x];
                g.drawImage(images[elem],x*48,y*24,this);
            }
        }
        
        
        /*Draw marks*/
        g.setColor(Color.yellow);
        g.drawRect(mark1.x*48+4, mark1.y*24+4, 8, 8);
        g.setColor(Color.red);
        g.drawRect(mark2.x*48+4, mark2.y*24+4, 8, 8);
        
        g.setColor(Color.white);
        g.drawString("Current:",2,vmarg+22);
        g.drawImage(images[currentElement],96,vmarg+4,this);
        g.drawRect(96,vmarg+4,48,24);
        
        g.setColor(Color.white);
        for(int i=0;i<21;i++) {
            pom=i*48;
            g.drawLine(pom,0,pom,vmarg);
        }
        for(int i=0;i<23;i++) {
            pom=i*24;
            g.drawLine(0,pom,hmarg,pom);
        }
        
        
    }
    
    public Dimension getPreferredSize() {
        Dimension r = new Dimension(20*48+1,22*24+60);
        return r;
    }
    
    public int getCurrentCave() {
        return currentCave;
    }
    
    public void initImages() {
        this.setOpaque(true);
        this.setDoubleBuffered(true);
        
        
        ImageIcon i = new javax.swing.ImageIcon(getClass().getResource("/clmedit/elBlank.png"));
        images[CalominConstants.BLANK]=i.getImage();
        
        i = new javax.swing.ImageIcon(getClass().getResource("/clmedit/elRockFull.png"));
        images[CalominConstants.ROCK_FULL]=i.getImage();
        
        i = new javax.swing.ImageIcon(getClass().getResource("/clmedit/elRockTopLeft.png"));
        images[CalominConstants.ROCK_TL]=i.getImage();
        
        i = new javax.swing.ImageIcon(getClass().getResource("/clmedit/elRockTopRight.png"));
        images[CalominConstants.ROCK_TR]=i.getImage();
        
        i = new javax.swing.ImageIcon(getClass().getResource("/clmedit/elRockBottomLeft.png"));
        images[CalominConstants.ROCK_BL]=i.getImage();
        
        i = new javax.swing.ImageIcon(getClass().getResource("/clmedit/elRockBottomRight.png"));
        images[CalominConstants.ROCK_BR]=i.getImage();
        
        i = new javax.swing.ImageIcon(getClass().getResource("/clmedit/elRockUnstable.png"));
        images[CalominConstants.ROCK_UNSTABLE]=i.getImage();
        
        i = new javax.swing.ImageIcon(getClass().getResource("/clmedit/elLadder.png"));
        images[CalominConstants.LADDER]=i.getImage();
        
        i = new javax.swing.ImageIcon(getClass().getResource("/clmedit/elDeathBottomTop.png"));
        images[CalominConstants.DEATH_BOTTOM_TOP]=i.getImage();
        
        i = new javax.swing.ImageIcon(getClass().getResource("/clmedit/elDeathTopBottom.png"));
        images[CalominConstants.DEATH_TOP_BOTTOM]=i.getImage();
        
        i = new javax.swing.ImageIcon(getClass().getResource("/clmedit/elDiamond.png"));
        images[CalominConstants.DIAMOND]=i.getImage();
        
        i = new javax.swing.ImageIcon(getClass().getResource("/clmedit/elRockBroken.png"));
        images[CalominConstants.ROCK_BROKEN]=i.getImage();
        
        i = new javax.swing.ImageIcon(getClass().getResource("/clmedit/elStartPosition.png"));
        images[CalominConstants.START_POSITION]=i.getImage();
        
        i = new javax.swing.ImageIcon(getClass().getResource("/clmedit/elInvalid.png"));
        images[CalominConstants.INVALID]=i.getImage();
        
        this.addMouseMotionListener(new MouseDrawer());
        this.addMouseListener(new MouseTicker());
        
    }
    
    public Point getMark1() {
        return mark1;
    }
    
    public Point getMark2() {
        return mark2;
    }
    
    
}


class MouseDrawer extends java.awt.event.MouseMotionAdapter {
    
    public void mouseDragged(MouseEvent e) {
        
        int x= e.getX();
        int y= e.getY();
        int gx=x/48;
        int gy=y/24;
        
        if (gx>19 || gy >21) return;
        
        DrawPanel dp = (DrawPanel)e.getSource();
        dp.placeCurrentElementAt(gx, gy);
        
        
    }
}

class MouseTicker extends java.awt.event.MouseAdapter {
    
    
    public void mouseClicked(MouseEvent e) {
        
        int x= e.getX();
        int y= e.getY();
        int gx=x/48;
        int gy=y/24;
        
        if (gx>19 || gy >21) return;
        
        DrawPanel dp = (DrawPanel)e.getSource();
        
        switch (e.getButton()) {
            case MouseEvent.BUTTON1:
                dp.placeCurrentElementAt(gx, gy);
                break;
            case MouseEvent.BUTTON2:
                Point m1 = dp.getMark1();
                m1.x=gx;
                m1.y=gy;
                dp.repaint();
                break;
            case MouseEvent.BUTTON3: {
                Point m2 = dp.getMark2();
                m2.x=gx;
                m2.y=gy;
                dp.repaint();
                break;
            }
        }
        
        
    }
    
    
}
