/*DTX Linker*/
package dtxlinker;

import java.io.*;
import java.util.HashMap;
import java.util.Set;

public class Linker {
    
    
    
    static String lastError="";
    static int lineCounter=0;
    static String outputFile=null;
    static RandomAccessFile raf=null;
    static boolean hasHeader=false;
    static final long MAX_SIZE=1024*1024;
    static HashMap symbolMap = new HashMap();
    static String lastLineBeforeSubst="";
    static String lastLineAfterSubst="";
    static String lineBuf="";
    
    /*Main*/
    public static void main(String[] args) {
        
        String linkFile="linkfile";
        
        
        
        
        if (args.length>0) {
            if (args[0].equals("-h") || args[0].equals("--help") || args[0].indexOf("?")>=0) {
                printHelp();
                return;
            }
        }
        
        if (args.length>1) {
            if (args[0].equals("-f")) {
                linkFile=args[1];
            }
        }
        
        
        
        /*Opening file*/
        FileReader fr=null;
        BufferedReader bfr=null;
        
        try {
            fr = new FileReader(linkFile);
            bfr = new BufferedReader(fr);
        }
        catch (Exception e) {
            printException(e);
            return;
        }
        
        /*File opened OK*/
        
        
        /*Read file line per line*/
        
        try {
        
            boolean b=true;
            
            
            while ( b==true && (lineBuf=bfr.readLine())!=null) {
                
                lineCounter++;
                b=true;
                lineBuf=lineBuf.trim();
                
                /*Comments are ignored*/
                if (lineBuf.startsWith("#") || lineBuf.startsWith(";") || lineBuf.startsWith("'")) continue;
                
                lastLineBeforeSubst=lineBuf;
                lineBuf=replaceSymbolsAtLine(lineBuf);
                lastLineAfterSubst=lineBuf;
                
                /*Binary file*/
                if (lineBuf.startsWith("binary:")) {
                    b=doBinary(lineBuf);
                    continue;
                }
                
                /*Data file*/
                if (lineBuf.startsWith("data:")) {
                    b=doData(lineBuf);
                    continue;
                }
                
                /*Jumps*/
                if (lineBuf.startsWith("run:") || lineBuf.startsWith("init:") || lineBuf.startsWith("runinit:")) {
                    b=doJump(lineBuf);
                    continue;
                }
                
                /*Output file*/
                if (lineBuf.startsWith("output:")) {
                    b=doOutput(lineBuf);
                    continue;
                }
                
                /*Symbol definition*/
                if (lineBuf.startsWith("symbol:")) {
                    b=doSymbol(lineBuf,false);
                    continue;
                }
                if (lineBuf.startsWith("envsymbol:")) {
                    b=doSymbol(lineBuf,true);
                    continue;
                }
                
                /*Blank lines are allowed*/
                if (lineBuf.equals("")) continue;
                
                /*Invalid line*/
                lastError="Syntax error";
                printError();
                break;
                
            
            }
            if (b==false) printError();
        }
        catch(Exception e) {
            printException(e);
            try {
                if (raf!=null) raf.close();
                bfr.close();
            }
            catch(Exception e1) {
                printException(e1);
            }
            finally {
                return;
            }
                
        }
        
        /*Close file*/
        try {
             bfr.close();
        }
        catch(Exception e1) {
             printException(e1);
        }
        
        
    }
    
  
    
    
    static boolean doBinary(String line) {
        if (raf==null) {
            lastError="Error: 'binary' line reached, but no output file was specified before";
            return false;
        }
        
        long ln=0;
        
        line=line.replaceFirst("binary:","");
        line=line.trim();
        RandomAccessFile df=null;
        try {
            df = new RandomAccessFile(line,"r");
            ln = df.length();
            if ( ln>MAX_SIZE) {
                lastError="Error: Binary file '"+outputFile+"' is too large";
                df.close();
                return false;
            }
            if (ln<4) {
                lastError="Error: Binary file '"+outputFile+" is too small";
                df.close();
                return false;
            }
            
        }
        catch(Exception e) {
            lastError="Error: Unable to open data file: '"+line+"'";
            return false;
        }
        
        try {
            /*Eventually write header*/
            if (hasHeader==false) {
                
                    int b1,b2;
                    
                    b1=df.read();
                    b2=df.read();
                    df.seek(0L);
                    if (b1!=255 || b2!=255) {
                        raf.writeByte(255);
                        raf.writeByte(255);
                        
                    }
                    hasHeader=true;
                
            }
            /*Write data*/
            byte[] buffer = new byte[(int)df.length()];
            df.readFully(buffer);
            df.close();
            raf.write(buffer);
            
        }
        catch(Exception e) {
            lastError="Error: Unable to write data";
            return false;
        }
        
        
        return true;
    }
    
    /**Appends data file*/
    static boolean doData(String line) {
        if (raf==null) {
            lastError="Error: 'data' line reached, but no output file was specified before";
            return false;
        }
        
        line=line.replaceFirst("data:","");
        line=line.trim();
        
        int dataAddress=0;
        long ln=0;
        
        /*Parse address*/
        try {
            int i=line.indexOf(",");
            String addr=line.substring(0,i);
            line=line.substring(i+1);
            line=line.trim();
            addr=addr.trim();
            int radix=10;
            if (addr.startsWith("$")) {radix=16;addr=addr.substring(1);}
            dataAddress=Integer.parseInt(addr,radix);
            
        }
        catch (Exception nfe) {
            lastError="Error: Malformed pair address,data file name";
            return false;
        }
        
        RandomAccessFile df=null;
        try {
            df = new RandomAccessFile(line,"r");
            if ( (ln=df.length())>1024*1024) {
                lastError="Error: Data file is too large";
                df.close();
                return false;
            }
            
        }
        catch(Exception e) {
            lastError="Error: Unable to open data file: '"+line+"'";
            return false;
        }
        
        try {
            /*Check size*/
            
            /*Eventually write header*/
            if (hasHeader==false) {
                raf.writeByte(255);
                raf.writeByte(255);
                hasHeader=true;
            }
            
            raf.writeByte(dataAddress % 256);
            raf.writeByte(dataAddress / 256);
            raf.writeByte((dataAddress+(int)ln-1)%256);
            raf.writeByte((dataAddress+(int)ln-1)/256);
            
            /*Write data*/
            byte[] buffer = new byte[(int)df.length()];
            df.readFully(buffer);
            df.close();
            raf.write(buffer);
            
        }
        catch(Exception e) {
            lastError="Error: Unable to write data";
            return false;
        }
        
        
        return true;
    }
    
    static boolean doJump(String line) {
        if (outputFile==null) {
            lastError="Error: 'jump' line reached, but no output file was specified before";
            return false;
        }
        
        try {
        
            if (hasHeader==false) {
            
                raf.writeByte(255);
                raf.writeByte(255);
                hasHeader=true;
            }
            
            int jump1=0;
            int jump2=0;
            String adr1,adr2;
            
            /*Examine what jump*/
            if (line.startsWith("runinit:")) {
                line=line.replaceFirst("runinit:","");
                line=line.trim();
                try {
                    int i = line.indexOf(',');
                    adr1=line.substring(0,i);
                    adr2=line.substring(i+1,line.length());
                    adr1=adr1.trim();
                    adr2=adr2.trim();
                    int radix1=10;
                    int radix2=10;
                    if (adr1.startsWith("$")) {adr1=adr1.substring(1);radix1=16;}
                    if (adr2.startsWith("$")) {adr2=adr2.substring(1);radix2=16;}
                    jump1=Integer.parseInt(adr1,radix1);
                    jump2=Integer.parseInt(adr2,radix2);
                    
                }
                catch (Exception nfe) {
                    lastError="Error: Malformed jump address";
                    return false;
                }
                raf.writeByte(736 % 256);
                raf.writeByte(736 / 256);
                raf.writeByte(739 % 256);
                raf.writeByte(739 / 256);
                raf.writeByte(jump1 % 256);
                raf.writeByte(jump1 / 256);
                raf.writeByte(jump2 % 256);
                raf.writeByte(jump2 / 256);
            }
            else {
                if (line.startsWith("run:")) {
                    jump2=736;line=line.replaceFirst("run:","");
                }
                if (line.startsWith("init:")) {
                    jump2=738;line=line.replaceFirst("init:","");
                }
                
                try {
                
                    line=line.trim();
                    int radix=10;
                    if (line.startsWith("$")) {radix=16;line=line.substring(1);}
                    jump1=Integer.parseInt(line,radix);
                    raf.writeByte(jump2 % 256);
                    raf.writeByte(jump2 / 256);
                    raf.writeByte((jump2+1) % 256);
                    raf.writeByte((jump2+1) / 256);
                    raf.writeByte(jump1 % 256);
                    raf.writeByte(jump1 / 256);
                }
                
                 catch (Exception nfe) {
                    lastError="Error: Malformed jump address";
                    return false;
                }
                    
            }
            
            
        }
        catch(Exception e) {
            lastError="Error: Unable to write data";
            return false;
        }
        
        return true;
    }
    
    /**Assigns new output file*/
    static boolean doOutput(String line) {
        line=line.replaceFirst("output:","");
        line=line.trim();
        try {
            if (raf!=null) raf.close();
            }
        catch(Exception e) {
            lastError="Error: Unable to close file";
            return false;
        }
        finally {
            raf=null;
        }
        
        try {
            hasHeader=false;
            outputFile=line;
            raf = new RandomAccessFile(outputFile,"rw");
            raf.setLength(0L);
            raf.seek(0L);
        }
        catch(Exception e) {
            lastError="Error: Unable to open output file: '"+outputFile+"'";
            return false;
        }
        
        return true;
    }
    
    static boolean doSymbol(String s,boolean fromEnv) {
        if (fromEnv==false) {
            s=s.replaceFirst("symbol:","");
        }
        else {
            s=s.replaceFirst("envsymbol:","");
        }
        
        s=s.trim();
        
        String key=null;
        String value=null;
        
        try {
            int i = s.indexOf("=");
            key=s.substring(0,i);
            if (fromEnv==false) {
                value=s.substring(i+1);
            }
            else {
                value=System.getenv(s.substring(i+1));
            }
            
        }
        catch(Exception e) {
            lastError="Error: Invalid symbol assignment";
            return false;
        }
        
        /*Key and value is ok*/
        if (key!=null && value!=null) {
            symbolMap.put(key,value);
            return true;
        }
        
        lastError="Error: General problem in symbol assignment";
        return false;
        
    }
    
    
    static void printError() {
        StringBuffer sb = new StringBuffer();
        sb.append(lineCounter);
        sb.append(':');
        sb.append(lastError);
        System.out.println(sb.toString());
        System.out.println(lastLineBeforeSubst);
        if ( !(lastLineBeforeSubst.equals(lastLineAfterSubst))) {
            System.out.println(lastLineAfterSubst);
        }
    }
    
    /*Check whether param is present*/
    static boolean checkParam(String s,String[] args) {
        int l = args.length;
        for(int i=0;i<l;i++) {
            if (args[i].equals(s)) return true;
        }
        return false;
    }
    
    static void printException(Exception e) {
        String s1 = e.toString();
        String s2= "";
        if (e.getMessage()!=null) s2=s1.concat(System.getProperty("line.separator")).concat(e.getMessage());
        System.out.println(e);
        
    }
    
    static void printHelp() {
        System.out.println("dtxlinker (PD) 2008 BAKTRA Software");
        System.out.println("program for linking Atari DOS 2 executables");
        System.out.println();
        System.out.println("Usage:");
        System.out.println("java -jar dtxlinker.jar             Link using 'linkfile' in current directory");
        System.out.println("java -jar dtxlinker.jar -f myfile   Link using 'myfile' in current directory");
        System.out.println("java -jar dtxlinker.jar -h          Show this help");
        System.out.println();
        System.out.println("See linkfile.txt inside jar archive to get information about linkfile format");
    }
    
    public static String replaceElements(String s,String what,String replacement) {
        
        int whatLength=what.length();
        int idx=-1;
        
        StringBuffer sb = new StringBuffer();
       
        /*Pokud to co hledame nema zadnou delku, tak je to nesmysl a vraci
         *se vstupni retezec
         */
        if (what.length()==0) return sb.toString();
        
        /**Maximalne cela smycka probehne 1000x*/
        int iterations=0;
        
        while (s.length()>0 && iterations<1000) {
            
            iterations++;
            
            /*V idx je index prvniho pismenka what*/
            idx=s.indexOf(what);
            
            /*Kdyz tam neni, tak pridame cely zbytek a skoncime*/
            if (idx==-1) {
                sb.append(s);
                break;
            }
            /*Do bufferu dame vsechno co je predtim, coz muze byt i nic*/
            sb.append(s.substring(0,idx));
            /*Z retezce vyhodime co jsme dali do buffer + what, vzdycky to
             dopadne dobre*/
            s=s.substring(idx+whatLength);
            /*Do bufferu dame nahrazeny retezec*/
            sb.append(replacement);
                    
        }
        
        
        return sb.toString();
    }
    
    static String replaceSymbolsAtLine(String line) {
        
        String key;
        String value;
        
        Set kset = symbolMap.keySet();
        
        Object[] ka = kset.toArray();
        int l = ka.length;
        
        for(int i=0;i<l;i++) {
            key=(String)ka[i];
            value=(String)symbolMap.get(key);
            key="${"+key+"}";
            line=replaceElements(line,key,value);
        }
        
        return line;
        
    }
    
}
