; Altirra BASIC
; Copyright (C) 2014 Avery Lee, All Rights Reserved.
;
; Copying and distribution of this file, with or without modification,
; are permitted in any medium without royalty provided the copyright
; notice and this notice are preserved.  This file is offered as-is,
; without any warranty.

		opt		m-
		opt		c+

		icl		'vsystem.inc'
		icl		'tokens.inc'
		icl		'vhost.inc'

;===========================================================================
; Zero page variables
;
; We try to be sort of compatible with Atari BASIC here, supporting all
; public variables and trying to support some unofficial usage as well.
;
; Test cases:
;	QUADRATO.BAS
;	- Uses $B0-B3 from USR() routine

		org		$0080
		opt		o-
argstk	equ		*
lomem	dta		a(0)		;$0080 (compat) from lomem; argument/operator stack
vntp	dta		a(0)		;$0082 (compat - loaded) variable name table pointer
vntd	dta		a(0)		;$0084 (compat - loaded) variable name table end
vvtp	dta		a(0)		;$0086 (compat - loaded) variable value table pointer
stmtab	dta		a(0)		;$0088 (compat - loaded) statement table pointer
stmcur	dta		a(0)		;$008A (compat - loaded) current statement pointer
starp	dta		a(0)		;$008C (compat - loaded) string and array table
runstk	dta		a(0)		;$008E (compat) runtime stack pointer
memtop2	dta		a(0)		;$0090 (compat) top of BASIC memory

exLineOffset	dta		0		;offset within current line being executed
exLineOffsetNxt	dta		0		;offset of next statement
exLineEnd		dta		0		;offset of end of current line
exTrapLine		dta		a(0)	;TRAP line
exFloatStk		dta		0		;bit 7 set if stack is floating (line numbers)
opsp		dta		0		;operand stack pointer offset
argsp		dta		0		;argument stack pointer offset
expCommas	dta		0		;expression evaluator comma count
expFCommas	dta		0
expAsnCtx	dta		0		;flag - set if this is an assignment context for arrays
expType		dta		0		;bit 7 = 0 for numeric, 1 for string
varptr		dta		a(0)	;pointer to current variable
lvarptr		dta		a(0)	;lvar pointer for array assignment
parptr		dta		a(0)	;parsing state machine pointer
parout		dta		0		;parsing output idx
expCurOp	= parout		;expression evaluator current operator
expCurPrec	dta		0		;expression evaluator current operator precedence
iocbexec	dta		0		;current immediate/deferred mode IOCB
iocbidx		dta		0		;current IOCB*16
iocbidx2	dta		0		;current IOCB (used to distinguish #0 and #16)
iterPtr		dta		a(0)	;pointer used for sequential name table indexing
ioPrintCol	dta		0		;IO: current PRINT column
ioTermSave	dta		0		;IO: String terminator byte save location
ioTermOff	dta		0		;IO: String terminator byte offset
argstk2		dta		a(0)	;Evaluator: Second argument stack pointer
dataLnEnd	dta		0		;current DATA statement line end

		.if grColor!=$c8
		.error "Graphics color is at ",grColor," but must be at $C8 for PEEK(200) to work (see Space Station Multiplication.bas)"
		.endif

		.if *>$ba
		.error "Zero page overflow: ",*
		.endif

stopln	= $ba				;(compat - Atari BASIC manual): line number of error
		; $bb
		
;--------------------------------------------------------------------------
; $BC-BF are reserved as scratch space for use by the currently executing
; statement or by the parser. They must not be used by functions or library
; code.
;
			org		$bc
stScratch	dta		0
stScratch2	dta		0
stScratch3	dta		0
stScratch4	dta		0

printDngl	= stScratch		;set if the print statement is 'dangling' - no follow EOL
parStrType	= stScratch		;parsing string type: set if string exp, clear if numeric
parStBegin	= stScratch2	;parsing offset of statement begin (0 if none)

;--------------------------------------------------------------------------
; $C0-C1 are reserved as scratch space for use by the currently executing
; function.
;
funScratch1	= $c0
funScratch2	= $c1
;--------------------------------------------------------------------------
errno	= $c2
errsave	= $c3				;(compat - Atari BASIC manual): error number

			org		$c4
dataln		dta		a(0)	;current DATA statement line
dataptr		dta		a(0)	;current DATA statement pointer
grColor		dta		0		;graphics color (must be at $C8 for Space Station Multiplication)
ptabw		dta		0		;(compat - Atari BASIC manual): tab width
dataoff		dta		0		;current DATA statement offset

.if ptabw != $C9
			.error	"PTABW is wrong"
.endif

.if * > $CB
.error "$CB-D1 are reserved"
.endif

;--------------------------------------------------------------------------
; $CB-D1 are reserved for use by annoying people that read Mapping The
; Atari.
;--------------------------------------------------------------------------
; Floating-point library vars
;
; $D2-D3 is used as an extension prefix to FR0; $D4-FF are used by the FP
; library, but can be reused outside of it.
;
prefr0	= fr0-2
a0		= fr0				;temporary pointer 0
a1		= fr0+2				;temporary pointer 1
a2		= fr0+4				;temporary pointer 2
a3		= fr0+6				;temporary pointer 3
a4		= fr0+8				;temporary pointer 4
a5		= fr0+10			;temporary pointer 5

degflg	= $fb				;(compat) degree/radian flag: 0 for radians, 6 for degrees

lbuff	equ		$0580

.macro _ERROR_RETURN
		jmp		errorBadRETURN
.endm

.macro _STATIC_ASSERT
		.if :1
		.else
		.error ":2"
		.endif
.endm

;==========================================================================
; Cartridge start
;
		opt		h-
		org		$0600
		opt		o+f+

;==========================================================================
.proc ApertureCopy
		pha
		lda.w	#[VRV_HIGH*$100]
		trb		veronica_ctl-1
		pla
		mvn		0,0
		lda.w	#[VRV_HIGH*$100]
		tsb		veronica_ctl-1
		rts
.endp

;==========================================================================
		org		$06ff
		dta		0
		opt		f-
		org		$c000
		opt		f+
		jmp		main

;==========================================================================

		icl		'parserbytecode.s'

;==========================================================================
; Message base
;
.pages 1
msg_base:
msg_ready:
		dta		$9B,c'Ready',$9B,0

msg_stopped:
		dta		$9B,c"Stopped",0

msg_error:
		dta		$9B
msg_error2:
		dta		c"Error-   ",0

msg_atline:
		dta		' at line ',0
.endpg

;==========================================================================
; Entry point
;
; This can be skipped by the loader if a command line load is requested,
; so this must be replaced by the load path.
;
main:
		;switch to native mode
		clc
		xce

		;init I/O
		ldx		#0
		stx		iocbidx
		
		;check if this is a warm start
;		bit		warmst
;		bmi		immediateMode

		;reset zero page
		ldx		#0
		stz:rne	0,x+

		;reset memtop
		mwa		#$bfff memtop

		dec		brkkey
		
		jmp		stNew
;==========================================================================
immediateModeReset:
		jsr		ExecReset
immediateMode:
		;use IOCB #0 (E:) for commands
		stz		iocbexec
.proc execLoop
loop:
		;display prompt
		stz		iocbidx
		ldx		#<msg_ready
		jsr		IoPrintMessage

loop2:	
		;reset stack
		rep		#$10
		ldx.w	#$01ff
		txs
		sep		#$10
	
		;read line
		ldx		iocbexec
		jsr		IoSetupReadLine
		jsr		ciov816
		
		;check if we got an EOF
		cpy		#$88
		beq		eof
		
		tya
		jsr		ioCheck
		
		;check for an empty line
		jsr		fp_ldbufa
		mva		#0 cix
		jsr		fp_skpspc
		lda		(inbuff),y
		cmp		#$9b
		beq		loop2
		
		;float the stack if it isn't already
		jsr		ExecFloatStack

		;##TRACE "Parsing immediate mode line: [%.*s]" dw(icbll) lbuff
		jsr		parseLine
		bcc		loop2
		
		;check if this line was immediate mode
		ldy		#1
		lda		(stmcur),y
		bpl		loop2
		
		;execute immediate mode line
		sec
		jmp		exec
		
eof:
		;close IOCB #7
		jsr		IoCloseX
		
		;restart in immediate mode
		jmp		immediateMode
.endp

;==========================================================================

		icl		'parser.s'
		icl		'comm.s'
		icl		'exec.s'
		icl		'data.s'
		icl		'statements.s'
		icl		'evaluator.s'
		icl		'functions.s'
		icl		'variables.s'
		icl		'math.s'
		icl		'io.s'
		icl		'memory.s'
		icl		'list.s'
		icl		'error.s'
		icl		'util.s'

;==========================================================================

const_table = $F7FA - 4 - 6*7 - 7

		.echo	"Main program ends at ",*," (",[((((*-$c000)*100/$3800)/10)*16+(((*-$c000)*100)/$3800)%10)],"% full) (", const_table-*," bytes free)"

		org		const_table
		.echo	"Constant table begins at ",*
		.pages 1

devname_c:
		dta		'C'
devname_s:
		dta		'S'
devname_e:
		dta		'E'
devname_p:
		dta		'P'
devpath_d1all:
		dta		'D1:*.*',$9B

angle_conv_tab:
		.fl		1.57079633
		.fl		90

const_one:
		.fl		1.0
const_negone:
		.fl		-1.0
const_half:
		.fl		0.5
fpconst_neg_pi2:
		.fl		-1.5707963267949
fp_180_div_pi:
		.fl		57.295779513082

		.endpg

		org		$F7FA
		jmp		ErrorCOPHandler
		jmp		main

		end
