; Veronica BASIC - host communications module
; Copyright (C) 2015 Avery Lee, All Rights Reserved.
;
; Copying and distribution of this file, with or without modification,
; are permitted in any medium without royalty provided the copyright
; notice and this notice are preserved.  This file is offered as-is,
; without any warranty.

;==========================================================================
.macro _COMM_PEEKMESSAGE
		bit		COMM_OFFSET+comm_req
		bpl		no_msg
		jsr		CommDispatchInterrupt
no_msg:
.endm

;==========================================================================
.proc CommDispatchInterrupt
		phy
		phx
		ldx		COMM_OFFSET+comm_req
		jsr		(comm_dispatch_table-$80,x)
		stz		COMM_OFFSET+comm_req
		plx
		ply
		lda		#VRV_SEMA
		trb		veronica_ctl
		rts
.endp

;==========================================================================
.proc CommBeginMessage
		inc		COMM_OFFSET+comm_attn
wait_loop:
		_COMM_PEEKMESSAGE
		bit		COMM_OFFSET+comm_attn
		bpl		wait_loop
		
		;clear the attention flag
		stz		COMM_OFFSET+comm_attn
		rts
.endp

;==========================================================================
CommAckReply = CommPostMessage
.proc CommPostMessage
		;assert the semaphore to post the message (go low from our side)
		lda		#VRV_SEMA
		trb		veronica_ctl
		rts
.endp

;==========================================================================
.proc CommSendMessage
		jsr		CommPostMessage
.def :CommWaitReply
		;wait for semaphore to deassert (go high from our side)
wait_loop:
		_COMM_PEEKMESSAGE
		bit		veronica_ctl
		bpl		wait_loop
		rts
.endp

;==========================================================================
.proc CommPostMessageV
		pha
		phx

		sep		#$30
		jsr		CommBeginMessage
		rep		#$30

		plx
		stx		COMM_OFFSET+comm_hostrout
		ply
		beq		no_payload

		;pull return address and save in X
		plx

		;pop from stack to comm buffer (note reverse order!)
		sep		#$20
pop_loop:
		pla
		dey
		sta		COMM_OFFSET+comm_buffer,y
		bne		pop_loop

		;push return address back on stack
		phx

no_payload:
		sep		#$30
		bra		CommPostMessage
.endp

;==========================================================================
.proc comm_dispatch_table
		dta		a(CommHandlerBreak)			;$01
.endp

;==========================================================================
.proc CommHandlerBreak
		mva		#0 brkkey
		rts
.endp
