		icl		'system.inc'

		org		$B800
		opt		f+h-
comm_buffer:
		dta		0

		org		$BA80

comm_req	dta		0

;==========================================================================
.proc MainLoop
on_break:
		;reset break
		lda		#$ff
		sta		brkkey

		lda		#$80
		sta		comm_req

		lda		veronica_ctl
		eor		#$02
		jsr		CommSendInterrupt

loop:
		;check for break
		lda		brkkey
		bpl		on_break


		;swap memory banks
		lda		veronica_ctl
		tay
		eor		#VRA_SWAP
		sta		veronica_ctl
		
		;check if attention flag is set
		ldx		#0
comm_attn = *-1
		beq		loop
		
		;ACK and push back
		sec
		ror		comm_attn
		
		sty		veronica_ctl
		
		;wait for semaphore to activate
		bit:rpl	veronica_ctl
		
		;swap back to request window, but leave semaphore on
		ora		#$80
		sta		veronica_ctl
		and		#$7f

		;execute the request
		pha
		jsr		$0100
comm_hostrout = *-2
		pla

		;clear the semaphore and swap the window back
		sta		veronica_ctl
		jmp		loop
.endp

;==========================================================================
.proc CommWaitACK
		;clear the semaphore and swap the window back
		lda		veronica_ctl
		eor		#$82
.def :CommSendInterrupt
		sta		veronica_ctl

		;wait for semaphore to go high again
		lda:rpl	veronica_ctl

		;clear the semaphore
		and		#$7f
		sta		veronica_ctl

		;exit
		rts
.endp

;==========================================================================
comm_HandleDPOKE:
		lda		#0
comm_dpokedata = *-1
		sta		$0100
comm_dpokeaddr = *-2
comm_HandlePOKE:
		lda		#0
comm_pokedata = *-1
		sta		$0100
comm_pokeaddr = *-2
		rts

;==========================================================================
comm_HandlePEEK:
		lda		$0100
comm_peekaddr = *-2
		sta		comm_buffer
		jmp		CommWaitACK

;==========================================================================
.nowarn .proc comm_HandleCIOV
		;copy request to IOCB
		ldy		comm_buffer

		mva		comm_buffer+1 iccmd,y
		mwa		#comm_buffer+16 icbal,y

		ldx		#6
copyloop1:
		lda		comm_buffer+1,x
		sta		icbll,y
		inx
		iny
		cpx		#8
_copylimit = *-1
		bne		copyloop1

		;call CIOV
		ldx		comm_buffer
finish:
		jsr		ciov

		;store status and char
		sta		comm_buffer+15
		sty		comm_buffer+1+[icsta-iccmd]

		;copy back length
		mwa		icbll,x comm_buffer+1+[icbll-iccmd]

		;wait for ACK and then exit
		jmp		CommWaitACK
.endp

comm_ciov_copylimit = comm_HandleCIOV._copylimit

;==========================================================================
comm_HandleGet:
		ldx		comm_buffer
		lda		#0
		sta		icbll,x
		sta		icblh,x
		lda		#CIOCmdGetChars
		sta		iccmd,x
		bne		comm_HandleCIOV.finish

;==========================================================================
.nowarn .proc comm_HandleBigIO
		ldx		comm_buffer

		;copy trampoline down into page zero
		ldx		#copyrout_end-copyrout_begin-1
		mva:rpl	copyrout_begin,x fr0,x-

bigio_loop:
		;send the window across, wait for a request to arrive
		;clear the semaphore and swap the window back
		lda		veronica_ctl
		tay
		eor		#$82
		sta		veronica_ctl
		lda:rpl	veronica_ctl
		eor		#$02
		sta		veronica_ctl

		;check if the command is valid
		lda		comm_buffer+2
		beq		done

		;set up the IOCB
		ldx		comm_buffer
		sta		iccmd,x

		mwa		#$a000 icbal,x
		mwa		comm_buffer+3 icbll,x

		;invoke CIOV through trampoline with aperture open
		lda		veronica_ctl
		and		#[$FF-VRA_HIGH]
		jsr		fr0

		;save status+length
		mwa		icbll,x comm_buffer+3
		sty		comm_buffer+1

		;loop back to wait for another request
		jmp		bigio_loop

done:
		rts

copyrout_begin:
		sta		veronica_ctl
		pha
		jsr		ciov
		pla
		eor		#VRA_HIGH
		sta		veronica_ctl
		rts
copyrout_end:
.endp

;==========================================================================
.nowarn .proc comm_HandlePutchar
		jsr		do_put
		sta		comm_buffer+1
		sty		comm_buffer+2
		jmp		CommWaitACK

do_put:
		ldx		#0
_iocb = *-1
		lda		icax1,x
		sta		icax1z
		lda		icpth,x
		pha
		lda		icptl,x
		pha
		lda		#0
_char = *-1
		sta		ciochr
		rts
.endp

;==========================================================================
comm_HandleSound:
		ldx		#0
comm_sound_offset = *-1
		lda		#0
comm_sound_freq = *-1
		sta		audf1,x
		lda		#0
comm_sound_ctl = *-1
		sta		audc1,x

		;force all audio channels to 64K clock and unlinked
		mva		#0 audctl

		;force off asynchronous mode so that channels 3 and 4 work
		mva		#3 skctl
		rts

;==========================================================================
comm_HandleSetColor:
		lda		#0
comm_setcolor_color = *-1
		ldx		#0
comm_setcolor_offset = *-1
		sta		color0,x
		rts

;==========================================================================
comm_HandlePlot:
		jsr		comm_HandlePosition
		mva		#$60 comm_HandlePutchar._iocb
		mva		comm_buffer+4 comm_HandlePutchar._char
		jmp		comm_HandlePutchar

;==========================================================================
comm_HandleDrawto:
		jsr		comm_HandlePosition
		mva		comm_buffer+4 atachr
		ldx		#$60
		mva		#$11 iccmd,x
		jsr		ciov
		sty		comm_buffer+2
		jmp		CommWaitACK

;==========================================================================
comm_HandleLocate:
		jsr		comm_HandlePosition
		ldx		#$60
		lda		#0
		sta		icbll,x
		sta		icblh,x
		mva		#CIOCmdGetChars iccmd,x
		jsr		ciov
		sta		comm_buffer+1
		sty		comm_buffer+2
		jmp		CommWaitACK

;==========================================================================
comm_HandlePosition:
		mva		comm_buffer+1 colcrs
		mva		comm_buffer+0 colcrs+1
		mva		comm_buffer+2 rowcrs
		rts

;==========================================================================
.nowarn .proc comm_HandleRandom
		;we need 5 bytes below 200
		ldy		#5
rloop:
		lda		random
		cmp		#200
		bcs		rloop
		dey
		sta		comm_buffer,y
		bne		rloop
		jmp		CommWaitACK
.endp

;==========================================================================
.nowarn .proc comm_HandleUsr
		lda		comm_buffer+2
		asl
		tax
arg_loop:
		lda		comm_buffer+2,x
		pha
		dex
		bpl		arg_loop
		jsr		dispatch

		mwa		fr0 comm_buffer
		jmp		CommWaitACK

dispatch:
		jmp		(comm_buffer)
.endp

;==========================================================================
.nowarn .proc comm_HandleExecReset
		ldx		#7
		lda		#0
		sta:rpl	audf1,x-
		rts
.endp

;==========================================================================
comm_HandleSetList:
		lda		#0
comm_setlist_data = *-1
		sta		dspflg
		rts

;==========================================================================
.nowarn .proc comm_HandleDos
		jmp		(dosvec)
.endp

;==========================================================================
.nowarn .proc comm_HandleBye
		ldx		#stub_end-stub_start-1
		mva:rpl	stub_start,x fr0,x-
		lda		#>[blkbdv-1]
		pha
		lda		#<[blkbdv-1]
		pha
		txa
		jmp		fr0

stub_start:
		sta		veronica_ctl
		rts
stub_end:
.endp
		

;==========================================================================
		.echo	"Host resident section end: ",*

		org		$BFE1
		jmp		$FFE1			;FFE1 - hang insn
		dta		a($F7FA)		;FFE4 - native COP vector
		dta		a($FFE1)		;FFE6 - native BRK vector
		org		$BFFC
		dta		a($F7FD)


;==========================================================================
; Communication section
;
comm_boot		= MainLoop.loop
comm_attn		= MainLoop.comm_attn
comm_hostrout	= MainLoop.comm_hostrout
comm_putchar_iocb	 = comm_HandlePutchar._iocb
comm_putchar_char	 = comm_HandlePutchar._char
