; Altirra BASIC
; Copyright (C) 2014 Avery Lee, All Rights Reserved.
;
; Copying and distribution of this file, with or without modification,
; are permitted in any medium without royalty provided the copyright
; notice and this notice are preserved.  This file is offered as-is,
; without any warranty.

		opt		m-

		icl		'system.inc'
		icl		'vhost.inc'

;===========================================================================
; Zero page variables
;
; We try to be sort of compatible with Atari BASIC here, supporting all
; public variables and trying to support some unofficial usage as well.
;
; Test cases:
;	QUADRATO.BAS
;	- Uses $B0-B3 from USR() routine

		org		$0080
		opt		o-
argstk	equ		*
lomem	dta		a(0)		;$0080 (compat) from lomem; argument/operator stack
vntp	dta		a(0)		;$0082 (compat - loaded) variable name table pointer
vntd	dta		a(0)		;$0084 (compat - loaded) variable name table end
vvtp	dta		a(0)		;$0086 (compat - loaded) variable value table pointer
stmtab	dta		a(0)		;$0088 (compat - loaded) statement table pointer
stmcur	dta		a(0)		;$008A (compat - loaded) current statement pointer
starp	dta		a(0)		;$008C (compat - loaded) string and array table
runstk	dta		a(0)		;$008E (compat) runtime stack pointer
memtop2	dta		a(0)		;$0090 (compat) top of BASIC memory

iocbidx	dta		0

lbuff	= $580
coldsv	= $e477

;==========================================================================
; EXE loader start
;
		org		$2800
		opt		o+
		
;==========================================================================
; Preloader
;
; The preloader executes before the main load.

.proc __preloader
		;check if BASIC is on
		jsr		__testROM
		beq		basic_ok
		
		;try to turn basic off
		lda		#0
		sta		basicf
		lda		portb
		ora		#2
		sta		portb

		;check again if BASIC is on
		jsr		__testROM
		beq		basic_ok

		;print failure
		mwa		#msg_romconflict_begin icbal
		mwa		#msg_romconflict_end-msg_romconflict_begin icbll
		mva		#CIOCmdPutChars iccmd
		ldx		#0
		jsr		ciov

wait_exit:
		lda		#$ff
		cmp:req	ch
		sta		ch

		;exit
		jmp		(dosvec)
		
basic_ok:
		;print loading banner and continue disk load
		mwa		#msg_loading_begin icbal
		mwa		#msg_loading_end-msg_loading_begin icbll
		mva		#CIOCmdPutChars iccmd
		ldx		#0
		jmp		ciov

msg_loading_begin:
		dta		'Loading Veronica BASIC...'
msg_loading_end:

msg_romconflict_begin:
		dta		$9B
		dta		'Cannot load Veronica BASIC: another',$9B
		dta		'ROM is already present at $A000.',$9B
		dta		$9B
		dta		'If you are running under SpartaDOS X,',$9B
		dta		'use the X command to run VBasic.',$9B
		dta		$9B
		dta		'Press a key',$9B
msg_romconflict_end:
.endp

;--------------------------------------------------------------------------
; Exit:
;	Z=0: Not writable
;	Z=1: Writable
;
.proc __testROM
		lda		$a000
		tax
		eor		#$ff
		sta		$a000
		cmp		$a000
		stx		$a000
		rts		
.endp

;--------------------------------------------------------------------------

		ini		__preloader


.macro _LOADER_DEBUG
.if 0
		php
		pha
		tya
		pha

		mva		#":1" (savmsc),y

		lda		rtclok+2
		eor		#$80
		cmp:rne	rtclok+2

		pla
		tay
		pla
		plp
.endif
.endm

;--------------------------------------------------------------------------
.proc __loader
		;reset RAMTOP if it is above $A000
		lda		#$a0
		cmp		ramtop
		bcs		ramtop_ok

adjust_ramtop:
		sta		ramtop
		
		;reinitialize GR.0 screen if needed (XEP80 doesn't)
		lda		sdmctl
		and		#$20
		beq		dma_off
		
		jsr		wait_vbl

		ldx		#0
		stx		dmactl
		stx		sdmctl
		lda		#4
		cmp:rcc	vcount
		mva		#CIOCmdClose iccmd
		jsr		ciov

		mva		#CIOCmdOpen iccmd
		mwa		#editor icbal
		mva		#$0c icax1
		mva		#$00 icax2
		ldx		#0
		jsr		ciov

		;Wait for a VBLANK to ensure that the screen has taken place;
		;we don't just use RTCLOK because we need to ensure that stage
		;2 VBLANK has been run, not just stage 1.
		jsr		wait_vbl
dma_off:
ramtop_ok:

		_LOADER_DEBUG "T"

		;set a flag indicating that we're on try 1
		mva		#$80 fr0

retry_cart:
		;Reset Veronica cartridge and enable $A000-BFFF window.
		sei
		mva		#VRA_WINA|VRA_HIGH veronica_ctl

		;stupid farking XL/XE OS cartridge check -- disable trigger
		;latching, and then update GINTLK from TRIG3
		mva		#0 gractl
		mva		trig3 gintlk
		cli

		_LOADER_DEBUG "G"

		;write signature bytes to $A000; we use the loading banner, but the
		;contents are not super-important
		ldx		#13
		mva:rpl	loadermsg_banner,x $A000,x-

		;switch banks and write inverted
		mva		#VRA_WINA veronica_ctl
		ldx		#13
testloop2:
		lda		loadermsg_banner,x
		eor		#$80
		sta		$A000,x
		dex
		bpl		testloop2

		;swap back and check original signature
		mva		#VRA_WINA|VRA_HIGH veronica_ctl
		ldx		#13
chkloop:
		lda		$A000,x
		cmp		loadermsg_banner,x
		beq		chkok

		;uh oh....
veronica_fail:
		_LOADER_DEBUG "F"

		;check if we're on the first try -- if so, we might be on U1MB with
		;SDX enabled. Try disabling SDX and enabling the external cart.

		asl		fr0
		bcc		veronica_fail2

		lda		#$80
		sta		$d5e0
		bne		retry_cart

veronica_fail2:

		mwa		#loadermsg_veronicafail icbal
		mwa		#[.len loadermsg_veronicafail] icbll
		mva		#CIOCmdPutChars iccmd
		ldx		#0
		jsr		ciov
		jmp		__preloader.wait_exit

chkok:
		dex
		bpl		chkloop

		_LOADER_DEBUG "0"

		;okay, we think we have a Veronica cartridge -- upload the bootstrap
		ldy		#0
bootstrap_loop:
		mva		bootstrap_start+$100,y $BE00,y
		mva		bootstrap_start,y $BF00,y
		iny
		bne		bootstrap_loop

		;set the semaphore and wait for Veronica to respond (4 second timeout)
		mva		#VRA_RUN|VRA_WINA|VRA_SWAP|VRA_HIGH|VRA_SEMA veronica_ctl

		ldx		rtclok+2
		dex
timeout_loop:
		ldx		veronica_ctl
		bpl		bootstrap_ok
		cpx		rtclok+2
		bne		timeout_loop
		beq		veronica_fail

		_LOADER_DEBUG "1"
		
bootstrap_ok:
		;upload the first half of the runtime
		mva		#VRA_RUN|VRA_WINA|VRA_HIGH veronica_ctl
		mva		#$30 fr0+1
		mva		#$A0 fr1+1
		ldy		#0
		sty		fr0
		sty		fr1
		ldx		#$20
copy_loop:
		mva:rne	(fr0),y (fr1),y+
		inc		fr0+1
		inc		fr1+1
		dex
		bne		copy_loop

		_LOADER_DEBUG "A"

		;set the semaphore and wait for Veronica to respond
		mva		#VRA_RUN|VRA_WINA|VRA_SWAP|VRA_HIGH|VRA_SEMA veronica_ctl
		lda:rmi	veronica_ctl

		_LOADER_DEBUG "B"

		;copy up the second half
		mva		#VRA_RUN|VRA_HIGH|VRA_WINA veronica_ctl
		mva		#$A0 fr1+1
		ldx		#$20
copyloop2:
		mva:rne	(fr0),y (fr1),y+
		inc		fr0+1
		inc		fr1+1
		dex
		bne		copyloop2

		_LOADER_DEBUG "C"

		;fire the semaphore and wait
		mva		#VRA_RUN|VRA_WINA|VRA_SWAP|VRA_HIGH|VRA_SEMA veronica_ctl
		lda:rmi	veronica_ctl

		_LOADER_DEBUG "D"

		;swap banks so that Veronica can clone to the other bank -- it's much
		;faster at doing so, but only the host can swap banks
		mva		#VRA_RUN|VRA_WINA|VRA_HIGH|VRA_SEMA veronica_ctl

		;wait for Veronica to finish cloning the data
		lda:rmi	veronica_ctl

		_LOADER_DEBUG "E"

		;reset RUNAD to $B800 so we can be re-invoked
		mwa		#$b800 runad

		;check if there is a command line to process
		ldy		#0
		sty		iocbidx				;!! - needed since we will be skipping it
		lda		(dosvec),y
		cmp		#$4c
		bne		no_cmdline
		ldy		#3
		lda		(dosvec),y
		cmp		#$4c
		bne		no_cmdline

		;check for DOSVEC being a COLDSV -- we need this to reject
		;AspeQt, as it aims DOSVEC at this (!)
		lda		dosvec
		cmp		#<coldsv
		bne		have_cmdline
		lda		dosvec+1
		cmp		#>coldsv
		bne		have_cmdline
no_cmdline:
		lda		#0
		jmp		no_filename

have_cmdline:
		;skip spaces
		ldy		#10
		lda		(dosvec),y
		clc
		adc		#63
		tay
space_loop:
		lda		(dosvec),y
		cmp		#$9b
		beq		no_filename
		iny
		cmp		#' '
		beq		space_loop

		;stash filename base offset
		dey
		sty		fr0+3

		;check if the first character is other than D and there is a colon
		;afterward -- if so, we should skip DOS's parser and use it straight
		;as it may be a CIO filename that DOS would munge
		cmp		#'D'
		beq		possibly_dos_file
cio_file:
		;copy filename to LBUFF
		ldx		#0
cio_copy_loop:
		lda		(dosvec),y
		sta		lbuff,x
		inx
		iny
		cmp		#$9b
		bne		cio_copy_loop

		;stash length
		stx		fr0+2

		tya
		jmp		have_filename_nz

possibly_dos_file:
		;scan for colon
colon_loop:
		lda		(dosvec),y
		iny
		cmp		#':'
		beq		cio_file
		cmp		#$9b
		bne		colon_loop

		;okay, assume it's a DOS file - clear the CIO filename flag
		lda		#0
		sta		fr0+2
		
		;try to parse out a filename
		ldy		fr0+3
		sec
		sbc		#63
		ldy		#10
		sta		(dosvec),y

		ldy		#4
		mva		(dosvec),y fr0
		iny
		mva		(dosvec),y fr0+1
		jsr		jump_fr0
		
no_filename:
have_filename_nz:
		;save off filename flag
		php

		;print banner
		mwa		#loadermsg_banner icbal
		mwa		#[.len loadermsg_banner] icbll
		mva		#CIOCmdPutRecord iccmd
		ldx		#0
		jsr		ciov

		;jsr		stNew.reset_entry
		;jsr		ExecReset

		;read filename flag
		plp
		bne		explicit_fn

		;no filename... try loading implicit file
		ldx		#$70
		stx		iocbidx
		mwa		#default_fn_start icbal+$70
		mwa		#default_fn_end-default_fn_start icbll+$70
		mva		#CIOCmdOpen iccmd+$70
		mva		#$04 icax1+$70
		jsr		ciov
		bmi		load_failed

		;load and run
		brk

load_failed:
		;failed... undo the EOL with an up arrow so the prompt is in the right place
		mwx		#0 icbll
		mva		#CIOCmdPutChars iccmd
		lda		#$1c
		jsr		ciov

		;close IOCB and jump to prompt
		ldx		#$70
		mva		#CIOCmdClose iccmd+$70
		jsr		ciov
		;jsr		ExecReset
		;jmp		execLoop

		jmp		comm_boot

explicit_fn:
		;move filename to line buffer
		ldy		#33
		ldx		#0
		stx		fr0+3

		;check if filename is already there
		lda		fr0+2
		bne		fncopy_skip
fncopy_loop:
		lda		(dosvec),y
		sta		lbuff,x
		cmp		#$9b
		beq		fncopy_exit
		iny
		inx
		bne		fncopy_loop
fncopy_exit:
		;finish length
		stx		fr0+2

fncopy_skip:
		;set string pointer
		mwa		#lbuff fr0

		;print newline
		mwx		#0 icbll
		mva		#CIOCmdPutChars iccmd
		lda		#$9b
		jsr		ciov

		;set up for RUN statement
;		lsr		stLoadRun._loadflg
		jmp		*

		ldx		#$70
		stx		iocbidx

		;jmp		stLoadRun.loader_entry
		jmp		*

wait_vbl:
		sei
		mwa		#1 cdtmv3
		cli
		lda:rne	cdtmv4
		rts

jump_fr0:
		jmp		(fr0)

editor:
		dta		c'E',$9B

default_fn_start:
		dta		'D:AUTORUN.BAS',$9B
default_fn_end:
.endp

;==========================================================================
.proc loadermsg_banner
		dta		$9C,'Veronica BASIC 0.1 (C) 2015 Avery Lee'
.endp
		
;==========================================================================
.proc loadermsg_veronicafail
		dta		$9C
		dta		'Unable to communicate with Veronica cartridge.',$9B
.endp
		
;==========================================================================
; Runtime bootstrap

bootstrap_start = $2E00
		org		$0700,$2E00
		opt		c+

.nowarn .proc RuntimeBoot
		;switch to native mode
		clc
		xce

		;copy bootstrap down to $0600
		rep		#$30
		ldx.w	#$fe00
		ldy.w	#$0600
		lda.w	#$01ff
		mvn		0,0

		;jump to new copy
		jmp		resume_low

resume_low:
		jsr		ack_wait			;[SYNC #1]

		;copy $E000-FFFF to $4000-5FFF
		rep		#$30
		ldx.w	#$e000
		ldy.w	#$4000
		lda.w	#$2000-1
		mvn		0,0

		jsr		ack_wait			;[SYNC #2]

		;copy $E000-FFFF to $6000-7FFF
		rep		#$30
		ldx.w	#$e000
		ldy.w	#$6000
		lda.w	#$2000-1
		mvn		0,0

		;copy $4000-5FFF to $C000-DFFF
		ldx.w	#$4000
		ldy.w	#$C000
		lda.w	#$2000-1
		mvn		0,0

		jsr		ack_wait			;[SYNC #3]

		;copy $4000-7FFF to $C000-FFFF
		rep		#$30
		ldx.w	#$4000
		ldy.w	#$C000
		lda.w	#$4000-1
		mvn		0,0

		;signal host, but don't wait
		sep		#$20
		lda		#$80
		tsb		$0200

		;switch back to emulation mode and invoke reset vector
		sec
		xce
		jmp		($fffc)

ack_wait:
		;signal host
		sep		#$20
		lda		#$80
		tsb		$0200

		;wait for semaphore to activate again
		lda:rmi	$0200
		rts
.endp

		org		$FFFC,$2EFC
		dta		a($ff00)
		opt		c-

;==========================================================================
; Runtime portion
		org		$2F00
		ins		'vruntime.bin'
		ins		'vhost.bin'

;==========================================================================
		
		run		__loader
		
		end
