; Altirra BASIC - System includes
; Copyright (C) 2014 Avery Lee, All Rights Reserved.
;
; Copying and distribution of this file, with or without modification,
; are permitted in any medium without royalty provided the copyright
; notice and this notice are preserved.  This file is offered as-is,
; without any warranty.

;==========================================================================
; OS INCLUDES (800)
;
dosvec	= $0010
		; $0011
appmhi	= $0012
		; $0013
brkkey	= $0014			;set on [BREAK]
memtop	= $001a			;highest location for programs and data
		; $001b

ioPtr	= $0020
		; $0021
ioLeft	= $0024
		; $0025
ioLen	= $0026
		; $0027

fr0		= $00d4			;floating point register 0
_fr3	= $00da			;FP: Accumulator 3 (officially FRE)
fr1		= $00e0			;floating point register 1
fr2		= $00e6			;FP: Accumulator 2
_fpcocnt= $00ec			;FP: temporary storage - polynomial coefficient counter
_fptemp0= $00ed			;FP: temporary storage - transcendental temporary (officially EEXP)
_fptemp1= $00ee			;FP: temporary storage - transcendental temporary (officially NSIGN)
;esign	  $00ef			;BASIC: Used in sqr() routine -- must not be touched by FP elementary functions
;fchrflg  $00f0			;BASIC: Used in sin() routine -- must not be touched by any FP functions
cix		= $00f2			;FP: Character index
inbuff	= $00f3
		; $00f4
		; $00f5			;FP: temporary storage -- also temporarily used by BASIC power routine
		; $00f6			;FP: temporary storage
		; $00f7			;FP: temporary storage -- also temporarily used by BASIC power routine
		; $00f8			;FP: temporary storage
		; $00f9			;FP: temporary storage
		; $00fa			;FP: temporary storage
flptr	= $00fc			;FP: pointer for floating-point loads and stores
fptr2	= $00fe			;FP: pointer for polynomial evaluation

coldst	= $0244			;cold start flag
paddl0	= $0270			;shadow for POT0 ($D200)
paddl1	= $0271			;shadow for POT1 ($D201)
paddl2	= $0272			;shadow for POT2 ($D202)
paddl3	= $0273			;shadow for POT3 ($D203)
paddl4	= $0274			;shadow for POT4 ($D204)
paddl5	= $0275			;shadow for POT5 ($D205)
paddl6	= $0276			;shadow for POT6 ($D206)
paddl7	= $0277			;shadow for POT7 ($D207)
stick0	= $0278			;shadow for PORTA lo ($D300)
stick1	= $0279			;shadow for PORTA hi ($D300)
stick2	= $027a			;shadow for PORTB lo ($D302)
stick3	= $027b			;shadow for PORTB hih ($D302)
ptrig0	= $027c			;paddle 0 trigger
ptrig1	= $027d			;paddle 1 trigger
ptrig2	= $027e			;paddle 2 trigger
ptrig3	= $027f			;paddle 3 trigger
ptrig4	= $0280			;paddle 4 trigger
ptrig5	= $0281			;paddle 5 trigger
ptrig6	= $0282			;paddle 6 trigger
ptrig7	= $0283			;paddle 7 trigger
strig0	= $0284			;shadow for TRIG0 ($D001)
strig1	= $0285			;shadow for TRIG1 ($D002)
strig2	= $0286			;shadow for TRIG2 ($D003)
strig3	= $0287			;shadow for TRIG3 ($D004)
pcolr0	= $02c0			;shadow for COLPM0 ($D012)
pcolr1	= $02c1			;shadow for COLPM1 ($D013)
pcolr2	= $02c2			;shadow for COLPM2 ($D014)
pcolr3	= $02c3			;shadow for COLPM3 ($D015)
color0	= $02c4			;shadow for COLPF0 ($D016)
color1	= $02c5			;shadow for COLPF1 ($D017)
color2	= $02c6			;shadow for COLPF2 ($D018)
color3	= $02c7			;shadow for COLPF3 ($D019)
color4	= $02c8			;shadow for COLBK ($D01A)
ichid	= $0340			;IOCB #0 handler ID
icdno	= $0341			;IOCB #0 device number
iccmd	= $0342			;IOCB #0 command byte
icsta	= $0343			;IOCB #0 status
icbal	= $0344			;IOCB #0 buffer address lo
icbah	= $0345			;IOCB #0 buffer address hi
icptl	= $0346			;IOCB #0 PUT address lo
icpth	= $0347			;IOCB #0 PUT address hi
icbll	= $0348			;IOCB #0 buffer length/byte count lo
icblh	= $0349			;IOCB #0 buffer length/byte count hi
icax1	= $034a			;IOCB #0 auxiliary information lo
icax2	= $034b			;IOCB #0 auxiliary information hi
icax3	= $034c			;
icax4	= $034d			;
icax5	= $034e			;
icax6	= $034f			;

plyarg	= $05e0			;FP: Polynomial evaluation temp register
fpscr	= $05e6			;FP: Temp evaluation register (used by LOG/LOG10)

ciov	= $e456
blkbdv	= $e471

CIOCmdOpen			= $03
CIOCmdGetRecord		= $05
CIOCmdGetChars		= $07
CIOCmdPutRecord		= $09
CIOCmdPutChars		= $0B
CIOCmdClose			= $0C
CIOCmdGetStatus		= $0D
CIOCmdSpecial		= $0E	;$0E and up is escape

veronica_ctl	= $0200
VRV_SEMA	= $80
VRV_WIN4	= $40
VRV_HIGH	= $20

COMM_OFFSET = $4000
