
; *******************************
; **                           **
; **  SELFTEST ROM: 5000-57FF  **
; **                           **
; *******************************

		.org $5000
		.segment "SELFTEST"
	
		.include "gtia.inc"
		.include "pokey.inc"
		.include "pia.inc"
		.include "atari.inc"
		.include "antic.inc"

		.if	(OS_REVISION=0)
		VFR=$CB88
		VSR=$CBA7
		CA57=$FEEC
		CA61=$FEF6
		.else
		.import	VFR,VSR
		.import	CA57,CA61

		.endif
	
		.if	(OS_REVISION>=3)
		.import	V7EC,V7F6
		.endif

		.export	SLFTST
		.export	V003,V009

SLFTST:	
		.if	(OS_REVISION<=2)
		jmp	V009
		.endif

V003:		jsr	V086
		jmp	V291
V009:		jsr	V086

V00C:		lda	#0
		sta	$80
		sta	$81
		sta	$82
		sta	AUDCTL
		lda	#%00000011
		sta	SKCTL
		jsr	V510
		lda	#%01000000
		sta	NMIEN
		ldx	#0
		jsr	V773
		ldx	#<V13A
		ldy	#>V13A
		jsr	V09E
		lda	#<V0D0
		sta	VDSLST
		lda	#>V0D0
		sta	VDSLST+1
		ldx	#12
		lda	#$AA
		jsr	V72A
		ldx	#0
@1:		stx	WSYNC
		inx
		bne	@1

@2:		lda	VCOUNT
		cmp	#24
		bcs	@2

		lda	#$10
		sta	$87
		lda	#$C0
		sta	NMIEN

@3:		lda	CONSOL
		and	#%00000001
		bne	@3

		lda	#$FF
		sta	CH
		lda	$86
		and	#%00001111
		cmp	#1
		beq	W11		; beq V291
		cmp	#2
		beq	W12		; beq v557
		cmp	#4
		beq	W13		; beq v450

V075:		lda	#$88
		sta	$86
		lda	#$FF
		sta	$82

W11:		jmp	V291
W12:		jmp	V557
W13:		jmp	V450

V086:		lda	#$11
		sta	$86
		lda	#%00100001
		sta	SDMCTL
		lda	#$C0
		sta	NMIEN
		lda	#$41
		sta	$83
		lda	#$FF
		sta	CH
		rts

V09E:		sta	$8A
		tya
		pha
		txa
		pha
		lda	#0
		sta	SDMCTL
		sta	$2DC
		lda	#<V3DA
		sta	VDSLST
		lda	#>V3DA
		sta	VDSLST+1
		ldx	#0
		txa
		jsr	V72A
		pla
		tax
		pla
		tay
		stx	SDLSTL
		stx	$84
		sty	SDLSTH
		sty	$85
		lda	#%00100001
		sta	SDMCTL
		rts

V0D0:		pha
		txa
		pha
V0D3:		ldx	#$7A
		lda	$87
		cmp	#1
		beq	V0FA
		and	#1
		beq	V0E9
		inc	$A2
		lda	$A2
		and	#$20
		beq	V0E9
		ldx	#$2C
V0E9:		stx	WSYNC
		stx	$D016
		clc
		ror	$87
		lda	#0
		sta	ATRACT
		pla
		tax
		pla
		rti

V0FA:		lda	$88
		bne	@1
		lda	CONSOL
		and	#2
		bne	@2
		lda	$86
		rol
		rol	$86
		lda	#$20
		sta	$A2
		lda	#$FF
		sta	$88
		bne	@2
@1:		lda	CONSOL
		and	#2
		beq	@2
		lda	#0
		sta	$88
@2:		lda	$86
		and	#%00001111
		ora	#%00010000
		sta	$87
		inc	$80
		bne	V12D
		inc	$81
V12D:		lda	$81
		cmp	#$FA
		.if	OS_REVISION <= 2
		bne	V137
		.else
		bne	V0D3
		.endif
		cli
		jmp	V075

V137:		.if	OS_REVISION <= 2
		jmp	V0D3
		.endif

V13A:		.byte	$70,$70,$70,$70,$70	; DISPLAY LIST
		.byte	$47
		.word	V161
		.byte	$70,$70,$70
		.byte	$4E
		.word	$3000
		.byte	$70,$F0
		.byte	$C6
		.word	V171
		.byte	$70,$86,$70,$86,$70,$06
		.byte	$70,$70
		.byte	$4E
		.word	$3000
		.byte	$70,$70,$70
		.byte	$42
		.word	V1B1
		.byte	$41				; dl jump
		.word	V13A

V161:		.byte	$00,$00,$00,$00,$33,$25,$2C,$26	; '    SELF TEST   '
		.byte	$00,$34,$25,$33,$34,$00,$00,$00
V171:		.byte	$00,$00,$2D,$25,$2D,$2F,$32,$39	; '  MEMORY        '
		.byte	$00,$00,$00,$00,$00,$00,$00,$00
		.byte	$00,$00,$21,$35,$24,$29,$2F,$0D	; '  AUDIO-VISUAL  '
		.byte	$36,$29,$33,$35,$21,$2C,$00,$00
		.byte	$00,$00,$2B,$25,$39,$22,$2F,$21	; '  KEYBOARD      '
		.byte	$32,$24,$00,$00,$00,$00,$00,$00
		.byte	$00,$00,$21,$2C,$2C,$00,$34,$25	; '  ALL TESTS     '
		.byte	$33,$34,$33,$00,$00,$00,$00,$00
V1B1:		.byte	$00,$00,$00,$00,$42,$B3,$A5,$AC	; '    [SELECT],[ST'
		.byte	$A5,$A3,$B4,$56,$0C,$42,$B3,$B4
		.byte	$A1,$B2,$B4,$56,$2F,$32,$42,$B2	; 'ART]OR[RESET]   '
		.byte	$A5,$B3,$A5,$B4,$56,$00,$00,$00

V1D1:		.byte	$70,$70,$70	; DISPLAY LIST
		.byte	$46
		.word	$3000
		.byte	$70,$70,$06
		.byte	$70,$08,$70,$70,$06,$70,$08,$70
		.byte	$08,$70,$08,$70,$08,$70,$70,$70
		.byte	$01
		.word	V1ED

V1ED:		.byte	$A0,$40
		.byte	$42
		.word	V1F5
		.byte	$01		; jump!
		.word	$83

V1F5:		.byte	$00,$00,$00,$00,$00,$42,$B2,$A5	; '     [RESET]OR[H'
		.byte	$B3,$A5,$B4,$56,$2F,$32,$42,$A8
		.byte	$A5,$AC,$B0,$56,$34,$2F,$00,$25	; 'ELP]TO EXIT     '
		.byte	$38,$29,$34,$00,$00,$00,$00,$00

V215:		.byte	$70,$70,$70,$70
		.byte	$46
		.word	$3000
		.byte	$70,$70,$70,$70,$02,$70,$70
		.byte	$02,$70,$02,$70,$02,$70,$02
		.byte	$70,$02,$70,$70
		.byte	$01
		.word	V1ED

V231:		.byte	$70,$70,$70,$70	; DISPLAY LIST!
		.byte	$46
		.word	V271
		.byte	$70,$06
		.byte	$70,$70
		.byte	$4B
		.word	$3100
		.byte	$0B,$0B,$0B,$0B,$0B,$0B,$0B,$0B,$0B,$0B,$0B,$0B,$0B,$0B
		.byte	$0B,$0B,$0B,$0B,$0B,$0B,$0B,$0B,$0B,$0B,$0B,$0B,$0B,$0B
		.byte	$0B,$0B,$0B,$0B,$0B,$0B,$0B,$0B,$0B,$0B,$0B,$0B,$0B,$0B
		.byte	$70
		.byte	$46
		.word	$3000
		.byte	$70
		.byte	$01
		.word	V1ED

V271:		.byte	$00,$00,$21,$35,$24,$29,$2F,$0D	; '  AUDIO-VISUAL  '
		.byte	$36,$29,$33,$35,$21,$2C,$00,$00
		.byte	$00,$00,$00,$00,$00,$00,$34,$25	; '      TEST      '
		.byte	$33,$34,$00,$00,$00,$00,$00,$00

V291:		ldx	#<V1D1
		ldy	#>V1D1
		lda	#0
		jsr	V09E
		ldx	#1
		jsr	V773
		ldx	#0
		jsr	V759
		ldx	#1
		jsr	V759
V2A9:		lda	$3020
		cmp	#$AA
		beq	V2C7
		lda	#$55
		jsr	V38E
		jsr	V3B1
		jsr	VFR
		bcs	V2C2
		lda	#$FF
		jmp	V2C4
V2C2:		lda	#$AA
V2C4:		jsr	V38E	
V2C7:		lda	$3024
		cmp	#$AA
		beq	V2E5
		lda	#$55
		jsr	V399
		jsr	V3B1
		jsr	VSR
		bcs	V2E0
		lda	#$FF
		jmp	V2E2
V2E0:		lda	#$AA
V2E2:		jsr	V399
V2E5:		.if	OS_REVISION <= 2
		lda	#$C0
		sta	$8D
		lda	#4
		sta	$A4
		.else
		lda	PORTB
		ora	#%00010000
		sta	PORTB
		lda	#$C0
		sta	$8D
		.endif
		lda	#0
		sta	$8E
		sta	$90
		sta	$91
		sta	$8F
V2F7:		ldx	$8E
		lda	$3038,X
		and	$8D
		cmp	#$80
		beq	V35E
		cmp	#8
		beq	V35E
		lda	#$44
		jsr	V3C3

		.if OS_REVISION>=3	; bigif

		lda	#1
		jsr	W3AD
		beq	V359
		jsr	V3B1
		lda	#$88
		jsr	V3C3
		jmp	V35E

V359:		lda	#$CC
		jsr	V3C3
V35E:		lda	$8D
		bpl	@1

		lda	#$C
		sta	$8D
		bne	@2

@1:		lda	#$C0
		sta	$8D
		inc	$8E
@2:		lda	$91
		cmp	$2E4
		bne	V2F7

		lda	PORTB
		sta	$4000
		and	#%11101111
		sta	PORTB
		sta	$4000
		ora	#%00010000
		sta	PORTB
		lda	$4000
		cmp	PORTB
		bne     @6
		lda	#$18
		sta	$8E
		lda	#$FF
		sta	$8D
		lda	#0
		sta	$A9
@3:		lda	PORTB
		and	#%11100011
		ldx	$A9
		ora	W3A8,X
		sta	PORTB
		lda	#$40
		sta	$91
		sta	$8F
		ldx	$8E
		lda	$3038,X
		cmp	#$AA
		beq	@5
		lda	#$55
		jsr	V3C3
		lda	#$10
		jsr	W3AD
		beq	@4

		lda	#$AA
		bne	@5
@4:		lda	#$FF
@5:		jsr	V3C3
		inc	$8E
		inc	$8E
		inc	$A9
		lda	$A9
		cmp	#4
		bne	@3
@6:		lda	$82
		bne	@7
		jmp	V2A9
@7:		jsr	V3B5
		jmp	V557

W3A8:		.byte	0,2,4,6
W3AC:		.byte	$FF

W3AD:		sta	$8F
@1:		ldx	#3
@2:		lda	V44A,X
		cmp	$91
		beq	@9
		dex
		bpl	@2
		lda	#4
		sta	$92
@3:		bit	W3AC
@4:		ldy	#0
@5:		tya
		bvs	@6
		eor	#$FF
@6:		sta	($90),Y
		iny
		bne	@5
		ldx	#$F
		jsr	V3B7
@7:		tya
		bvs	@8
		eor	#$FF
@8:		cmp	($90),Y
		bne	@12
		iny
		bne	@7
		bvc	@10
		clv
		bvc	@4
@9:		jsr	V3B5
		lda	$91
		clc
		adc	#4
		sta	$91
		bne	@11
@10:		inc	$91
		dec	$92
		bne	@3
@11:		dec	$8F
		bne	@1
@12:		rts
	
V44A:		.byte	$00,$50,$54,$30

V38E:		ldx	#4
		jsr	V72A
		and	#$FC
		sta	$3023
		rts

V399:		ldx	#8
		jsr	V72A
		and	#$FC
		sta	$3027
		rts

V3C3:		pha
		ldx	$8E
		lda	$8D
		eor	#$FF
		and	$3038,X
		sta	$3038,X
		pla
		and	$8D
		ora	$3038,X
		sta	$3038,X
		rts
	
V3B1:		ldx	#$3C
		bne	V3B7
V3B5:		ldx	#$96
V3B7:		ldy	#$FF
@1:		sty	WSYNC
		dey
		bne	@1
		dex
		bne	V3B7
		rts

V3DA:		pha
		lda	#12
		sta	$D017
		lda	$2C8
		sta	$D018
		lda	#0
		sta	$4D
		lda	$2DC
		beq	V3FD
		lda	#0
		sta	$2DC
		cli
		jmp	V00C
 
V3FD:		lda	$8A
		beq	V448
		lda	CONSOL
		and	#1
		beq	V40C
		lda	#$B3
		bne	V40E
V40C:		lda	#$33
V40E:		sta	$3025
		lda	CONSOL
		and	#2
		beq	V41C
		lda	#$F3
		bne	V41E
V41C:		lda	#$73
V41E:		sta	$3028
		lda	CONSOL

		and	#4
		beq	V42C
		lda	#$AF
		bne	V42E
V42C:		lda	#$2F
V42E:		sta	$302b
		lda	CONSOL
		and	#%00000111
		cmp	#7
		beq	V443
		lda	#$64
		sta	AUDF2
		lda	#$A8
		bne	V445
V443:		lda	#0
V445:		sta	AUDC2
V448:		pla
		rti
 
V450:		ldx	#0
		stx	$94
		ldx	#3
		jsr	V773
		ldx	#<V215
		ldy	#>V215
		lda	#$FF
		jsr	V09E
V462:		ldx	#2
		jsr	V759
		ldx	#7
		jsr	V759
		lda	$82
		beq	V483
		ldx	$94
		lda	W572,X
		inc	$94
		ldx	$94
		cpx	#$13
		bne	V491
		jsr	V3B5
		jmp	V291
 
V483:		lda	CH
		cmp	#$FF
		beq	V483
		cmp	#$C0
		bcs	V483
V491:		ldx	#$FF

		stx	CH

		pha
		and	#%10000000
		beq	V4A0
		ldx	#8
		jsr	V759
V4A0:		pla
		pha

		and	#%01000000
		beq	V4B0
		ldx	#5
		jsr	V759
		ldx	#4
		jsr	V759
V4B0:		pla
		and	#%00111111
		cmp	#$21

		beq	V51F
		cmp	#$2C
		beq	V52F
		cmp	#$C
		beq	V539
		tax
		lda	V79C,X
		pha
		lda	#$21
		sta	$95
		lda	#$30
		sta	$96
		pla
		ldy	#$FF
V4D3:		iny
		cmp	($95),Y
		bne	V4D3
		eor	#$80
		sta	($95),Y

V4DE:		lda	$82
		beq	V4F5	
		jsr	V505
		ldx	#$14
		jsr	V3B7
		jsr	V510
		ldx	#10
		jsr	V3B7
		jmp	V462

V4F5:		jsr	V505
V4F8:		lda	SKSTAT
		and	#4
		beq	V4F8
		jsr	V510
		jmp	V462

V51F:	
		ldx	#3
		jsr	V759
		beq	V4DE


V52F:		lda	#$7F
		sta	$3052
		sta	$3053
		bne	V4DE
V539:		lda	#$32
		sta	$306D
		lda	#$34
		sta	$306E
		bne	V4DE
 
W572:		.byte	$52,$08,$0A,$2B,$28,$0D,$3D,$39
		.byte	$2D,$1F,$30,$35,$1D,$7F,$2D,$3F
		.byte	$28,$0D

V505:		lda	#$64
		sta	AUDF1
		lda	#$A8
		sta	AUDC1
		rts

V510:		lda	#0
		sta	AUDC1
		sta	AUDC2
		sta	AUDC3
		sta	AUDC4
		rts

V557:		ldx	#2
		jsr	V773	 
@1:		lda	#0
		sta	$97
@2:		lda	#0
		sta	$98
		ldx	#<V231
		ldy	#>V231
		lda	#0
		jsr	V09E
		ldx	#9
		jsr	V759
		lda	$97
		lsr
		clc
		adc	#$11
		sta	$300B

		ldx	#15
@3:		lda	#$FF
		sta	$3150,X
		sta	$31B0,X
		sta	$3210,X
		sta	$3270,X
		sta	$32D0,X
		dex
		bpl	@3
	
		lda	#0
		sta	$99
		lda	#12
		sta	$9A

@4:		ldx	$99	 
		lda	V716+1,X
		tay
		lda	V716,X
		tax
		lda	$9A
		jsr	V685
		clc
		lda	$9A
		adc	#6
		sta	$9A
		inc	$99
		inc	$99
		lda	$99
		cmp	#20
		bne	@4

		jsr	$542C

		ldx	#0	
		stx	$A6
		lda	$565B,X
		pha
		lda	$5668,X
		pha
		lda	$5682,X
		tay
		lda	$5675,X
		tax
		pla
		jsr	V685
		pla
		.byte	$f0,$18
		ldy	$97
		sta	$D200,Y
		lda	#$A8
		sta	$D201,Y
		ldx	$98
		lda	$56BC,X
		tax
		jsr	V3B7
		inc	$98
		jsr	V510
		inc	$A6
		ldx	$A6
		cpx	#$D
		.byte	$D0,$C9
		jsr	V3B5
		inc	$97
		inc	$97
		lda	$97
		cmp	#8
		bne	@5

		lda	$82
		bne	@6
   		jmp	@1
@5:		jmp	@2
@6:		jsr	V3B5
   		jmp	V450

		.byte	$51,$5b,$00,$00,$44,$00,$00,$3c
		.byte	$00,$00,$2d,$00,$35,$00,$00,$48
		.byte	$54,$4e,$48,$4e,$06,$48,$4e,$06
		.byte	$48,$4e,$54,$86,$f8,$c7,$48,$ca
		.byte	$1a,$ca,$3c,$8c,$3c,$9e,$ee,$31
		.byte	$31,$30,$30,$32,$30,$32,$31,$30
		.byte	$31,$31,$30,$31

V685:		stx	$9B
		sty	$9C
		tax
		ldy	#0

		lda	#$10
		sta	$9D
		lda	#6
		sta	$A3
@1:		lda	V6BC,X
		ora	($9B),Y
		sta	($9B),Y
		clc
		lda	$9B
		adc	#$10
		sta	$9B
		bcc	@2

		inc	$9C
@2:		dec	$9D
		bne	@1
		inc	$9D
		inx
		dec	$A3
		bne	@1
		rts
 	
		.else		;  bigelse

		lda	$A4
		jsr	V3A4
		lda	$A4
		eor	#$C
		sta	$A4

		ldx	#7
V318:		lda	V44A,X
		cmp	$91
		beq	V356
		dex
		bpl	V318

		lda	#4
		sta	$92
V326:		ldx	#0
V328:		ldy	#0
V32A:		txa
		sta	($90),Y
		inx
		iny
		bne	V32A
		stx	$93
		ldy	#0
V335:		lda	($90),Y
		cmp	$93
		bne	V34B
		inc	$93
		iny
		bne	V335
		inx
		bne	V328
		inc	$91
		dec	$92
		bne	V326
		beq	V359
V34B:		jsr	V3B1
		lda	#$88
		jsr	V3C3
		jmp	V35E
V356:		jsr	V3B5

V359:		lda	#$CC
		jsr	V3C3
V35E:		lda	$8D
		bmi	V388
		lda	#$C0
		sta	$8D
		inc	$8E
V368:		clc
		lda	$8F
		adc	#4
		sta	$91
		sta	$8F
		cmp	$2E4
		bne	V2F7
		lda	$82
		bne	V37D
		jmp	V2A9
V37D:		lda	#$C
		jsr	V3A4
		jsr	V3B5
		jmp	V557

V388:		lda	#12
		sta	$8D
		bne	V368

V38E:		ldx	#4
		jsr	V72A
		and	#$FC
		sta	$3023
		rts

V399:		ldx	#8
		jsr	V72A
		and	#$FC
		sta	$3027
		rts

V3A4:		sta	$A5
		lda	PORTB
		and	#$F3
		ora	$A5
		sta	PORTB
		rts

V3B1:		ldx	#$3C
		bne	V3B7
V3B5:		ldx	#$96
V3B7:		ldy	#$FF
@1:		sty	WSYNC
		dey
		bne	@1
		dex
		bne	V3B7
		rts

V3C3:		pha
		ldx	$8E
		lda	$8D
		eor	#$FF
		and	$3038,X
		sta	$3038,X
		pla
		and	$8D
		ora	$3038,X
		sta	$3038,X
		rts

V3DA:		pha
		lda	#$C
		sta	$D017
		lda	$2C8
		sta	$D018
		lda	#0
		sta	$4D
		lda	$2DC
		beq	V3FD
		lda	#0
		sta	$2DC
		lda	#12
		jsr	V3A4
		cli
		jmp	V00C
	
V3FD:		lda	$8A
		beq	V448
		lda	CONSOL
		and	#1
		beq	V40C
		lda	#$B3
		bne	V40E
V40C:		lda	#$33
V40E:		sta	$301C
		lda	CONSOL
		and	#2
		beq	V41C
		lda	#$F3
		bne	V41E
V41C:		lda	#$73
V41E:		sta	$301E
		lda	CONSOL
		and	#4
		beq	V42C
		lda	#$AF
		bne	V42E
V42C:		lda	#$2F
V42E:		sta	$3020
		lda	CONSOL
		and	#%00000111
		cmp	#7
		beq	V443
		lda	#$64
		sta	AUDF2
		lda	#$A8
		bne	V445
V443:		lda	#0
V445:		sta	AUDC2
V448:		pla
		rti

V44A:		.byte	$00,$50,$54,$30
		.byte	$30,$30

V450:		ldx	#0
		stx	$94
		ldx	#3
		jsr	V773
		ldx	#<V215
		ldy	#>V215
		lda	#$FF
		jsr	V09E
V462:		ldx	#2
		jsr	V759
		ldx	#7
		jsr	V759
		lda	$82
		beq	V483
		ldx	$94
		lda	V545,X
		inc	$94
		ldx	$94
		cpx	#(V557-V545+1)
		bne	V491
		jsr	V3B5
		jmp	V291

V483:		lda	CH
		cmp	#$FF
		beq	V483
		cmp	#$C0
		bcs	V483
		lda	CH
V491:		ldx	#$FF
		stx	CH
		pha
		and	#%10000000
		beq	V4A0
		ldx	#8
		jsr	V759
V4A0:		pla
		pha
		and	#%01000000
		beq	V4B0
		ldx	#5
		jsr	V759
		ldx	#4
		jsr	V759
V4B0:		pla
		and	#%00111111
		cmp	#$21
		beq	V51F
		cmp	#$2C
		beq	V52F
		cmp	#$34
		beq	V527
		cmp	#$C
		beq	V539
		tax
		lda	V79C,X
		pha
		lda	#$21
		sta	$95
		lda	#$30
		sta	$96
		pla
		ldy	#$FF
V4D3:		iny
		cmp	($95),Y
		bne	V4D3
		lda	($95),Y
		eor	#$80
		sta	($95),Y
V4DE:		lda	$82
		beq	V4F5
		jsr	V505
		ldx	#$14
		jsr	V3B7
		jsr	V510
		ldx	#10
		jsr	V3B7
		jmp	V462

V4F5:		jsr	V505
V4F8:		lda	SKSTAT
		and	#4
		beq	V4F8
		jsr	V510
		jmp	V462

V505:		lda	#$64
		sta	AUDF1
		lda	#$A8
		sta	AUDC1
		rts

V510:		lda	#0
		sta	AUDC1
		sta	AUDC2
		sta	AUDC3
		sta	AUDC4
		rts

V51F:		ldx	#3
		jsr	V759
		jmp	V4DE

V527:		ldx	#6
		jsr	V759
		jmp	V4DE

V52F:		lda	#$7F
		sta	$3052
		sta	$3053
		bne	V4DE
V539:		lda	#$32
		sta	$306D
		lda	#$34
		sta	$306E
		bne	V4DE

V545:		.if	OS_REVISION <= 1
		.byte	$65,$0D,$12,$39,$3F,$2A,$00,$21
		.byte	$52,$08,$00,$15,$0B,$28,$23
		.else
		.byte	$52,$08,$0A,$2B,$28,$0D,$3D,$39
		.byte	$2D,$1F,$30,$35,$1A,$7F,$2D,$3F
		.byte	$28,$0D
		.endif

V557:		ldx	#2
		jsr	V773
@1:		lda	#0
		sta	$97
@2:		lda	#0
		sta	$98
		ldx	#<V231
		ldy	#>V231
		lda	#0
		jsr	V09E
		ldx	#9
		jsr	V759
		lda	$97
		lsr
		clc
		adc	#$11
		sta	$300B

		ldx	#15
@3:		lda	#$FF
		sta	$3150,X
		sta	$31B0,X
		sta	$3210,X
		sta	$3270,X
		sta	$32D0,X
		dex
		bpl	@3

		lda	#0
		sta	$99
		lda	#12
		sta	$9A
@4:		ldx	$99
		lda	V716+1,X
		tay
		lda	V716,X
		tax
		lda	$9A
		jsr	V685
		clc
		lda	$9A
		adc	#6
		sta	$9A
		inc	$99
		inc	$99
		lda	$99
		cmp	#20
		bne	@4

		jsr	V3B1

		ldx	#<$3154
		ldy	#>$3154
		lda	#0
		jsr	V685

		lda	#$51
		jsr	V66C

		ldx	#<$3186
		ldy	#>$3186
		lda	#0
		jsr	V685

		lda	#$5B
		jsr	V66C

		ldx	#<$30F8
		ldy	#>$30F8
		lda	#$48
		jsr	V685

		ldx	#<$30C7
		ldy	#>$30C7
		lda	#$54
		jsr	V685

		ldx	#<$3248
		ldy	#>$3248
		lda	#$4E
		jsr	V685

		lda	#$44
		jsr	V66C

		ldx	#<$30CA
		ldy	#>$30CA
		lda	#$48
		jsr	V685

		ldx	#<$321A
		ldy	#>$321A
		lda	#$4E
		jsr	V685

		ldx	#<$31CA
		ldy	#>$31CA
		lda	#6
		jsr	V685

		lda	#$3C
		jsr	V66C

		ldx	#<$303C
		ldy	#>$303C
		lda	#$48
		jsr	V685

		ldx	#<$318C
		ldy	#>$318C
		lda	#$4E
		jsr	V685

		ldx	#<$313C
		ldy	#>$313C
		lda	#6
		jsr	V685

		lda	#$2D
		jsr	V66C

		ldx	#<$309E
		ldy	#>$309E
		lda	#$48
		jsr	V685

		ldx	#<$31EE
		ldy	#>$31EE
		lda	#$4E
		jsr	V685

		lda	#$35
		jsr	V66C
		jsr	V3B5

		inc	$97
		inc	$97
		lda	$97
		cmp	#8
		bne	@5		; bne @2

		lda	$82
		bne	@6
		jmp	@1
@5:		jmp	@2
@6:		jsr	V3B5
		jmp	V450
	
V66C:		ldy	$97
		sta	$D200,Y
		lda	#$A8
		sta	$D201,Y
		ldx	$98
		lda	V6B6,X
		tax
		jsr	V3B7
		inc	$98
		jsr	V510
		rts

V685:		stx	$9B
		sty	$9C
		tax
		ldy	#0
		lda	#$10
		sta	$9D
		lda	#6
		sta	$A3
@1:		lda	V6BC,X
		ora	($9B),Y
		sta	($9B),Y
		jsr	V6AA
		dec	$9D
		bne	@1
		inc	$9D
		inx
		dec	$A3
		bne	@1
		rts

V6AA:		clc
		lda	$9B
		adc	#$10
		sta	$9B
		bcc	@1
		inc	$9C
@1:		rts

		.endif


V6B6:		.byte	$20,$20,$20,$10,$10,$20
V6BC:		.byte	$01,$1F,$3F,$7F,$3E,$1C,$00,$41
		.byte	$42,$4C,$70,$40,$00,$01,$02,$04
		.byte	$08,$10,$00,$43,$44,$48,$48,$48
		.byte	$00,$44,$22,$10,$08,$07,$00,$04
		.byte	$08,$05,$02,$00,$00,$30,$48,$88
		.byte	$84,$84,$00,$88,$88,$90,$A0,$C0
		.byte	$00,$F0,$88,$84,$82,$82,$00,$82
		.byte	$82,$84,$88,$F0,$00,$00,$00,$00
		.byte	$00,$80,$80,$80,$80,$80,$80,$80
		.byte	$00,$1C,$3E,$7F,$7E,$7C,$40,$00
		.byte	$00,$00,$00,$00,$00,$04,$04,$06
		.byte	$05,$06

V716:		.word	$30C1,$3121,$3181,$31F1,$3002
		.word	$3062,$3122,$3182,$30C2,$31C2

V72A:		pha			; fill a stretch of memory with the
		lda	V7DC,X		; value in the accumulator
		sta	$9E
		lda	V7DC+1,X
		sta	$9F
		lda	V7DC+2,X
		sta	$A0
		lda	V7DC+3,X
		sta	$A1
		ldy	#0
@1:		pla
		sta	($9E),Y
		inc	$9E
		bne	@2
		inc	$9F
@2:		pha
		lda	$9E
		cmp	$A0
		bne	@1
		lda	$9F
		cmp	$A1
		bne	@1
		pla
		rts

V759:		lda	CA57,X
		tay
		lda	V7EC,X
		sta	$9E
		lda	V7F6,X
		tax
@1:		lda	CA61,Y
		sta	$3000,X
		iny
		inx
		dec	$9E
		bne	@1
		rts

V773:		lda	V78C,X			; load a color scheme
		sta	COLOR0
		lda	V790,X
		sta	COLOR1
		lda	V794,X
		sta	COLOR2
		lda	V798,X

		sta	COLOR4
		rts

V78C:		.byte	$2C,$0C,$2A,$18		; color schemes, color 0
V790:		.byte	$0F,$32,$0C,$0E		; color schemes, color 1
V794:		.byte	$D2,$D6,$00,$B4		; color schemes, color 2
V798:		.byte	$D2,$A0,$30,$B4		; color schemes, color 4

V79C:		.byte	$2C,$2A,$1B,$91,$92,$2B,$0B,$0A
		.byte	$2F,$00,$30,$35,$B2,$29,$0D,$1D
		.byte	$36,$A8,$23,$93,$94,$22,$38,$3A
		.byte	$14,$00,$13,$16,$5B,$15,$12,$11
		.byte	$0C,$00,$0E,$2E,$00,$2D,$0F

		.if	OS_REVISION <= 2
		.byte	$A1
		.else
		.byte	$48
		.endif
		.byte	$32,$00,$25,$39,$FF,$34,$37,$31,$19,$00,$10,$17
		.if	OS_REVISION <= 2
		.byte	$A2,$18
		.else
		.byte	$A4,$18
		.endif
		.byte	$1C,$1E
		.byte	$26,$28,$24,$00,$A3,$27,$33,$21

V7DC:		.if	OS_REVISION <= 2
		.word	$3000,$3EFF
		.else
		.word	$3000,$3EEF
		.endif
		.word	$3020,$3024
		.word	$3024,$3028
		.word	$3000,$3020

		.if	OS_REVISION <= 2
V7EC:		.byte	$13,$03,$13,$13,$04,$04,$03,$A8,$03,$07
V7F6:		.byte	$00,$28,$00,$B7,$92,$AB,$4C,$22,$72,$04
		.endif

		.res	($5800-*),0
		
		.end
