
		; *************************************************
		; **                                             **
		; **  6502 Non-Maskable Interrupt (NMI) handler  **
		; **                                             **
		; *************************************************

NMI_Handler:	bit	NMIST		; check NMI status
		bpl	@vblank		; determine NMI type

		; display list interrupt detected

		jmp	(VDSLST)	; engage DLI handler

		; vertical blank interrupt detected

@vblank:	cld			; clear decimal flag
		pha			; save A register
		txa			; save X register
		pha
		tya			; save Y register
		pha
		sta	NMIRES		; reset NMI status
		jmp	(VVBLKI)	; engage VBLANK immediate handler
