		; **********************
		; **                  **
		; **  Checksum Stuff  **
		; **                  **
		; **********************

		.export VFR,VSR

		

		.if	(OS_REVISION=0)
		.import	ROM2ID
		.else
		.import ROM1ID
		.endif

VFR:		ldx	#0		; clear checksum value
		stx	$8B
		stx	$8C
@1:		jsr	checksum	; calculate checksum of 1st 8K ROM:
		cpx	#12		; C000-CFFF + 5000-57FF + D800-DFFF
		bne	@1
		lda	ROM1ID+0	; checksum of first ROM
		ldx	ROM1ID+1

		; patched by XL-IT! to: clc/rts

next_block:	cmp	$8B		; carry = ( A==$8B && X==$8C )
		bne	@1
		cpx	$8C
		bne	@1
		clc			; clear carry means OK
		rts
@1:		sec			; set carry means ERROR
		rts

VSR:		ldx	#0		; clear checksum value
		stx	$8B
		stx	$8C
		ldx	#12
		jsr	checksum	; calculate checksum of 2nd 8K ROM:
		jsr	checksum	; E000-FFF7 + FFFA-FFFF
		lda	ROM2ID+10
		ldx	ROM2ID+11
		jmp	next_block	; carry = ( A==$8B && X==$8C )

checksum:	ldy	#0		; copy 4 checksum-specifier bytes 
@1:		lda	FFD7,X		; to $9E..$A1
		.if	(OS_REVISION=0)	; STA $9E,Y (abs. addr mode)
		.byte	$99
		.word	$9E
		.else
		sta	$9E,Y
		.endif
		inx			; advance to next checksum
		iny
		cpy	#4
		bne	@1
		ldy	#0		; add ($9E) -> $8B
@2:		clc
		lda	($9E),Y
		adc	$8B
		sta	$8B
		bcc	@3
		inc	$8C		; advance ($9E)
@3:		inc	$9E
		bne	@4
		inc	$9F
@4:		lda	$9E
		cmp	$A0		; repeat until $9E-ptr == $A0-ptr
		bne	@2
		lda	$9F
		cmp	$A1
		bne	@2
		rts			; return

		; checksums

FFD7:		.word	$C002,$D000
		.word	$5000,$5800
		.word	$D800,$E000

		.word	$E000,$FFF8
		.word	$FFFA,$0000
