
		; ********************************************************
		; **                                                    **
		; **  Device Handler Initialization Code for device C:  **
		; **                                                    **
		; ********************************************************

CIN:		lda	#<1484		; 1484 <--> 600 baud
		sta	CBAUDL
		lda	#>1484
		sta	CBAUDH

		; *****************
		; **             **
		; ** Special C:  **
		; **             **
		; *****************

FCE5:		rts			; patched by XL-IT!

		; ***************
		; **           **
		; **  Open C:  **
		; **           **
		; ***************

FCE6:		lda	ICAX2Z		; patched by XL-IT!
		sta	FTYPE
		lda	ICAX1Z
		and	#12
		cmp	#4
		beq	CSOPI
		cmp	#8
		beq	FD34
		rts

CSOPI:		lda	#0
		sta	WMODE		; 'read'
		sta	FEOF
		lda	#1
		jsr	FDFC
		bmi	FD2E
FD05:		lda	#$34
		sta	PACTL
		ldx	PALNTS
		ldy	FE93,X
		lda	FE91,X
		tax
		lda	#3
		sta	CDTMF3
		jsr	SETVBV
FD1B:		lda	CDTMF3
		bne	FD1B
		lda	#$80
		sta	BPTR
		sta	BLIM
		jmp	FD77
FD2A:		ldy	#$80
		dec	BRKKEY
FD2E:		lda	#0		; 'read'
		sta	WMODE
		rts

FD34:		lda	#$80		; 'write'
		sta	WMODE
		lda	#2
		jsr	FDFC
		bmi	FD2E

		lda	#<1484		; set baudrate
		sta	$D204
		lda	#>1484
		sta	$D206
		lda	#$60
		sta	DDEVIC
		jsr	SENDEV
		lda	#$34
		sta	PACTL
		ldx	PALNTS
		ldy	FE8F,X
		lda	FE8D,X
		tax
		lda	#3
		jsr	SETVBV
		lda	#$FF
		sta	CDTMF3
FD6A:		lda	BRKKEY
		beq	FD2A
		lda	CDTMF3
		bne	FD6A
		lda	#0
		sta	BPTR
FD77:		ldy	#1
FD79:		rts

		; **************
		; **          **
		; **  Get C:  **
		; **          **
		; **************

FD7A:		lda	FEOF		; PATCHED BY XL-IT!
		bmi	FDB1		; ldy #136; rts
		ldx	BPTR
		cpx	BLIM
		beq	RBLOK
		lda	CASBUF+3,X
		inc	BPTR
		ldy	#1
FD8C:		rts

RBLOK:		lda	#'R'		; read command
		jsr	FE3F
		tya
		bmi	FD8C
		lda	#0
		sta	BPTR
		ldx	#$80
		lda	CASBUF+2
		cmp	#$FE
		beq	@2
		cmp	#$FA
		bne	@1
		ldx	CASBUF+130
@1:		stx	BLIM
		jmp	FD7A
@2:		dec	FEOF
FDB1:		ldy	#$88
		rts

		; **************
		; **          **
		; **  Put C:  **
		; **          **
		; **************

FDB4:		ldx	BPTR		; PATCHED BY XL-IT!
		sta	CASBUF+3,X
		inc	BPTR
		ldy	#1
		cpx	#$7F
		beq	@1
		rts

@1:		lda	#$FC
		jsr	FE7C
		lda	#0
		sta	BPTR
		rts

		; ****************
		; **            **
		; ** Status C:  **
		; **            **
		; ****************

FDCC:		ldy	#1		; PATCHED BY XL-IT!
FDCE:		rts

		; ****************
		; **            **
		; **  Close C:  **
		; **            **
		; ****************

FDCF:		lda	WMODE		; PATCHED BY XL-IT!
		bmi	FDDC
		ldy	#1
FDD6:		lda	#%00111100
		sta	PACTL
		rts

FDDC:		ldx	BPTR
		beq	@1
		stx	CASBUF+130
		lda	#$FA
		jsr	FE7C
		bmi	FDD6
@1:		ldx	#$7F
		lda	#0
@2:		sta	CASBUF+3,X
		dex
		bpl	@2
		lda	#$FE
		jsr	FE7C
		jmp	FDD6

FDFC:		sta	FREQ
@1:		lda	RTCLOK+2
		clc
		ldx	PALNTS
		adc	FE95,X
		tax
@2:		lda	#$FF
		sta	CONSOL
		lda	#0
		ldy	#$F0		; wait a bit ...
@3:		dey
		bne	@3
		sta	CONSOL
		ldy	#$F0		; wait a bit ...
@4:		dey
		bne	@4
		cpx	RTCLOK+2
		bne	@2
		dec	FREQ
		beq	@6
		txa
		clc
		ldx	PALNTS
		adc	FE97,X
		tax
@5:		cpx	RTCLOK+2	; busy waiting
		bne	@5
		beq	@1

@6:		.if	(OS_REVISION=4)
		jsr	CB90
		.else
		jsr	FE36
		.endif
		tya
		rts

FE36:		lda	E424+1		; jmp (E424)+1 --> jmp KGB.
		pha
		lda	E424
		pha
		rts

FE3F:		sta	DCOMND
		lda	#>131		; 131 bytes per record
		sta	DBYTHI
		lda	#<131
		sta	DBYTLO
		lda	#>CASBUF	; cassette buffer
		sta	DBUFHI
		lda	#<CASBUF
		sta	DBUFLO
		lda	#$60
		sta	DDEVIC
		lda	#0
		sta	DUNIT
		lda	#$23
		sta	DTIMLO
		lda	DCOMND
		ldy	#$40
		cmp	#$52
		beq	@1
		ldy	#$80
@1:		sty	DSTATS
		lda	FTYPE
		sta	DAUX2
		jsr	SIOV
		rts

FE7C:		sta	CASBUF+2
		lda	#%01010101	; bit pattern!
		sta	CASBUF
		sta	CASBUF+1
		lda	#'W'		; write command
		jsr	FE3F
		rts

		; timing stuff

FE8D:		.byte	$04,$03
FE8F:		.byte	$80,$C0
FE91:		.byte	$02,$01
FE93:		.byte	$40,$E0
FE95:		.byte	$1E,$19
FE97:		.byte	$0A,$08
