		; ********************************************************
		; **                                                    **
		; **  Device Handler Initialisation Code for device P:  **
		; **                                                    **
		; ********************************************************

PIN:		lda	#30
		sta	PTIMOT
		rts

FE9F:		.word	DVSTAT
FEA1:		.word	PRNBUF

		; *****************
		; **             **
		; **  Status P:	 **
		; **             **
		; *****************

FEA3:		lda	#4
		sta	PBUFSZ
		ldx	FE9F
		ldy	FE9F+1
		lda	#'S'		; status
		sta	DCOMND
		sta	DAUX1
		jsr	FF14
		jsr	SIOV
		bmi	FEC1
		jsr	FF44
FEC1:		rts

		; ***************
		; **           **
		; **  Open P:  **
		; **           **
		; ***************

FEC2:		jsr	FEA3
		lda	#0
		sta	PBPNT
FECA:		rts

		; ******************
		; **              **
		; **  Put Byte P: **
		; **              **
		; ******************

FECB:		pha

		.if	(OS_REVISION>=2)
		lda	ICDNO,X
		sta	ICDNOZ
		.endif
		jsr	FF4B
		ldx	PBPNT
		pla
		sta	PRNBUF,X
		inx
		cpx	PBUFSZ
		beq	FEF6
		stx	PBPNT
		cmp	#$9B
		beq	FEEB
		ldy	#1
		rts

FEEB:		lda	#$20
FEED:		sta	PRNBUF,X
		inx
		cpx	PBUFSZ
		bne	FEED
FEF6:		lda	#0
		sta	PBPNT
		ldx	FEA1
		ldy	FEA1+1
		jsr	FF14
		jmp	SIOV

		; ***************
		; **           **
		; **  Close P: **
		; **           **
		; ***************

FF07:		jsr	FF4B
		lda	#$9B
		ldx	PBPNT
		bne	FEED
		ldy	#1
		rts

FF14:		stx	DBUFLO
		sty	DBUFHI
		lda	#$40		; printer 1 ID
		sta	DDEVIC
		lda	ICDNOZ
		sta	DUNIT
		lda	#$80
		ldx	DCOMND
		cpx	#'S'		; COMMAND == STATUS ?
		bne	@1
		lda	#$40		; yes!
@1:		sta	DSTATS
		lda	PBUFSZ
		sta	DBYTLO
		lda	#0
		sta	DBYTHI
		lda	PTIMOT
		sta	DTIMLO
		rts

FF44:		lda	DVSTAT+2
		sta	PTIMOT
		rts

FF4B:		ldy	#'W'
		lda	ICAX2Z
@1:		cmp	#'N'
		bne	@2
		ldx	#'('
		bne	@4
@2:		cmp	#'D'
		bne	@3
		ldx	#$14
		bne	@4
@3:		cmp	#'S'
		bne	@5
		ldx	#29
@4:		stx	PBUFSZ
		sty	DCOMND
		sta	DAUX1
		rts
@5:		lda	#$4E
		bne	@1
