
		; ***************************************************************
		; **                                                           **
		; **  Device Handler Initialisation Code for devices E: S: K:  **
		; **                                                           **
		; ***************************************************************

SIN:		lda	#$FF
		sta	CH
		lda	RAMSIZ
		sta	RAMTOP
		lda	#$40
		sta	SHFLOK
		lda	#<KEYMAP
		sta	KEYDEF
		lda	#>KEYMAP
		sta	KEYDEF+1
		lda	#<FKYMAP
		sta	FKDEF
		lda	#>FKYMAP
		sta	FKDEF+1
		rts

		; ***************
		; **           **
		; **  Open S:  **
		; **           **
		; ***************

EF8E:		lda	ICAX2Z		; perform screen OPEN
		and	#%00001111
		bne	EF9C

		.if	(OS_REVISION=0)
		.byte	$AC,$47,$02
		.byte	$D0,$08
		.endif

		; ***************
		; **           **
		; **  Open E:  **
		; **           **
		; ***************

EF94:		lda	ICAX1Z		; perform editor OPEN
		and	#%00001111
		sta	ICAX1Z
		lda	#0

EF9C:		sta	DINDEX		; complete OPEN command
		cmp	#$10
		bcc	EFA7
		lda	#$91
		jmp	F154

EFA7:		lda	#>CHARSET1
		sta	CHBAS
		.if	(OS_REVISION>0)
		lda	#>CHARSET2
		sta	CHSALT
		.endif
		lda	#2
		sta	CHACT
		sta	SDMCTL
		lda	#1
		sta	DSTAT
		lda	#%11000000
		ora	POKMSK
		sta	POKMSK
		sta	IRQEN
		lda	#%01000000
		sta	NMIEN
		bit	FINE
		bpl	EFDC
		lda	#<FDL		; gimme a DLI!
		sta	VDSLST
		lda	#>FDL
		sta	VDSLST+1
		lda	#%11000000
EFDC:		sta	NMIEN
		lda	#0
		sta	TINDEX
		sta	ADRESS
		sta	SWPFLG
		sta	CRSINH
		ldy	#14
		lda	#1
EFEF:		sta	TABMAP,Y
		dey
		bpl	EFEF

		ldx	#4		; init color 0-3
EFF7:		lda	def_colors,X
		sta	COLOR0,X
		dex
		bpl	EFF7

		ldy	RAMTOP
		dey
		sty	TXTMSC+1
		lda	#$60
		sta	TXTMSC
		ldx	DINDEX
		lda	EE4D,X
		sta	HOLD1
		lda	RAMTOP
		sta	ADRESS+1
		ldy	EE1D,X
F019:		lda	#$28
		jsr	F57A
		dey
		bne	F019
		lda	GPRIOR
		and	#%00111111
		sta	MLTTMP+1
		tay
		cpx	#8
		bcc	F04C
		cpx	#15
		beq	F03E
		cpx	#12
		bcs	F04C
		txa
		ror
		ror
		ror
		and	#%11000000
		ora	MLTTMP+1
		tay
F03E:		lda	#$10
		jsr	F57A
		cpx	#11
		bne	F04C
		lda	#6		; gray
		sta	COLOR4
F04C:		sty	GPRIOR
		lda	ADRESS
		sta	SAVMSC
		lda	ADRESS+1
		sta	SAVMSC+1
F057:		lda	VCOUNT
		cmp	#$7A
		bne	F057
		jsr	F578
		lda	EE5D,X
		beq	F06C
		lda	#$FF
		sta	ADRESS
		dec	ADRESS+1
F06C:		jsr	F565
		lda	ADRESS
		sta	SAVADR
		lda	ADRESS+1
		sta	SAVADR+1
		lda	#$41
		jsr	F570
		stx	MLTTMP
		lda	#$18
		sta	BOTSCR
		lda	DINDEX
		cmp	#12
		bcs	F08D
		cmp	#9
		bcs	F0C6
F08D:		lda	ICAX1Z
		and	#%00010000
		beq	F0C6
		lda	#4
		sta	BOTSCR
		ldx	#2
		lda	FINE
		beq	F0A2
		jsr	F5A0
F0A2:		lda	#2
		jsr	F569
		dex
		bpl	F0A2
		ldy	RAMTOP
		dey
		tya
		jsr	F570
		lda	#$60
		jsr	F570
		lda	#$42
		jsr	F569
		clc
		lda	#$10
		adc	MLTTMP
		tay
		ldx	EE2D,Y
		bne	F0DB
F0C6:		ldy	MLTTMP
		ldx	EE2D,Y
		lda	DINDEX
		bne	F0DB
		lda	FINE
		beq	F0DB
		jsr	F5A0
		lda	#$22
		sta	HOLD1
F0DB:		lda	HOLD1
		jsr	F570
		dex
		bne	F0DB
		lda	DINDEX
		cmp	#8
		bcc	F10F
		cmp	#15
		beq	F0F1
		cmp	#12
		bcs	F10F
F0F1:		ldx	#$5D
		lda	RAMTOP
		sec
		sbc	#$10
		jsr	F570
		lda	#0
		jsr	F570
		lda	HOLD1
		ora	#$40
		jsr	F570
F107:		lda	HOLD1
		jsr	F570
		dex
		bne	F107
F10F:		lda	SAVMSC+1
		jsr	F570
		lda	SAVMSC
		jsr	F570
		lda	HOLD1
		ora	#$40
		jsr	F570
		lda	#$70
		jsr	F570
		lda	#$70
		jsr	F570
		lda	ADRESS
		sta	SDLSTL
		lda	ADRESS+1
		sta	SDLSTH
		lda	#$70
		jsr	F570
		lda	ADRESS
		sta	HIMEM
		lda	ADRESS+1
		sta	HIMEM+1
		ldy	#1
		lda	SDLSTL
		sta	(SAVADR),Y
		iny
		lda	SDLSTH
		sta	(SAVADR),Y
		lda	DSTAT
		bpl	F164
F154:		.if	(OS_REVISION=0)
		.byte	$48
		.byte	$20,$f8,$ee
		.byte	$68
		.else
		sta	DERRF
		jsr	EF94
		lda	DERRF
		ldy	#0
		sty	DERRF
		.endif
		tay
		rts

F164:		lda	ICAX1Z
		and	#%00100000
		bne	F175
		jsr	key_7D
		sta	TXTROW
		lda	LMARGN
		sta	TXTCOL
F175:		lda	#%00100010
		ora	SDMCTL
		sta	SDMCTL
		jmp	F20B

		; *******************
		; **               **
		; **  Get Byte S:  **
		; **               **
		; *******************

F180:		jsr	F6CA		; screen get-byte routine
		jsr	F18F
		jsr	F76A
		jsr	F60A
		jmp	F21E

F18F:		jsr	F5AC		; get data under cursor
		lda	(ADRESS),Y
		and	DMASK
F197:		lsr	SHFAMT
		bcs	F19E
		lsr
		bpl	F197
F19E:		sta	CHAR
		cmp	#0
F1A3:		rts

		; *******************
		; **               **
		; **  Put Byte S:  **
		; **               **
		; *******************

F1A4:		sta	ATACHR
		cmp	#$7D
		bne	F1B1
		jsr	key_7D
		jmp	F20B
F1B1:		jsr	F6CA
F1B4:		lda	ATACHR
		cmp	#$9B
		bne	F1C1
		jsr	key_9B
		jmp	F20B
F1C1:		jsr	F1CA
		jsr	F60E
		jmp	F20B

F1CA:		lda	SSFLAG		; plot point
		bne	F1CA
		ldx	#2
F1D1:		lda	ROWCRS,X	; copy $54..$56 -> 
		sta	OLDROW,X
		dex
		bpl	F1D1
		lda	ATACHR
		tay
		rol
		rol
		rol
		rol
		and	#%00000011
		tax
		tya
		and	#$9F
		ora	asc2int,X
F1E9:		sta	CHAR		; display
		jsr	F5AC
		lda	CHAR
F1F2:		lsr	SHFAMT
		bcs	F1FA
		asl
		jmp	F1F2
F1FA:		and	DMASK
		sta	TEMPOR
		lda	DMASK
		eor	#$FF
		and	(ADRESS),Y
		ora	TEMPOR
		sta	(ADRESS),Y
		rts

F20B:		jsr	F18F
		sta	OLDCHR
		ldx	DINDEX
		bne	F21E
		ldx	CRSINH
		bne	F21E
		eor	#$80
		jsr	F1E9

		; ********************************************
		; **                                        **
		; **  Open K: Close K: Get Status E: S: K:  **
		; **                                        **
		; ********************************************

F21E:		ldy	DSTAT

		.if	(OS_REVISION>0)
		jmp	F226
SELFS:		jmp	C8FC
		.endif

F226:		lda	#1
		sta	DSTAT
		lda	ATACHR

		; *********************************
		; **                             **
		; **  Special E: K: Put Byte K:  **
		; **                             **
		; *********************************

F22D:		rts

		; *******************
		; **               **
		; **  Close E: S:  **
		; **               **
		; *******************

F22E:		bit	FINE
		bpl	F21E
		.if	(OS_REVISION>0)
		lda	#$40
		sta	NMIEN
		lda	#0
		sta	FINE
		.endif
		lda	#<do_RTI
		sta	VDSLST
		lda	#>do_RTI
		sta	VDSLST+1
		.if	OS_REVISION=0
		.byte	$d0,$e5
		.else
		jmp	EF94
		.endif
		; *******************
		; **               **
		; **  Get Byte E:  **
		; **               **
		; *******************

GETCHAR:	jsr	F962
		jsr	F6BC
		lda	BUFCNT
		bne	F288
		lda	ROWCRS
		sta	BUFSTR
		lda	COLCRS
		sta	BUFSTR+1

F25C:		.if	(OS_REVISION=59)
		jsr	$E739
		.else
		jsr	KGB
		.endif
		sty	DSTAT
		lda	ATACHR
		cmp	#$9B
		beq	F27A
		jsr	F2BE
		jsr	F962
		lda	LOGCOL
		cmp	#$71
		bne	F277
		jsr	key_FD
F277:		jmp	F25C
F27A:		jsr	F718
		jsr	CBC
		lda	BUFSTR
		sta	ROWCRS
		lda	BUFSTR+1
		sta	COLCRS
F288:		lda	BUFCNT
		beq	F29D
F28C:		dec	BUFCNT
		beq	F29D
		lda	DSTAT
		bmi	F28C
		jsr	F180
		sta	ATACHR
		jmp	F962

F29D:		jsr	key_9B
		lda	#$9B
		sta	ATACHR
		jsr	F20B
		sty	DSTAT
		jmp	F962

F2AD:		jmp	(ADRESS)

		; ******************
		; **              **
		; ** Put Byte E:  **
		; **              **
		; ******************
		
OUTCHAR:	sta	ATACHR
		jsr	F962
		jsr	F6BC
		lda	#0
		sta	SUPERF
F2BE:		jsr	F718
		jsr	F93C
		beq	F2CF
F2C6:		asl	ESCFLG
		.if	(OS_REVISION=0)
		jsr	F1B1
		.else
		jsr	F1B4
		.endif
		jmp	F962
F2CF:		lda	DSPFLG
		ora	ESCFLG
		bne	F2C6
		asl	ESCFLG
		inx
		lda	SUPERF
		beq	F2E5
		txa
		clc
		adc	#45
		tax
F2E5:		lda	keyjump,X
		sta	ADRESS
		lda	keyjump+1,X
		sta	ADRESS+1
		jsr	F2AD		; JSR (ADRESS)
		jsr	F20B
		jmp	F962

IGN:		lda	#$FF
		sta	CH

		; *******************
		; **               **
		; **  Get Byte K:  **
		; **               **
		; *******************

KGB:		lda	#0
		sta	SUPERF
		lda	ICAX1Z
		lsr
		bcs	@10
		lda	#$80
		ldx	BRKKEY
		beq	@9
		lda	CH
		cmp	#$FF
		beq	KGB
		sta	HOLDCH
		ldx	#$FF
		stx	CH
		ldx	NOCLIK
		bne	@1
		jsr	keyclick
@1:		tay
		.if	(OS_REVISION=59)
		jmp	$E804
		nop
		.else
		cpy	#$C0
		bcs	IGN
		.endif
		lda	(KEYDEF),Y
@2:		sta	ATACHR
		tax
		bmi	@3
		jmp	@16
@3:		cmp	#$80
		beq	IGN
		cmp	#$81
		bne	@4
		lda	INVFLG
		eor	#$80
		sta	INVFLG
		bcs	IGN
@4:		cmp	#$82
		bne	@5
		lda	SHFLOK
		beq	@6
		lda	#0
		sta	SHFLOK
		beq	IGN
@5:		cmp	#$83
		bne	@7
@6:		lda	#$40
		sta	SHFLOK
		bne	IGN
@7:		cmp	#$84
		bne	@8
		lda	#$80
		sta	SHFLOK
		jmp	IGN
@8:		cmp	#$85
		bne	@11
		lda	#$88
@9:		sta	DSTAT
		sta	BRKKEY
@10:		lda	#$9B
		jmp	@18
@11:
		.if	(OS_REVISION=0)
		cmp	#$88
		bne	@skip
		jmp	$F2C4
@skip:
		.endif

		cmp	#$89
		bne	@13
		lda	NOCLIK
		eor	#$FF
		sta	NOCLIK
		bne	@12		; bne IGN
		jsr	keyclick
@12:		jmp	IGN

@13:		cmp	#$8E
		bcs	@15
		cmp	#$8A
		bcc	@12
		sbc	#$8A
		asl	HOLDCH
		bpl	@14
		ora	#4
@14:		tay
		lda	(FKDEF),Y
		jmp	@2
@15:		cmp	#$92
		bcs	@16
		cmp	#$8E
		bcc	@12		; bcc IGN
		sbc	#$72
		inc	SUPERF
		bne	@18
@16:		lda	HOLDCH
		cmp	#$40
		bcs	@17
		lda	ATACHR
		cmp	#$61
		bcc	@17
		cmp	#$7B
		bcs	@17
		lda	SHFLOK
		beq	@17
		ora	HOLDCH
		jmp	@1
@17:		jsr	F93C
		beq	@19		; beq F21E
		lda	ATACHR
		eor	INVFLG
@18:		sta	ATACHR
@19:		jmp	F21E

		; *******************************
		; ** KEYBOARD HANDLER ROUTINES **
		; *******************************
	
key_1B:		lda	#$80		; keyboard handler 27
		sta	ESCFLG
		rts

key_1C:		dec	ROWCRS		; keyboard handler 28
		bpl	F3F0
		ldx	BOTSCR
		dex
F3EE:		stx	ROWCRS
F3F0:		jmp	F90C

key_1D:		inc	ROWCRS		; keyboard handler 29
		lda	ROWCRS
		cmp	BOTSCR
		bcc	F3F0
		ldx	#0
		beq	F3EE

key_1E:		dec	COLCRS		; keyboard handler $1E
		lda	COLCRS
		bmi	real_fkey_1F
		cmp	LMARGN
		bcs	F40E

		.if	(OS_REVISION>0)
fkey_1F:
		.endif
real_fkey_1F:
		lda	RMARGN		; keyboard handler $1F
F40C:		sta	COLCRS
F40E:		jmp	F88E

key_1F:		inc	COLCRS		; keyboard handler $1F
		lda	COLCRS
		cmp	RMARGN
		bcc	F40E
		beq	F40E

		.if	(OS_REVISION>0)
fkey_1E:	
		.endif

		lda	LMARGN		; keyboard handler $1E
		jmp	F40C

key_7D:		jsr	F9A6		; keyboard handler $7D
		ldy	ADRESS
		lda	#0
		sta	ADRESS
F429:		sta	(ADRESS),Y
		iny
		bne	F429
		inc	ADRESS+1
		ldx	ADRESS+1
		cpx	RAMTOP
		bcc	F429
		lda	#$FF
F438:		sta	LOGMAP,Y
		iny
		cpy	#4
		bcc	F438

		.if	(OS_REVISION>0)
fkey_1C:
		.endif
real_fkey_1C:
		jsr	F997		; keyboard handler $1C
		sta	LOGCOL
		sta	BUFSTR+1
		lda	#0
		sta	ROWCRS
		sta	COLCRS+1
		sta	BUFSTR
		rts

key_7E:		lda	LOGCOL		; keyboard handler $7E
		cmp	LMARGN
		beq	F477
		lda	COLCRS
		cmp	LMARGN
		bne	F45F
		jsr	F923
F45F:		jsr	key_1E
		lda	COLCRS
		cmp	RMARGN
		bne	F46F
		lda	ROWCRS
		beq	F46F
		jsr	key_1C
F46F:		.if	(OS_REVISION=59)
		jmp	$E8BC
		nop
		nop
		.else
		lda	#$20
		sta	ATACHR
		.endif
		jsr	F1CA
F477:		jmp	F88E

key_7F:		jsr	key_1F		; keyboard handler $7F
		lda	COLCRS
		cmp	LMARGN
		bne	F48B
		jsr	F665
		jsr	F758
		bcs	F492
F48B:		lda	LOGCOL
		jsr	F75D
		bcc	key_7F
F492:		jmp	F88E

key_9F:		lda	LOGCOL		; keyboard handler $9F
		jmp	F73E

key_9E:		lda	LOGCOL		; keyboard handler $9E
		jmp	F74A

key_FF:		jsr	F94C		; keyboard handler $FF
		jsr	F18F
		sta	INSDAT
		lda	#0
		sta	SCRFLG
F4AC:		jsr	F1E9
		lda	LOGCOL
		pha
		jsr	F612
		pla
		cmp	LOGCOL
		bcs	F4C6
		lda	INSDAT
		pha
		jsr	F18F
		sta	INSDAT
		pla
		jmp	F4AC

F4C6:		jsr	F957
F4C9:		dec	SCRFLG
		bmi	F4D2
		dec	ROWCRS
		bne	F4C9
F4D2:		jmp	F88E

key_FE:		jsr	F94C		; keyboard handler $FE
F4D8:		jsr	F5AC
		lda	ADRESS
		sta	SAVADR
		lda	ADRESS+1
		sta	SAVADR+1
		lda	LOGCOL
		pha
		jsr	F60A
		pla
		cmp	LOGCOL
		bcs	F4FE
		lda	ROWCRS
		cmp	BOTSCR
		bcs	F4FE
		jsr	F18F
		ldy	#0
		sta	(SAVADR),Y
		beq	F4D8
F4FE:		ldy	#0
		tya
		sta	(SAVADR),Y
		jsr	F918
		jsr	F957
		jmp	F88E

key_9D:		sec			; keyboard handler $9D
F50D:		jsr	F7C2
		lda	LMARGN
		sta	COLCRS
		jsr	F5AC
		jsr	F78E
		jsr	F7E2
		jmp	F88E

key_9C:		jsr	F88E		; keyboard handler $9C
		ldy	HOLD1
		sty	ROWCRS

F527:		ldy	ROWCRS
@1:		tya
		sec
		jsr	F75B
		php
		tya
		clc
		adc	#$78
		plp
		jsr	F73C
		iny
		cpy	#$18
		bne	@1
		lda	LOGMAP+2
		ora	#1
		sta	LOGMAP+2

		.if (OS_REVISION=0)
		.byte	$a9,$00
		.byte	$85,$55
		.byte	$20,$00,$f5
		.byte	$20,$7e,$f7
		.byte	$20,$ac,$f6
		.byte	$90,$d4
		.byte	$b0,$12
key_FD:		.byte	$a0,$20
		.byte	$20,$d7,$f8
		.byte	$88
		.byte	$10,$fa
		.byte	$60
fkey_1C:	.byte	$4c,$8c,$f3
fkey_1D:	.byte	$20,$8c,$f3
		.byte	$4c,$32,$f3
fkey_1E:	.byte	$4c,$67,$f3
fkey_1F:	.byte	$4c,$56,$f3
		.else

		lda	#0
		sta	COLCRS
		jsr	F5AC
		jsr	F82A
		jsr	F758
		bcc	F527
		jmp	fkey_1E

key_FD:		ldy	#$20		; keyboard handler $FD
@1:		jsr	keyclick
		dey
		bpl	@1
		rts

fkey_1D:	jsr	fkey_1C		; keyboard handler $1D
		jmp	key_1C

		.endif

F565:		lda	#2
		bne	F57A

F569:		ldy	FINE
		beq	F570
		ora	#$20

F570:		ldy	DSTAT
		bmi	F59F		; rts
		ldy	#0
		sta	(ADRESS),Y

F578:		lda	#1
F57A:		sta	SUBTMP
		lda	DSTAT
		bmi	F59F		; rts
		lda	ADRESS
		sec
		sbc	SUBTMP
		sta	ADRESS
		bcs	@1
		dec	ADRESS+1
@1:		lda	APPMHI+1
		cmp	ADRESS+1
		bcc	F59F		; rts
		bne	@2
		lda	APPMHI
		cmp	ADRESS
		bcc	F59F		; rts
@2:		lda	#$93
		sta	DSTAT
F59F:		rts

F5A0:		lda	#2
		jsr	F570
		lda	#$A2
		jsr	F570
		dex
		rts

F5AC:		ldx	#1
		stx	MLTTMP
		dex
		stx	ADRESS+1
		lda	ROWCRS
		asl
		rol	ADRESS+1
		asl
		rol	ADRESS+1
		adc	ROWCRS
		sta	ADRESS
		bcc	@1
		inc	ADRESS+1
@1:		ldy	DINDEX
		ldx	EE6D,Y
@2:		asl	ADRESS
		rol	ADRESS+1
		dex
		bne	@2
		lda	COLCRS+1
		lsr
		lda	COLCRS
		ldx	EE9D,Y
		beq	@4
@3:		ror
		asl	MLTTMP
		dex
		bne	@3
@4:		adc	ADRESS
		bcc	@5
		inc	ADRESS+1
@5:		clc
		adc	SAVMSC
		sta	ADRESS
		sta	OLDADR
		lda	ADRESS+1
		adc	SAVMSC+1
		sta	ADRESS+1
		sta	OLDADR+1

		ldx	EE9D,Y
		lda	TMSK,X
		and	COLCRS
		adc	MLTTMP
		tay
		lda	EEAD-1,Y
		sta	DMASK
		sta	SHFAMT
		ldy	#0
F609:		rts


F60A:		lda	#0
		beq	F610

F60E:		lda	#$9B
F610:		sta	INSDAT

F612:		inc	LOGCOL
		inc	COLCRS
		bne	@1
		inc	COLCRS+1
@1:		lda	COLCRS
		ldx	DINDEX
		cmp	EE7D,X
		beq	@2
		cpx	#0
		bne	F609		; rts
		cmp	RMARGN
		beq	F609		; rts
		bcc	F609		; rts
@2:		cpx	#8
		bne	@3
		lda	COLCRS+1
		beq	F609
@3:		lda	DINDEX
		bne	F665
		lda	LOGCOL
		cmp	#$51
		bcc	@4
		lda	INSDAT
		beq	F665
		jsr	key_9B
		jmp	F6AB		; jmp F88E
@4:		jsr	F665
		lda	ROWCRS
		clc
		adc	#$78
		jsr	F75D
		bcc	@5		; bcc F88E
		lda	INSDAT
		beq	@5		; bcc F88E
		clc
		jsr	F50D
@5:		jmp	F88E

		; key_9B

key_9B:		lda	#$9B		; keyboard handler $9B
		sta	INSDAT

		; F665

F665:		jsr	F997
		lda	#0
		sta	COLCRS+1
		inc	ROWCRS
		ldx	DINDEX
		ldy	#$18
		bit	SWPFLG
		bpl	@1
		ldy	#4
		tya
		bne	@2
@1:		lda	EE8D,X
@2:		cmp	ROWCRS
		bne	F6AB		; bne F88E
		sty	HOLD3
		txa
		bne	F6AB		; bne F88E
		lda	INSDAT
		beq	F6AB		; beq F88E
		cmp	#$9B
		beq	@3
		clc
@3:		jsr	SCR
		inc	SCRFLG
		dec	BUFSTR
		bpl	@4
		inc	BUFSTR
@4:		dec	HOLD3
		lda	LOGMAP
		sec
		bpl	@3
		lda	HOLD3
		sta	ROWCRS
F6AB:		jmp	F88E

		; F6AE

F6AE:		sec
		lda	ROWAC,X
		sbc	ENDPT
		sta	ROWAC,X
		lda	ROWAC+1,X
		sbc	ENDPT+1
		sta	ROWAC+1,X
		rts

		; F6BC

F6BC:		lda	BOTSCR
		cmp	#4
		beq	F6CA
		lda	DINDEX
		beq	F6CA
		jsr	EF94

		; F6CA
	
F6CA:		lda	#39		; column 39 ?
		cmp	RMARGN
		bcs	@1
		sta	RMARGN
@1:		ldx	DINDEX
		lda	EE8D,X
		cmp	ROWCRS
		bcc	@5
		beq	@5
		cpx	#8
		bne	@2
		lda	COLCRS+1
		beq	@4
		cmp	#1
		bne	@5
		beq	@3
@2:		lda	COLCRS+1
		bne	@5
@3:		lda	EE7D,X
		cmp	COLCRS
		bcc	@5
		beq	@5
@4:		lda	#1
		sta	DSTAT
		lda	#$80
		ldx	BRKKEY
		sta	BRKKEY
		beq	@6
		rts
@5:		jsr	real_fkey_1C
		lda	#$8D
@6:		sta	DSTAT
		pla
		pla
		lda	SWPFLG
		bpl	@7
		jmp	F962
@7:		jmp	F21E

		; F718
	
F718:		ldy	#0
		lda	OLDADR+1
		beq	@1
		lda	OLDCHR
		sta	(OLDADR),Y
@1:		rts

		; bitmap routines
	
BMAP:		pha
		and	#%00000111
		tax
		lda	BARREL,X
		sta	BITMSK
		pla
		lsr
		lsr
		lsr
		tax
		rts

		; F732
	
F732:		rol	LOGMAP+2
		rol	LOGMAP+1
		rol	LOGMAP+0
		rts

		; F73C
	
F73C:		bcc	F74A
F73E:		jsr	BMAP
		lda	TABMAP,X
		ora	BITMSK
		sta	TABMAP,X
		rts

		; F74A
	
F74A:		jsr	BMAP
		lda	BITMSK
		eor	#$FF
		and	TABMAP,X
		sta	TABMAP,X
		rts

	
F758:		lda	ROWCRS
F75A:		clc
F75B:		adc	#$78
F75D:		jsr	BMAP
		clc
		lda	TABMAP,X
		and	BITMSK
		beq	F769
		sec
F769:		rts

		; F76A

F76A:		lda	CHAR
		ldy	DINDEX
		cpy	#14
		bcs	@2
		cpy	#12
		bcs	@1
		cpy	#3
		bcs	@2
@1:		rol
		rol
		rol
		rol
		and	#3
		tax
		lda	CHAR
		and	#$9F
		ora	int2asc,X
@2:		sta	ATACHR
do_RTS:		rts

		; F78E
	
F78E:		ldx	RAMTOP
		dex
		stx	SAVADR+1
		stx	MLTTMP+1
		lda	#$B0
		sta	SAVADR
		lda	#$D8
		sta	MLTTMP
		ldx	ROWCRS
@1:		inx
		cpx	BOTSCR
		beq	do_RTS		; rts
		ldy	#$27
@2:		lda	(SAVADR),Y
		sta	(MLTTMP),Y
		dey
		bpl	@2
		sec
		lda	SAVADR
		sta	MLTTMP
		sbc	#$28
		sta	SAVADR
		lda	SAVADR+1
		sta	MLTTMP+1
		sbc	#0
		sta	SAVADR+1
		jmp	@1

		; F7C2
	
F7C2:		php
		ldy	#$16
@1:		tya
		jsr	F75A
		php
		tya
		clc
		adc	#$79
		plp
		jsr	F73C
		dey
		bmi	@2
		cpy	ROWCRS
		bcs	@1
@2:		lda	ROWCRS
		clc
		adc	#$78
		plp
		jmp	F73C

		; F7E2
	
F7E2:		lda	LMARGN
		sta	COLCRS
		jsr	F5AC
		sec
		lda	RMARGN
		sbc	LMARGN
		tay
		lda	#0
@1:		sta	(ADRESS),Y
		dey
		bpl	@1
		rts

		; screen scroll routines

SCR:		jsr	F732
		lda	FINE
		beq	@5
@1:		lda	VSFLAG		; busy waiting (fine scroll)
		bne	@1
		lda	#8
		sta	VSFLAG
@2:		lda	VSFLAG		; busy waiting (fine scroll)
		cmp	#1
		bne	@2
@3:		lda	VCOUNT
		cmp	#$40
		bcs	@3		; busy waiting
		ldx	#$D
		lda	BOTSCR
		cmp	#4
		bne	@4
		ldx	#$70
@4:		cpx	VCOUNT
		bcs	@4
@5:		jsr	F9A6

		; F82A
	
F82A:		lda	ADRESS
		ldx	ADRESS+1
@1:		inx
		cpx	RAMTOP
		beq	@2
		sec
		sbc	#$10
		jmp	@1
@2:		adc	#39
		bne	@3
		ldx	ADRESS+1
		inx
		cpx	RAMTOP
		beq	@6
		clc
		adc	#$10
@3:		tay
		sta	COUNTR
		sec
		lda	ADRESS
		sbc	COUNTR
		sta	ADRESS
		bcs	@4
		dec	ADRESS+1
@4:		lda	ADRESS
		clc
		adc	#40
		sta	COUNTR
		lda	ADRESS+1
		adc	#0
		sta	COUNTR+1
@5:		lda	(COUNTR),Y
		sta	(ADRESS),Y
		iny
		bne	@5
		ldy	#$10
		lda	ADRESS
		cmp	#$D8
		beq	@6
		clc
		adc	#240
		sta	ADRESS
		bcc	@4
		inc	ADRESS+1
		bne	@4
@6:		ldx	RAMTOP
		dex
		stx	COUNTR+1
		ldx	#$D8
		stx	COUNTR
		lda	#0
		ldy	#$27
@7:		sta	(COUNTR),Y
		dey
		bpl	@7

		; F88E

F88E:		lda	#0
		sta	LOGCOL
		lda	ROWCRS
		sta	HOLD1
@1:		lda	HOLD1
		jsr	F75A
		bcs	@2
		lda	LOGCOL
		clc
		adc	#$28
		sta	LOGCOL
		dec	HOLD1
		jmp	@1
@2:		clc
		lda	LOGCOL
		adc	COLCRS
		sta	LOGCOL
		rts

		; CBC	; buffer count computation
	
CBC:		jsr	F94C
		lda	LOGCOL
		pha
		lda	BUFSTR
		sta	ROWCRS
		lda	BUFSTR+1
		sta	COLCRS
		lda	#1
		sta	BUFCNT
@1:		ldx	#$17
		lda	SWPFLG
		bpl	@2
		ldx	#3
@2:		cpx	ROWCRS
		bne	@3
		lda	COLCRS
		cmp	RMARGN
		bne	@3
		inc	BUFCNT
		jmp	@4
@3:		jsr	F60A
		inc	BUFCNT
		lda	LOGCOL
		cmp	LMARGN
		bne	@1
		dec	ROWCRS
		jsr	key_1E
@4:		jsr	F18F
		bne	@6
		dec	BUFCNT
		lda	LOGCOL
		cmp	LMARGN
		beq	@6
		jsr	key_1E
		lda	COLCRS
		cmp	RMARGN
		bne	@5
		dec	ROWCRS
@5:		lda	BUFCNT
		bne	@4
@6:		pla
		sta	LOGCOL
		jmp	F957

		; F90C

F90C:		jsr	F88E
		lda	HOLD1
		sta	BUFSTR
		lda	LMARGN
		sta	BUFSTR+1
F917:		rts


F918:		lda	LOGCOL
		cmp	LMARGN
		bne	@1
		dec	ROWCRS
@1:		jsr	F88E


F923:		lda	LOGCOL
		cmp	LMARGN
		beq	F917
		jsr	F5AC
		lda	RMARGN
		sec
		sbc	LMARGN
		tay
@1:		lda	(ADRESS),Y
		bne	F917
		dey
		bpl	@1
		jmp	F527

F93C:		ldx	#$2D
@1:		lda	keyjump,X
		cmp	ATACHR
		beq	F94B		; rts
		dex
		dex
		dex
		bpl	@1
F94B:		rts

F94C:		ldx	#2		; copy ZP --> TMPROW, TMPCOL
@1:		lda	ROWCRS,X
		sta	TMPROW,X
		dex
		bpl	@1
		rts

F957:		ldx	#2
@1:		lda	TMPROW,X	; copy TMPROW, TMPCOL -> ZP
		sta	ROWCRS,X
		dex
		bpl	@1
		rts

F962:		lda	BOTSCR
		cmp	#$18
		beq	@2		; beq F21E

		ldx	#11		; swap $54..$5F with $290..$29B
@1:		lda	ROWCRS,X	; TXTROW, TXTCOL, TINDEX
		pha			; TXTMSC, TXTOLD
		lda	TXTROW,X
		sta	ROWCRS,X
		pla
		sta	TXTROW,X
		dex
		bpl	@1
		lda	SWPFLG
		eor	#$FF
		sta	SWPFLG

@2:		jmp	F21E

keyclick:	ldx	#126
		pha
@1:		stx	CONSOL
		lda	VCOUNT
@2:		cmp	VCOUNT
		beq	@2
		dex
		dex
		bpl	@1
		pla
		rts

F997:		lda	#0
		ldx	SWPFLG
		bne	@1
		ldx	DINDEX
		bne	@2
@1:		lda	LMARGN
@2:		sta	COLCRS
		rts

F9A6:		lda	SAVMSC
		sta	ADRESS
		lda	SAVMSC+1
		sta	ADRESS+1
		rts

		; ******************
		; **              **
		; **  Special S:  **
		; **              **
		; ******************

F9AF:		ldx	#0
		lda	ICCOMZ
		cmp	#17
		beq	@2
		cmp	#18
		beq	@1
		ldy	#132		; ERROR: Invalid Handler Command
		rts

@1:		inx
@2:		stx	FILFLG
		lda	ROWCRS
		sta	NEWROW
		lda	COLCRS
		sta	NEWCOL
		lda	COLCRS+1
		sta	NEWCOL+1
		lda	#1
		sta	ROWINC
		sta	COLINC
		sec
		lda	NEWROW
		sbc	OLDROW
		sta	DELTAR
		bcs	@3
		lda	#$FF
		sta	ROWINC
		lda	DELTAR
		eor	#$FF
		clc
		adc	#1
		sta	DELTAR
@3:		sec
		lda	NEWCOL
		sbc	OLDCOL
		sta	DELTAC
		lda	NEWCOL+1
		sbc	OLDCOL+1
		sta	DELTAC+1
		bcs	@4
		lda	#$FF
		sta	COLINC
		lda	DELTAC
		eor	#$FF
		sta	DELTAC
		lda	DELTAC+1
		eor	#$FF
		sta	DELTAC+1
		inc	DELTAC
		bne	@4
		inc	DELTAC+1
@4:		ldx	#2
		ldy	#0
		sty	COLAC+1
@5:		tya
		sta	ROWAC,X
		lda	OLDROW,X
		sta	ROWCRS,X
		dex
		bpl	@5
		lda	DELTAC
		inx
		tay
		lda	DELTAC+1
		sta	COUNTR+1
		sta	ENDPT+1
		bne	@6
		lda	DELTAC
		cmp	DELTAR
		bcs	@6
		lda	DELTAR
		ldx	#2
		tay
@6:		tya
		sta	COUNTR
		sta	ENDPT
		pha
		lda	ENDPT+1
		lsr
		pla
		ror
		sta	ROWAC,X
@7:		lda	COUNTR
		ora	COUNTR+1
		bne	@8
		jmp	@19		; jmp F21E
@8:		clc
		lda	ROWAC
		adc	DELTAR
		sta	ROWAC
		bcc	@9
		inc	ROWAC+1
@9:		lda	ROWAC+1
		cmp	ENDPT+1
		bcc	@11
		bne	@10
		lda	ROWAC
		cmp	ENDPT
		bcc	@11
@10:		clc
		lda	ROWCRS
		adc	ROWINC
		sta	ROWCRS
		ldx	#0
		jsr	F6AE
@11:		clc
		lda	COLAC
		adc	DELTAC
		sta	COLAC
		lda	COLAC+1
		adc	DELTAC+1
		sta	COLAC+1
		cmp	ENDPT+1
		bcc	@15
		bne	@12
		lda	COLAC
		cmp	ENDPT
		bcc	@15
@12:		bit	COLINC
		bpl	@13
		dec	COLCRS
		lda	COLCRS
		cmp	#$FF
		bne	@14
		lda	COLCRS+1
		beq	@14
		dec	COLCRS+1
		bpl	@14
@13:		inc	COLCRS
		bne	@14
		inc	COLCRS+1
@14:		ldx	#2
		jsr	F6AE
@15:		jsr	F6CA
		jsr	F1CA
		lda	FILFLG
		beq	@18
		jsr	F94C
		lda	ATACHR
		sta	HOLD4
@16:		lda	ROWCRS
		pha
		jsr	F612
		pla
		sta	ROWCRS
		jsr	F6CA
		jsr	F18F
		bne	@17
		lda	FILDAT
		sta	ATACHR
		jsr	F1CA
		jmp	@16
@17:		lda	HOLD4
		sta	ATACHR
		jsr	F957
@18:		sec
		lda	COUNTR
		sbc	#1
		sta	COUNTR
		lda	COUNTR+1
		sbc	#0
		sta	COUNTR+1
		bmi	@19
		jmp	@7
@19:		jmp	F21E
