
		; **********************************************
		; **                                          **
		; **  OPERATING SYSTEM ROM PART 2: E400-FFFF  **
		; **                                          **
		; **********************************************

		.org $E400
		.segment "E400FFFF"

		.include "atari.inc"
		.include "gtia.inc"
		.include "antic.inc"
		.include "pokey.inc"
		.include "pia.inc"

		.import V009

		.import ROM1ID,C02C,C745,C7E4,C8FC
		.import C90C,C991,C996,C99B,C9A0,C9A5,C9AA
		.import CA29,CB56

		.if	(OS_REVISION = 4)
		.import	CB90
		.endif

		.import do_RTI,NMI_Handler,IRQ_Handler,RST_Handler
		.import parbus_init

		.import ROM1ID
		.import CHARSET1,CHARSET2
		.import SLFTST,COLDS,WARMS,INTIN,VBLKD
		.import VBLKI,SETVBL,SIO,DISKIN,DISKI

		.export	EDITRV,SCRENV ,KEYBDV,PRINTV,CASETV
		.export	DISKIV,DISKINV,SIOV  ,SETVBV,SYSVBV,XITVBV
		.export	SIOINV,SENDEV ,INTINV,CIOINV,WARMSV,COLDSV
		.export	RBLOKV,CSOPIV ,PUPDIV,SLFTSV,PENTV ,PHUNLV,PHINIV
		.export	KIR
		.export	E40C,E41C,E42C,E43C,E44C
		.export	E510,E55C,E716,E971
		.if	(OS_REVISION>=3)
		.export	V7EC,V7F6
		.endif
		.export FE36

		.if (OS_REVISION>0)
		.export init_parbus
		.export	GPDVV
		.export	PHR,E89E,E7DE
		.endif

		.export	ISRODN,ISRTD,ISRSIR
		.export	SELFS

		.if (OS_REVISION=0)

		PHE=$CAAE
		PHUNL=$CAEB
		PHINI=$CA34
		EEF9=$CB2D

		.endif

		; ***********************
		; **                   **
		; **  DEVICE HANDLERS  **
		; **                   **
		; ***********************

		; Device Handler "E:"

EDITRV:		.word	EF94-1		; Open    E:
		.word	F22E-1		; Close   E:
		.word	GETCHAR-1	; Get     E:
		.word	OUTCHAR-1	; Put     E:
		.word	F21E-1		; Status  E:
		.word	F22D-1		; Special E: [rts]
E40C:		jmp	SIN		; Init    E:
		.byte	0

		; Device Handler "S:"

SCRENV:		.word	EF8E-1		; Open    S:
		.word	F22E-1		; Close   S:
		.word	F180-1		; Get     S:
		.word	F1A4-1		; Put     S:
		.word	F21E-1		; Status  S:
		.word	F9AF-1		; Special S:
E41C:		jmp	SIN		; Init    S:
		.byte	0

		; Device Handler "K:"

KEYBDV:		.word	F21E-1		; Open    K:
		.word	F21E-1		; Close   K:
E424:		.word	KGB-1		; Get     K:
		.word	F22D-1		; Put     K: [rts]
		.word	F21E-1		; Get     K:
		.word	F22D-1		; Special K: [rts]
E42C:		jmp	SIN		; Init    K:
		.byte	0

		; Device Handler "P:"

PRINTV:		.word	FEC2-1		; Open    P:
		.word	FF07-1		; Close   P:
		.word	FEC1-1		; Get     P: [rts]
		.word	FECB-1		; Put     P:
		.word	FEA3-1		; Status  P:
		.word	FEC1-1		; Special P: [rts]
E43C:		jmp	PIN		; Init    P:
		.byte	0

		; Device Handler "C:"

CASETV:		.word	FCE6-1		; Open    C:
		.word	FDCF-1		; Close   C:
		.word	FD7A-1		; Get     C:
		.word	FDB4-1		; Put     C:
		.word	FDCC-1		; Status  C:
		.word	FCE5-1		; Special C: [rts]
E44C:		jmp	CIN		; Init    C: !!! Patched by XL-IT! !!!
		.byte	0

		; ********************
		; **                **
		; **  Jump Vectors  **
		; **                **
		; ********************

DISKIV:		jmp	DISKI
DISKINV:	jmp	DISKIN

		EntryPoint(CIOV)
		jmp	CIO		; Central I/O
SIOV:		jmp	SIO		; Serial  I/O
SETVBV:		jmp	SETVBL
SYSVBV:		jmp	VBLKI
XITVBV:		jmp	VBLKD
SIOINV:		jmp	SIOINT
SENDEV:		jmp	SENDEN
INTINV:		jmp	INTIN
CIOINV:		jmp	ICIO

EntryPoint(SELFSV)
		jmp	SELFS
WARMSV:		jmp	WARMS
COLDSV:		jmp	COLDS
RBLOKV:		jmp	RBLOK
CSOPIV:		jmp	CSOPI
PUPDIV:		jmp	SELFS
SLFTSV:		.if	(OS_REVISION<=2)
		jmp	SLFTST
		.else
		jmp	V009
		.endif
PENTV:		jmp	PHE
PHUNLV:		jmp	PHUNL
PHINIV:		jmp	PHINI

		; Device Handler Parallel Bus

		.if	(OS_REVISION=0)
		.res	15,0
		.else
GPDVV:		.word	C991-1
		.word	C996-1
		.word	C99B-1
		.word	C9A0-1
		.word	C9A5-1
		.word	C9AA-1
init_parbus:	jmp	parbus_init
		.endif

		; weird stuff

		.if	(OS_REVISION<=2)
		.res	34,0
		rts
		.else
V7EC:		.byte	$13,$03,$0F,$13,$04,$02,$01,$A8,$03,$07
V7F6:		.byte	$00,$28,$00,$B7,$92,$AB,$4C,$22,$72,$04
		.res	14,0
		rts
		.endif

		.include "cio.inc"
	
		.if (OS_REVISION>0)
	
		; *********************************
		; **                             **
		; **  PERIPHERAL HANDLER LOADER  **
		; **                             **
		; *********************************

		.if	(OS_REVISION=59)

		E89E	= $E89E
		E7DE    = $E7DE
		E7BE    = $E7BE
		E85D    = $E85D
		PHINI   = $E898

PHR:		jsr	$E74A
		jsr	$F2FD
		ldx	$2F4
		cpx	#$CC
		.byte	$f0,$03
		jsr	$CB65
		rts
		lda	$2BF
		cmp	#$18
		.byte	$d0,$f8
		bit	$24E
		.byte	$30,$0b
		lda	$58
		sta	$9C24
		lda	$59
		sta	$9C25
		rts
		jsr	$E7E6
		lda	$2BF
		sta	$F5
		ldy	#0
		sty	$67
		sty	$F6
		ldx	#$28
		stx	$66
		lda	($58),Y
		pha
		cmp	#2
		.byte	$f0,$0e
		and	#%01111111
		cmp	#0
		.byte	$f0,$08
		pla
		iny
		cpy	#$28
		.byte	$f0,$3a
		.byte	$d0,$eb
		pla
		cpy	$F6
		.byte	$d0,$33
		sty	$F7
		.byte	$a4,$66,$91,$64
		jsr	$E7FD
		ldy	$F7
		iny
		sty	$F6
		cpy	#$28
		.byte	$d0,$d4
		dec	$F5
		.byte	$f0,$43
		clc
		lda	#$28
		adc	$58
		sta	$58
		lda	$59
		adc	#0
		sta	$59
		clc
		lda	#$28
		adc	$64
		sta	$64
		lda	$65
		adc	#0
		sta	$65
		jmp	$E769
		sty	$67
		dey
		sty	$F7
		lda	($58),Y
		ldy	$66
		sta	($64),Y
		jsr	$E7FD
		ldy	$F7
		cpy	$F6
		.byte	$f0,$07
		.byte	$c0,$00
		.byte	$f0,$03
		dey
		.byte	$10,$e8
		ldy	$67
		sty	$F6
		cpy	#$28
		.byte	$f0,$bc
		jmp	$E773
		lda	#$58
		sta	$9C24
		sta	$64
		lda	#$98
		sta	$65
		sta	$9C25
		lda	#$40
		sta	$58
		lda	#$9C
		sta	$59
		rts
		lda	$66
		.byte	$f0,$02
		dec	$66
		rts
		cmp	#$BC
		.byte	$d0,$0e
		lda	$24E
		eor	#%10000000
		sta	$24E
		jsr	$E74A
		jmp	$F2FD
		jmp	$F328

		jsr	$E82F
		lda	$CD
		sta	$55
		lda	$CE
		sta	$54
		lsr	$CF
		jmp	$CB8F
		lda	$CF
		.byte	$f0,$f9
		.byte	$d0,$ed

		lda	$2BF
		cmp	#4
		.byte	$f0,$36
		lda	$5D
		and	#%01111111
		cmp	#$7B
		.byte	$d0,$05
		lda	#$16
		jmp	$E85A
		cmp	#$61
		.byte	$90,$25
		cmp	#$7A
		.byte	$b0,$21
		.byte	$a0,$00
		cmp	$E86D,Y
		.byte   $f0,$1a
		iny
		cpy	#6

		.byte	$d0,$f6
		sec
		sbc	#$60
		ora	$2B6
		jsr	$F2B0
		jsr	$F400
		ldx	$55
		cpx	$53
		.byte	$d0,$03
		jmp	$F3E6
		rts
		.byte	$62,$63,$68,$6e,$76,$78,$3b,$7b
		.byte	$2e,$60,$7b,$3b,$60,$2e,$2d,$5f,$5f,$2d,$20
		.byte   $00
		pla
		and	#%01111111
		ldx	#0
		cmp	$E873,X
		.byte	$f0,$08
		inx
		inx
		cpx	#14
		.byte	$d0,$f5
		.byte	$f0,$04
		inx
		lda	$E873,X
		ora	$2B6
		pha
		and	#%01111111
		.byte	$f0,$17
		cmp	#$5C
		.byte	$f0,$16
		cmp	#$20
		.byte	$90,$07
		cmp	#$41
		.byte	$b0,$03
		jmp	$E8B6
		cmp	#$5B
		.byte   $90,$07
		cmp	#$5F
		.byte	$b0,$03
		jsr	$E82F
		jmp	$CB97
		lda	$2F4
		cmp	#$E0
		.byte   $d0,$09
		bit	$2BE
		.byte	$70,$04
		lda	#0
		.byte	$f0,$02
		lda	#$20
		sta	$2FB
		jmp	$F474

		.res	62,0	

		.else

PHR:		lda	WARMST
		beq	@2
		lda	#<$3E9		; ZCHAIN = $3E9
		sta	ZCHAIN
		lda	#>$3E9
		sta	ZCHAIN+1
@1:		ldy	#$12
		clc
		lda	(ZCHAIN),Y
		tax
		iny
		adc	(ZCHAIN),Y
		beq	@4		; rts
		lda	(ZCHAIN),Y
		sta	ZCHAIN+1
		stx	ZCHAIN
		jsr	CB56
		bne	@4		; rts
		jsr	E894
		bcs	@4		; rts
		bcc	@1
@2:		lda	#0
		sta	CHLINK
		sta	CHLINK+1
		lda	#$4F
		bne	@7
@3:		lda	#0
		tay
		jsr	E7BE
		bpl	@5
@4:		rts

@5:		clc
		lda	MEMLO		; HIMEM>=(MEMLO+DVSTAT) ?
		adc	DVSTAT
		sta	TEMP1
		lda	MEMLO+1
		adc	DVSTAT+1
		sta	TEMP1+1
		sec
		lda	HIMEM
		sbc	TEMP1
		lda	HIMEM+1
		sbc	TEMP1+1
		bcs	@8

@6:		lda	#$4E
@7:		tay
		jsr	E7BE
		jmp	@3

@8:		lda	DVSTAT+2	; device SIO address used for loading
		ldx	MEMLO
		stx	DVSTAT+2
		ldx	MEMLO+1
		stx	DVSTAT+3
		jsr	E7DE
		bmi	@6
		sec
		jsr	E89E
		bcs	@6
		bcc	@3

E7BE:		pha
		ldx	#9
@1:		lda	E7D4,X
		sta	$300,X
		dex
		bpl	@1
		sty	DAUX2
		pla
		sta	DAUX1
		jmp	SIOV

		; original fill for $300 .. $309

E7D4:		.byte	$4F		; DDEVIC
		.byte	1		; DUNIT
		.byte	$40		; DCOMND
		.byte	%01000000	; DSTATS
		.word	DVSTAT		; DBUFLO/HI
		.byte	30		; DTIMLO
		.byte	0		; DUNUSE
		.word	4		; DBYTLO/HI

E7DE:		sta	TEMP2
		ldx	#0
		stx	TEMP1
		dex
		stx	TEMP3
		lda	DVSTAT+2
		ror
		bcc	@1
		inc	DVSTAT+2
		bne	@1
		inc	DVSTAT+3
@1:		lda	DVSTAT+2
		sta	LOADAD
		lda	DVSTAT+3
		sta	LOADAD+1
		lda	#<E816
		sta	GBYTEA
		lda	#>E816
		sta	GBYTEA+1
		lda	#$80
		sta	ZLOADA
		jmp	C745

E816:		ldx	TEMP3
		inx
		stx	TEMP3
		beq	@2
@1:		ldx	TEMP3
		lda	$37D,X
		clc
		rts
@2:		lda	#$80
		sta	TEMP3
		jsr	E833
		bpl	@1
		sec
		rts

E833:		ldx	#11
@1:		lda	E851,X
		sta	$300,X
		dex
		bpl	@1
		ldx	TEMP1
		stx	DAUX1
		inx
		stx	TEMP1
		lda	TEMP2
		sta	DDEVIC
		jmp	SIOV

		; Device Control Block

E851:		.byte	0		; DDEVIC
		.byte	1		; DUNIT
		.byte	$26		; DCOMND
		.byte	%01000000	; DSTATS
		.word	CASBUF		; DBUFLO/HI
		.byte	30		; DTIMLO
		.byte	0		; DUNUSE
		.word	$80		; DBYTLO/HI
		.word	0		; DAUX1/2

E85D:		sty	TEMP1
		sta	TEMP1+1
		lda	#<$3E9		; ZCHAIN = $3E9
		sta	ZCHAIN
		lda	#>$3E9
		sta	ZCHAIN+1
@1:		ldy	#$12
		lda	(ZCHAIN),Y
		tax
		iny
		lda	(ZCHAIN),Y
		cmp	TEMP1+1
		bne	@2
		cpx	TEMP1
		bne	@2
		clc
		rts
@2:		cmp	#0
		bne	@4
		cpx	#0
		bne	@4
@3:		sec
		rts
@4:		stx	ZCHAIN
		sta	ZCHAIN+1
		jsr	CB56
		bne	@3
		beq	@1
E894:		sec
		php
		bcs	E8C0		; jmp E8C0

PHINI:		sta	DVSTAT+3
		sty	DVSTAT+2

E89E:		php
		lda	#0
		tay
		jsr	E85D
		bcs	E8CE
		ldy	#$12
		lda	DVSTAT+2
		sta	(ZCHAIN),Y
		tax
		iny
		lda	DVSTAT+3
		sta	(ZCHAIN),Y
		stx	ZCHAIN
		sta	ZCHAIN+1
		lda	#0
		sta	(ZCHAIN),Y
		dey
		sta	(ZCHAIN),Y

E8C0:		jsr	E900
		bcc	E8D1
		lda	DVSTAT+3
		ldy	DVSTAT+2
		jsr	PHUNL
E8CE:		plp
		sec
		rts

E8D1:		plp
		bcs	E8DD
		lda	#0
		ldy	#$10
		sta	(ZCHAIN),Y
		iny
		sta	(ZCHAIN),Y
E8DD:		clc
		ldy	#$10
		lda	MEMLO
		adc	(ZCHAIN),Y
		sta	MEMLO
		iny
		lda	MEMLO+1
		adc	(ZCHAIN),Y
		sta	MEMLO+1
		ldy	#15
		lda	#0
		sta	(ZCHAIN),Y
		jsr	CB56
		ldy	#15
		sta	(ZCHAIN),Y
		clc
		rts

E900:		clc
		lda	ZCHAIN
		adc	#12
		sta	TEMP1
		lda	ZCHAIN+1
		adc	#0
		sta	TEMP1+1
		jmp	(TEMP1)

		.endif

		jmp	SETVBL

PHUNL:		jsr	E85D
		bcs	@3
		tay
		lda	ZCHAIN
		pha
		lda	ZCHAIN+1
		pha
		stx	ZCHAIN
		sty	ZCHAIN+1
		lda	COLDST
		bne	@1
		ldy	#$10
		clc
		lda	(ZCHAIN),Y
		iny
		adc	(ZCHAIN),Y
		bne	@2
		jsr	CB56
		bne	@2
@1:		ldy	#18
		lda	(ZCHAIN),Y
		tax
		iny
		lda	(ZCHAIN),Y
		tay
		pla
		sta	ZCHAIN+1
		pla
		sta	ZCHAIN
		tya
		ldy	#19
		sta	(ZCHAIN),Y
		dey
		txa
		sta	(ZCHAIN),Y
		clc
		rts
@2:		pla
		pla
@3:		sec
		rts

		; weird stuff

		.res	2,0		; two bytes wasted
		jmp	SIO

		.endif

		.include "sio.inc"

		.if (OS_REVISION=0)

		.include "dev_p.inc"
		.include "dev_c.inc"

		.else

		.include "grxtabs.inc"

		; *****************************************
		; **                                     **
		; **  END OF: PERIPHERAL HANDLER LOADER  **
		; **                                     **
		; *****************************************

PHE:		pha			; peripheral handler entry
		tya
		pha
		txa
		ldx	#0
@1:		cmp	HATABS,X
		beq	@3
		inx
		inx
		inx
		cpx	#$22
		bmi	@1
		ldx	#0
		tay
		lda	#0
@2:		cmp	HATABS,X
		beq	@4
		inx
		inx
		inx
		cpx	#$22
		bmi	@2
		pla
		pla
		ldy	#$FF
		sec
		rts

@3:		pla
		tay
		pla
		inx
		sec
		rts

@4:		tya
		sta	HATABS,X
		pla
		sta	HATABS+1,X
		pla
		sta	HATABS+2,X
		clc
		rts

EEF9:		ldy	#0
		lda	(ICBALZ),Y
		ldy	ICDNOZ
		jsr	E7BE
		bpl	EF07
		ldy	#130
		rts

EF07:		lda	#$7F
		sta	ICHIDZ
		lda	#<(EF26-1)
		sta	ICPTLZ
		lda	#>(EF26-1)
		sta	ICPTHZ
		lda	DVSTAT+2

		.byte	$AE		; absolute addr. mode for LDX ICAX5Z
		.word	ICAX5Z

		sta	ICAX4,X
		ldy	#0
		lda	(ICBALZ),Y
		sta	ICAX3,X
		ldy	#1
		rts

EF26:		pha
		txa
		pha
		and	#%00001111
		bne	EF3D
		cpx	#$80
		bpl	EF3D
		lda	HNDLOD
		bne	EF41
		ldy	#$82

EF38:		pla
		pla
		cpy	#0
		rts
EF3D:		ldy	#134
		bmi	EF38

EF41:		.byte	$8E		; absolute addr. mode for STX ICAX5Z
		.word	ICAX5Z

		ldy	#0
EF46:		lda	IOCB,X
		sta	ZIOCB,Y
		inx
		iny
		cpy	#12
		bmi	EF46

		jsr	CA29
		bmi	EF38
		pla
		tax
		pla
		tay
		lda	ICPTHZ
		pha
		lda	ICPTLZ
		pha
		tya
		ldy	#146
		rts

		.res	6,0		; 6 bytes wasted
	
		jmp	FD05

		.endif

		.include "dev_ske.inc"

		.if	(OS_REVISION=0)

		.include "grxtabs.inc"	
		.include "auxtabs.inc"

KIR:		.byte	$ad,$09,$d2
		.byte	$cd
                .byte	$f2,$02
		.byte	$d0,$05
		.byte	$ad,$f1,$02
		.byte	$d0,$55
		.byte	$ad,$09,$d2
		.byte	$c9,$83
		.byte	$d0,$1b
                .byte	$ad,$6d,$02
		.byte	$49,$ff
		.byte	$8d,$6d,$02
		.byte	$d0,$07
		.byte	$ad,$01,$d3
		.byte	$09,$04
		.byte	$d0,$05
		.byte	$ad,$01,$d3
		.byte	$29,$fb
		.byte	$8d,$01,$d3
		.byte	$b0,$2a
		.byte	$ad,$6d,$02
		.byte	$d0,$3f
                .byte	$ad,$09,$d2
		.byte	$c9,$9f
		.byte	$d0,$0a
		.byte	$ad,$ff,$02
		.byte	$49,$ff
		.byte	$8d,$ff,$02
		.byte	$b0,$14
		.byte	$29,$3f
		.byte	$c9,$11
		.byte	$d0,$2a
		.byte	$ad,$09,$d2
		.byte	$8d,$dc,$02
		.byte	$d0,$06
		.byte	$8d,$fc,$02
		.byte	$8d,$f2,$02
		.byte	$a9,$03
		.byte	$8d,$f1,$02
		.byte	$a9,$00
		.byte	$85,$4d
		.byte	$ad,$d9,$02
		.byte	$8d,$2b,$02
		.byte	$ad,$2f,$02
		.byte	$d0,$06
		.byte	$ad,$dd,$02
		.byte	$8d,$2f,$02
		.byte	$68
                .byte	$40

		.byte	$ad,$09,$d2,$c9,$84,$f0,$28,$c9,$94,$d0,$d3,$ad,$f4,$02,$29
                .byte	$fc,$c9,$cc,$f0,$0c,$ad,$01,$d3,$29,$f7,$8d,$01,$d3,$a9,$cc,$d0
                .byte	$0a,$ad,$01,$d3,$09,$08,$8d,$01,$d3,$a9,$e0,$8d,$f4,$02,$d0,$b5
                .byte	$ad,$2f,$02,$f0,$ca,$8d,$dd,$02,$a9,$00,$8d,$2f,$02,$f0,$c0

		.include "fdl.inc"
	
		.byte	$00,$00,$00,$00,$00,$00,$00,$4c,$d7,$f8,$00,$00,$00,$00,$00,$00
	
SELFS:		.byte	$a9,$ff
		.byte	$8d,$44,$02
		.byte	$a9,$00
		.byte	$8d,$dc,$02
		.byte	$a9,$01
		.byte	$8d,$fb,$02
                .byte	$a2,$10
		.byte	$a9,$0c,$9d,$42,$03,$20,$56,$e4,$a2,$10
		.byte	$a9,$03
		.byte	$9d,$42
                .byte	$03
		.byte	$a9,$a0
		.byte	$9d,$44,$03
		.byte	$a9,$fd
		.byte	$9d,$45,$03
		.byte	$a9,$08
		.byte	$9d,$4a,$03
		.byte	$a9,$07
		.byte	$9d,$4b,$03
		.byte	$20,$56,$e4
		.byte	$a9,$00
		.byte	$8d,$2f,$02
		.byte	$a9,$a2
		.byte	$85,$d0
		.byte	$a9,$fd
		.byte	$85,$d1
		.byte	$a2,$24
		.byte	$86,$d2
		.byte	$a0,$00
		.byte	$8c,$5c,$00
		.byte	$8c,$56,$00,$b1
		.byte	$d0,$e6
		.byte	$d0,$d0,$02,$e6,$d1,$48,$29,$7f,$18,$69,$2d,$8d
                .byte	$5b,$00,$ce,$5b,$00,$18,$69,$04,$8d,$55,$00,$68,$48,$10,$06,$ce
                .byte	$55,$00,$ce,$55,$00,$a5,$d2,$8d,$5a,$00,$8d,$54,$00,$a2,$10,$a9
                .byte	$11,$9d,$42,$03,$20,$56,$e4,$68,$c9,$44,$d0,$bd,$e6,$d2,$a5,$d2
                .byte	$c9,$3e,$d0,$b5,$a0,$92,$a2,$fe,$a9,$07,$20,$5c,$e4,$a9,$22,$8d
                .byte	$2f,$02,$ad,$dc,$02,$f0,$fb,$a9,$00,$8d,$dc,$02,$a0,$a3,$a2,$c2
                .byte	$a9,$07
		.byte	$20,$5c,$e4
		.byte	$ad,$01,$d3
		.byte	$29,$7f,$8d,$01,$d3,$4c,$83,$e4
                .byte $53,$3a,$8a,$11,$15,$19,$1d,$a6,$36,$39,$44,$09,$11,$15,$19,$1d
                .byte $25,$34,$38,$3b,$44,$08,$0a,$11,$15,$19,$1d,$24,$26,$34,$38,$3c
                .byte $44,$08,$0a,$11,$15,$19,$1d,$24,$26,$33,$37,$3b,$3d,$44,$08,$0a
                .byte $17,$24,$26,$33,$34,$3d,$3e,$44,$07,$0b,$17,$23,$27,$33,$3e,$44
                .byte $07,$0b,$17,$23,$27,$33,$3e,$44,$07,$0b,$17,$23,$27,$33,$3e,$44
                .byte $06,$0c,$17,$22,$28,$33,$3e,$44,$06,$0c,$17,$22,$28,$33,$3e,$44
                .byte $06,$0c,$17,$22,$28,$33,$3d,$44,$05,$0d,$17,$21,$29,$33,$3c,$44
                .byte $05,$0d,$17,$21,$29,$33,$3b,$44,$05,$0d,$17,$21,$29,$33,$3a,$44
                .byte $04,$0e,$17,$20,$2a,$33,$39,$44,$04,$0e,$17,$20,$2a,$33,$39,$44
                .byte $04,$0e,$17,$20,$2a,$33,$3a,$44,$03,$07,$0b,$0f,$17,$1f,$23,$27
                .byte $2b,$33,$3a,$44,$03,$07,$0b,$0f,$17,$1f,$23,$27,$2b,$33,$3b,$44
                .byte $03,$07,$0b,$0f,$17,$1f,$23,$27,$2b,$33,$3b,$44,$02,$06,$0a,$0e
                .byte $10,$17,$1e,$22,$26,$2a,$2c,$33,$3c,$44,$02,$10,$17,$1e,$2c,$33
                .byte $3c,$44,$02,$10,$17,$1e,$2c,$33,$3d,$44,$01,$11,$17,$1d,$2d,$33
                .byte $3d,$44,$01,$11,$17,$1d,$2d,$33,$3e,$44,$01,$11,$17,$1d,$2d,$33
                .byte $3e,$44,$c6,$d4,$a5,$d4,$29,$fe,$aa,$a0,$e6,$8d,$0a,$d4,$e8,$e8
                .byte $d0,$02,$a2,$10,$8e,$16,$d0,$88,$d0,$f1,$4c,$62,$e4,$48,$8a,$48
                .byte $29,$0f,$d0,$10,$e0,$80,$10,$0c,$ad,$e9,$02,$d0,$0b,$a0,$82,$68
                .byte $68,$c0,$00,$60,$a0,$86,$30,$f7,$8e,$2e,$00,$a0,$00,$bd,$40,$03
                .byte $99,$20,$00,$e8,$c8,$c0,$0c,$30,$f4,$20,$5a,$cb,$30,$e1,$68,$aa
                .byte $68,$a8,$a5,$27,$48,$a5,$26,$48,$98,$a0,$92,$60,$00,$13,$16,$d1
                .byte $e4,$e4,$e8,$29,$eb,$ee,$00,$00,$2d,$25,$2d,$2f,$32,$39,$00,$34
                .byte $25,$33,$34,$00,$00,$00,$32,$2f,$2d,$32,$21,$2d,$00,$00,$2b,$25
                .byte $39,$22,$2f,$21,$32,$24,$00,$34,$25,$33,$34,$00,$00,$00,$b2,$91
                .byte $00,$92,$00,$93,$00,$94,$00,$a8,$00,$a1,$00,$a2,$00,$00,$00,$5b
                .byte $00,$11,$00,$12,$00,$13,$00,$14,$00,$15,$00,$16,$00,$17,$00,$18
                .byte $00,$19,$00,$10,$00,$1c,$00,$1e,$00,$a2,$80,$b3,$00,$00,$00,$ff
                .byte $ff,$00,$31,$00,$37,$00,$25,$00,$32,$00,$34,$00,$39,$00,$35,$00
                .byte $29,$00,$2f,$00,$30,$00,$0d,$00,$1d,$00,$b2,$b4,$00,$00,$00,$80
                .byte $dc,$80,$00,$21,$00,$33,$00,$24,$00,$26,$00,$27,$00,$28,$00,$2a
                .byte $00,$2b,$00,$2c,$00,$1b,$00,$0b,$00,$0a,$00,$a3,$00,$00,$00,$80
                .byte $b3,$a8,$80,$00,$3a,$00,$38,$00,$23,$00,$36,$00,$22,$00,$2e,$00
                .byte $2d,$00,$0c,$00,$0e,$00,$0f,$00,$80,$b3,$a8,$80,$00,$00,$00,$00
                .byte $00,$00,$00,$00,$80,$b3,$80,$b0,$80,$a1,$80,$a3,$80,$a5,$80,$80
                .byte $80,$a2,$80,$a1,$80,$b2,$80,$00,$33,$00,$30,$00,$21,$00,$23,$00
                .byte $25,$00,$00,$00,$22,$00,$21,$00,$32,$00,$00,$33,$28,$00,$22,$00
                .byte $33,$00,$5c,$00,$36,$2f,$29,$23,$25,$00,$03,$00,$00,$00

		.else
	
		.include "auxtabs.inc"

		; **********************************
		; **                              **
		; **  KEYBOARD INTERRUPT ROUTINE  **
		; **                              **
		; **********************************

KIR:		txa
		pha
		tya
		pha
		ldy	PORTB
		lda	KBCODE
		cmp	CH1
		bne	@1
		ldx	KEYDEL
		bne	@8
@1:		ldx	KEYDIS
		cmp	#$83
		bne	@4
		txa
		eor	#$FF
		sta	KEYDIS
		bne	@2
		tya
		ora	#%00000100
		bne	@3
@2:		tya
		and	#%11111011
@3:		tay
		bcs	@7
@4:		txa
		bne	@9
		lda	KBCODE
		tax
		cmp	#$9F
		bne	@5
		lda	SSFLAG
		eor	#%11111111
		sta	SSFLAG
		bcs	@7
@5:		.if	(OS_REVISION=59)
		and	#%11111111
		.else
		and	#%00111111
		.endif
		cmp	#17
		bne	@10
		stx	HELPFLG
		beq	@7
@6:		stx	CH
		stx	CH1
@7:		lda	#3
		sta	KEYDEL
		lda	#0
		sta	ATRACT
@8:		lda	KRPDEL
		sta	SRTIMR
		lda	SDMCTL
		bne	@9
		lda	DMASAV
		sta	SDMCTL
@9:		sty	PORTB
		pla
		tay
		pla
		tax
		pla
		rti

@10:		cpx	#$84
		beq	@12
		.if	(OS_REVISION=59)
		cmp	#$51
		.else
		cpx	#$94
		.endif
		bne	@6

		lda	CHBAS
		ldx	CHSALT
		sta	CHSALT
		stx	CHBAS
		cpx	#>CHARSET2
		beq	@11
		tya
		ora	#%00001000
		tay
		bne	@7
@11:		tya
		and	#%11110111
		tay
		jmp	@7

@12:		lda	SDMCTL
		beq	@9
		sta	DMASAV
		lda	#0
		sta	SDMCTL
		beq	@9

		.include "fdl.inc"

		.byte	0,0		; waste 2 bytes
		jmp	keyclick	; waste 3 bytes

		.include "dev_c.inc"
		.include "dev_p.inc"
		.include "checksum.inc"

		.endif
	
		.res	($FFEE-*),0	; next block (ROM2ID) starts at $FFEE

		.include "rom2id.inc"

		; ***************************************
		; **                                   **
		; **  6502 HARDWARE INTERRUPT VECTORS  **
		; **                                   **
		; ***************************************

FFFA:		.word	NMI_Handler	; Non-Maskable Interrupt (NMI) handler
FFFC:		.word	RST_Handler	; Reset (RST) handler
FFFE:		.word	IRQ_Handler	; Interrupt Request (IRQ) handler

		; **********************************
		; **                              **
		; ** END OF OPERATING SYSTEM ROM  **
		; **                              **
		; **********************************

		.end
