
		; **********************
		; **                  **
		; **  VBLANK STAGE 1  **
		; **                  **
		; **********************

VBLKI:		inc	RTCLOK+2	; increase RTCLOK
		bne	@1
		inc	ATRACT
		inc	RTCLOK+1
		bne	@1
		inc	RTCLOK

@1:		lda	#%11111110	; manage ATRACT mode
		ldx	#0
		ldy	ATRACT
		bpl	@2
		sta	ATRACT
		ldx	RTCLOK+1
		lda	#%11110110
@2:		sta	DRKMSK
		stx	COLRSH
		.if	(OS_REVISION>0)
		lda	COLOR1
		eor	COLRSH
		and	DRKMSK
		sta	COLPF1
		.endif

		ldx	#0		; decrement countdown timer 1
		jsr	dec_timer
		bne	@3
		jsr	@16		; jsr (CDTMA1)

@3:		lda	CRITIC
		bne	@4		; bne VBLKD
		tsx
		lda	$104,X
		and	#%00000100
		beq	@5		; skip if no I-bit
@4:		jmp	VBLKD

@5:		lda	TRIG3		; crash purposely if (TRIG3!=GINTLK)
		cmp	GINTLK
		bne	HALT

		lda	PENV		; light pen hardware -> shadow
		sta	LPENV
		lda	PENH
		sta	LPENH	
		lda	SDLSTH		; dlist shadow -> hardware
		sta	DLISTH
		lda	SDLSTL
		sta	DLISTL
		lda	SDMCTL		; dma control shadow -> hardware
		sta	DMACTL
		lda	GPRIOR		; GTIA priority shadow -> hardware
		sta	PRIOR
		lda	VSFLAG		; do vertical scrolling
		beq	@6
		dec	VSFLAG
		lda	#8
		sec
		sbc	VSFLAG
		and	#%00000111	; mask to lower 3 bits
		sta	VSCROL
@6:		ldx	#8		; reset console keys
		stx	CONSOL

@7:		cli			; copy shadow colors -> GTIA
		lda	PCOLR0,X	; the label should be here
		eor	COLRSH
		and	DRKMSK
		sta	$D012,X
		dex
		bpl	@7

		lda	CHBAS		; character base shadow -> hardware
		sta	CHBASE
		lda	CHACT		; character control shadow -> hardware
		sta	CHACTL

		ldx	#2		; decrement countdown timer 2
		jsr	dec_timer
		bne	@8
		jsr	@17		; jsr (CDTMA2)

@8:		ldx	#2		; decrement timer 3,4,5 & set flags
@9:		inx
		inx
		lda	$218,X
		ora	$219,X
		beq	@10
		jsr	dec_timer
		sta	$226,X
@10:		cpx	#8
		bne	@9

		lda	SKSTAT
		and	#%00000100
		beq	@11
		lda	KEYDEL
		beq	@11
		dec	KEYDEL
@11:		lda	SRTIMR
		beq	@13
		lda	SKSTAT
		and	#%00000100
		bne	@12
		dec	SRTIMR
		bne	@13
		lda	KEYDIS
		bne	@13
		lda	KEYREP
		sta	SRTIMR

		lda	KBCODE		; KBCODE in [$9F,$83,$84,$94,$11,$51,$91,$D1] ?
		cmp	#$9F		;  ... skip
		beq	@13
		cmp	#$83
		beq	@13
		cmp	#$84
		beq	@13
		.if	(OS_REVISION>0)
		cmp	#$94
		beq	@13
		.endif
		and	#$3F
		cmp	#$11
		beq	@13

		lda	KBCODE
		sta	CH
		jmp	@13

@12:		lda	#0
		sta	SRTIMR

@13:		lda	PORTA		; set stick() values
		lsr
		lsr
		lsr
		lsr
		sta	STICK1
		sta	STICK3
		lda	PORTA
		and	#%00001111
		sta	STICK0
		sta	STICK2

		lda	TRIG0		; set STRIG() from TRIG() values
		sta	STRIG0
		sta	STRIG2
		lda	TRIG1
		sta	STRIG1
		sta	STRIG3

		ldx	#3		; set PADDLE() from POT() values
@14:		lda	$D200,X
		sta	$270,X
		sta	$274,X
		dex
		bpl	@14

		sta	POTGO		; paddles have been read; initiate new "POTGO"!

		ldx	#2		; set PTRIG() values
		ldy	#1
@15:		lda	$278,Y
		lsr
		lsr
		lsr
		sta	$27D,X
		sta	$281,X
		lda	#0
		rol
		sta	$27C,X
		sta	$280,X
		dex
		dex
		dey
		bpl	@15

		jmp	(VVBLKD)

@16:		jmp	(CDTMA1)
@17:		jmp	(CDTMA2)

		; *********************************
		; **                             **
		; **  DECREMENT COUNTDOWN TIMER  **
		; **                             **
		; *********************************

dec_timer:	ldy	CDTMV1,X	; if it has already expired,
		bne	@1		; return $FF
		ldy	CDTMV1+1,X
		beq	@2
		dec	CDTMV1+1,X	; decrease timer value
@1:		dec	CDTMV1,X
		bne	@2
		ldy	CDTMV1+1,X
		bne	@2
		lda	#0		; not expired: return 0
		rts
@2:		lda	#$FF		; expired: return $FF
		rts

		; ************************************
		; **                                **
		; **  SET VERTICAL BLANK INTERRUPT  **
		; **                                **
		; ************************************

		; subroutine to set vertical blank vectors and timers
		; entry X=hi, Y=lo byte to set
		;       A= 1-5 TIMERS 1-5
		;          6 immediate VBLANK
		;          7 deferred  VBLANK

SETVBL:		asl			; mul by 2
		sta	INTEMP
		txa
		ldx	#5
		sta	WSYNC		; waste 20 CPU cycles
@1:		dex			; to allow VBLANK to happen
		bne	@1		; if this is line "7C"
		ldx	INTEMP
		sta	$217,X
		tya
		sta	$216,X
		rts
	
		; ******************************************
		; *                                       **
		; *  END-VBLANK & DEFAULT VBLANK STAGE 2  **
		; *                                       **
		; ******************************************

		; exit rom vertical blank

VBLKD:		pla		; unstack Y
		tay
		pla		; unstack X
		tax
		pla		; unstack A
		rti		; and go back from whence
