		.segment "FC00FFFF"
	
		; 6502 IRQ VECTOR

FC00:           jmp     ($200)

FC03:           pha
                lda     #$20
                bit     $E80E
                bne     FC18
                lda     #$DF
                sta     $E80E
                lda     $0
                sta     $E80E
                jmp     ($210)

FC18:           bpl     FC88
                bvc     FC95
                lda     #$10
                and     $E80E
                bne     FC30
                lda     #$EF
                sta     $E80E
                lda     $0
                sta     $E80E
                jmp     ($212)

FC30:           lda     #8
                and     0
                beq     FC48
                and     $E80E
                bne     FC48
                lda     #$F7
                sta     $E80E
                lda     $0
                sta     $E80E
                jmp     ($214)

FC48:           lda     $E80E
                ror     A
                bcs     FC5B
                lda     #$FE
                sta     $E80E
                lda     $0
                sta     $E80E
                jmp     ($216)

FC5B:           ror     A
                bcs     FC6B
                lda     #$FD
                sta     $E80E
                lda     $0
                sta     $E80E
                jmp     ($218)

FC6B:           ror     A
                bcs     FC7B
                lda     #$FB
                sta     $E80E
                lda     $0
                sta     $E80E
                jmp     ($21A)

FC7B:           txa
                pha
                tsx
                lda     $103,X
                and     #$10
                beq     FCB4
                jmp     ($20E)

FC88:           lda     #$7F
                sta     $E80E
                lda     $0
                sta     $E80E
                jmp     ($20C)

FC95:           lda     #$BF
                sta     $E80E
                lda     $0
                sta     $E80E
                jmp     ($208)

		; 6502 NMI VECTOR

FCA2:           bit     $D40F
                sta     $D40F
                bmi     FCAF
                bvc     FCB7
                jmp     ($202)

FCAF:           jmp     ($206)

FCB2:           pla
                tay
FCB4:           pla
                tax
                pla
FCB7:           rti
FCB8:           pha
                txa
                pha
                tya
                pha
                inc     $2
                bne     FCC5
                inc     $4
                inc     $1
FCC5:           lda     $3
                bne     FCB2
                lda     $6
                sta     $D403
                lda     $5
                sta     $D402
                lda     $7
                sta     $D400
                ldy     $4
                bpl     FCE0
                ldy     #$80
                sty     $4
FCE0:           ldx     #8
FCE2:           lda     $8,X
                cpy     #$80
                bcc     FCEC
                eor     $1
                and     #$F6
FCEC:           sta     $C012,X
                dex
                bpl     FCE2
                ldx     #7
FCF4:           lda     $E800,X
                sta     $11,X
                dex
                bpl     FCF4
                sta     $E80B
                jmp     ($204)

FD02:           txa
                pha
                tya
                pha
                lda     $E809
                lsr     A
                and     #15
                tax
                lda     FD13,X
                jmp     ($20A)

FD13:           .byte   $FF,$0B,$00,$0A,$0E,$09,$08,$07
                .byte   $0D,$06,$05,$04,$0C,$03,$02,$01

		; 6502 RESET VECTOR

FD23:           sei
                cld
                ldx     #$FF
                txs
                lda     $BFFD
                cmp     #$FF
                bne     @nocart
                jmp     ($BFFE)

@nocart:	inx
                txa
@clear:         sta     $E800,X
                sta     $C000,X
                sta     $D400,X
                sta     $0,X
                inx
                bne     @clear
                lda     #$F8
                sta     $D409

                ldx     #11
@copyvec:       lda     FE95,X
                sta     $200,X
                dex
                bpl     @copyvec

		; set $3000-$3C00 --> zero

                lda     #>$3C00
                sta     $12
                lda     #<$3C00
                sta     $11
                ldx     #12
                tay
@zeromem:       sta     ($11),Y
                dey
                bne     @zeromem
                dec     $12
                dex
                bpl     @zeromem

                lda     #13
                ldx     #$4D
@1:             sta     $2007,X
                dex
                bpl     @1

                ldx     #6
@2:             lda     FEC8,X
                sta     $2000,X
                dex
                bpl     @2

                ldx     #4
@3:             lda     FECF,X
                sta     $2055,X
                dex
                bpl     @3

                lda     #<$2000
                sta     $5
                lda     #>$2000
                sta     $6
                lda     #$22
                sta     $7
                lda     #$30
                tay
                lda     #$28
                ldx     #$36
@4:             sta     $1100,X
                pha
                tya
                sta     $1000,X
                pla
                dex
                bmi     @5
                clc
                adc     #$28
                bcc     @4
                iny
                bcs     @4

@5:             ldx     #$13
                stx     $17
                inx
                stx     $18
                lda     #$20
                sta     $13
@6:             lda     #1
                sta     $15
                lda     #$40
                sta     $16
@7:             dec     $13
                bmi     @11
                ldx     $13
                lda     FEE8,X
                sta     $14
                lda     FF08,X
                tax
@8:             cpx     $14
                beq     @9
                lda     $1100,X
                sta     $11
                lda     $1000,X
                sta     $12
                ldy     $17
                lda     $15
                ora     ($11),Y
                sta     ($11),Y
                ldy     $18
                lda     $16
                ora     ($11),Y
                sta     ($11),Y
                inx
                bne     @8
@9:             asl     $15
                asl     $15
                bcs     @10
                lsr     $16
                lsr     $16
                bcc     @7
@10:            dec     $17
                inc     $18
                bcs     @6
@11:            lda     #$11
                sta     $11
                lda     #$39
                sta     $12
                lda     #$13
                sta     $13
                lda     #0
                sta     $15
@12:            lda     #1
                ldy     #10
@13:            sta     $18
                ldx     $15
                inc     $15
                lda     FF28,X
                beq     @18
                tax
                and     #15
                sta     $16
                txa
                lsr     A
                lsr     A
                lsr     A
                lsr     A
                tax
                lda     $18
@14:            asl     A
                asl     A
                bcc     @15
                sta     ($11),Y
                iny
                lda     #1
@15:            dex
                bpl     @14
                ldx     $16
@16:            sec
                rol     A
                asl     A
                bcc     @17
                sta     ($11),Y
                iny
                lda     #1
@17:            dex
                bpl     @16
                bmi     @13
@18:            lda     $18
@19:            asl     A
                asl     A
                bcc     @19
                sta     ($11),Y
                lda     $11
                clc
                adc     #$28
                sta     $11
                bcc     @20
                inc     $12
@20:            dec     $13
                bpl     @12

                ldx     #19
@21:            lda     FED4,X
                sta     $3C94,X
                lda     $BFE8,X
                sta     $3C80,X
                dex
                bpl     @21

                lda     $BFFC
                sta     $3CA0
                lda     $BFFD
                sta     $3CA1
                lda     #15
                sta     $D
                lda     #$C0
                sta     $D40E
                lda     #2
                sta     $E80F
@22:            cpx     $2
                bne     @22
                jmp     ($BFFE)

FE95:           .word   FC03,FCB8,FCB2,FEA1,FD02,FCB2

FEA1:           pha
                txa
                pha
                tya
                pha
                ldx     $8
                ldy     #$72
@1:             cpx     #$10
                bcs     @2
                ldx     #$FE
@2:             stx     $D40A
                stx     $C016
                dex
                dex
                dey
                bne     @1
                inc     $8
                ldy     #$10
                cpy     $8
                bcc     @3
                sty     $8
@3:             jmp     FCB2

FEC8:           .byte   $70,$70,$70,$4D,$00,$30,$8D
FECF:		.byte	$07,$07,$41,$00,$20
FED4:		.byte	$63,$6F,$70,$79,$72,$69,$67,$68,$74,$00
		.byte	$51,$59,$58,$51,$00,$61,$74,$61,$72,$69
FEE8:           .byte   $08,$08,$08,$09,$09,$09,$0A,$0A
                .byte   $0B,$0B,$0C,$0D,$0E,$0F,$10,$11
                .byte   $12,$14,$16,$19,$1C,$1F,$36,$36
                .byte   $36,$36,$00,$00,$36,$36,$36,$36
FF08:           .byte   $00,$00,$00,$00,$00,$00,$01,$01
                .byte   $01,$02,$02,$03,$03,$04,$05,$06
                .byte   $07,$08,$09,$0A,$0B,$0C,$0E,$10
                .byte   $13,$16,$00,$00,$00,$00,$00,$00
FF28:           .byte   $92,$4E,$42,$97,$52,$00,$84,$3E
                .byte   $34,$79,$42,$00,$76,$2E,$26,$5B
                .byte   $32,$00,$76,$82,$86,$53,$43,$22
                .byte   $00,$63,$03,$72,$73,$03,$42,$63
                .byte   $12,$00,$62,$22,$72,$72,$22,$42
                .byte   $72,$12,$00,$62,$22,$72,$72,$22
                .byte   $42,$72,$12,$00,$52,$42,$62,$62
                .byte   $42,$32,$62,$22,$00,$52,$42,$62
                .byte   $62,$42,$32,$52,$32,$00,$52,$42
                .byte   $62,$62,$42,$32,$06,$42,$00,$43
                .byte   $43,$52,$53,$43,$22,$05,$52,$00
                .byte   $42,$62,$52,$52,$62,$22,$05,$52
                .byte   $00,$42,$62,$52,$52,$62,$22,$42
                .byte   $42,$00,$3E,$42,$4E,$12,$42,$42
                .byte   $00,$3E,$42,$4E,$12,$52,$32,$00
                .byte   $3E,$42,$4E,$12,$52,$32,$00,$23
                .byte   $83,$32,$33,$83,$02,$62,$22,$00
                .byte   $22,$A2,$32,$32,$A2,$02,$62,$22
                .byte   $00,$22,$A2,$32,$32,$A2,$02,$72
                .byte   $12,$00,$22,$A2,$32,$32,$A2,$02
                .byte   $72,$12,$00,$00,$00,$00,$00,$00
                .byte   $00,$00,$00,$00,$00,$00,$00,$00
                .byte   $00,$00,$00,$00,$00,$00,$00,$00
                .byte   $00,$00,$00,$00,$00,$00,$00,$00
                .byte   $00,$00,$00,$00,$00,$00,$00,$00
                .byte   $00,$52,$4A,$5A,$20,$31,$39,$38
                .byte   $32,$00

                .word   FCA2	; 6502 NMI
                .word   FD23	; 6502 RESET
                .word   FC00	; 6502 IRQ
