//Pixel editor pre ATARI gr3
//
//created especially for Laser Blaster INIT
//
//MatoSimi 11.4.2005
//used also for MONEX init
//Added MOVE function - 5.2.2006 by MatoSimi
//Added keypress 1,2,3 - color switch. 32/40 pixels switch - 17.5.2014

unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls, Buttons, XPMan;

type
  TForm1 = class(TForm)
    img: TImage;
    icol: TImage;
    SpeedButton1: TSpeedButton;
    SpeedButton2: TSpeedButton;
    SpeedButton3: TSpeedButton;
    Label1: TLabel;
    XPManifest1: TXPManifest;
    SpeedButton4: TSpeedButton;
    SpeedButton5: TSpeedButton;
    SpeedButton6: TSpeedButton;
    SpeedButton7: TSpeedButton;
    SpeedButton8: TSpeedButton;
    procedure FormCreate(Sender: TObject);
    procedure imgMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure imgMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure vyfarbi(xf,yf:byte);
    procedure imgMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure FormMouseWheelUp(Sender: TObject; Shift: TShiftState;
      MousePos: TPoint; var Handled: Boolean);
    procedure FormMouseWheelDown(Sender: TObject; Shift: TShiftState;
      MousePos: TPoint; var Handled: Boolean);
    procedure farba();
    procedure FormMouseWheel(Sender: TObject; Shift: TShiftState;
      WheelDelta: Integer; MousePos: TPoint; var Handled: Boolean);
    procedure SpeedButton1Click(Sender: TObject);
    procedure SpeedButton3Click(Sender: TObject);
    procedure refreshp;
    procedure Label1Click(Sender: TObject);
    procedure SpeedButton2Click(Sender: TObject);
    procedure SpeedButton4Click(Sender: TObject);
    procedure SpeedButton5Click(Sender: TObject);
    procedure SpeedButton7Click(Sender: TObject);
    procedure SpeedButton6Click(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure SpeedButton8Click(Sender: TObject);
  private
  fld:array[0..39,0..23] of byte;
  btn:tMousebutton;
  selectedcolor:byte;
  size:byte;
    { Private declarations }
  public
    { Public declarations }
  end;

const
  coltab:array[0..3] of TColor=(clBlack,clWhite,$00aaaaaa,$00555555);
var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.FormCreate(Sender: TObject);
var a,b:byte;
begin
size := 40;
form1.DoubleBuffered:=true;
btn:=mbMiddle;
img.Canvas.Brush.Color:=clBlack;
img.Canvas.FillRect(bounds(0,0,img.Width,img.Height));
for a:=0 to size-1 do
  for b:=0 to 23 do
    begin
    img.Canvas.Pixels[a*12,b*12]:=clWhite;
    fld[a,b]:=0;
    selectedcolor:=1;
    end;
farba;

end;

procedure tform1.farba;
begin
icol.Canvas.Brush.Color:=coltab[selectedcolor];
icol.Canvas.FillRect(bounds(0,0,icol.width,icol.Height));
end;

procedure TForm1.vyfarbi(xf,yf:byte);
var col:byte;
begin
case btn of
  mbLeft:   col:=selectedcolor;
  mbRight:  col:=0;
  else
  exit;
  end;

fld[xf,yf]:=col;
img.Canvas.Brush.Color:=coltab[col];
img.Canvas.FillRect(bounds(xf*12,yf*12,12,12));
img.Canvas.Pixels[xf*12,yf*12]:=coltab[abs(1-col)];
end;

procedure tform1.refreshp;
var col,xf,yf:byte;
begin
img.Canvas.Brush.Color := clWhite;
img.Canvas.Brush.Style := bsSolid;
img.Canvas.FillRect(bounds(0,0,img.Width, img.Height));
for xf:=0 to size-1 do
  for yf:=0 to 23 do begin
col:=fld[xf,yf];
img.Canvas.Brush.Color:=coltab[col];
img.Canvas.FillRect(bounds(xf*12,yf*12,12,12));
img.Canvas.Pixels[xf*12,yf*12]:=coltab[abs(1-col)];
end;
img.Canvas.Brush.Style := bsClear;
img.Canvas.Pen.Color := clRed;
img.canvas.rectangle(0,0,(size*12),24*12);
img.Refresh;
end;

procedure TForm1.imgMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var xf,yf:byte;
begin
btn:=Button;
xf:=X div 12;
yf:=Y div 12;
vyfarbi(xf,yf);
end;

procedure TForm1.imgMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
btn:=mbMiddle;
end;

procedure TForm1.imgMouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
vyfarbi(x div 12,y div 12);
end;

procedure TForm1.FormMouseWheelUp(Sender: TObject; Shift: TShiftState;
  MousePos: TPoint; var Handled: Boolean);
begin
if selectedcolor>1 then dec(selectedcolor);
farba;
end;

procedure TForm1.FormMouseWheelDown(Sender: TObject; Shift: TShiftState;
  MousePos: TPoint; var Handled: Boolean);
begin
if selectedcolor<3 then inc(selectedcolor);
farba;
end;

procedure TForm1.FormMouseWheel(Sender: TObject; Shift: TShiftState;
  WheelDelta: Integer; MousePos: TPoint; var Handled: Boolean);
begin
form1.SetFocus;
end;

procedure TForm1.SpeedButton1Click(Sender: TObject);
var fil:file of byte;
   x,y:integer;
    dta:byte;
begin
assignfile(fil,label1.Caption);

rewrite(fil);
for y:=0 to 23 do begin
for x:=0 to (size div 4)-1 do begin
  dta:=fld[x*4,y]*64+
       fld[x*4+1,y]*16+
       fld[x*4+2,y]*4+
       fld[x*4+3,y];
  write(fil,dta);
  end;
  end;
closefile(fil);
beep;
end;

procedure TForm1.SpeedButton3Click(Sender: TObject);
var x,y:byte;
begin
for x:=0 to size-1 do
  for y:=0 to 23 do fld[x,y]:=0;
refreshp;

end;

procedure TForm1.Label1Click(Sender: TObject);
begin
label1.Caption:=inputbox('Enter filename','Type:',label1.Caption);

end;

procedure TForm1.SpeedButton2Click(Sender: TObject);
var fil:file of byte;
    x,y:integer;
    dta:byte;
begin
assignfile(fil,label1.Caption);
reset(fil);
for y:=0 to 23 do begin
for x:=0 to (size div 4)-1 do begin
  read(fil,dta);
  fld[x*4,y]:=dta div 64;
  fld[x*4+1,y]:=(dta mod 64) div 16;
  fld[x*4+2,y]:=(dta mod 16) div 4;
  fld[x*4+3,y]:=dta mod 4;

  end;
  end;
closefile(fil);
refreshp;
beep;
end;

procedure TForm1.SpeedButton4Click(Sender: TObject);
var x,y:integer;
begin
for x:=0 to size-1 do
  for y:=1 to 23 do
    begin
    fld[x,y-1]:=fld[x,y];
    end;
refreshp;
end;

procedure TForm1.SpeedButton5Click(Sender: TObject);
var x,y:integer;
begin
for x:=0 to size-1 do
  for y:=22 downto 0 do
    begin
    fld[x,y+1]:=fld[x,y];
    end;
refreshp;

end;

procedure TForm1.SpeedButton7Click(Sender: TObject);
var x,y:integer;
begin
for x:=size-2 downto 0 do
  for y:=23 downto 0 do
    begin
    fld[x+1,y]:=fld[x,y];
    end;
refreshp;
end;

procedure TForm1.SpeedButton6Click(Sender: TObject);
var x,y:integer;
begin
for x:=1 to size-1 do
  for y:=23 downto 0 do
    begin
    fld[x-1,y]:=fld[x,y];
    end;
refreshp;
end;

procedure TForm1.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
case key of
  ord('1'): selectedcolor := 1;
  ord('2'): selectedcolor := 2;
  ord('3'): selectedcolor := 3;
end;
  farba;
end;

procedure TForm1.SpeedButton8Click(Sender: TObject);
begin
  if size = 40 then size := 32 else size := 40;
  refreshp;
  form1.SetFocus;
end;

end.
