//Pixel editor pre ATARI gr3
//
//created especially for Laser Blaster INIT
//
//MatoSimi 11.4.2005
//used also for MONEX init
//Added MOVE function - 5.2.2006 by MatoSimi
//Added keypress 1,2,3 - color switch. 32/40 pixels switch - 17.5.2014

{
  Original program by MatoSimi
  Modification Gury

  29.5.2014
  ---------

  Porting to Lazarus and Free Pascal development environment (from Delphi)
  - New features
  - Few bug fixes
  ---------------
  - Added toolbox with new features:
    - Drawing shapes: square, rectangle, circle, diamant
    - Program settings: shape ratio and distance
    - Atari BASIC viewer source code to use pictures in your own programs on Atari
  - Two palettes to choose from: Atari default and grayscale
  - Bug fix: no trailing pixels when moving in any of four directions

  Development environment:
    Lazarus (version 1.0.12)
    Free Pascal Compiler (version 2.6.2)
}

unit main;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, ExtCtrls,
  Buttons, StdCtrls, ComCtrls, types;

type

  { TfrmMain }

  TfrmMain = class(TForm)
    Bevel1: TBevel;
    Bevel2: TBevel;
    Button1: TButton;
    imgList: TImageList;
    img: TImage;
    icol: TImage;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    rbDefault: TRadioButton;
    rbGray: TRadioButton;
    shapeColor0: TShape;
    shapeColor1: TShape;
    shapeColor2: TShape;
    shapeColor3: TShape;
    sbRight: TSpeedButton;
    sbLeft: TSpeedButton;
    sbUp: TSpeedButton;
    sbDown: TSpeedButton;
    ToolBar1: TToolBar;
    ToolButton1: TToolButton;
    ToolButton10: TToolButton;
    ToolButton11: TToolButton;
    ToolButton12: TToolButton;
    ToolButton13: TToolButton;
    ToolButton2: TToolButton;
    ToolButton3: TToolButton;
    ToolButton4: TToolButton;
    ToolButton5: TToolButton;
    ToolButton6: TToolButton;
    ToolButton7: TToolButton;
    ToolButton8: TToolButton;
    ToolButton9: TToolButton;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure FormMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormMouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);
    procedure FormMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormMouseWheel(Sender: TObject; Shift: TShiftState;
      WheelDelta: Integer; MousePos: TPoint; var Handled: Boolean);
    procedure FormMouseWheelDown(Sender: TObject; Shift: TShiftState;
      MousePos: TPoint; var Handled: Boolean);
    procedure FormMouseWheelUp(Sender: TObject; Shift: TShiftState;
      MousePos: TPoint; var Handled: Boolean);
    procedure imgMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure imgMouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);
    procedure imgMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Label1Click(Sender: TObject);
    procedure rbDefaultClick(Sender: TObject);
    procedure shapeColor0MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure sbRightClick(Sender: TObject);
    procedure sbLeftClick(Sender: TObject);
    procedure sbUpClick(Sender: TObject);
    procedure sbDownClick(Sender: TObject);
    procedure refreshp;
    procedure farba;
    procedure SpeedButton4Click(Sender: TObject);
    procedure ToolButton10Click(Sender: TObject);
    procedure ToolButton12Click(Sender: TObject);
    procedure ToolButton13Click(Sender: TObject);
    procedure ToolButton1Click(Sender: TObject);
    procedure ToolButton2Click(Sender: TObject);
    procedure ToolButton3Click(Sender: TObject);
    procedure ToolButton5Click(Sender: TObject);
    procedure ToolButton6Click(Sender: TObject);
    procedure ToolButton8Click(Sender: TObject);
    procedure ToolButton9Click(Sender: TObject);
    procedure vyfarbi(xf,yf:byte);
    procedure Plot(x, y : Byte);
    procedure HLine(x1, x2, y : Byte);
    procedure VLine(x, y1, y2 : Byte);
    procedure Square(x, y, r : Byte);
    procedure Rectangle(x1, y1, x2, y2 : Byte);
    procedure Circle(x, y, r, shapeType : Byte);
  private
    { private declarations }
    fld : array[0..39, 0..23] of byte;
    btn : tMousebutton;
    SelColor : byte;
    size : byte;
//    px, py : Byte;  // Global coordinates
  public
    { public declarations }
    SquareR,         // Square side distance
    RectX, RectY,    // Rectangle X and Y side distance
    CircleR,         // Circle radius
    DiamondR : Byte  // Diamond radius
  end;

  // Functions
  TFuncSet = (fNormal, fSquare, fRect, fCircle, fDiamond);
  TFunc = Set of TFuncSet;

const
  version = 'v1.2';
  authors = 'MatoSimi and Gury';
  coltab : array[0..3] of TColor = (clBlack, $0E90FF, $0DF285, $C77538);
  coltab2 : array[0..3] of TColor = (clBlack, clWhite, clLtGray, clDkGray);

var
  frmMain: TfrmMain;
  func : TFunc;

implementation

{$R *.lfm}

uses
  settings, view_code;

{ TfrmMain }

procedure TfrmMain.FormCreate(Sender: TObject);
var
  a, b : byte;
begin
  Caption := Caption + ' ' + version + ' by ' + authors;
  size := 40;
  frmMain.DoubleBuffered := true;
  btn := mbMiddle;
  img.Canvas.Brush.Color := clBlack;
  img.Canvas.FillRect(bounds(0, 0, img.Width, img.Height));

  for a := 0 to size - 1 do
    for b := 0 to 23 do begin
      img.Canvas.Pixels[a * 12, b * 12] := clWhite;
      fld[a, b] := 0;
    end;

  func := [fNormal];
  SelColor := 1;
  farba;

  // Set manipulation button images
  imgList.GetBitmap(3, sbUp.Glyph);
  imgList.GetBitmap(0, sbDown.Glyph);
  imgList.GetBitmap(1, sbLeft.Glyph);
  imgList.GetBitmap(2, sbRight.Glyph);

  // Set colors for palette toolbar
  if rbDefault.Checked then
  begin
    shapeColor0.Brush.Color := coltab[0];
    shapeColor1.Brush.Color := coltab[1];
    shapeColor2.Brush.Color := coltab[2];
    shapeColor3.Brush.Color := coltab[3];
  end else begin
    shapeColor0.Brush.Color := coltab2[0];
    shapeColor1.Brush.Color := coltab2[1];
    shapeColor2.Brush.Color := coltab2[2];
    shapeColor3.Brush.Color := coltab2[3];
  end;

  // Set default values
  SquareR := 3;
  RectX := 6; RectY := 3;
  CircleR := 3;
  DiamondR := 3;
end;

procedure TfrmMain.Button1Click(Sender: TObject);
begin
  Close;
end;

procedure TfrmMain.Plot(x, y : Byte);
begin
  btn := mbLeft;
//  px := x; py := y;
  vyfarbi(x, y);
  btn := mbMiddle;
  refreshp;
end;

//procedure TfrmMain.DrawTo(x, y : Byte);
//begin
//end;

procedure TfrmMain.HLine(x1, x2, y : Byte);
var
  i : Byte;
begin
  for i := x1 to x2 do
  begin
    Plot(i, y);
  end;
end;

procedure TfrmMain.VLine(x, y1, y2 : Byte);
var
  i : Byte;
begin
  for i := y1 to y2 do
  begin
    Plot(x, i);
  end;
end;

procedure TfrmMain.Square(x, y, r : Byte);
var
  i : Byte;
begin
  for i := x to x + r do
  begin
    Plot(i, y);
    Plot(i, y + r);
  end;

  for i := y to y + r do
  begin
    Plot(x + r, i);
    Plot(x, i);
  end;
end;

procedure TfrmMain.Rectangle(x1, y1, x2, y2 : Byte);
var
  i : Byte;
begin
  for i := x1 to x2 do Plot(i, y1);
  for i := x1 to x2 do Plot(i, y2);
  for i := y1 to y2 do
  begin
    Plot(x2, i);
    Plot(x1, i);
  end;
end;

procedure TfrmMain.Circle(x, y, r, shapeType : Byte);
var
  a, c : Integer;
begin
  if r = 0 then
  begin
    plot(x, y);
    Exit;
  end;

  c := 0; a := r - 1;

  while r >= c do
  begin
    Plot(x + c, y + r);
    Plot(x + c, y - r);
    Plot(x - c, y - r);
    Plot(x - c, y + r);
    Plot(x + r, y + c);
    Plot(x + r, y - c);
    Plot(x - r, y - c);
    Plot(x - r, y + c);
    c := c + 1;
    a := a + 1 - c - c;

    if shapeType = 0 then
      if a >= 0 then Continue;

    r := r - 1;
    a := a + r + r;
  end;
end;

//procedure TfrmMain.Diamond(x, y, r : Byte);
//var
//  a, b, c : Integer;
//begin
//  if r = 0 then
//  begin
//    plot(x, y);
//    Exit;
//  end;
//
//  b := r; c := 0; a := r - 1;
//
//  while b >= c do
//  begin
//    Plot(x + c, y + b);
//    Plot(x + c, y - b);
//    Plot(x - c, y - b);
//    Plot(x - c, y + b);
//    Plot(x + b, y + c);
//    Plot(x + b, y - c);
//    Plot(x - b, y - c);
//    Plot(x - b, y + c);
//    c := c + 1;
//    a := a + 1 - c - c;
//    b := b - 1;
//    a := a + b + b;
//  end;
//end;

procedure TfrmMain.Button2Click(Sender: TObject);
begin
end;

procedure TfrmMain.FormKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
begin
  case key of
    ord('1'): SelColor := 1;
    ord('2'): SelColor := 2;
    ord('3'): SelColor := 3;
  end;

  farba;
end;

procedure TfrmMain.FormMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var
  xf, yf : byte;
begin
  btn := Button;
  xf := X div 12;
  yf := Y div 12;
  vyfarbi(xf, yf);
end;

procedure TfrmMain.FormMouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);
begin
  vyfarbi(x div 12, y div 12);
end;

procedure TfrmMain.FormMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  btn := mbMiddle;
end;

procedure TfrmMain.FormMouseWheel(Sender: TObject; Shift: TShiftState;
  WheelDelta: Integer; MousePos: TPoint; var Handled: Boolean);
begin
  frmMain.SetFocus;
end;

procedure TfrmMain.FormMouseWheelDown(Sender: TObject; Shift: TShiftState;
  MousePos: TPoint; var Handled: Boolean);
begin
  if SelColor < 3 then inc(SelColor);

  farba;
end;

procedure TfrmMain.FormMouseWheelUp(Sender: TObject; Shift: TShiftState;
  MousePos: TPoint; var Handled: Boolean);
begin
  if SelColor > 1 then dec(SelColor);

  farba;
end;

procedure TfrmMain.farba;  // Barva ;)
begin
  if rbDefault.Checked then
    icol.Canvas.Brush.Color := coltab[SelColor]
  else
    icol.Canvas.Brush.Color := coltab2[SelColor];

  icol.Canvas.FillRect(bounds(0, 0, icol.width, icol.Height));
end;

procedure TfrmMain.SpeedButton4Click(Sender: TObject);
begin
end;

procedure TfrmMain.ToolButton10Click(Sender: TObject);
begin
  func := [fDiamond];
end;

procedure TfrmMain.ToolButton12Click(Sender: TObject);
begin
  frmSettings.ShowModal;
end;

procedure TfrmMain.ToolButton13Click(Sender: TObject);
begin
  frmCode.ShowModal;
end;

procedure TfrmMain.ToolButton1Click(Sender: TObject);
begin
  func := [fSquare];
end;

procedure TfrmMain.ToolButton2Click(Sender: TObject);
begin
  func := [fRect];
end;

procedure TfrmMain.ToolButton3Click(Sender: TObject);
begin
  func := [fCircle];
end;

{
  Load screen from file
}
procedure TfrmMain.ToolButton5Click(Sender: TObject);
var
  fil : file of byte;
  x, y : integer;
  dta : byte;
begin
  assignfile(fil,label1.Caption);
  reset(fil);

  for y := 0 to 23 do begin
    for x := 0 to (size div 4) - 1 do
    begin
      read(fil, dta);
      fld[x * 4, y] := dta div 64;
      fld[x * 4 + 1, y] := (dta mod 64) div 16;
      fld[x * 4 + 2, y] := (dta mod 16) div 4;
      fld[x * 4 + 3, y] := dta mod 4;
    end;
  end;

  closefile(fil);
  refreshp;
  beep;
end;

{
  write screen to file
}
procedure TfrmMain.ToolButton6Click(Sender: TObject);
var
  fil : file of byte;
  x, y : integer;
  dta : byte;
begin
  assignfile(fil, label1.Caption);
  rewrite(fil);

  for y := 0 to 23 do begin
    for x := 0 to (size div 4) - 1 do
    begin
      dta := fld[x * 4, y] * 64 +
             fld[x * 4 + 1, y] * 16 +
             fld[x * 4 + 2, y] * 4 +
             fld[x * 4 + 3, y];
      write(fil, dta);
    end;
  end;

  closefile(fil);
  beep;
end;

{
  Clear screen
}
procedure TfrmMain.ToolButton8Click(Sender: TObject);
var
  x, y : byte;
begin
  for x := 0 to size - 1 do
    for y := 0 to 23 do fld[x, y] := 0;

  refreshp;
end;

procedure TfrmMain.ToolButton9Click(Sender: TObject);
begin
  func := [fNormal];
end;

procedure TfrmMain.imgMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var
  xf, yf : byte;
begin
  btn := Button;
  xf := X div 12;
  yf := Y div 12;

  if func = [fNormal] then
    vyfarbi(xf, yf)
  else if func = [fSquare] then
    Square(xf, yf, SquareR)  // 3
  else if func = [fRect] then
    Rectangle(xf, yf, xf + RectX, yf + RectY)  // 6, 3
  else if func = [fCircle] then
    Circle(xf, yf, CircleR, 0)  // 3
  else if func = [fDiamond] then
    Circle(xf, yf, DiamondR, 1);  // 3
end;

procedure TfrmMain.imgMouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);
begin
  vyfarbi(x div 12, y div 12);
end;

procedure TfrmMain.imgMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  btn := mbMiddle;
  refreshp;
end;

procedure TfrmMain.Label1Click(Sender: TObject);
begin
  label1.Caption := inputbox('Enter filename','Type:',label1.Caption);
end;

procedure TfrmMain.rbDefaultClick(Sender: TObject);
begin
  if rbDefault.Checked then
  begin
    shapeColor0.Brush.Color := coltab[0];
    shapeColor1.Brush.Color := coltab[1];
    shapeColor2.Brush.Color := coltab[2];
    shapeColor3.Brush.Color := coltab[3];
  end else begin
    shapeColor0.Brush.Color := coltab2[0];
    shapeColor1.Brush.Color := coltab2[1];
    shapeColor2.Brush.Color := coltab2[2];
    shapeColor3.Brush.Color := coltab2[3];
  end;

  btn := mbMiddle;
  refreshp;
  farba;
end;

procedure TfrmMain.vyfarbi(xf, yf : byte);
var
  col : byte;
begin
  case btn of
    mbLeft : col := SelColor;
    mbRight: col := 0;
  else
    exit;
  end;

  fld[xf, yf] := col;

  if rbDefault.Checked then
    img.Canvas.Brush.Color := coltab[col]
  else
    img.Canvas.Brush.Color := coltab2[col];

  img.Canvas.FillRect(bounds(xf * 12, yf * 12, 12, 12));

  if rbDefault.Checked then
    img.Canvas.Pixels[xf * 12, yf * 12] := coltab[abs(1 - col)]
  else
    img.Canvas.Pixels[xf * 12, yf * 12] := coltab2[abs(1 - col)];
end;

procedure TfrmMain.refreshp;
var
  col, xf, yf : byte;
begin
  img.Canvas.Brush.Color := clWhite;
  img.Canvas.Brush.Style := bsSolid;
  img.Canvas.FillRect(bounds(0, 0, img.Width, img.Height));

  for xf := 0 to size - 1 do
    for yf := 0 to 23 do
    begin
      col := fld[xf, yf];

      if rbDefault.Checked then
        img.Canvas.Brush.Color := coltab[col]
      else
        img.Canvas.Brush.Color := coltab2[col];

      img.Canvas.FillRect(bounds(xf * 12, yf * 12, 12, 12));

      if rbDefault.Checked then
        img.Canvas.Pixels[xf * 12, yf * 12] := coltab[abs(1 - col)]
      else
        img.Canvas.Pixels[xf * 12, yf * 12] := coltab2[abs(1 - col)];
    end;

  img.Canvas.Brush.Style := bsClear;
  img.Canvas.Pen.Color := clRed;
  img.canvas.rectangle(0, 0, (size * 12), 24 * 12);
  img.Refresh;
end;

procedure TfrmMain.shapeColor0MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  SelColor := Tshape(Sender).Tag;
  farba;
end;

{
  Move screen right
}
procedure TfrmMain.sbRightClick(Sender: TObject);
var x, y : integer;
begin
  for x := size - 2 downto 0 do
    for y := 23 downto 0 do
    begin
      fld[x + 1, y] := fld[x, y];
      fld[x, y] := 0;
    end;

  refreshp;
end;

{
  Move screen left
}
procedure TfrmMain.sbLeftClick(Sender: TObject);
var
  x, y : integer;
begin
  for x := 1 to size - 1 do
    for y := 23 downto 0 do
    begin
      fld[x - 1, y] := fld[x, y];
      fld[x, y] := 0;
    end;

  refreshp;
end;

{
  Move screen up
}
procedure TfrmMain.sbUpClick(Sender: TObject);
var
  x, y : integer;
begin
  for x := 0 to size - 1 do
    for y := 1 to 23 do
    begin
      fld[x, y - 1] := fld[x, y];
      fld[x, y] := 0;
    end;

  refreshp;
end;

{
  Move screen down
}
procedure TfrmMain.sbDownClick(Sender: TObject);
var
  x, y : integer;
begin
  for x := 0 to size - 1 do
    for y := 22 downto 0 do
    begin
      fld[x, y + 1] := fld[x, y];
      fld[x, y] := 0;
    end;

  refreshp;
end;

end.

