unit settings;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, StdCtrls,
  ExtCtrls, lcltype;

type

  { TfrmSettings }

  TfrmSettings = class(TForm)
    Bevel1: TBevel;
    Button1: TButton;
    Button2: TButton;
    editDiamondR: TLabeledEdit;
    editRectYR: TLabeledEdit;
    editSquareR: TLabeledEdit;
    editRectXR: TLabeledEdit;
    editCircleR: TLabeledEdit;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure FormShow(Sender: TObject);
  private
    { private declarations }
  public
    { public declarations }
  end;

var
  frmSettings: TfrmSettings;

implementation

{$R *.lfm}

uses main;

{ TfrmSettings }

procedure TfrmSettings.Button2Click(Sender: TObject);
begin
  Close;
end;

procedure TfrmSettings.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  case Key of
    VK_ESCAPE: Close;
  end;
end;

procedure TfrmSettings.FormShow(Sender: TObject);
begin
  editSquareR.Text := IntToStr(frmMain.SquareR);
  editRectXR.Text := IntToStr(frmMain.RectX);
  editRectYR.Text := IntToStr(frmMain.RectY);
  editCircleR.Text := IntToStr(frmMain.CircleR);
  editDiamondR.Text := IntToStr(frmMain.DiamondR);
end;

procedure TfrmSettings.Button1Click(Sender: TObject);
begin
  frmMain.SquareR := StrToInt(editSquareR.Text);
  frmMain.RectX := StrToInt(editRectXR.Text);
  frmMain.RectY := StrToInt(editRectYR.Text);
  frmMain.CircleR := StrToInt(editCircleR.Text);
  frmMain.DiamondR := StrToInt(editDiamondR.Text);
  Close;
end;

end.

