/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.tools.atariroms.model;

import com.wudsn.tools.atariroms.DataTypes;
import com.wudsn.tools.base.repository.Attribute;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;

public final class ComparisonEntry {
    private int offset;
    private int address;
    private List<String> values;
    private List<Integer> colors;

    ComparisonEntry(int columnCount) {
        this.values = new ArrayList<String>(columnCount);
        this.colors = new ArrayList<Integer>(columnCount);
        int i = 0;
        while (i < columnCount) {
            this.values.add("");
            this.colors.add(0);
            ++i;
        }
    }

    void setOffset(int offset) {
        this.offset = offset;
    }

    public int getOffset() {
        return this.offset;
    }

    void setAddress(int address) {
        this.address = address;
    }

    public int getAddress() {
        return this.address;
    }

    void setValue(int column, String value, int color) {
        this.values.set(column, value);
        this.colors.set(column, color);
    }

    public String getValue(int column) {
        return this.values.get(column);
    }

    public Color getColor(int column) {
        Integer colorKey = this.colors.get(column);
        switch (colorKey) {
            case 0: {
                return Color.GREEN;
            }
            case 1: {
                return Color.RED;
            }
            case 2: {
                return Color.YELLOW;
            }
            case 3: {
                return Color.ORANGE;
            }
            case 4: {
                return Color.PINK;
            }
        }
        return Color.WHITE;
    }

    public String toString() {
        return "offset=" + this.offset + "/address=" + this.address + "/values=" + this.values.toString();
    }

    public static final class Attributes {
        public static final Attribute ID = new Attribute("id", DataTypes.ComparisonEntry_Id);
        public static final Attribute OFFSET = new Attribute("offset", DataTypes.ComparisonEntry_Offset);
        public static final Attribute ADDRESS = new Attribute("address", DataTypes.ComparisonEntry_Address);
        public static final Attribute VALUE = new Attribute("value", DataTypes.ComparisonEntry_Value);

        private Attributes() {
        }
    }
}

