/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.tools.atariroms.model;

import com.wudsn.tools.atariroms.DataTypes;
import com.wudsn.tools.base.repository.Attribute;
import java.util.HashMap;
import java.util.Map;

public final class ROMVersion {
    public static final ROMVersion UNKNOWN = new ROMVersion(0, "Unknown", "Unknown", "Unknown", "Unknown", "Unknown", "Unknown");
    public static final ROMVersion ATARI_OS_A_NTSC = new ROMVersion(10240, "Atari OS", "OS-A", "NTSC", "1979", "Production ROM", "CO12499A (low-OS, NTSC), CO14599A (high-OS NTSC), CO12399B (FPP)");
    public static final ROMVersion ATARI_OS_A_PAL = new ROMVersion(10240, "Atari OS", "OS-A", "PAL", "1979", "Production ROM", "CO15199  (low-OS, NTSC), CO15299 (high-OS NTSC), CO12399B (FPP)");
    public static final ROMVersion ATARI_OS_B_NTSC_LINBUG = new ROMVersion(10240, "Atari OS", "OS-B", "NTSC", "1981", "Production ROM, LINBUG Version with incorrect checksums", "C012499B (low-OS, NTSC), CO14599B (high-OS, NTSC), CO12399B (FPP)");
    public static final ROMVersion ATARI_OS_B_NTSC = new ROMVersion(10240, "Atari OS", "OS-B", "NTSC", "1981", "Production ROM", "Unknown");
    public static final ROMVersion ATARI_OS_B_NTSC_PCXFORMER = new ROMVersion(10240, "Atari OS", "OS-B", "NTSC", "1996", "PCXFormer hack", "n/a");
    public static final ROMVersion ATARI_OS_B_PAL = new ROMVersion(10240, "Atari OS", "OS-B", "PAL", "1981", "Tomasz Krasuski", "Unknown");
    private static Map<String, ROMVersion> crc32Map = new HashMap<String, ROMVersion>();
    private final int fileSize;
    private final String type;
    private final String revision;
    private final String norm;
    private final String year;
    private final String comment;
    private final String parts;

    static {
        crc32Map.put("0xc1b3bb02", ATARI_OS_A_NTSC);
        crc32Map.put("0x72b3fed4", ATARI_OS_A_PAL);
        crc32Map.put("0x0e86d61d", ATARI_OS_B_NTSC_LINBUG);
        crc32Map.put("0xf28bc97d", ATARI_OS_B_NTSC);
        crc32Map.put("0x3e28a1fe", ATARI_OS_B_NTSC_PCXFORMER);
        crc32Map.put("0x0c913dfc", ATARI_OS_B_PAL);
    }

    public ROMVersion(int fileSize, String type, String revision, String norm, String year, String comment, String parts) {
        if (type == null) {
            throw new IllegalArgumentException("Parameter 'type' must not be null.");
        }
        if (revision == null) {
            throw new IllegalArgumentException("Parameter 'revision' must not be null.");
        }
        if (norm == null) {
            throw new IllegalArgumentException("Parameter 'norm' must not be null.");
        }
        if (year == null) {
            throw new IllegalArgumentException("Parameter 'year' must not be null.");
        }
        if (comment == null) {
            throw new IllegalArgumentException("Parameter 'comment' must not be null.");
        }
        if (parts == null) {
            throw new IllegalArgumentException("Parameter 'parts' must not be null.");
        }
        this.fileSize = fileSize;
        this.type = type;
        this.revision = revision;
        this.norm = norm;
        this.year = year;
        this.comment = comment;
        this.parts = parts;
    }

    public int getFileSize() {
        return this.fileSize;
    }

    public String getType() {
        return this.type;
    }

    public String getRevision() {
        return this.revision;
    }

    public String getNorm() {
        return this.norm;
    }

    public String getYear() {
        return this.year;
    }

    public String getComment() {
        return this.comment;
    }

    public String getParts() {
        return this.parts;
    }

    public String toString() {
        return String.valueOf(this.type) + "/" + this.revision + "/" + this.norm + "/" + this.year + "/" + this.comment + "/" + this.parts;
    }

    public static ROMVersion getByCRC32(String crc32) {
        if (crc32 == null) {
            throw new IllegalArgumentException("Parameter 'crc32' must not be null.");
        }
        ROMVersion result = crc32Map.get(crc32);
        if (result == null) {
            result = UNKNOWN;
        }
        return result;
    }

    public static final class Attributes {
        public static final Attribute TYPE = new Attribute("type", DataTypes.Version_Type);
        public static final Attribute REVISION = new Attribute("revision", DataTypes.Version_Revision);
        public static final Attribute NORM = new Attribute("norm", DataTypes.Version_Norm);
        public static final Attribute YEAR = new Attribute("year", DataTypes.Version_Year);
        public static final Attribute COMMENT = new Attribute("comment", DataTypes.Version_Comment);
        public static final Attribute PARTS = new Attribute("parts", DataTypes.Version_Parts);

        private Attributes() {
        }
    }
}

