/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.tools.atariroms.model;

import com.wudsn.tools.atariroms.model.WorkbookEntry;
import com.wudsn.tools.base.gui.AttributeTableModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class Workbook {
    private List<WorkbookEntry> entriesList = new ArrayList<WorkbookEntry>();
    private List<WorkbookEntry> unmodifiableEntriesList = Collections.unmodifiableList(this.entriesList);
    private int resolvedFilesCount;
    private AttributeTableModel entriesModel;

    public void setEntriesTableModel(AttributeTableModel entriesModel) {
        this.entriesModel = entriesModel;
    }

    public void clear() {
        this.entriesList.clear();
        this.resolvedFilesCount = 0;
        if (this.entriesModel != null) {
            this.entriesModel.fireTableDataChanged();
        }
    }

    public void addEntry(WorkbookEntry entry) {
        if (entry == null) {
            throw new IllegalArgumentException("Parameter 'entry' must not be null.");
        }
        this.entriesList.add(entry);
        if (this.entriesModel != null) {
            this.entriesModel.fireTableDataChanged();
        }
    }

    public WorkbookEntry getEntry(int row) {
        return this.entriesList.get(row);
    }

    public int getEntryCount() {
        return this.entriesList.size();
    }

    public List<WorkbookEntry> getUnmodifiableEntriesList() {
        return this.unmodifiableEntriesList;
    }

    public void setResolvedFilesCount(int resolvedFilesCount) {
        this.resolvedFilesCount = resolvedFilesCount;
    }

    public int getResolvedFilesCount() {
        return this.resolvedFilesCount;
    }
}

