/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.tools.atariroms.ui;

import com.wudsn.tools.atariroms.Preferences;
import com.wudsn.tools.atariroms.model.Comparison;
import com.wudsn.tools.atariroms.model.ComparisonEntry;
import com.wudsn.tools.atariroms.model.WorkbookEntry;
import com.wudsn.tools.base.common.TextUtility;
import com.wudsn.tools.base.gui.AttributeTableModel;
import com.wudsn.tools.base.gui.AttributeTablePanel;
import com.wudsn.tools.base.repository.Attribute;
import com.wudsn.tools.base.repository.DataType;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public final class ComparisonEntryPanel
extends AttributeTablePanel {
    private Comparison comparison;

    public ComparisonEntryPanel(Preferences preferences, Comparison comparison) {
        super(new TableModel(comparison), preferences, "comparisonEntriesTable");
        this.comparison = comparison;
    }

    public void setSelectedComparisonEntry(ComparisonEntry comparisonEntry, Attribute attribute) {
        if (comparisonEntry == null) {
            throw new IllegalArgumentException("Parameter 'comparisonEntry' must not be null.");
        }
        int modelRowIndex = this.comparison.getUnmodifiableEntriesList().indexOf(comparisonEntry);
        this.table.selectCell(modelRowIndex, attribute);
    }

    public static final class TableModel
    extends AttributeTableModel {
        private Comparison comparison;

        public TableModel(final Comparison comparison) {
            if (comparison == null) {
                throw new IllegalArgumentException("Parameter 'comparison' must not be null.");
            }
            this.comparison = comparison;
            final Font monoSpacedFont = new Font("Monospaced", 0, 12);
            DefaultTableCellRenderer cellRenderer = new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    Component result = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    int modelRowIndex = table.convertRowIndexToModel(row);
                    int modelColumnIndex = table.convertColumnIndexToModel(column);
                    if (modelColumnIndex >= 3) {
                        this.setBackground(comparison.getEntry(modelRowIndex).getColor(modelColumnIndex - 3));
                    } else {
                        this.setBackground(table.getBackground());
                    }
                    this.setFont(monoSpacedFont);
                    return result;
                }

                @Override
                protected void setValue(Object value) {
                    super.setValue(value);
                }
            };
            this.addColumn(ComparisonEntry.Attributes.ID, 2);
            this.addColumn(ComparisonEntry.Attributes.OFFSET, 2, cellRenderer, null);
            this.addColumn(ComparisonEntry.Attributes.ADDRESS, 2, cellRenderer, null);
            int i = 0;
            while (i < comparison.getWorkbookEntryCount()) {
                DataType dataType = new DataType(String.class);
                WorkbookEntry workbookEntry = comparison.getWorkbookEntry(i);
                dataType.setTexts(workbookEntry.getFileName(), workbookEntry.getFolderPath());
                Attribute attribute = new Attribute("value" + i, dataType);
                this.addColumn(attribute, 2, cellRenderer, null);
                ++i;
            }
        }

        @Override
        public Object getValueAt(int row, int column) {
            ComparisonEntry entry = this.comparison.getEntry(row);
            switch (column) {
                case 0: {
                    return this.table.convertRowIndexToView(row) + 1;
                }
                case 1: {
                    return entry.getOffset() >= 0 ? TextUtility.formatAsHexaDecimal(entry.getOffset(), this.comparison.getMaximumOffset()) : "";
                }
                case 2: {
                    return entry.getAddress() >= 0 ? TextUtility.formatAsHexaDecimal(entry.getAddress(), this.comparison.getMaximumAddress()) : "";
                }
            }
            return entry.getValue(column - 3);
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }

        @Override
        public int getRowCount() {
            return this.comparison.getEntryCount();
        }

        public final class Columns {
            public static final int ID = 0;
            public static final int OFFSET = 1;
            public static final int ADDRESS = 2;
            public static final int VALUE = 3;
        }
    }
}

