/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.tools.base.gui;

import com.wudsn.tools.base.Texts;
import com.wudsn.tools.base.common.ClassPathUtility;
import com.wudsn.tools.base.common.ResourceUtility;
import com.wudsn.tools.base.gui.SimpleDialog;
import com.wudsn.tools.base.repository.NLS;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dimension;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public final class HelpDialog
extends SimpleDialog {
    private String path;
    private int width;
    private int height;
    JEditorPane jep;

    public HelpDialog(JFrame parent, String path, int width, int height) {
        super(parent, Texts.HelpDialog_Title, false);
        if (path == null) {
            throw new IllegalArgumentException("Parameter 'path' must not be null.");
        }
        this.path = path;
        this.width = width;
        this.height = height;
    }

    @Override
    protected void initComponents(JDialog dialog) {
        Container pane = dialog.getContentPane();
        this.jep = new JEditorPane();
        this.jep.setEditable(false);
        pane.add((Component)new JScrollPane(this.jep), "Center");
        String fullPath = NLS.getResourcePath(this.path);
        if (fullPath == null) {
            throw new RuntimeException("Help resource '" + this.path + "' not found in path.");
        }
        URL url = ClassPathUtility.class.getClassLoader().getResource(fullPath);
        this.setPage(url);
        this.jep.setPreferredSize(new Dimension(this.width, this.height));
        this.jep.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    URL url = e.getURL();
                    String protocol = url.getProtocol();
                    if (protocol.equals("file") || protocol.equals("jar")) {
                        HelpDialog.this.setPage(url);
                        HelpDialog.this.jep.scrollToReference(e.getDescription());
                        return;
                    }
                    if ((protocol.equals("http") || protocol.equals("https")) && Desktop.isDesktopSupported()) {
                        try {
                            Desktop.getDesktop().browse(url.toURI());
                        }
                        catch (IOException ex) {
                            throw new RuntimeException("Cannot load page '" + url + "'.", ex);
                        }
                        catch (URISyntaxException ex) {
                            throw new RuntimeException("Cannot load page '" + url + "'.", ex);
                        }
                    }
                }
            }
        });
        this.initButtonBar();
    }

    void setPage(URL url) {
        if (url == null) {
            throw new IllegalArgumentException("Parameter 'url' must not be null.");
        }
        try {
            url = new URL(url, "", ResourceUtility.createStreamHandler());
            this.jep.setPage(url);
        }
        catch (IOException ex) {
            this.jep.setText(ex.getMessage());
        }
    }
}

