;-view as Internal/character

;
; Load Font From DataSection
;
#option_ata=2
#option_int=3

Import "atari.lib"
      ConvertBasicToText(inFile$, outFile$, typ.i) As "_ConvertBasicToText@12" 
    EndImport

Import "User32.lib" 
  ;Windows NT/2000/XP/Vista: Included in Windows 2000 And later. 
  ;Windows 95/98/Me: Unsupported. 
  AddFontMemResourceEx(pFont,Size,Par,Count) 
  RemoveFontMemResourceEx(fHandle) 
EndImport 

Global fHandle.l,Fonts.l 

Global Dim atascii.a(40,24)
Global crsx.b=0
Global crsy.b=0

Procedure.a Atascii2intrnl(atsc.a)
  at.a=atsc&127
  intrnl.a=0
  Select at
    Case 32 To 95
      intrnl=at-32
    Case 0 To 31
      intrnl=at+64
    Case 96 To 127
      intrnl=at
  EndSelect
 ProcedureReturn intrnl|(atsc&128)
EndProcedure

Procedure.a intrnl2Atascii(intr.a)
  atas.a=0
  intrnl.a=intr&127
  Select intrnl
    Case 0 To 63
      atas=intrnl+32
    Case 64 To 95
      atas=intrnl-64
    Case 96 To 127
      atas=intrnl
  EndSelect
  ;?inverse?
  ProcedureReturn atas|(intr&128)
EndProcedure

Procedure ReadAtascii(fn.s)
 If ReadFile(0,fn)
  
  x.b=0
  y.b=0
  While (Eof(0) = 0)
    atascii(x,y)=ReadByte(0)
    x=x+1
    If x=40;39
      x=0
      y=y+1
    EndIf
    If y=25
      Break
    EndIf
  Wend

  CloseFile(0)
Else
  MessageRequester("Information","Couldn't open the file:"+fn);Debug "it happens:"+fn
EndIf
EndProcedure

Procedure DrawAtascii()
CanvasGadget(0, 0, 0, 320, 192)
StartDrawing(CanvasOutput(0))
Box(0, 0, 320, 192,RGB(0,0,255))
DrawingFont(FontID(1))
For x=0 To 39
  For y=0 To 23
    b.a=atascii(x,y)
    If GetGadgetState(#option_int)=1
      b.a=intrnl2Atascii(b)
    EndIf
    txtclr=RGB(0,255,255)
    bkclr=RGB(0,0,255)
    If (b=0) Or (b=31);non-printable chars
      b=b+128
      bkclr=RGB(0,255,255)
      txtclr=RGB(0,0,255)
  EndIf
  If (x=crsx)And (y=crsy)
    txtclr=RGB(255,0,0)
    bkclr=RGB(0,255,255)
    
  EndIf
  DrawText(x*8,y*8,Chr(b),txtclr,bkclr)
Next y
Next x
StopDrawing() 
 
EndProcedure

If OpenWindow(0, #PB_Ignore,#PB_Ignore,640,480, "AtasciiPad", #PB_Window_SystemMenu | #PB_Window_MinimizeGadget | #PB_Window_MaximizeGadget)
  
;   Variable$="%Temp%"
; Author: Wicker Man
; Date: May 22 2009
; OS: All
; Demo: No
; More codes at: www.geocities.com/kc2000labs/pb/pb.htm
; 
; If OpenWindow(0, 0, 0, 640, 520, "Environment Variables", #PB_Window_SystemMenu | #PB_Window_MinimizeGadget | #PB_Window_ScreenCentered)
;    If CreateGadgetList(WindowID(0))
;       ListIconGadget(0,10,10,621,500,"Variable",200,#PB_ListIcon_GridLines | #PB_ListIcon_FullRowSelect)
;    EndIf
;    
;    AddGadgetColumn(0,1,"Data",400)
;    If ExamineEnvironmentVariables()
;       While NextEnvironmentVariable()
;          AddGadgetItem(0,-1,EnvironmentVariableName()+Chr(10)+EnvironmentVariableValue())
;       Wend
;    EndIf
; 
;   Repeat
;     EventID = WaitWindowEvent()
; 
;     If EventID = #PB_Event_CloseWindow
;       Quit = 1
;     EndIf
; 
;   Until Quit = 1
;   
; EndIf


    PanelGadget(96, 0, 0, 640, 480)
    
    AddGadgetItem (96, 1, ".BAS viewer")
    StringGadget(97, 0, 0, 620, 460,"Drag *.BAS for convert",#ES_MULTILINE|#ES_AUTOVSCROLL|#WS_VSCROLL|#WS_HSCROLL|#ESB_DISABLE_LEFT|#ESB_DISABLE_RIGHT) 
    
    
    AddGadgetItem (96, 2, "AtaDraw")
    
    
    OptionGadget(#option_ata, 324, 0, 60, 20, "ATASCII")
    OptionGadget(#option_int, 324, 20, 60, 20, "Internal")
    SetGadgetState(#option_int, 1)
    
      If CreateMenu(0, WindowID(0))
      MenuTitle("Project")
      MenuItem(1, "Open..")
      
      OpenSubMenu("Save")       ; begin sub-menu
        MenuItem(2, "Image..")
        MenuItem(3, "Save internal XEX/binary..")
      CloseSubMenu()

        MenuBar()
        MenuItem(4, "Clear")
        MenuBar(); here the separator bar will be inserted
        MenuItem(5, "Quit")
        ;todo - save binary,save image ,  jpeg
      EndIf

    fHandle = AddFontMemResourceEx(?MyFont,?EndOfMyFont-?MyFont,0,@Fonts) 
    LoadFont(1,"Atari 8-Bit Graphics",8);14) 
    
    
    SetGadgetFont(97,FontID(1))
;--------------------------------1st buttons with chars
    CreateImage(1, 8, 8)
    StartDrawing(ImageOutput(1))
    DrawingFont(FontID(1))
    DrawText(0,0,Chr(128),RGB(255,255,255),RGB(0,0,0))
    StopDrawing() 
    
    CreateImage(3, 8, 8)
    StartDrawing(ImageOutput(3))
    DrawingFont(FontID(1))
    DrawText(0,0,Chr(128+30),RGB(255,255,255),RGB(0,0,0))
    StopDrawing() 
    
    CreateImage(2, 8, 8)
    StartDrawing(ImageOutput(2))
    DrawingFont(FontID(1))
    DrawText(0,0,Chr(128+31),RGB(255,255,255),RGB(0,0,0))
    StopDrawing() 

    For j=0 To 3
      For i=0 To 31
       ;If ((i+j*32<>30)And(i+j*32<>31)) Or (i+j*32<>0)
       Select i+j*32
         Case 0
           ButtonImageGadget(100, 0, 192, 16, 16, ImageID(1))
         Case 30
           ButtonImageGadget(130, 30*16, 192, 16, 16, ImageID(3))
         Case 31
          ButtonImageGadget(131, 31*16, 192, 16, 16, ImageID(2))
       Default  
        ButtonGadget(100+i+j*32,i*16,192+j*16,16,16,Chr(i+j*32))
        SetGadgetFont(100+i+j*32,FontID(1))
      EndSelect
     Next i
    Next j
   
    SetGadgetText(138,Chr(38)+Chr(38));&&
;-----------------------------------------------------------
ButtonGadget(99, 511,192, 80, 20, "Inverse", #PB_Button_Toggle)
    
;-----------------------------------------------------------
;clear
For j=0 To 23
  For i=0 To 39
    atascii(i,j)=0;32
  Next i
Next j
;--
For j=0 To 7
  For i=0 To 31
    atascii(i,j)=j*32+i
  Next i
Next j

CanvasGadget(0, 0, 0, 320, 192)
DrawAtascii()

EnableWindowDrop(0,#PB_Drop_Files,#PB_Drag_Copy)

Repeat
;------------------cursor keys--------------------------------
If GetAsyncKeyState_(#VK_LEFT)=-32767
  If crsx>0
    crsx=crsx-1
    DrawAtascii()
  EndIf
  EndIf
  If GetAsyncKeyState_(#VK_RIGHT)=-32767
   If crsx<39
    crsx=crsx+1
    DrawAtascii()
   EndIf
  EndIf
  If GetAsyncKeyState_(#VK_UP)=-32767
   If crsy>0
    crsy=crsy-1
    DrawAtascii()
   EndIf
  EndIf
  If GetAsyncKeyState_(#VK_DOWN)=-32767
   If crsy<23
    crsy=crsy+1
    DrawAtascii()
   EndIf
  EndIf
  
  EventID = WaitWindowEvent() 
  Select EventID
      Case #PB_Event_Menu
        Select EventMenu()
          Case 4
            If GetGadgetState(#option_int)=1
              clv.b=0
            Else
              clv=32
             EndIf
            For j=0 To 23
              For i=0 To 39
                atascii(i,j)=clv;0;32
              Next i
            Next j 
            DrawAtascii()

            EnableGadgetDrop(0, #PB_Drop_Files, #PB_Drag_Copy)

          Case 1
Files$ = OpenFileRequester("Please choose file to open", "","All files (*.*)|*.*", 0)
If Files$
     ReadAtascii(Files$)
     DrawAtascii()
EndIf

          Case 2
Pattern$ = "Bitmap|*.bmp|JPEG|*.jpg|Portable Network Graphics|*.png"
File$ = SaveFileRequester("Please choose image to save", "", Pattern$, 0);SelectedFilePattern()

If File$
  UseJPEGImageEncoder()
  UsePNGImageEncoder()
  
CreateImage(0,320,192)
StartDrawing(ImageOutput(0))
Box(0, 0, 320, 192,RGB(0,0,255))
DrawingFont(FontID(1))
For x=0 To 39
  For y=0 To 23
    b.a=atascii(x,y)
    If GetGadgetState(#option_int)=1
      b.a=intrnl2Atascii(b)
    EndIf
    txtclr=RGB(0,255,255)
    bkclr=RGB(0,0,255)
    If (b=0) Or (b=31);non-printable chars
      b=b+128
      bkclr=RGB(0,255,255)
      txtclr=RGB(0,0,255)
  EndIf
  DrawText(x*8,y*8,Chr(b),txtclr,bkclr)
Next y
Next x
StopDrawing()
Select SelectedFilePattern()
    Case 0:
      SaveImage(0,file$+".bmp",#PB_ImagePlugin_BMP)
    Case 1:
    SaveImage(0,file$+".jpg",#PB_ImagePlugin_JPEG)
    Case 2:
    SaveImage(0,file$+".png",#PB_ImagePlugin_PNG)
EndSelect
FreeImage(0)
EndIf





          Case 3
        Pattern$ = "Executable(*.xex)|*.xex|Binary ATASCII|*.atascii|All files (*.*)|*.*"
        File$ = SaveFileRequester("Please choose file to save", "", Pattern$, 0);SelectedFilePattern()
        If File$
          If (LCase(Mid(File$,Len(File$)-3))<>".xex") And (SelectedFilePattern()=0)
            File$=File$+".xex"
          EndIf
          If (LCase(Mid(File$,Len(File$)-7))<>".atascii") And (SelectedFilePattern()=1)
            File$=File$+".atascii"
          EndIf
          
          CreateFile(0,File$)
          
        If SelectedFilePattern()=0
            
          Restore xexdump
          For i=1 To 30
            Read.b j
            WriteByte(0,j)
          Next i
          
        EndIf
        
            For j=0 To 23
              For i=0 To 39
                WriteAsciiCharacter(0,atascii(i,j))
              Next i
            Next j 
          CloseFile(0)
        Else
          MessageRequester("Information", "The requester was canceled.", 0)
        EndIf

        EndSelect
        
        
      Case #PB_Event_WindowDrop
        Select GetGadgetState(96)
            Case 1
            Files$ = EventDropFiles()
            Files$ = StringField(Files$, 1, Chr(10))
            ReadAtascii(Files$)
            DrawAtascii()
          Case 0

            Files$ = EventDropFiles()
            Files$ = StringField(Files$, 1, Chr(10))

;;            Debug LCase(Mid(Files$,Len(Files$)-3))
     If LCase(Mid(Files$,Len(Files$)-3))=".bas"
            If ConvertBasicToText(Files$,Files$+"~",0)=0
              ba$=""
              ReadFile(0,Files$+"~")
              While Not (Eof(0))
                co.a=ReadAsciiCharacter(0)
                If co<>155
                  ba$=ba$+Chr(co)
                Else
                  ;AddGadgetItem(97,-1,ba$)
                  ba$=ba$+Chr(13)+Chr(10);;#CRLF$
                  ;ba$=""
                EndIf
              Wend
              CloseFile(0)
              ;delete ~
              DeleteFile(Files$+"~")
              SetGadgetText(97,ba$)
            Else
               MessageRequester("Information", "Something wrong with expected format", 0)
             EndIf
     ElseIf (LCase(Mid(Files$,Len(Files$)-3))=".lst")
       ReadFile(0,Files$)
       ba$=""
       While Not (Eof(0))
         co.a=ReadAsciiCharacter(0)
         If co<>155
           ba$=ba$+Chr(co)
         Else
           ba$=ba$+Chr(13)+Chr(10);;#CRLF$
         EndIf
       Wend
       CloseFile(0)
       SetGadgetText(97,ba$)
     Else
       ;;;;;ask what to do
       SetGadgetState(96, 1)
            Files$ = EventDropFiles()
            Files$ = StringField(Files$, 1, Chr(10))
            ReadAtascii(Files$)
            DrawAtascii()

      EndIf
      
         EndSelect

    Case #PB_Event_Gadget 
      Select EventGadget()
        Case 0
          If EventType()=#PB_EventType_LeftClick
            ;Debug "clicked:"+Str(WindowMouseX(0))+","+Str(WindowMouseY(0))
             crsx=Int(WindowMouseX(0)/8)
             crsy=Int(WindowMouseY(0)/8)-3
             DrawAtascii()
          EndIf  
        Case #option_ata
          DrawAtascii()
        Case #option_int
          DrawAtascii()
        Case 100 To 227:
          b=0
          ;Debug "button:"+Str(EventGadget()-100)+",i:"+Str(Atascii2intrnl(EventGadget()-100))
          invf=GetGadgetState(99)*128
          If GetGadgetState(#option_int)=1
            b=Atascii2intrnl(EventGadget()-100)
          EndIf
          If GetGadgetState(#option_ata)=1
            b=EventGadget()-100
          EndIf
          atascii(crsx,crsy)=b+invf
          If crsx<39:crsx=crsx+1:EndIf
          DrawAtascii()
      EndSelect 
    EndSelect 
    If EventID = #PB_Event_CloseWindow 
      Quit = 1 
    EndIf 
  Until Quit = 1
  RemoveFontMemResourceEx(fHandle) 
EndIf 
End 

DataSection 
  xexdump:
 Data.b 255,255,000,128,215,131,173,048
 Data.b 002,133,203,173,049,002,133,204
 Data.b 160,004,169,024,145,203,200,169
 Data.b 128,145,203,076,021,128,000,000

  MyFont: 
  IncludeBinary "Atari.fon" 
  EndOfMyFont: 
EndDataSection
; IDE Options = PureBasic 4.60 (Windows - x86)
; CursorPosition = 415
; FirstLine = 401
; Folding = -
; EnableXP
; UseIcon = ata.ico
; Executable = ata.exe