package clmedit;

import java.awt.*;
import javax.swing.*;
import java.awt.event.*;


public class DrawPanel extends JPanel{
    
    int hmarg=20*48;
    int vmarg=22*24;
    int pom=0;
    int currentElement=29;
    
    Image[] images = new Image[30];
    
    public void paintComponent(Graphics g) {
        
        
        g.setColor(Color.black);
        g.fillRect(0,0,20*48,22*24+60);
        
        if (CalominEditor2.loaded==0) return;
        
        
        
        for (int y=0;y<22;y++) {
            for (int x=0;x<20;x++) {
                int i = CalominEditor2.caveData[CalominEditor2.currentCave][x][y];
                if (i<30 && i>=0) g.drawImage(images[i],x*48,y*24,this);
            }
        }
        
        g.setColor(Color.white);
        g.drawString("Current:",2,vmarg+22);
        g.drawImage(images[currentElement],96,vmarg+4,this);
        g.drawRect(96,vmarg+4,48,24);
        
        g.setColor(Color.white);
        for(int i=0;i<21;i++) {
            pom=i*48;
            g.drawLine(pom,0,pom,vmarg);
        }
        for(int i=0;i<23;i++) {
            pom=i*24;
            g.drawLine(0,pom,hmarg,pom);
        }
        
        
    }
    
    public Dimension getPreferredSize() {
        Dimension r = new Dimension(20*48,22*24+60);
        return r;
    }
    
    public void initImages() {
        this.setOpaque(true);
        this.setDoubleBuffered(true);
        ImageIcon i = new javax.swing.ImageIcon(getClass().getResource("/clmedit/el16.png"));
        images[29]=i.getImage();
        
        i = new javax.swing.ImageIcon(getClass().getResource("/clmedit/el1.png"));
        images[0]=i.getImage();
        
        i = new javax.swing.ImageIcon(getClass().getResource("/clmedit/el2.png"));
        images[1]=i.getImage();
        
        i = new javax.swing.ImageIcon(getClass().getResource("/clmedit/el3.png"));
        images[2]=i.getImage();
        
        i = new javax.swing.ImageIcon(getClass().getResource("/clmedit/el4.png"));
        images[3]=i.getImage();
        
        i = new javax.swing.ImageIcon(getClass().getResource("/clmedit/el5.png"));
        images[4]=i.getImage();
        
        i = new javax.swing.ImageIcon(getClass().getResource("/clmedit/el6.png"));
        images[5]=i.getImage();
        
        i = new javax.swing.ImageIcon(getClass().getResource("/clmedit/el7.png"));
        images[6]=i.getImage();
        
        i = new javax.swing.ImageIcon(getClass().getResource("/clmedit/el8.png"));
        images[7]=i.getImage();
        
        i = new javax.swing.ImageIcon(getClass().getResource("/clmedit/el9.png"));
        images[8]=i.getImage();
        
        i = new javax.swing.ImageIcon(getClass().getResource("/clmedit/el11.png"));
        images[16]=i.getImage();
        
        i = new javax.swing.ImageIcon(getClass().getResource("/clmedit/el12.png"));
        images[17]=i.getImage();
        
        i = new javax.swing.ImageIcon(getClass().getResource("/clmedit/el13.png"));
        images[20]=i.getImage();
        
        i = new javax.swing.ImageIcon(getClass().getResource("/clmedit/el14.png"));
        images[21]=i.getImage();
        
        i = new javax.swing.ImageIcon(getClass().getResource("/clmedit/el15.png"));
        images[22]=i.getImage();
        
        this.addMouseMotionListener(new MouseDrawer());
        this.addMouseListener(new MouseTicker());
        
    }
    
    
}


class MouseDrawer extends java.awt.event.MouseMotionAdapter {
    
    public void mouseDragged(MouseEvent e) {
        
        if (CalominEditor2.loaded==0) return;
        
        int x= e.getX();
        int y= e.getY();
        int gx=x/48;
        int gy=y/24;
        
        if (gx>19 || gy >21) return;
        
        CalominEditor2.caveData[CalominEditor2.currentCave][gx][gy]=(short)CalominEditor2.drawPanel.currentElement;
        CalominEditor2.drawPanel.repaint();
        
    }
}

class MouseTicker extends java.awt.event.MouseAdapter {
    public void mouseClicked(MouseEvent e) {
        if (CalominEditor2.loaded==0) return;
        
        int x= e.getX();
        int y= e.getY();
        int gx=x/48;
        int gy=y/24;
        
        if (gx>19 || gy >21) return;
        
        CalominEditor2.caveData[CalominEditor2.currentCave][gx][gy]=(short)CalominEditor2.drawPanel.currentElement;
        CalominEditor2.drawPanel.repaint();
    }
    
    
}
