;
; Effectus / MADS game controller library
;
; Source code assembled with Mads 1.9.8
;

  icl 'equates.asm'
  
  .reloc
	
  .public Stick, Strig, Paddle, Ptrig

;
; Stick - Joystick movement status routine
;
; Parameters:
; .byte a (8-bit value): Joystick port (0 or 1)
;
; Result:
; STORE1 (8-bit value): Joystick movement status
;
Stick .proc (.byte a) .reg

  sta STORE2
  #if .byte STORE2 = #0
    lda STICK0  ; Stick 0 status
    sta STORE1
  #end
  #if .byte STORE2 = #1
    lda STICK1  ; Stick 1 status
    sta STORE1
  #end
  rts
 
  .endp

;
; Strig - Joystick trigger status routine
;
; Parameters:
; .byte a (8-bit value): Joystick port (0 or 1)
;
; Result:
; STORE1 (8-bit value): Joystick trigger status
;
Strig .proc (.byte a) .reg

  sta STORE2
  #if .byte STORE2 = #0
    lda STRIG0  ; Stick 0 trigger status
    sta STORE1
  #end
  #if .byte STORE2 = #1
    lda STRIG1  ; Stick 1 trigger status
    sta STORE1
  #end
  rts
 
  .endp 

;
; Paddle - Paddle movement status routine
;
; Parameters:
; .byte a (8-bit value): Paddle (0 or 3)
;
; Result:
; STORE1 (8-bit value): Paddle movement status
;
Paddle  .proc (.byte a) .reg

  sta STORE2
  #if .byte STORE2 = #0
    lda PADDL0  ; Paddle 0 status
    sta STORE1
  #end
  #if .byte STORE2 = #1
    lda PADDL1  ; Paddle 1 status
    sta STORE1
  #end
  #if .byte STORE2 = #2
    lda PADDL2  ; Paddle 2 status
    sta STORE1
  #end
  #if .byte STORE2 = #3
    lda PADDL3  ; Paddle 3 status
    sta STORE1
  #end
  rts
 
  .endp

;
; Ptrig - Paddle trigger status routine
;
; Parameters:
; .byte a (8-bit value): Paddle (0 or 3)
;
; Result:
; STORE1 (8-bit value): Paddle trigger status
;
Ptrig .proc (.byte a) .reg

  sta STORE2
  #if .byte STORE2 = #0
    lda PTRIG0  ; Paddle 0 trigger status
    sta STORE1
  #end
  #if .byte STORE2 = #1
    lda PTRIG1  ; Paddle 1 trigger status
    sta STORE1
  #end
  #if .byte STORE2 = #2
    lda PTRIG2  ; Paddle 2 trigger status
    sta STORE1
  #end
  #if .byte STORE2 = #3
    lda PTRIG3  ; Paddle 3 trigger status
    sta STORE1
  #end
  rts
 
  .endp
