{ 
  Program    : Effectus - Atari MADS cross-assembler/parser for Action! language
  Version    : 0.1.6

  Project file: effectus.pas
  
  Author: Bostjan Gorisek, Slovenia

  Program compiled with Free Pascal 2.6.4
  Reference: http://www.freepascal.org/
  
  This is cource code generator for MADS Assembler, which then generates
  executable files from parser of Action! language for 8-bit Atari home computers.
  
  References:
  http://mads.atari8.info/
  http://gury.atari8.info/effectus/ 
  
  This is open source and freeware project!  
}
program Effectus;
{$APPTYPE CONSOLE}

uses
  Classes, SySutils, StrUtils, Crt, Common, Decl;

procedure CloseApp;
begin
  DestroyLists;
end;

procedure Parameters;
var
  i : Integer;
begin
  meditMADS_src_dir := GetCurrentDir + PathDelim;
  meditMADS_bin_dir := GetCurrentDir + PathDelim;
  meditMADS_output_dir := GetCurrentDir + PathDelim + 'output.txt';

  if ParamCount = 0 then
  begin
    TextColor(LightCyan);
{$ifdef Unix}
    WriteLn('Effectus ' + VERSION + ' (Linux platform console version)');
{$else}
    WriteLn('Effectus ' + VERSION + ' (i386-win32 platform console version)');
{$endif}
    WriteLn('Atari MADS cross-assembler/parser for Action! language');
    TextColor(White);
    WriteLn('Written by Bostjan Gorisek');
    WriteLn('Page URL: http://gury.atari8.info/effectus/');
    WriteLn('');
    TextColor(LightCyan);
    WriteLn('MAD Assembler (MADS) is a product written by Tebe');
    TextColor(White);
    WriteLn('Page URL: http://mads.atari8.info/');
    WriteLn('');
    TextColor(LightGreen);
    WriteLn('Usage:');    
    WriteLn('effectus <filename> <parameters>');
    WriteLn('');  
    TextColor(White);
    WriteLn('Program options:');
    TextColor(LightCyan);
    Write('-md: ');
    TextColor(LightGray);
    Writeln('MADS cross-assembler directory');
    TextColor(LightCyan);
    Write('-sa: ');
    TextColor(LightGray);
    WriteLn('Program starting address');
    TextColor(LightCyan);
    Write('-ms: ');
    TextColor(LightGray);
    WriteLn('Output source directory');
    TextColor(LightCyan);
    Write('-mb: ');
    TextColor(LightGray);
    Writeln('Output binary directory');
    TextColor(LightCyan);
    Write('-se: ');
    TextColor(LightGray);
    Writeln('Output source extension');
    TextColor(LightCyan);
    Write('-be: ');
    TextColor(LightGray);
    Writeln('Output binary extension');
    TextColor(LightCyan);
    Write('-rl: ');
    TextColor(LightGray);
    Writeln('Effectus/MADS runtime library directory');
    TextColor(LightCyan);
    Write('-lo: ');
    TextColor(LightGray);
    Writeln('Log pathname (including filename)');
    TextColor(LightCyan);
    Write('-sm: ');
    TextColor(LightGray);
    WriteLn('Machine language starting address');
    CloseApp;
    Halt(0);
  end;

  for i := 1 to ParamCount do
  begin
    if ParamStr(i)[1] <> '-' then
      meditEff_src_filename := ParamStr(i)
    else if Copy(ParamStr(i), 1, 3) = '-ms' then
      meditMADS_src_dir := Copy(ParamStr(i), 5, Length(ParamStr(i))-4)
    else if Copy(ParamStr(i), 1, 3) = '-mb' then
      meditMADS_bin_dir := Copy(ParamStr(i), 5, Length(ParamStr(i))-4)
    else if Copy(ParamStr(i), 1, 3) = '-se' then
      meditMADS_src_ext := Copy(ParamStr(i), 5, Length(ParamStr(i))-4)
    else if Copy(ParamStr(i), 1, 3) = '-be' then
      meditMADS_bin_ext := Copy(ParamStr(i), 5, Length(ParamStr(i))-4)
    else if Copy(ParamStr(i), 1, 3) = '-rl' then
      meditMADS_rtl_dir := Copy(ParamStr(i), 5, Length(ParamStr(i))-4)
    else if Copy(ParamStr(i), 1, 3) = '-lo' then
      meditMADS_output_dir := Copy(ParamStr(i), 5, Length(ParamStr(i))-4)
    else if Copy(ParamStr(i), 1, 3) = '-md' then
      meditMADS_dir := Copy(ParamStr(i), 5, Length(ParamStr(i))-4)
    else if Copy(ParamStr(i), 1, 3) = '-sa' then
      meditAddr := StrToInt(Copy(ParamStr(i), 5, Length(ParamStr(i))-4))
    else if Copy(ParamStr(i), 1, 3) = '-sm' then
      meditMLAddr := StrToInt(Copy(ParamStr(i), 5, Length(ParamStr(i))-4))
    else if Copy(ParamStr(i), 1, 2) = '-i' then
      boolInfo := True;
  end;      
end;

procedure CheckCfg;
begin
  if not FileExists(GetCurrentDir + PathDelim + 'config.ini') then
  begin
    WriteLn('Configuration file is missing!');
    CloseApp;
    Halt(0)
  end;
end;

var
  n : Byte;

begin
  ReadCfg;  
  CreateLists;  
  Parameters;  
  Init;  

  lInclude := False; lIncFlag := True;
  
  if not ReadOrig then
  begin
    CloseApp;
    Exit;
  end;
  
  GetFuncs;
  lIncFlag := False;
  
  GenerateCode;
  
  RunMads(meditMADS_dir, meditMADS_src_dir, meditMADS_bin_dir, meditMADS_output_dir);

  Write(mStatusLog);
  
  //if mStatus <> '' then WriteLn(mStatus);

  if boolInfo then
  begin
    WriteLn('');    
    WriteLn('Variables:');
    WriteLn('----------');
    
    for n := 1 to GVarCnt do
      writeln(GVar[n].VarType + ' * ' + GVar[n].ParentType + ' * ' + GVar[n].OrigType + ' * ' +
              GVar[n].VarName + ' * ' + GVar[n].Value + ' * ' + GVar[n].ML_type);
        
    for n := 1 to GVarCnt2 do
      writeln(GVar2[n].VarType + ' * ' + GVar2[n].OrigType + ' * ' + GVar2[n].VarName + ' * ' +
              IntToStr(GVar2[n].Dim) + ' * ' + (GVar2[n].Value) + ' * ' + (GVar2[n].Location));
    
    WriteLn('');
    WriteLn('PROCs and FUNCs:');
    WriteLn('----------------');
    
    for n := 0 to ProcCount do
      writeln(Copy(ProcBuf[n], 5, Length(ProcBuf[n]) - 4) + '  Parameters: ' + PrmBuf[n]);
  end;

  CloseApp;
end.
