;
; Effectus / MADS runtime library
; Version 0.0.16 Beta
;
; Source code assembled with Mads 1.9.3
;

  icl 'equates.asm'
  
  .reloc
	
  .public device, device.devscr
  .public GetD, GetLine, SetColor, Put, PutE, Rand, SetBlock, Zero
 
; temporary BYTE variable
  .var b_lparam1 .byte
 
; temporary WORD variables
  .var w_lparam1, w_lparam2, w_lparam3 .word

;
; device - Global variable representing current device enabled
;
; Parameters:
; .byte x (8-bit value): current device 
;
; Result:
; devscr (8-bit value): current device (a variable used inside any file)
;
device  .proc (.byte x) .reg

  stx devscr
  rts

devscr  brk

  .endp

;
; GetD - Get a character from chosen device
;
; Parameters:
; .byte x (8-bit value): Chosen device number
;
; Result:
; STORE1 (8-bit value): A character read from chosen device
;	
GetD  .proc (.byte x) .reg

  mva #7 ICHID+2,x  ; CIO command
  mwa #0 ICHID+8,x	; length
  jsr CIOV
  sta STORE1
  rts

  .endp

;
; GetLine - Input string from device 0 (editor)
;
; Original source:
; Mad-Assembler (MADS)
; Hyperlink: http://mads.atari8.info/
;
; Parameters:
; .word ya (16-bit value): Buffer for inputted string
;
; Result:
; ICBAL,x (low byte of 16-bit value): Buffer for inputted string on device 0
; ICBAL+1,x (high byte of 16-bit value): Buffer for inputted string on device 0
;
GetLine .proc (.word ya)  .reg

  ldx device.devscr
  sta ICBAL,x
  tya
  sta ICBAL+1,x

  mwa #120 ICBLL,x	; maximum size of inputted text

  mva #$05  iccom,x
  jmp CIOV

  .endp

;
; Setcolor - Set color of specific color register
;
; Parameters:
; .byte x (8-bit value): Color register
; .byte a (8-bit value): Color hue
; .byte y (8-bit value): Color luminance
;
; Result:
; COLOR0,X (8-bit value): Actual color register affected
; STORE1 (8-bit value)
;
SetColor  .proc (.byte x .byte a .byte y) .reg

  asl @         ; need to multiply
  asl @         ; hue by 16, and
  asl @         ; add it to lum.
  asl @         ; now hue is *16
  sta STORE1    ; temporarily
  tya           ; so we can add
  clc           ; before adding
  adc STORE1    ; now have sum
  sta COLORO,x  ; actual SETCOLOR
  rts

  .endp

;
; Rand - Random routine
;
; Parameters:
; .byte a (8-bit value): A value between 0 and 255
;
; Result:
; STORE1 (8-bit value): Random number between 0 and 255
; 
Rand  .proc (.byte a) .reg
    
  sta STORE2
Loop
  lda RANDOM
  sta STORE1
  #if .byte STORE1>STORE2
    jmp Loop
  #end
;  jmp Loop
;skip
  rts

  .endp

;
; Put - Put a character to device 0 (editor)
;
; Parameters:
; .byte a (8-bit value): ATASCII value of character to be written to device 0
;
Put .proc (.byte a) .reg

  ldx device.devscr
  tay
  lda ICPTL+1,x
  pha
  lda ICPTL,x
  pha
  tya
  rts

  .endp

;
; PutE - Put a carriage return character to device 0 (editor)
;
PutE  .proc

  Put #$9b
  rts
 
  .endp

; ANTIC VOL. 1, NO. 2 / JUNE 1982 / PAGE 15
;PROC SetBlock (BYTE POINTER adr,CARD size,BYTE value)
SetBlock  .proc (.word w_lparam1, w_lparam2 .byte b_lparam1) .var

  LDA #>w_lparam1       ; save lo-byte of dest addr
  STA  $CC
  LDA #<w_lparam1       ; save hi-byte of dest addr
  STA  $CB
  LDA #>w_lparam2       ; save total to be moved
  STA  $CE       ; *
  LDA #<w_lparam2       ; save total to be moved
  STA  $CD       ; *
  LDX  $CE       ; count of bytes to move
  LDY  #0        ; init index
  LDA  b_lparam1    ; init character to be moved
MOV STA ($CB),Y    ; move data
  DEY            ; decrement index
  BNE  MOV       ; go move next character
  INC  $CC       ; incr dest addr lo-byte
  DEX            ; decr lo-byte count to move
  BMI  EXIT
  BNE  MOV       ; go move next character
  LDY  $CD       ; hi-byte of count to move
  BNE  MOV       ; go move next character
EXIT  DEC  $CC       ; decr lo-byte dest addr
  LDY  #0
  STA  ($CD),Y
  rts

  .endp

Zero  .proc (.word w_lparam1, w_lparam2) .var
;PROC Zero (BYTE POINTER adr,CARD size)

  SetBlock w_lparam1, w_lparam2, #0
  rts

  .endp
