{ 
  Program    : Effectus - Atari MADS cross-assembler/parser for Action! language
  Version    : 0.0.16

  Unit file  : core.pas
  Description: Build-in Action! core behaviour
                           
  Author: Bostjan Gorisek, Slovenia
  
  Program compiled with Free Pascal 2.6.0
  Reference: http://www.freepascal.org/
  
  This is cource code generator for MADS Assembler, which then generates
  executable files from parser of Action! language for 8-bit Atari home
  computers
  References:
  http://mads.atari8.info/
  http://gury.atari8.info/effectus/ 
  
  This is open source and freeware project!  
}
unit Core;
{$ifdef FPC}{$mode objfpc}{$h+}{$endif}

interface

uses
  sysutils, Classes, StrUtils;

procedure sc_Proc(i : LongInt);
procedure sc_Return(i : LongInt);
procedure sc_Include(i : LongInt);
procedure sc_Var(i : LongInt);
procedure sc_Var2(i : LongInt);
procedure sc_Var3(i : LongInt; xType, xVar, xVarType : String);
procedure sc_Array(i : LongInt);
procedure sc_VarExpr(i : LongInt);
procedure sc_Data;
procedure sc_ML_data;
procedure sc_ProcTrack(i : LongInt);
procedure sc_while(i : LongInt);
procedure sc_For(i : LongInt);
procedure sc_od(i : LongInt);
procedure sc_if(i : LongInt);
procedure sc_fi(i : LongInt);
procedure sc_else(i : LongInt);
procedure sc_Comments(i : LongInt);
procedure sc_ASM(i : LongInt);
function FuncCheck(i : LongInt): Boolean;
//function ProcCheck(i : LongInt): Boolean;
procedure sc_Define(i : LongInt);
procedure GenLoop(Flag : Boolean);
procedure Cond(Stmt : String; i : LongInt);
procedure sc_do(i : LongInt);
procedure sc_Exit(i : LongInt);
procedure sc_ML(i : LongInt);

implementation

uses
  Decl, Common, Routines;

{
  ACTION! PROC statement
}
procedure sc_Proc(i : LongInt);
var
  n1, n4, n, j : LongInt;
  FuncName, Params, FuncParams, VarType, VarX, Buffer : String;
  boolNextType : Boolean = False;
  ParamList : TStringList;                                                      
begin
  n1 := System.Pos(UpperCase('PROC '), UpperCase(TextBuf[i]));
  n4 := System.Pos(UpperCase('FUNC '), UpperCase(TextBuf[i]));

  if ((n1 > 0) or (n4 > 0)) then //and not CheckComments(TextBuf[i]) then
  begin
    if n1 > 0 then
      Split(UpperCase(TextBuf[i]), 'PROC')
    else
      Split(UpperCase(TextBuf[i]), 'FUNC');

    FuncName := StrBuf[1];
    Split(FuncName, '(');
    FuncName := StrBuf[0];
    FuncParams := Extract(StrBuf[1], ')', 1);

    // Check for machine language mnemonics
    if System.Pos('=*', FuncName) > 0 then
    begin
      FuncName := Copy(FuncName, 1, Length(FuncName)-2);      
      CntML := MemCnt;
      Inc(ProcML_cnt);
      ProcML[ProcML_cnt].Name := FuncName;
      ProcML[ProcML_cnt].ProcType := 0;      
      ProcML[ProcML_cnt].Code := ' .he';
      ProcML_start := True;
      PrgVar.SB := _SB_PROC_ML;
    end;    

    if lIncludeX and not lInclude then
    begin
      if (LowerCase(Copy(ProcBuf[ProcCount2 - 1], 5, Length(ProcBuf[ProcCount2 - 1]) - 4)) = LowerCase(FuncName)) then
      begin
        CodeBuf.Add(FuncName);
        lMainProc := True;
        Exit;
      end;
    end;

    if Length(FuncParams) > 0 then
    begin    
      ParamList := TStringList.Create;
      Buffer := '';
      
      for n := 1 to _VAR_TYPES do
      begin
        if System.Pos(VarTypes[n], UpperCase(FuncParams)) > 0 then
        begin
          VarType := VarTypes[n];
          Split(FuncParams, VarType);
          Params := StrBuf[1];          
          Split(Params, ',');
          boolNextType := False;                    
                    
          for j := 0 to StrBuf.Count - 1 do
          begin
            if (System.Pos(' ', StrBuf[j]) > 0) then  //and (j > 0) then
            begin
              StrBuf[j] := Extract(StrBuf[j], ' ', 1);
              boolNextType := True;
            end;            

            VarX := '';
            if (VarType = 'BYTE') or (VarType = 'CHAR') then VarX := 'byte';
            if (VarType = 'INT') or (VarType = 'CARD') then VarX := 'word';

            if j = 0 then Buffer := Buffer + ' .' + VarX + ' ';

            Inc(GVarCnt);
            GVar[GVarCnt].VarType  := SetType(VarType);
            GVar[GVarCnt].OrigType := '';
            GVar[GVarCnt].VarName  := StrBuf[j];
            GVar[GVarCnt].Location := FuncName;
            GVar[GVarCnt].Value    := '';
            GVar[GVarCnt].Dim      := 0;
            GVar[GVarCnt].ML_type := VarX;
            GVar[GVarCnt].Scope    := 'L';
            
            ParamList.Add(StrBuf[j]);

            if j = 0 then
              Buffer := Buffer + StrBuf[j]
            else
              Buffer := Buffer + ', ' + StrBuf[j];

            if boolNextType then Break;
          end;
        end;
      end;

      if not ProcML_start then
        CodeBuf.Add(FuncName + ' .proc (' + Buffer + ') .var');

      if not lInclude and (LowerCase(Copy(ProcBuf[ProcCount], 5, Length(ProcBuf[ProcCount]) - 4)) = LowerCase(FuncName)) then
        lMainProc := True
      else
        lMainProc := False;      

      n := 0;
      
      for j := 1 to GVarCnt do
      begin        
          for n1 := 0 to ParamList.Count - 1 do          
          begin
            if (UpperCase(GVar[j].VarName) = UpperCase(ParamList[n1])) and (GVar[j].Scope = 'L') then
            begin
              Inc(n);
              CodeBuf.Add(' .var ' + GVar[j].VarName + ' .' + GVar[j].ML_type);
            
              if PrgVar.SB <> _SB_PROC_ML then
              begin
                if System.Pos(GVar[j].VarType, 'T1T2') > 0 then  // BYTE, CHAR
                  CodeBuf.Add(' mva b_param' + IntToStr(n) + ' ' + GVar[j].VarName)
                else
                  CodeBuf.Add(' mwa w_param' + IntToStr(n) + ' ' + GVar[j].VarName);
              end;
            end;
          end;
      end;
      
      ParamList.Free;
    end
    
    else
    
    begin
      lMainProc := False;           
      
      if not lInclude then
      begin
        if UpperCase(Copy(ProcBuf[ProcCount], 5, Length(ProcBuf[ProcCount]) - 4)) = UpperCase(FuncName) then
        begin
          CodeBuf.Add(FuncName);
          lMainProc := True;
        end
        else
        begin
          if PrgVar.SB <> _SB_PROC_ML then
            CodeBuf.Add(FuncName + ' .proc');
        end;
      end
      else
      begin      
        if PrgVar.SB <> _SB_PROC_ML then
          CodeBuf.Add(FuncName + ' .proc');
      end;    
    end;       
  end;  
end;

{
  ACTION! RETURN statement
}
procedure sc_Return(i : LongInt);
var
  n : Integer;
begin
  if System.Pos('RETURN', UpperCase(TextBuf[i])) > 0 then
  begin
    if (System.Pos('(', UpperCase(TextBuf[i])) > 0) and (System.Pos(')', UpperCase(TextBuf[i])) > 0) then
    begin
      for n := 1 to GVarCnt do
      begin      
        if System.Pos(UpperCase(GVar[n].VarName), UpperCase(TextBuf[i])) > 0 then
        begin
          if ProcML_start then
          begin
          end
          else
          begin                          
            CodeBuf.Add(' mwa ' + GVar[n].VarName + ' STORE1');
          end;
                    
          Break;
        end;
      end;
    end;     

    if not lMainProc then
    begin
      CodeBuf.Add(' rts');
      CodeBuf.Add('');
      CodeBuf.Add(' .endp');
      CodeBuf.Add('');
    end;    
  end;
end;

{
  Check FUNCs
}
function FuncCheck(i : LongInt): Boolean;
var
  n : Byte;
begin
  Result := True;
  for n := 0 to FuncList.Count-1 do
  begin
    if System.Pos(UpperCase(FuncList[n]) + '(', UpperCase(TextBuf[i])) > 0 then
    begin
      Result := False;
      Break;
    end;
  end;
end;

{ Check PROCs }
function ProcCheck(i : LongInt) : Boolean;
var
  Buffer : String;
begin
  Exit;
  Result := True;

  Buffer := Strip(TextBuf[i], ' ');
  if Buffer[1] = ';' then
  begin
    Result := False;
    Exit;
  end;
end;

{ Public and local variables }
procedure sc_Var(i : LongInt);
var
  VarPos, n, j, k : LongInt;
  MemAddr, Buffer, VarType, VarX, Str1, Str2 : String;
  EquPos : Byte;
begin
  if (System.Pos('[', TextBuf[i]) > 0) and (System.Pos('TYPE ', UpperCase(TextBuf[i])) > 0) then
  begin
    Exit;
  end;
  
  if not boolType then
  begin
  for j := 1 to _VAR_TYPES do
  begin
    VarPos := System.Pos(UpperCase(VarTypes[j]) + ' ', UpperCase(TextBuf[i]));
    
    if (VarPos > 0) and VarDeclCheck(TextBuf[i]) then
    begin      
      Buffer := Trim(TextBuf[i]);
      VarType := UpperCase(Extract(Buffer, ' ', 1));
      
      if VarType = VarTypes[j] then
      begin              
        if (VarType = 'CARD') or (VarType = 'INT') then
          VarType := 'word'
        else if VarType = 'CHAR' then
          VarType := 'byte';
        
        VarX := LowerCase(VarType);
      end;
        
      VarType := Extract(Buffer, ' ', 2);
      Split(VarType, ',');            
      
      for n := 0 to StrBuf.Count - 1 do
      begin
        MemAddr := '';
        
        if System.Pos('=', StrBuf[n]) < 1 then
        begin          
          Str2 := '-1'
        end
        else
        begin          
          Buffer := Strip(StrBuf[n], ' ');
          Str1 := Extract(Buffer, '=', 1);
          Str2 := Extract(Buffer, '=', 2);
          k := System.Pos('[', Str2);
          
          if k < 1 then
          begin
            MemAddr := Str2
          end
          else
          begin
            Str2 := Copy(Str2, k + 1, Length(Str2) - k - 1);
            PrgVar.SB := _SB_ARRAY_SET;
          end;                    
          
          StrBuf[n] := Str1;        
        end;
                
        if System.Pos('"', StrBuf[n]) < 1 then
        begin
          Inc(GVarCnt);
          GVar[GVarCnt].VarType    := SetType(VarTypes[j]);
          GVar[GVarCnt].ParentType := SetType(VarTypes[j]);
          GVar[GVarCnt].OrigType   := SetType(VarTypes[j]);        
          GVar[GVarCnt].VarName    := StrBuf[n];
          GVar[GVarCnt].Location   := '';
          GVar[GVarCnt].Value      := MemAddr;
          GVar[GVarCnt].Dim        := 0;
          GVar[GVarCnt].InitValue  := StrToInt(Str2);
          GVar[GVarCnt].ML_type := VarX;
        end;
      end;
        
      Break;
    end;
  end;
  
  for j := 1 to GVarCnt2 do
  begin
    if System.Pos(GVar2[j].VarType, 'T5T6T7T8T10') > 0 then Continue;  // ARRAY, POINTER
    //if System.Pos('ARRAY', UpperCase(GVar2[j].VarType)) > 0 then Continue;
    //if System.Pos('POINTER', UpperCase(GVar2[j].VarType)) > 0 then Continue;  
    //
    VarPos := System.Pos(UpperCase(GVar2[j].VarName), UpperCase(TextBuf[i]));
    if (VarPos > 0) and VarDeclCheck(TextBuf[i]) then
    begin      
      Buffer := Trim(TextBuf[i]);
      VarType := Extract(Buffer, ' ', 1);
      VarType := UpperCase(VarType);
            
      if UpperCase(VarType) = UpperCase(GVar2[j].VarName) then
      begin
        VarX := VarType;
        
        if (VarType = 'CARD') or (VarType = 'INT') then
          VarX := 'word'
        else if (VarType = 'BYTE') or (VarType = 'CHAR') then
          VarX := 'byte';
      end;
         
      VarType := Extract(Buffer, ' ', 2);
      Split(VarType, ',');
      MemAddr := '';
      
      for n := 0 to StrBuf.Count - 1 do
      begin
        if System.Pos('"', StrBuf[n]) < 1 then
        begin              
          Inc(GVarCnt);
          GVar[GVarCnt].VarType    := SetType(VarType);
          GVar[GVarCnt].ParentType := SetType(GVar2[j].VarType);
          GVar[GVarCnt].OrigType   := SetType(GVar2[j].VarName);        
          GVar[GVarCnt].VarName    := StrBuf[n];
          GVar[GVarCnt].Location   := '';
          GVar[GVarCnt].Value      := MemAddr;
          GVar[GVarCnt].Dim        := 0;
          GVar[GVarCnt].ML_type    := VarX;
          
          SData[Cnt] := GVar[GVarCnt].VarName + ' ' + VarX;
          Inc(Cnt);
        end;
      end;
      
      Break;
    end;
  end;
  
  // TYPE declaration variables
  end
  //
  else
  //
  begin
    for j := 1 to _VAR_TYPES do
    begin
      VarPos := System.Pos(UpperCase(VarTypes[j]) + ' ', UpperCase(TextBuf[i]));      
      if (VarPos > 0) and VarDeclCheck(TextBuf[i]) then
      begin      
        Buffer := Trim(TextBuf[i]);
        VarType := Extract(Buffer, ' ', 1);
        
        if UpperCase(VarType) = VarTypes[j] then
        begin
          if (UpperCase(VarType) = 'CHAR') or (UpperCase(VarType) = 'BYTE') then
            VarType := 'byte'
          else if (UpperCase(VarType) = 'CARD') or (UpperCase(VarType) = 'INT') then
            VarType := 'word';                      
        end;
        
        Buffer := Extract(Buffer, ' ', 2);
        Split(Buffer, ',');
        
        for n := 0 to StrBuf.Count - 1 do
        begin
          EquPos := System.Pos('=', StrBuf[n]);
          MemAddr := '';
          
          if EquPos > 0 then 
          begin
            MemAddr := Copy(StrBuf[n], EquPos + 1, Length(StrBuf[n])-EquPos);
            StrBuf[n] := Copy(StrBuf[n], 1, EquPos - 1);
          end;
          
          if VarType = 'byte' then
            Inc(TypeMemCnt, 1)
          else
            Inc(TypeMemCnt, 2);
          
          if System.Pos(']', StrBuf[n]) > 0 then
          begin
            StrBuf[n] := Copy(StrBuf[n], 1, Length(StrBuf[n]) - 1);            
            boolType := False;
            PrgVar.SB := _SB_ARRAY_SET;
          end;
          
          Inc(GVarCnt);
          GVar[GVarCnt].VarType    := SetType(VarTypes[j]);  // VarType
          GVar[GVarCnt].ParentType := SetType(GVar2[GVarCnt2].VarName);
          GVar[GVarCnt].OrigType   := SetType(VarTypes[j]);
          GVar[GVarCnt].VarName    := StrBuf[n];
          GVar[GVarCnt].Location   := IntToStr(GVarCnt2);
          GVar[GVarCnt].Value      := MemAddr;
          GVar[GVarCnt].Dim        := 0;
          GVar[GVarCnt].ML_type := VarType;
        end;
        
        Break;
      end;
    end;
    
    if (System.Pos(']', TextBuf[i]) > 0) and boolType then
      boolType := False;
  end;
end;

{ Public and local more complex variables }
procedure sc_Var2(i : LongInt);
var
  VarPos, n, n4, n5, n6, j : LongInt;
  CharPos : String[1];
  Buffer, VarType, VarX, Str1, Str2, xType, xVar : String;
  boolFirstSpace : Boolean;
begin
  // TYPE variable
  if (System.Pos('TYPE ', UpperCase(TextBuf[i])) > 0) then
  begin
    if System.Pos('"', TextBuf[i]) > 0 then Exit;
    
    CodeBuf.Add('; Handling TYPE variables');
    CodeBuf.Add(' .var struct_ptr_var .word');
    CodeBuf.Add('');
       
    boolType := True;
    TypeMemCnt := 0;
    Buffer := Trim(TextBuf[i]);
    Str1 := Extract(Buffer, '=', 1);
    VarType := Extract(Str1, ' ', 2);
    Str2 := Extract(Buffer, '=', 2);
    Split(Str1, ' ');
    Str2 := Extract(Str2, '[', 2);
    PrgVar.SB := _SB_TYPE;
    
    Inc(GVarCnt2);
    
    // TYPE members, delimited with ,
    //    
    if System.Pos(',', Str2) > 0 then
    begin
      Split(Str2, ',');
      
      for n := 0 to StrBuf.Count - 1 do
      begin
        if n <> 0 then
          xVar := StrBuf[n]
        else
        begin
          Str1 := Extract(StrBuf[n], ' ', 1);
          xType := Str1;
          Str2 := Extract(StrBuf[n], ' ', 2);
          xVar := Str2;
        end;
        
        sc_var3(i, UpperCase(xType), xVar, VarType);
      end;      
    end
    //
    // TYPE lone member
    else
    begin
      Str1 := Extract(Str2, ' ', 1);
      Str2 := Extract(Str2, ' ', 2);
      sc_var3(i, UpperCase(Str1), Str2, VarType);
    end;
    
    GVar2[GVarCnt2].VarType  := SetType('type');
    GVar2[GVarCnt2].ParentType := SetType('type');
    GVar2[GVarCnt2].OrigType := SetType('type');
    GVar2[GVarCnt2].VarName  := VarType;
    GVar2[GVarCnt2].Location := '';
    GVar2[GVarCnt2].Value    := '';
    GVar2[GVarCnt2].Dim      := 0;
    GVar2[GVarCnt2].ML_type := '';
    
    Exit;
  end;

  Buffer := Strip(UpperCase(TextBuf[i]), ' ');
  if (System.Pos('PRINT(', Buffer) > 0) or (System.Pos('PRINTE(', Buffer) > 0) then
  begin
    Exit;
  end;

  boolPtr := False;

  for j := 1 to _VAR_TYPES2 do
  begin    
    VarPos := System.Pos(UpperCase(VarTypes2[j]) + ' ', UpperCase(TextBuf[i]));
    
    if System.Pos('ARRAY', UpperCase(VarTypes2[j])) > 0 then
    begin
      PrgVar.SB := _SB_ARRAY_SET;
      boolArray := True;
    end
    else if System.Pos(' POINTER ', UpperCase(VarTypes2[j])) > 0 then
    begin
      boolPtr := True;
      boolFirstSpace := True;
      VarPos := System.Pos(UpperCase(VarTypes2[j]), UpperCase(TextBuf[i]));
    end;
    
    if (VarPos > 0) then
    begin
      Buffer := Trim(TextBuf[i]);
      VarType := '';
      VarX := '';
      
      // CARD ARRAY values=[1 2 3 4 5 6 7]
      if (System.Pos(' ARRAY ', UpperCase(Buffer)) > 0)
         and (System.Pos('=', Buffer) > 0) and (System.Pos('[', Buffer) > 0) then
      begin
        Buffer := Extract(Buffer, '=', 1);
        PrgVar.SB := _SB_ARRAY_SET;
      end;
      
      // BYTE ARRAY str1="Text"
      if (System.Pos(' ARRAY ', UpperCase(Buffer)) > 0) and (System.Pos('=', Buffer) > 0)
         and (System.Pos('"', Buffer) > 0) then
      begin
        VarType := StrBetween(Buffer, '"', '"');
        Split(UpperCase(TextBuf[i]), 'ARRAY');
        Split(StrBuf[1], '=');
        
        Inc(GVarCnt2);
        GVar2[GVarCnt2].VarType  := 'T5';
        GVar2[GVarCnt2].ParentType := 'T5';
        GVar2[GVarCnt2].OrigType := 'T5';
        GVar2[GVarCnt2].VarName  := StrBuf[0];
        GVar2[GVarCnt2].Location := 'T5';
        GVar2[GVarCnt2].Value := VarType;
        GVar2[GVarCnt2].ML_type := '';
        GVar2[GVarCnt2].Dim := Length(VarType);
        
        // BYTE ARRAY str1(4)="Text"
        if (System.Pos('(', Buffer) > 0) and (System.Pos(')', Buffer) > 0) then
        begin
          n6 := StrToInt(StrBetween(Buffer, '(', ')'));
          VarType := Extract(StrBuf[0], '(', 1);
          GVar2[GVarCnt2].VarName := VarType;
          GVar2[GVarCnt2].Dim := n6;
        end;
      end
      
      else
      
      begin      
        for n := 1 to Length(Buffer) do
        begin
          CharPos := Copy(Buffer, n, 1);
          VarType := VarType + CharPos;
          
          // ARRAY          
          if not boolPtr then
          begin                     
            if (CharPos = ',') or (n = Length(Buffer)) then
            begin            
              if n = Length(Buffer) then
                VarType := Trim(Copy(VarType, 1, Length(VarType)))
              else
                VarType := Trim(Copy(VarType, 1, Length(VarType)-1));
              
              // Extract variable and its dimension
              n5 := System.Pos('(', VarType);
              if n5 < 1 then
                n4 := 0
              else
              begin
                n4 := StrToInt(StrBetween(VarType, '(', ')'));
                VarType := Extract(VarType, '(', 1);
                PrgVar.SB := _SB_ARRAY;
              end;              
              
              // It is ARRAY set
              n5 := System.Pos('[', TextBuf[i]);
              if n5 > 0 then PrgVar.SB := _SB_ARRAY_SET;
              
              // Set variable parameters
              Inc(GVarCnt2);
              GVar2[GVarCnt2].VarType  := SetType(VarX);
              GVar2[GVarCnt2].ParentType := SetType(VarTypes2[j]);
              GVar2[GVarCnt2].OrigType := SetType(VarTypes2[j]);
              GVar2[GVarCnt2].VarName  := VarType;
              
              if PrgVar.SB = _SB_ARRAY_SET then
                GVar2[GVarCnt2].Location := 'SET'
              else
                GVar2[GVarCnt2].Location := '';
              
              GVar2[GVarCnt2].ML_type := VarX;
              GVar2[GVarCnt2].Value := '';
              GVar2[GVarCnt2].Dim := n4;
              RecPtrVar.ArrayDim := n4;
              VarType := '';      
            end
            else if UpperCase(VarType) = UpperCase(VarTypes2[j]) then
            begin        
              VarX := LowerCase(VarType);
              VarType := '';
            end;            
          end
          //
          else
          //          
          // POINTER
          begin
            if (CharPos = ' ') and boolFirstSpace then
            begin
              boolFirstSpace := False;
              Inc(GVarCnt2);
              GVar2[GVarCnt2].OrigType := SetType(Copy(VarType, 1, Length(VarType)-1));
              VarType := '';
            end;
            
            if (CharPos = ' ') and not boolFirstSpace then
            begin
              GVar2[GVarCnt2].VarType := SetType(Copy(VarType, 1, Length(VarType)-1));
              GVar2[GVarCnt2].ParentType := SetType(Copy(VarType, 1, Length(VarType)-1));
              VarType := '';
            end;
            
            if (n = Length(Buffer)) then
            begin
              if System.Pos(GVar2[GVarCnt2].OrigType, 'T1T2') > 0 then  // BYTE, CHAR            
                VarX := 'byte'
              else if System.Pos(GVar2[GVarCnt2].OrigType, 'T3T4') > 0 then  // INT, CARD
                VarX := 'word'
              else
                VarX := GVar2[GVarCnt2].OrigType;
                                     
              VarType := Trim(Copy(VarType, 1, Length(VarType)));
              GVar2[GVarCnt2].VarName  := VarType;
              GVar2[GVarCnt2].Location := '';
              GVar2[GVarCnt2].Value    := IntToStr(PtrCnt);
              GVar2[GVarCnt2].Dim      := 0;
              GVar2[GVarCnt2].ML_type := VarType;
              Inc(PtrCnt, 2);
              
              Inc(GVarCnt);
              GVar[GVarCnt].VarType  := SetType(VarX);
              GVar[GVarCnt].ParentType := SetType('POINTER');
              GVar[GVarCnt].OrigType := SetType(VarType);
              GVar[GVarCnt].VarName  := VarType + '_ptr';
              GVar[GVarCnt].Location := '';
              GVar[GVarCnt].Value    := '';
              GVar[GVarCnt].Dim      := 0;
              GVar[GVarCnt].ML_type := VarX;
              
              VarType := '';        
            end;
          end;
        end;   
      end;                      
    end;               
  end;
end;

{ Generate MADS ASM source code from ACTION! public and local variables }
procedure sc_Var3(i : LongInt; xType, xVar, xVarType : String);
var
  VarPos, j : LongInt;
  MemAddr, VarType : String;
  EquPos : Byte;
begin
  for j := 1 to _VAR_TYPES do
  begin
    VarPos := System.Pos(UpperCase(VarTypes[j]) + ' ', UpperCase(xType + ' ' + xVar));
    if (VarPos > 0) and VarDeclCheck(UpperCase(xType + ' ' + xVar)) then
    begin
      VarType := xType;
      
      if UpperCase(VarType) = UpperCase(VarTypes[j]) then
      begin
        if (VarType = 'BYTE') or (VarType = 'CHAR') then
          VarType := 'byte'
        else if (VarType = 'INT') or (VarType = 'CARD') then
          VarType := 'word';
      end;
      
      EquPos := System.Pos('=', xVar);
      MemAddr := '';
      
      if EquPos > 0 then 
      begin
        MemAddr := Copy(xVar, EquPos + 1, Length(xVar)-EquPos);
        xVar := Copy(xVar, 1, EquPos - 1);
      end;
      
      if System.Pos(']', xVar) > 0 then
      begin
        xVar := Copy(xVar, 1, Length(xVar) - 1);
        boolType := False;
      end;
      
      if VarType = 'byte' then
        Inc(TypeMemCnt, 1)
      else
        Inc(TypeMemCnt, 2);
      
      Inc(GVarCnt);
      GVar[GVarCnt].VarType    := SetType(VarTypes[j]);  // VarType
      GVar[GVarCnt].ParentType := SetType(xVarType);
      GVar[GVarCnt].OrigType   := SetType(VarTypes[j]);
      GVar[GVarCnt].VarName    := xVar;
      GVar[GVarCnt].Location   := IntToStr(GVarCnt2);
      GVar[GVarCnt].Value      := MemAddr;
      GVar[GVarCnt].Dim        := 0;
      GVar[GVarCnt].ML_type    := VarType;      
            
      Break;
    end;
  end;
  
  if (System.Pos(']', xType + ' ' + xVar) > 0) and boolType then
    boolType := False;
end;

{ Handle ARRAY set variables and values }
procedure sc_Array(i : LongInt);
var
  Buffer : String;
  n : Integer;
begin
  if (System.Pos('[', TextBuf[i]) > 0) then  //and (PrgVar.SB = _SB_NULL) then
  begin
    if System.Pos('ARRAY ', UpperCase(TextBuf[i])) > 0 then
    begin
      PrgVar.SB := _SB_ARRAY_SET;
      ArraySet_start := True;
    end;
  end;

  if ArraySet_start then
  begin   
    // Array elements in [] block
    if (System.Pos('[', TextBuf[i]) > 0) and (System.Pos(']', TextBuf[i]) > 0) then
    begin
      Buffer := StrBetween(TextBuf[i], '[', ']');      
      ArraySet_start := False;
      PrgVar.SB := _SB_NULL;
    end
    // Start of array
    else if System.Pos('[', TextBuf[i]) > 0 then
    begin
      Split(TextBuf[i], '[');
      Buffer := StrBuf[1];
    end
    else
    begin
      // End of array
      Buffer := TextBuf[i];
      if System.Pos(']', Buffer) > 0 then
      begin
        Buffer := Replace(Buffer, ']', ' ');
        ArraySet_start := False;
        PrgVar.SB := _SB_NULL;
      end;  
    end;    
    
    Buffer := Trim(Buffer);    
    Split(Buffer, ' ');
    
    Buffer := '';

    for n := 0 to StrBuf.Count - 1 do
    begin
      if n = 0 then
        Buffer := StrBuf[n]
      else
        Buffer := Buffer + ', ' + StrBuf[n];
    end;

    Buffer := Buffer + ', ';
        
    // Write current array elements
    if StrBuf[0] <> '' then
      GVar2[GVarCnt2].Value := GVar2[GVarCnt2].Value + Buffer;
  end;
end;

{ Public and local variable expression declaration }
procedure sc_VarExpr(i : LongInt);
var
  Str1, Str2, Str3, Str4, VarName, TempBuf, TempBuf2 : String;
  j, k, n, p, n1, n5, r : Integer;
begin
  if Pos('=', TextBuf[i]) < 1 then Exit;
  
  for n := 1 to GVarCnt do
  begin
    Str1 := Strip(TextBuf[i], ' ');
    
    n5 := System.Pos('==', Str1);    
    if n5 > 0 then
    begin
      Str2 := Copy(Str1, n5 + 1, Length(Str1) - (n5 + 2));
      Str1 := Copy(Str1, 1, n5 - 1);
    end
    else if (System.Pos('=-', Str1) > 0) then
    begin      
      str2 := 'M=-' + Extract(Str1, '=-', 2);
      str1 := Extract(Str1, '=-', 1);
    end
    else
    begin
      Split(Str1, '=');
      Str1 := StrBuf[0];
      Str2 := StrBuf[1];
    end;
        
    if (UpperCase(GVar[n].VarName) = UpperCase(Str1)) and FuncCheck(i) and 
       ExprCheck(UpperCase(TextBuf[i])) then
    begin      
      TempBuf := ''; TempBuf2 := '';
      
      for k := 1 to GVarCnt2 do
      begin
        // Handle ARRAY variables
        if System.Pos(UpperCase(GVar2[k].VarName) + '(', UpperCase(Str2)) > 0 then
        begin
          Str2 := Replace(Str2, '(', '[');
          Str2 := Replace(Str2, ')', ']');
          GVar2[k].Value := Str2;
          TempBuf := GVar2[k].VarType;
          TempBuf2 := GVar2[k].VarName;
          break;
        end;
      end;    
            
      (*
      if (System.Pos('==+1', Str2) > 0) then
          //or (System.Pos(UpperCase(GVar[n].VarName + '=' + GVar[n].VarName) + '+1', UpperCase(Str1 + '=' + Str2)) > 0) then
      begin
        if System.Pos(GVar[n].VarType, 'T1T2') > 0 then  // BYTE, CHAR
          CodeBuf.Add(' inc ' + GVar[n].VarName)
        else        
          CodeBuf.Add(' inw ' + GVar[n].VarName);
      end
      else if (System.Pos('==-1', Str2) > 0) then
          //or (System.Pos(UpperCase(GVar[n].VarName + '=' + GVar[n].VarName) + '-1', UpperCase(Str1 + '=' + Str2)) > 0) then
      begin
        if System.Pos(GVar[n].VarType, 'T1T2') > 0 then  // BYTE, CHAR
          CodeBuf.Add(' dec ' + GVar[n].VarName)
        else        
          CodeBuf.Add(' dew ' + GVar[n].VarName);
      end
      *)      
      if (System.Pos('M=-', Str2) > 0) then
      begin
        lMath := True;
        CodeBuf.Add(' mwa #65535 STORE1');
        CodeBuf.Add(' sbw STORE1 ' + GVar[n].VarName);
        CodeBuf.Add(' inw ' + GVar[n].VarName);
      end  
      else
      begin
        if (System.Pos('=+', UpperCase(Str2)) > 0) or (System.Pos('=-', UpperCase(Str2)) > 0) or (System.Pos('=*', UpperCase(Str2)) > 0)
           or(System.Pos('=/', UpperCase(Str2)) > 0) or (System.Pos('=!', UpperCase(Str2)) > 0) or (System.Pos('=XOR', UpperCase(Str2)) > 0)
           or (System.Pos('=LSH', UpperCase(Str2)) > 0) or (System.Pos('=RSH', UpperCase(Str2)) > 0)
           or (System.Pos('=&', UpperCase(Str2)) > 0) or (System.Pos('=%', UpperCase(Str2)) > 0) then
        begin          
          Delete(Str2, 1, 1);
          Str2 := Str1 + Str2;
          MathExpr(GVar[n].VarType, Str1, Str2, 1, n);
        end
        else
        begin          
          if System.Pos('(', TextBuf[i]) > 0 then
          begin
            //j = data(i)
            Str4 := Extract(Str2, '[', 1);
            Str3 := Extract(Str2, '[', 2);
            Str3 := Copy(Str3, 1, Length(Str3) - 1);
            
            if ((Str3[1] > Chr(47)) and (Str3[1] < Chr(58))) or (Str3[1] = '$') then
            begin
              MathExpr(GVar[n].VarType, Str1, Str2, 1, n);
            end
            else
            begin
              if ForFlag then
              begin
                CodeBuf.Add(' ldy array_index_' + TempBuf2);
                
                if System.Pos(TempBuf, 'T5T6') > 0 then  // BYTE/CHAR ARRAY
                //if (UpperCase(TempBuf) = 'BYTE ARRAY') or (UpperCase(TempBuf) = 'CHAR ARRAY') then
                  CodeBuf.Add(' mva ' + Str4 + ',y ' + GVar[n].VarName)
                else
                begin
                  CodeBuf.Add(' mwa ' + Str4 + ',y ' + GVar[n].VarName);
                  CodeBuf.Add(' inc array_index_' + TempBuf2);
                end;
              end;
            end;
          end
          else
          begin
            MathExpr(GVar[n].VarType, Str1, Str2, 1, n);
          end;
        end;
      end;
    end
    //
    // TYPE variable expression
    else if (System.Pos('.' + UpperCase(GVar[n].VarName), UpperCase(Str1)) > 0) and FuncCheck(i) and
      ExprCheck(UpperCase(TextBuf[i])) then
    begin
      if System.Pos('"', TextBuf[i]) > 0 then Exit;
      
      Str2 := AsmStrNum(Str2);
      
      for j := 1 to GVarCnt do
      begin
        if GVar[n].ParentType = GVar[j].OrigType then
        //if UpperCase(GVar[n].ParentType) = UpperCase(GVar[j].OrigType) then
        begin
          if System.Pos(GVar[n].VarType, 'T1T2') > 0 then  // BYTE, CHAR
            CodeBuf.Add(' mva ' + Str2 + ' ' + GVar[j].VarName + '.' + GVar[n].VarName)
          else
            CodeBuf.Add(' mwa ' + Str2 + ' ' + GVar[j].VarName + '.' + GVar[n].VarName);
          
          Exit;
        end;
      end;
    end;    
  end;

  for n := 1 to GVarCnt2 do
  begin
    Str1 := TextBuf[i];
    Split(TextBuf[i], '=');
    Str1 := StrBuf[0];
    Str2 := StrBuf[1];
    VarName := Str1;
    
    if System.Pos(UpperCase(GVar2[n].VarName) + '=@', UpperCase(TextBuf[i])) > 0 then
    begin      
      if FuncCheck(i) and ExprCheck(UpperCase(TextBuf[i])) then
      begin
        for p := 1 to GVarCnt do
        begin
          if System.Pos('@' + UpperCase(GVar[p].VarName), Str2) > 0 then
          begin          
            CodeBuf.Add(' lda #<' + GVar[p].VarName);
            CodeBuf.Add(' sta $c0');
            CodeBuf.Add(' lda #>' + GVar[p].VarName);
            CodeBuf.Add(' sta $c1');            
            CodeBuf.Add('');
            
            if System.Pos(GVar2[n].VarType, 'T10') > 0 then  // POINTER
            //if UpperCase(Trim(GVar2[n].VarType)) = 'POINTER' then
            begin            
              for r := 1 to GVarCnt do
              begin                
                // POINTER
                if (System.Pos(GVar[r].ParentType, 'T10') > 0) and (UpperCase(GVar[r].OrigType) = UpperCase(GVar2[n].VarName)) then
                //if (GVar[r].ParentType = 'POINTER') and (GVar[r].OrigType = GVar2[n].VarName) then
                begin              
                  CodeBuf.Add(' mwa $c0 ' + GVar[r].VarName);
                  CodeBuf.Add('');
                  Break;
                end;
              end;            
            end;
            
            Break;
          end;
        end;
      end;
      
      Exit;
    end
    
    else if System.Pos(UpperCase(GVar2[n].VarName) + '^=', UpperCase(TextBuf[i])) > 0 then
    begin
      if FuncCheck(i) and ExprCheck(UpperCase(TextBuf[i])) then
      begin
        if System.Pos(GVar2[n].VarType, 'T10') > 0 then  // POINTER
        //if UpperCase(Trim(GVar2[n].VarType)) = 'POINTER' then
        begin            
          for r := 1 to GVarCnt do
          begin
            // POINTER
            if (System.Pos(GVar[r].ParentType, 'T10') > 0)
               and (UpperCase(GVar[r].OrigType) = UpperCase(GVar2[n].VarName)) then
            //if (GVar[r].ParentType = 'POINTER') and (GVar[r].OrigType = GVar2[n].VarName) then
            begin              
              CodeBuf.Add(' mwa #' + Str2 + ' ' + GVar[r].VarName);
              CodeBuf.Add(' lda ' + GVar[r].VarName);
              CodeBuf.Add(' ldy #0');
              CodeBuf.Add(' sta ($c0),y');
              Break;
            end;
          end;            
        end;        
      end;
    end
    //
    // Handling TYPE, ARRAY and POINTER variables
    //
    else if System.Pos(UpperCase(GVar2[n].VarName), UpperCase(Str1)) > 0 then
    begin
      // Handling TYPE record ARRAY POINTER variables
      // ENTRY=DATA+(0*SIZE)
      if (System.Pos('(', Str1) < 1) and (System.Pos('.', Str1) < 1)
         and (System.Pos(GVar2[n].VarType, 'T10') > 0) then  // POINTER
      begin
        for j := 1 to GVarCnt2 do
        begin
          if (System.Pos(UpperCase(GVar2[j].VarName), UpperCase(Str2)) > 0)
            and (System.Pos(GVar2[j].OrigType, 'T5T6T7T8') > 0)  // ARRAY
            and (System.Pos(GVar2[n].VarType, 'T10') > 0) then  // POINTER
          begin
            Str3 := Str2;
            k := System.Pos('+', Str3);
            Str4 := Copy(Str3, 1, k-1);
            
            if k > 0 then
            begin
              Str3 := Copy(Str3, k+1, Length(Str3)-k);
              RecPtrVar.Name := GVar2[n].VarName;
              RecPtrVar.Dim := StrToInt(Str3) div TypeMemCnt;
              RecPtrVar.Flag := True;
              
              for n1 := 1 to GVarCnt2 do
              begin
                if UpperCase(GVar2[n1].VarName) = UpperCase(Str4) then
                begin                
                  if not boolXY then
                  begin
                    n5 := (GVar2[n1].Dim div TypeMemCnt) - 1;
                    TypeMemDim := n5;
                    PtrData := GVar2[n].VarName + '_sv';
                    SData[Cnt] := PtrData + ' dta ' + GVar2[n].OrigType + ' [' + IntToStr(n5) + ']';
                    Inc(Cnt);
                    boolXY := True;
                  end;
                                  
                  Break;              
                end;
              end;                        
            end;
          end
        end
      end
      //
      // Handling ARRAY variables
      //
      else if (System.Pos('(', Str1) > 0) and (System.Pos(GVar2[n].VarType, 'T10') < 1) then  // Not POINTER
      begin
        VarName := Replace(VarName, '(', '[');
        VarName := Replace(VarName, ')', ']');
        GVar2[n].Value := VarName;       
        Str3 := Extract(VarName, '[', 2);
        Str3 := Copy(Str3, 1, Length(Str3) - 1);
        
        if ((Str3[1] > Chr(47)) and (Str3[1] < Chr(58))) or (Str3[1] = '$') then
        begin
          if System.Pos('"', Str2) < 1 then
            MathExpr(GVar2[n].VarType, VarName, Str2, 2, n)
          else
          begin
            PrgVar.Pointer := i;
            Str2 := StrBetween(Str2, '"', '"');
            MathExpr(GVar2[n].VarType, VarName, Str2, 3, n);
          end
        end
        else        
        begin
          if ForFlag then
          begin
            CodeBuf.Add(' ldy array_index_' + GVar2[n].VarName);
            
            if System.Pos(GVar2[n].VarType, 'T5T6') > 0 then  // BYTE and CHAR ARRAY
            begin                           
              CodeBuf.Add(' lda ' + AsmStrNum(Str2));
              CodeBuf.Add(' sta ' + GVar2[n].VarName + ',y');
              CodeBuf.Add(' lda #0');
              CodeBuf.Add(' sta ' + GVar2[n].VarName + '+1,y');              
            end
            else
              CodeBuf.Add(' mwa ' + AsmStrNum(Str2) + ' ' + GVar2[n].VarName + ',y');            
          end;        
        end;                
      end
      //
      // Handling TYPE record ARRAY POINTER variables
      //
      else if (System.Pos(UpperCase(GVar2[n].VarName) + '.', UpperCase(Str1)) > 0)
              and (System.Pos(GVar2[n].VarType, 'T10') > 0) then  // POINTER
      begin
        Split(Str1, '.');
        Str3 := AsmStrNum(Str2);
        
        for r := 1 to GVarCnt do
        begin
          if UpperCase(GVar[r].VarName) = UpperCase(StrBuf[1]) then
          begin
            if System.Pos('"', TextBuf[i]) > 0 then Break;
            
            if System.Pos(GVar[r].VarType, 'T1T2') > 0 then  // BYTE, CHAR
              CodeBuf.Add(' mva ' + Str3 + ' ' + PtrData + '[' + IntToStr(RecPtrVar.Dim) + '].' + StrBuf[1])
            else
              CodeBuf.Add(' mwa ' + Str3 + ' ' + PtrData + '[' + IntToStr(RecPtrVar.Dim) + '].' + StrBuf[1]);
            
            Break;
          end;
        end;
      end      
    end;    
  end;
end;

{ Generate MADS ASM source code from ACTION! DEFINE declaration statement }
procedure sc_Define(i : LongInt);
var
  n1 : LongInt;
  Buffer : String;
  StrBufX : TStringList;
begin
  if (System.Pos(UpperCase('DEFINE '), UpperCase(TextBuf[i])) > 0) then
  begin
    Buffer := StrBetween(TextBuf[i], '"', '"');
    if (Buffer <> '') and (System.Pos('DEFINE',UpperCase(Buffer)) > 0) then
      Exit;
    
    Split(Trim(UpperCase(TextBuf[i])), 'DEFINE');
    Buffer := StrBuf[1];
    Split(Buffer, ',');
    
    if StrBuf.Count = 1 then
    begin
      Buffer := Strip(StrBuf[0], ' ');
      Split(Buffer, '=');
      Buffer := StrBetween(StrBuf[1], '"', '"');
      
      if (StrToInt(Buffer) >= 0) and (StrToInt(Buffer) <= 255) then
        CodeBuf.Add(' .var ' + StrBuf[0] + '=' + Buffer + ' .byte')
      else
        CodeBuf.Add(' .var ' + StrBuf[0] + '=' + Buffer + ' .word');
    end
    else
    begin
      StrBufX := TStringList.Create;
      
      for n1 := 0 to StrBuf.Count - 1 do
        StrBufX.Add(StrBuf[n1]);
      
      for n1 := 0 to StrBufX.Count - 1 do
      begin
        Buffer := Strip(StrBufX[n1], ' ');
        Split(Buffer, '="');
        Buffer := Copy(StrBuf[1], 1, Length(StrBuf[1])-1);
        
        if (StrToInt(Buffer) >= 0) and (StrToInt(Buffer) <= 255) then
          CodeBuf.Add(' .var ' + StrBuf[0] + '=' + Buffer + ' .byte')
        else
          CodeBuf.Add(' .var ' + StrBuf[0] + '=' + Buffer + ' .word');
      end;
      
      StrBufX.Free;
    end;
  end;
end;

{ Generate MADS ASM source code from ACTION! INCLUDE directive }
procedure sc_Include(i : LongInt);
var
  n1 : LongInt;
  Temp, Temp2 : String;
begin
  n1 := System.Pos('INCLUDE "', UpperCase(TextBuf[i]));
  if (n1 > 0) then
  begin
    lInclude := True;
    lIncludeX := True;
    Temp := Copy(TextBuf[i], n1+9, Length(TextBuf[i])-(n1+9)-2);
    
    if (System.Pos('\', Temp) < 1) and (System.Pos('/', Temp) < 1) then
    begin
      if ExtractFileDir(meditEff_src_filename) = '' then
        Temp := Copy(TextBuf[i], n1+9, Length(TextBuf[i])-(n1+9)-2)
      else
        Temp := ExtractFileDir(meditEff_src_filename) + '\' + Copy(TextBuf[i], n1+9, Length(TextBuf[i])-(n1+9)-2);
    end;
    
    Inc(Icl);
    //ACT_include[icl] := Lowercase(Temp);        
    Temp2 := StringReplace(ExtractFilename(Temp), '.EFF', '.asm', [rfIgnoreCase]);
    ASM_icl[icl] := Temp;
    WriteLn(fASM, ' icl ' + AnsiQuotedStr(Temp2, ''''));
  end;
end;

{ Create symbol table for MADS source code }
procedure sc_Data;
var
  i : Byte;
begin
  i := 1;
  while SData[i] <> '' do
  begin
    WriteLn(fASM, SData[i]);
    Inc(i);
  end;

  i := 1;
  while word_Data[i] <> '' do
  begin
    WriteLn(fASM, word_Data[i]);
    Inc(i);
  end;
end;

{ Create symbol table for MADS source code }
procedure sc_ML_data;
var
  i : Byte;
begin
  i := 1;
  while ProcML_data[i] <> '' do
  begin
    WriteLn(fASM, ProcML_data[i]);
    WriteLn(fASM, ProcML[i].Code);
    Inc(i);
  end;
end;

function CheckProcML(Proc: String): Boolean;
var
  bFound: Boolean = False;
  k: Integer;
begin  
  for k := 1 to ProcML_cnt do
  begin
    if UpperCase(ProcML[k].Name) = UpperCase(Copy(Proc, 5, Length(Proc) - 4)) then
    begin
      bFound := True;
      Break;
    end;
  end;
  
  result := bFound;            
end;

function GetMLAddress(Proc: String): String;
var
  MLAddr: String = '';
  k: Integer;
begin  
  for k := 1 to ProcML_cnt do
  begin
    if UpperCase(ProcML[k].Name) = UpperCase(Copy(Proc, 5, Length(Proc) - 4)) then
    begin
      MLAddr := ProcML[k].Address;
      Break;
    end;
  end;
  
  result := MLAddr;            
end;
 
{ PROC statements }
procedure sc_ProcTrack(i : LongInt);
var
  n, n1, j : Integer;
  Buffer, param : String;  
  Params : Array[1..21] of String;
  ParamInc : Integer = 0;
begin
  if (System.Pos(UpperCase('PROC '), UpperCase(TextBuf[i])) > 0)
     or (System.Pos(UpperCase('FUNC '), UpperCase(TextBuf[i])) > 0) then
  begin
    Exit;
  end;
    
  for n := 0 to ProcCount do
  begin
    if (System.Pos(UpperCase(Copy(ProcBuf[n], 5, Length(ProcBuf[n])-4)) + '(', UpperCase(TextBuf[i])) > 0) then
    begin
(*  
      if lIncludeX and not lInclude then
      begin
        if (System.Pos(Copy(UpperCase(ProcBuf[n1]), 5, Length(ProcBuf[n1])-4) + '(', UpperCase(TextBuf[i])) > 0) then
          Exit;                      
      end;
*)      

      Split(TextBuf[i], '(');      
      Buffer := Extract(StrBuf[1], ')', 1);
      Split(Buffer, ',');
      
      param := buffer;
      buffer := '';
      
      if StrBuf.Count > 1 then      
      begin    
        for j := 1 to 21 do Params[j] := '';
        
        for j := 0 to StrBuf.Count - 1 do
        begin
          Inc(ParamInc);
          Params[ParamInc] := AsmStrNum(StrBuf[j]);                  
        end;
        
        // Check the parameters and fill appropriate global variables with them depending on the parameter type
                
        for j := 1 to ParamInc do
        begin          
          for n1 := 1 to GVarCnt do
          begin                                
            if UpperCase(GVar[n1].VarName) = UpperCase(Params[j]) then
            begin
              if System.Pos(GVar[n1].VarType, 'T1T2') > 0 then
              begin            
                if CheckProcML(ProcBuf[n]) then
                begin
                  if j = 1 then
                    CodeBuf.Add(' lda ' + Params[j])
                  else
                    CodeBuf.Add(' ldx ' + Params[j]);
                end
                else
                begin          
                  CodeBuf.Add(' mva ' + Params[j] + ' b_param' + IntToStr(j));
                end;
              
                if j = 1 then
                  Buffer := 'b_param1'
                else
                  Buffer := Buffer + ', b_param' + IntToStr(j);
              end
              else
              begin            
                if CheckProcML(ProcBuf[n]) then
                begin
                  if System.Pos('#', Params[j]) > 0 then
                  begin                
                    if j = 1 then
                      CodeBuf.Add(' lda ' + Params[j])
                    else
                      CodeBuf.Add(' ldx ' + Params[j]);
                  end;
                end
                else
                begin          
                  CodeBuf.Add(' mwa ' + Params[j] + ' w_param' + IntToStr(j));
                end;
                                                                                                                   
                if j = 1 then
                  Buffer := 'w_param1'
                else
                  Buffer := Buffer + ', w_param' + IntToStr(j);                  
              end;
            end;
          end;
                                         
          if Pos('#', Params[j]) > 0 then          
          begin
            if StrToInt(Extract(Params[j], '#', 2)) < 256 then
            begin
              if CheckProcML(ProcBuf[n]) then
              begin
                if j = 1 then
                  CodeBuf.Add(' lda ' + Params[j])
                else
                  CodeBuf.Add(' ldx ' + Params[j]);
              end
              else
              begin
                CodeBuf.Add(' mva ' + Params[j] + ' b_param' + IntToStr(j));
              
                if j = 1 then
                  Buffer := 'b_param1'
                else
                  Buffer := Buffer + ', b_param' + IntToStr(j);              
              end;              
            end
            else
            begin
              CodeBuf.Add(' mwa ' + Params[j] + ' w_param' + IntToStr(j));
              
              if j = 1 then
                Buffer := 'w_param1'
              else
                Buffer := Buffer + ', w_param' + IntToStr(j);
            end;              
          end;
        end;
        // End block: Check the parameters and fill appropriate global variables with them depending on the
        // parameter type
        //                
        if CheckProcML(ProcBuf[n]) then
          CodeBuf.Add(' jsr ' + GetMLAddress(ProcBuf[n]))
        else
          CodeBuf.Add(' ' + Copy(ProcBuf[n], 5, Length(ProcBuf[n]) - 4) + ' ' + Buffer);
      end
      //
      else
      //
      begin
        if CheckProcML(ProcBuf[n]) then
        begin
            if (param <> '') then
            begin
              if ((param[1] > Chr(47)) and (param[1] < Chr(58))) or (param[1] = '$') then
              begin         
                CodeBuf.Add(' lda #' + param);
              end;
            end;
            
            CodeBuf.Add(' jsr ' + GetMLAddress(ProcBuf[n]));
        end                        
        else
        begin
          CodeBuf.Add(' ' + Copy(ProcBuf[n], 5, Length(ProcBuf[n]) - 4));
        end;
      end;
      
      if System.Pos('=', TextBuf[i]) > 0 then
      begin
        n1 := System.Pos('=', TextBuf[i]) - 1;
        Buffer := Trim(Copy(TextBuf[i], 1, n1));
            
        if CheckProcML(ProcBuf[n]) then
          CodeBuf.Add(' mwa $A0 STORE1');
                
        CodeBuf.Add(' mwa STORE1 ' + Buffer);
      end;
            
      Break;
    end;
  end;
end;

{ Generate MADS ASM source code from ACTION! WHILE DO statement }
procedure sc_while(i: LongInt);  
begin
  Cond('WHILE', i);
end;

{ Generate MADS ASM source code from ACTION! WHILE - OD clause statement }
procedure sc_od(i : LongInt);
var
  n1, n2 : Byte;
  Buffer : String;
  boolByte : Boolean = True;
begin
  n1 := System.Pos(UpperCase('OD'), UpperCase(TextBuf[i]));
  if (n1 > 0) then 
  begin
    Buffer := Trim(UpperCase(TextBuf[i]));
    if Copy(Buffer, 1, 2) = 'OD' then
    begin
      if WhileFlag then 
      begin
        for n2 := 1 to GVarCnt2 do
        begin
          if System.Pos(GVar2[n2].VarType, 'T5T6T7T8') > 0 then  // ARRAY
          //if System.Pos(' ARRAY', UpperCase(GVar2[n2].VarType)) > 0 then
            if boolArray then CodeBuf.Add(' inc array_index_' + GVar2[n2].VarName);
        end;                           
        //CodeBuf.Add(' mva #' + IntToStr(StrToInt(ForVar2) * 2) + ' array_index');
        CodeBuf.Add(' #end');
        CodeBuf.Add('jump_from_while_' + IntToStr(WhileIndex));
        WhileFlag := False;
      end
      else if ForFlag then 
      begin
        for n1 := 1 to GVarCnt do
        begin
          if UpperCase(ForVar1) = UpperCase(GVar[n1].VarName) then
          begin
            if System.Pos(GVar[n1].VarType, 'T1T2') > 0 then  // BYTE, CHAR
            begin
              for n2 := 1 to StrToInt(ForVar4) do
                CodeBuf.Add(' inc ' + ForVar1);
            end
            else
            begin
              boolByte := False;
              
              for n2 := 1 to StrToInt(ForVar4) do
                CodeBuf.Add(' inw ' + ForVar1);
            end;
            if boolArray then
            begin
              for n2 := 1 to GVarCnt2 do
              begin
                if System.Pos(GVar2[n2].VarType, 'T5T6T7T8') > 0 then  // ARRAY
                  CodeBuf.Add(' inc array_index_' + GVar2[n2].VarName);
              end;              
            end;
            
            Break;
          end;      
        end;      
        
        //if (ForVar1[2] > Chr(47)) and (ForVar1[2] < Chr(58)) then
//          if StrToInt(ForVar1) < 256 then boolByte := True;
        
        if boolByte then
        begin
          CodeBuf.Add(' ldx ' + ForVar1);        
          CodeBuf.Add(' cpx ' + AsmStrNum(ForVar3));
        end
        else
        begin      
          CodeBuf.Add(' lda ' + ForVar1);
          CodeBuf.Add(' cmp STORE3');
          CodeBuf.Add(' lda ' + ForVar1 + '+1');
          CodeBuf.Add(' sbc STORE3+1');
        end;
        
        CodeBuf.Add(' jcc ' + ForLabels[ForCnt]);
        
        // Jump from FOR loop in case there is EXIT statement
        CodeBuf.Add('jump_from_' + ForLabels[ForCnt]);
        
        ForFlag := False;
      end
      else if UntilFlag then
      begin
         CodeBuf.Add('loop_jump' + IntToStr(LoopIndex));
         //CodeBuf.Add('jump_from_until_' + IntToStr(UntilIndex));
         UntilFlag := False;
      end
      else
      begin
        CodeBuf.Add(' ldx #0');
        CodeBuf.Add(' cpx loop_var');
        CodeBuf.Add(' jcc loop' + IntToStr(LoopIndex));
        
        CodeBuf.Add('loop_jump' + IntToStr(LoopIndex))
      end;
    end;
  end;
end;

procedure Cond(Stmt : String; i : LongInt);
var
  n, n1, n2, n3 : Integer;
  IFExpr, Number, Buffer, Buffer2, Oper : String;
begin
  n1 := System.Pos(UpperCase(Stmt) + ' ', UpperCase(TextBuf[i]));
  if (n1 > 0) then
  begin
    if System.Pos('"', TextBuf[i]) > 0 then Exit;
    if Stmt = 'WHILE' then WhileFlag := True;
    
    IFExpr := Trim(LowerCase(TextBuf[i]));
    IFExpr := Copy(IFExpr, Length(Stmt)+2, Length(IFExpr)-Length(Stmt)+1);

    if Stmt = 'IF' then
    begin
      Split(IFExpr, 'then');
      IFExpr := StrBuf[0];
    end;
    
    // Parse IF and WHILE conditional OR and AND expressions
    
    IFExpr := StringReplace(IFExpr,' and ',' .and ', [rfReplaceAll]);
    IFExpr := StringReplace(IFExpr,' or ',' .or ', [rfReplaceAll]);       
    
    IFExpr := Strip(IFExpr, ' ');
    
    if (System.Pos('.and', IFExpr) > 0) then
    begin
      Oper := ' .and';
      Split(IFExpr, '.and');
    end
    else if (System.Pos('.or', IFExpr) > 0) then
    begin
      Oper := ' .or';
      Split(IFExpr, '.or');
    end
    else
    begin
      Oper := '';
      StrBuf.Clear;
      StrBuf.Add('no and or');
    end;          
      
    Buffer := '';
    
    for n3 := 0 to StrBuf.Count - 1 do
    begin
      for n2 := 1 to 20 do
      begin
        if Oper = '' then
        begin
          n := System.Pos(Operators[n2], IFExpr);
          n1 := Length(Operators[n2]);
        
          if n > 0 then
          begin
            Number := Copy(IFExpr, n+n1, Length(IFExpr)-(n+n1)+1);
            Buffer2 := Number;
            Number := AsmStrNum(Number);
            Buffer2 := Copy(IFExpr, 1, Length(IFExpr)-(Length(IFExpr)-(n+n1)+1)-n1);
            IFExpr := Copy(IFExpr, 1, n+n1-1) + Number;
          
            for n1 := 1 to GVarCnt do
            begin
              if LowerCase(GVar[n1].VarName) = LowerCase(Buffer2) then
              begin
                if System.Pos(GVar[n1].VarType, 'T1T2') > 0 then  // BYTE, CHAR
                  Buffer := ' .byte ' + Buffer2 + Operators[n2] + Number
                else
                  Buffer := ' .word ' + Buffer2 + Operators[n2] + Number;
              
                Break;
              end;
            end;          
                   
            Break;
          end;        
        end
        else
        begin
          if System.Pos(Operators[n2], StrBuf[n3]) > 0 then
          begin
            Number := AsmStrNum(Extract(StrBuf[n3], Operators[n2][1], 2));
            Buffer2 := Extract(StrBuf[n3], Operators[n2][1], 1);
          
            for n1 := 1 to GVarCnt do
            begin
              if LowerCase(GVar[n1].VarName) = LowerCase(Buffer2) then
              begin
                if System.Pos(GVar[n1].VarType, 'T1T2') > 0 then  // BYTE, CHAR
                  Buffer := Buffer + ' .byte ' + Buffer2 + Operators[n2] + Number
                else
                  Buffer := Buffer + ' .word ' + Buffer2 + Operators[n2] + Number;
              
                Break;
              end;
            end;
          
            if n3 < StrBuf.Count - 1 then
              Buffer := Buffer + Oper;
          
            Break;
          end;
        end;
      end;
    end;

    if Stmt = 'IF' then
    begin
      CodeBuf.Add(' #if ' + Buffer);      
    end
    else
    begin
      for n2 := 1 to GVarCnt2 do
      begin
        if System.Pos(GVar2[n2].VarType, 'T5T6T7T8') > 0 then  // ARRAY
        //if System.Pos(' ARRAY', UpperCase(GVar2[n2].VarType)) > 0 then
          CodeBuf.Add(' mva #0 array_index_' + GVar2[n2].VarName);
      end;
      
      WhileIndex := i;
      CodeBuf.Add(' #while ' + Buffer);      
      //CodeBuf.Add(' jmp jump_from_while_' + IntToStr(WhileIndex));
    end;
  end;
end;

{ Generate MADS ASM source code from ACTION! IF THEN statement }
procedure sc_if(i: LongInt);
begin
  Cond('IF', i);  
end;

{ Generate MADS ASM source code from ACTION! ELSEIF statement }
procedure sc_elseif(i: LongInt);
begin
  // not implemented yet
end;

{ Generate MADS ASM source code from ACTION! ELSE statement }
procedure sc_else(i : LongInt);
var
  n1 : Byte;
begin
  n1 := System.Pos(UpperCase('ELSE'), UpperCase(TextBuf[i]));
  if (n1 > 0) then
    if System.Pos(UpperCase('"'), UpperCase(TextBuf[i])) < 1 then
      CodeBuf.Add(' #else');
end;

{ Generate MADS ASM source code from ACTION! IF - FI clause statement }
procedure sc_fi(i: LongInt);
var
  Buffer: String;  
begin  
  if (System.Pos(UpperCase('FI'), UpperCase(TextBuf[i])) > 0) then
  begin
    Buffer := Strip(UpperCase(TextBuf[i]), ' ');
    if Copy(Buffer, 1, 2) = 'FI' then
    begin
      CodeBuf.Add(' #end');
    end;
  end;  
end;

{ Generate MADS ASM source code from ACTION! UNTIL condition statement }
procedure sc_until(i: LongInt);
var
  Buffer: String;
  n, n2: Integer;
  bflag: Boolean = false;
begin  
  if (System.Pos(UpperCase('UNTIL '), UpperCase(TextBuf[i])) > 0) then
  begin
    UntilFlag := True;
    Buffer := Extract(UpperCase(TextBuf[i]), 'UNTIL ', 2);    
    
    for n2 := 1 to 20 do
    begin
      n := System.Pos(Operators[n2], Buffer);
      //n1 := Length(Operators[n2]);
        
      if n > 0 then
      begin
        Split(Buffer, Operators[n2]);

        if Operators[n2] = '>' then
        begin
          CodeBuf.Add(' lda ' + AsmStrNum(StrBuf[0]));
          CodeBuf.Add(' ldx ' + AsmStrNum(StrBuf[1]));
          CodeBuf.Add(' inx');
          CodeBuf.Add(' stx STORE1');
          CodeBuf.Add(' cmp STORE1');
          //CodeBuf.Add(' bcs jump_from_until_' + IntToStr(UntilIndex));
          CodeBuf.Add(' bcs loop_jump' + IntToStr(LoopIndex));
        end
        else if Operators[n2] = '<' then
        begin
          CodeBuf.Add(' lda ' + AsmStrNum(StrBuf[0]));
          CodeBuf.Add(' cmp ' + AsmStrNum(StrBuf[1]));
          //CodeBuf.Add(' bcc jump_from_until_' + IntToStr(UntilIndex));
          CodeBuf.Add(' bcc loop_jump' + IntToStr(LoopIndex));
        end
        else
        begin
          CodeBuf.Add(' lda ' + AsmStrNum(StrBuf[0]));
          CodeBuf.Add(' cmp ' + AsmStrNum(StrBuf[1]));
          //CodeBuf.Add(' beq jump_from_until_' + IntToStr(UntilIndex));
          CodeBuf.Add(' beq loop_jump' + IntToStr(LoopIndex));
        end;
                                           
        Break;
      end;        
    end;
     
    for n := 0 to CodeBuf.Count - 1 do
    begin
      if CodeBuf[n] = ' jmp LabelUntil' + IntToStr(UntilIndex) then
      begin
        bFlag := true;
        break;
      end;
    end;
               
    if not bflag then           
      CodeBuf.Add(' jmp LabelUntil' + IntToStr(UntilIndex));
  end;
end;

{ Generate MADS ASM source code from ACTION! comments (;) }
procedure sc_Comments(i : LongInt);
begin
  CodeBuf.Add(Copy(TextBuf[i], 1, Length(TextBuf[i])-Length(LineEnding)));
end;

{ Generate MADS ASM source code from new ACTION! ASM procedure statement }
procedure sc_ASM(i : LongInt);
var
  n1, n2 : LongInt;
begin
  n1 := System.Pos(UpperCase('ASM("'), UpperCase(TextBuf[i]));
  if n1 > 0 then
  begin
    Inc(n1, 5);
    n2 := System.Pos(UpperCase('")'), UpperCase(TextBuf[i]));
    CodeBuf.Add(Copy(TextBuf[i], n1, n2-n1));
  end;
end;

{ 
  Generate MADS ASM source code from ACTION! FOR branch statement
  
  Examples:
    FOR n = 1 to 25600
    FOR i = 0 to 30 STEP 1
}
procedure sc_For(i : LongInt);
var
  n1, n2 : LongInt;
begin
  n1 := System.Pos(UpperCase('FOR '), UpperCase(TextBuf[i]));
  if (n1 > 0) then
  begin
    if System.Pos('"', TextBuf[i]) > 0 then Exit;
  
    ForVar1 := Extract(TextBuf[i], '=', 1);
    ForVar1 := Extract(UpperCase(ForVar1), 'FOR', 2);  // ex Extract3
    ForVar2 := Extract(TextBuf[i], '=', 2);
    Split(UpperCase(ForVar2), 'TO');
    ForVar2 := StrBuf[0];
    ForVar3 := StrBuf[1];
    Split(UpperCase(ForVar3), 'STEP');
    
    if StrBuf.Count <= 1 then
      ForVar4 := '1'
    else
    begin
      ForVar3 := StrBuf[0];
      ForVar4 := StrBuf[1];
    end;

    if (((ForVar3[1] > Chr(47)) and (ForVar3[1] < Chr(58))) or (ForVar3[1] = '$')) then
      ForVar3 := IntToStr(StrToInt(ForVar3)+1)
    else
      CodeBuf.Add(' inc ' + ForVar3);
    
    for n1 := 1 to GVarCnt do
    begin
      if UpperCase(ForVar1) = UpperCase(GVar[n1].VarName) then
      begin
        ForVar := GVar[n1].VarName;
        
        if (((ForVar2[1] > Chr(47)) and (ForVar2[1] < Chr(58))) or (ForVar2[1] = '$')) then
        begin
          if System.Pos(GVar[n1].VarType, 'T1T2') > 0 then  // BYTE, CHAR
            CodeBuf.Add(' mva #' + ForVar2 + ' ' + ForVar1)
          else
            CodeBuf.Add(' mwa #' + ForVar2 + ' ' + ForVar1);
        end
        else
        begin
          if System.Pos(GVar[n1].VarType, 'T1T2') > 0 then  // BYTE, CHAR
            CodeBuf.Add(' mva ' + ForVar2 + ' ' + ForVar1)
          else
            CodeBuf.Add(' mwa ' + ForVar2 + ' ' + ForVar1);
        end;
        
        if boolArray then
        begin
          if (((ForVar2[1] > Chr(47)) and (ForVar2[1] < Chr(58))) or (ForVar2[1] = '$')) then
          begin
            for n2 := 1 to GVarCnt2 do
            begin
              if System.Pos(GVar2[n2].VarType, 'T5T6T7T8') > 0 then  // ARRAY
              //if System.Pos(' ARRAY', UpperCase(GVar2[n2].VarType)) > 0 then
                CodeBuf.Add(' mva #' + IntToStr(StrToInt(ForVar2) * 2) + ' array_index_' + GVar2[n2].VarName);
            end;
          end;
        end;            
        
        ForFlag := True;
        Inc(ForCnt);
        ForLabels[ForCnt] := 'for_loop' + IntToStr(ForCnt);
                
        if System.Pos(GVar[n1].VarType, 'T3T4') > 0 then                
          CodeBuf.Add(' mwa ' + AsmStrNum(ForVar3) + ' STORE3');
            
        CodeBuf.Add(ForLabels[ForCnt]);
        
        Break;
      end;
    end;
  end;
end;

{ Parse and compile Action! commands }
procedure GenLoop(Flag : Boolean);
var
  i : LongInt;    
begin
  for i := 1 to CR_LF do
  begin  
    CurLine := i;

    //Remarks := Extract(TextBuf[i], ';', 2);
    if System.Pos(';', TextBuf[i]) > 0 then
    begin
      CodeBuf.Add('; ' + Extract(TextBuf[i], ';', 2));
      TextBuf[i] := Extract(TextBuf[i], ';', 1);
    end;

    // Check for comments - ; as first character on the line
    if Copy(Trim(TextBuf[i]), 1, 1) = ';' then
    begin
      sc_Comments(i);
      Continue;
    end;
        
    sc_Proc(i);
    sc_Return(i);
    
    // Parse machine code opcodes
    sc_ML(i);

    // Action! statements, assignments, directives
    sc_VarExpr(i);
    sc_ProcTrack(i);
    sc_while(i);
    sc_until(i);
    sc_for(i);
    sc_od(i);
    sc_do(i);
    sc_if(i);
    sc_fi(i);
    sc_else(i);
    sc_Exit(i);

    sc_Print(True, i);
    sc_Print(False, i);
    sc_PrintF(i);
    sc_Color(i);
    sc_Device(i);
    sc_Locate(i);
    sc_Command(i, 'Graphics', '1');
    sc_Command(i, 'Poke', '01');
    sc_Command(i, 'PokeC', '01');
    sc_Command(i, 'Position', '11');
    sc_Command(i, 'Plot', '11');
    sc_Command(i, 'DrawTo', '11');
    sc_Command(i, 'Fill', '1111');
    sc_Command(i, 'SetColor', '111');
    sc_Command(i, 'Sound', '1111');
    
    sc_Command(i, 'SetBlock', '011');
    sc_Command(i, 'Zero', '01');
    sc_Command(i, 'MoveBlock', '001');

    sc_XIO(i);
        
    sc_Command(i, 'Put', '1');
    sc_PutE(i);
    sc_PrintX(i, 'PrintB', False);
    sc_PrintX(i, 'PrintBE', True);
    sc_PrintX(i, 'PrintI', False);
    sc_PrintX(i, 'PrintIE', True);
    sc_PrintX(i, 'PrintC', False);
    sc_PrintX(i, 'PrintCE', True);

    sc_InputS(i);
    sc_SCopy(i);
    sc_SCopyS(i);
    sc_SAssign(i);
    sc_StrNum('StrB', i);
    sc_StrNum('StrC', i);
    sc_StrNum('StrI', i);

    sc_Open(i);
    sc_Close(i);
    sc_PrintDX(True, i);
    sc_PrintDX(False, i);
    sc_PutDX('PutD', i);
    sc_PutDX('PutDE', i);
    sc_Point(i);
    sc_Note(i);
    sc_GetD(i);
    sc_InputSD(i);
    sc_PrintXD(i, 'PrintBD', False);
    sc_PrintXD(i, 'PrintBDE', True);
    sc_PrintXD(i, 'PrintID', False);
    sc_PrintXD(i, 'PrintIDE', True);
    sc_PrintXD(i, 'PrintCD', False);
    sc_PrintXD(i, 'PrintCDE', True);

    sc_SndRst(i);
    
    sc_Func1(i, 'Peek', '0');
    sc_Func1(i, 'PeekC', '0');
    sc_Func1(i, 'Stick', '1');
    sc_Func1(i, 'Strig', '1');
    sc_Func1(i, 'Paddle', '1');
    sc_Func1(i, 'Ptrig', '1');
    sc_Func1(i, 'Rand', '1');

    sc_Func2(i, 'ValB', '1');
    sc_Func2(i, 'ValI', '1');
    sc_Func2(i, 'ValC', '1');

    sc_ASM(i);

    if TextBuf[i] = LineEnding then CodeBuf.Add('');    
  end;
end;

{ Check the type of the loop and initializes all necessary variables }
procedure sc_do(i: LongInt);
var
  Buffer: String;
begin
  if System.Pos('DO', UpperCase(TextBuf[i])) > 0 then 
  begin
    Buffer := Strip(UpperCase(TextBuf[i]), ' ');
    if (Copy(Buffer, 1, 2) = 'DO') and not ForFlag and not WhileFlag and not UntilFlag then
    begin
      CodeBuf.Add(' mva #10 loop_var');
      LoopIndex := i;
      CodeBuf.Add('loop' + IntToStr(LoopIndex));
      UntilIndex := i;
      CodeBuf.Add('LabelUntil' + IntToStr(UntilIndex));
    end;
  end;
end;

{ Generate MADS ASM source code from ACTION! EXIT command }
procedure sc_Exit(i : LongInt);
var
  Buffer : String;
begin
  if System.Pos('EXIT', UpperCase(TextBuf[i])) > 0 then
  begin
    Buffer := Strip(UpperCase(TextBuf[i]), ' ');
    
    if (Copy(Buffer, 1, 4) = 'EXIT') then
    begin
      if ForFlag then
        CodeBuf.Add(' jmp jump_from_' + ForLabels[ForCnt])
      else if WhileFlag then
        CodeBuf.Add(' jmp jump_from_while_' + IntToStr(WhileIndex))
//      else if UntilFlag then
//        CodeBuf.Add(' jmp jump_from_until_' + IntToStr(UntilIndex))
      else
        CodeBuf.Add(' jmp loop_jump' + IntToStr(LoopIndex));
    end;
  end;
end;

{ Check for PROC or FUNC block consisting of machine language mnemonics }
procedure sc_ML(i : LongInt);
var
  Buffer : String;
  n : Integer;
begin
  // PROC / FUNC machine code call
  if ProcML_start then
  begin
    // Machine code in [] block
    if (System.Pos('[', TextBuf[i]) > 0) and (System.Pos(']', TextBuf[i]) > 0) then
    begin
      Buffer := StrBetween(TextBuf[i], '[', ']');      
      ProcML_start := False;
      PrgVar.SB := _SB_NULL;
    end
    // Start of machine code
    else if System.Pos('[', TextBuf[i]) > 0 then
    begin
      Split(TextBuf[i], '[');
      Buffer := StrBuf[1];
    end
    else
    begin
      // End of machine code
      Buffer := TextBuf[i];
      
      if System.Pos(']', Buffer) > 0 then
      begin
        Buffer := Replace(Buffer, ']', ' ');
        ProcML_start := False;
        PrgVar.SB := _SB_NULL;
      end;              
    end;
    
    Buffer := Trim(Buffer);    
    Split(Buffer, ' ');
        
    // Machine code opcodes without spaces (just opcodes supperceded with $)
    if StrBuf.Count <= 1 then
    begin
      Split(Buffer, '$');
      Buffer := '';
      
      for n := 0 to StrBuf.Count - 1 do
      begin      
        if Length(StrBuf[n]) > 2 then
          StrBuf[n] := Copy(StrBuf[n], 3, 2) + ' ' + Copy(StrBuf[n], 1, 2);
               
        Inc(MemCnt, Length(StrBuf[n]) div 2);        
        Buffer := Buffer + ' ' + StrBuf[n];
      end;
    end
    //
    else
    //
    // Machine code opcodes separated with spaces (decimal and hexadecimal format allowed)
    //
    begin
      Buffer := '';
      
      for n := 0 to StrBuf.Count - 1 do
      begin
        if Pos('$', StrBuf[n]) < 1 then
          StrBuf[n] := Dec2Numb(StrToInt(StrBuf[n]), 4, 16);                
        
        StrBuf[n] := Trim(Replace(StrBuf[n], '$', ' '));                        
        
        if Length(StrBuf[n]) > 2 then
          StrBuf[n] := Copy(StrBuf[n], 3, 2) + ' ' + Copy(StrBuf[n], 1, 2);
        
        Inc(MemCnt, Length(StrBuf[n]) div 2);
        Buffer := Buffer + ' ' + StrBuf[n];                
      end;
    end;       
    
    // Write current machine code
    ProcML[ProcML_cnt].Code := ProcML[ProcML_cnt].Code + Buffer;       
    
    // Write machine code memory address
    if not ProcML_start then
    begin
      Buffer := Dec2Numb(CntML, 4, 16);
      ProcML[ProcML_cnt].Address := '$' + Buffer;
      ProcML_data[ProcML_cnt] := ' org $' + Buffer;
      CntML := 0;
    end;        
  end
  //
  // Machine code elsewhere in the program
  //
  else if (System.Pos('[', TextBuf[i]) > 0) then
  begin
    for n := 1 to _VAR_TYPES do
      if System.Pos(VarTypes[n], UpperCase(TextBuf[i])) > 0 then
    //if (System.Pos('ARRAY ', UpperCase(TextBuf[i])) < 1) and (System.Pos('TYPE ', UpperCase(TextBuf[i])) < 1) then
    begin
      ML_start := False;      
      Exit;
    end;
    
    for n := 1 to _VAR_TYPES2 do
      if System.Pos(VarTypes2[n], UpperCase(TextBuf[i])) > 0 then
    begin
      ML_start := False;      
      Exit;
    end;    
    
    ML_start := True;
    CntML := MemCnt;
    Inc(ProcML_cnt);
    PrgVar.SB := _SB_ML;
    ProcML[ProcML_cnt].Code := ' .he';    
  end;

  if ML_start then
  begin
    if (System.Pos('[', TextBuf[i]) > 0) and (System.Pos(']', TextBuf[i]) > 0) then
    begin
      Buffer := StrBetween(TextBuf[i], '[', ']');
      PrgVar.SB := _SB_NULL;
      ML_start := False;
    end
    else if System.Pos('[', TextBuf[i]) > 0 then
    begin
      Split(TextBuf[i], '[');
      Buffer := StrBuf[1];
    end
    else
    begin      
      Buffer := TextBuf[i];
      if System.Pos(']', Buffer) > 0 then
      begin
        Buffer := Replace(Buffer, ']', ' ');
        ML_start := False;
        PrgVar.SB := _SB_NULL;
      end;  
    end;      
    
    Buffer := Trim(Buffer);    
    Split(Buffer, ' ');        
    
    if StrBuf.Count <= 1 then
    begin
      Split(Buffer, '$');
      Buffer := '';
      for n := 0 to StrBuf.Count - 1 do
      begin      
        if Length(StrBuf[n]) > 2 then
          StrBuf[n] := Copy(StrBuf[n], 3, 2) + ' ' + Copy(StrBuf[n], 1, 2);
                
        Inc(MemCnt, Length(StrBuf[n]) div 2);
        
        Buffer := Buffer + ' ' + StrBuf[n];
      end;
    end
    
    else
    
    begin    
      Buffer := '';
      
      for n := 0 to StrBuf.Count - 1 do
      begin
        if Pos('$', StrBuf[n]) < 1 then
          StrBuf[n] := Dec2Numb(StrToInt(StrBuf[n]), 4, 16);      
        
        StrBuf[n] := Trim(Replace(StrBuf[n], '$', ' '));
        
        if Length(StrBuf[n]) > 2 then
          StrBuf[n] := Copy(StrBuf[n], 3, 2) + ' ' + Copy(StrBuf[n], 1, 2);
        
        Inc(MemCnt, Length(StrBuf[n]) div 2);
        
        Buffer := Buffer + ' ' + StrBuf[n];        
      end;
    end;
    
    ProcML[ProcML_cnt].Code := ProcML[ProcML_cnt].Code + Buffer;
    
    if not ML_start then
    begin
      Buffer := Dec2Numb(CntML, 4, 16);
      ProcML[ProcML_cnt].Address := '$' + Buffer;
      ProcML_data[ProcML_cnt] := ' org $' + Buffer;
      CntML := 0;
      CodeBuf.Add(' jsr ' + ProcML[ProcML_cnt].Address);            
    end;
  end;
end;

end.
