{ 
  Program    : Effectus - Atari MADS cross-assembler/parser for Action! language
  Version    : 0.0.16

  Unit file  : routines.pas
  Description: Library of build-in Action! procedures and routines
  
  Author: Bostjan Gorisek, Slovenia
  
  Program compiled with Free Pascal 2.6.0
  Reference: http://www.freepascal.org/
  
  This is cource code generator for MADS Assembler, which then generates
  executable files from parser of Action! language for 8-bit Atari home
  computers
  References:
  http://mads.atari8.info/
  http://gury.atari8.info/effectus/ 
  
  This is open source and freeware project!  
}
unit Routines;
{$ifdef FPC}{$mode objfpc}{$h+}{$endif}

interface

uses
 SySutils, Classes, StrUtils, INIfiles,
 Decl, Core, Common;

procedure sc_Print(boolCR: Boolean; i: LongInt); 
procedure sc_Color(i: LongInt);
procedure sc_Device(i: LongInt);
procedure sc_Command(i: LongInt; CmdName, Flag : String);
procedure sc_PutE(i: LongInt);
procedure sc_PrintX(i: LongInt; Proc: String; lEnter: Boolean);
procedure sc_SndRst(i: LongInt);
procedure sc_Func1(i: LongInt; Proc: String; Flag : String);
procedure sc_Func2(i: LongInt; Proc: String; Flag : String);
procedure sc_InputS(i: LongInt);
procedure sc_SCopy(i: LongInt);
procedure sc_SCopyS(i: LongInt);
procedure sc_SAssign(i: LongInt);
procedure sc_XIO(i: LongInt);
procedure sc_Open(i: LongInt);
procedure sc_Close(i: LongInt);
procedure sc_PrintDX(boolCR: Boolean; i: LongInt);
procedure sc_PutDX(Proc: String; i: LongInt);
procedure sc_PrintXD(i: LongInt; Proc: String; lEnter: Boolean);
procedure sc_InputSD(i: LongInt);
procedure sc_Point(i: LongInt);
procedure sc_Note(i: LongInt);
procedure sc_GetD(i: LongInt);
procedure sc_Locate(i: LongInt);
procedure sc_StrNum(Proc: String; i: LongInt);
function GetParams(StrBufX : String; lNum, lConv : Boolean; ParamTypes : String): Integer;
procedure sc_PrintF(i: LongInt);

implementation

{ Generate MADS ASM source code from ACTION! PrintE procedure statement }
procedure sc_Print(boolCR : Boolean; i : LongInt);
var
  n, n1, n4 : LongInt;
  Text_ASM, TextX, Proc : String;
begin
  TextX := Strip(TextBuf[i], ' ');
  
  if boolCR then
    Proc := 'PRINTE'
  else
    Proc := 'PRINT';    
  
  if (System.Pos(UpperCase(Proc + '("'), UpperCase(TextX)) > 0) then
  begin    
    if System.Pos(UpperCase(Proc) + '("")', UpperCase(TextBuf[i])) > 0 then
    begin
      if boolCr then
        CodeBuf.Add(' PutE');
    end
    else
    begin
      Text_ASM := StrBetween(TextBuf[i], '"', '"');
      CodeBuf.Add(' jsr printf');
      
      if boolCR then
        CodeBuf.Add(' dta c' + QuotedStr(Text_ASM) + ',$9b,0')
      else
        CodeBuf.Add(' dta c' + QuotedStr(Text_ASM) + ',0');
    end;
  end
  //
  else
  //
  { String variable as parameter }
  if (System.Pos(UpperCase(Proc + '('), UpperCase(TextX)) > 0) then
  begin
    Text_ASM := StrBetween(TextBuf[i], '(', ')');
    CodeBuf.Add(' jsr printf');
    
    if cnt_InputS > 0 then
    begin      
      n := 1;
      
      for n1 := 1 to cnt_InputS do
      begin
        if System.Pos(Text_ASM + '_', InputS_buf[n1]) < 1 then
          Continue
        else
          n := n1;
        
        if InputS_buf[n1] = '' then Break;
      end;
      
      if (n = 1) and (InputS_buf[n] = '') then
      begin
        Exit;
      end;
          
      if bool_InputS[n] then
      begin
        n4 := System.Pos('_array_', InputS_buf[n]);
        
        //if System.Pos('_array_', InputS_buf[n]) > 0 then
        if n4 > 0 then
        begin
          if boolCR then
            TextX := '_' + Text_ASM + '_' + Copy(InputS_buf[n], n4 + 7, Length(InputS_buf[n]) - (n4 + 7) + 2)
          else
            TextX := '_' + Text_ASM + '_' + Copy(InputS_buf[n], n4 + 6, Length(InputS_buf[n]) - (n4 + 6) + 2);
        end;
        
        if boolCR then
          CodeBuf.Add(TextX + ' .by ' + AnsiQuotedStr(' ', '''') + ' $9b 0')
        else
          CodeBuf.Add(TextX + ' .by ' + AnsiQuotedStr(' ', '''') + ' 0');
        
        CodeBuf.Add(' .wo ' + InputS_buf[n]);
        bool_InputS[n] := False;
      end
      else
      begin
        if boolCR then
          CodeBuf.Add(' dta ' + AnsiQuotedStr('#', '''') + ',$9b,0')
        else
          CodeBuf.Add(' dta ' + AnsiQuotedStr('#', '''') + ',0');
        
        CodeBuf.Add(' dta a(' + InputS_buf[n] + ')');
      end;
    end
    else
    begin
      if boolCR then
        CodeBuf.Add(' dta ' + AnsiQuotedStr('#', '''') + ',$9b,0')
      else
        CodeBuf.Add(' dta ' + AnsiQuotedStr('#', '''') + ',0');
      
      // Handle ARRAY variables
      for n1 := 1 to GVarCnt2 do
      begin        
        if System.Pos(UpperCase(GVar2[n1].VarName) + '(', UpperCase(Text_ASM)) > 0 then
        begin
          TextX := Extract(Text_ASM, '(', 2);
          Text_ASM := GVar2[n1].VarName + '_array_str_' + TextX;
          Break;
        end;
      end;
      
      CodeBuf.Add(' dta a(' + Text_ASM + ')');
    end;    
  end;
end;

{ Generate MADS ASM source code from ACTION! PutE procedure statement }
procedure sc_PutE(i : LongInt);
var
  Buffer : String;
begin
  Buffer := Trim(TextBuf[i]);
  
  if (System.Pos(UpperCase('PutE()'), UpperCase(Buffer)) > 0) then  
    CodeBuf.Add(' PutE');
end;

(*
{ Generate MADS ASM source code from ACTION! Graphics procedure statement }
procedure sc_Graphics(i : LongInt);
var
  Buffer1, Buffer2, Buffer3 : String;
begin
  Buffer1 := Strip(TextBuf[i], ' ');

  if System.Pos(UpperCase('Graphics('), UpperCase(Buffer1)) > 0 then
  begin
    Buffer1 := TextBuf[i];
    Buffer2 := StrBetween(Buffer1, '(', ')');
    Buffer3 := AsmStrNum(Trim(Buffer2));
    CodeBuf.Add(' Graphics ' + Buffer3 + Comments(Buffer1, Buffer2));
  end;
end;
*)

{ Generate MADS ASM source code from ACTION! Color variable statement }
{ BYTE color }
procedure sc_Color(i : LongInt);
var
  mParams, Buffer : String;
begin
  Buffer := Strip(TextBuf[i], ' ');

  if System.Pos(UpperCase('Color='), UpperCase(Buffer)) > 0 then
  begin
    Buffer := Trim(TextBuf[i]);
    mParams := Extract(Buffer, '=', 2);    
    CodeBuf.Add(' Color ' + AsmStrNum(mParams));
  end;
end;

{ Generate MADS ASM source code from ACTION! device variable statement }
{ BYTE device }
procedure sc_Device(i : LongInt);
var
  mParams, Buffer : String;
begin
  Buffer := Strip(TextBuf[i], ' ');

  if System.Pos(UpperCase('Device='), UpperCase(Buffer)) > 0 then
  begin
    Buffer := Trim(TextBuf[i]);
    mParams := Extract(Buffer, '=', 2);    
    CodeBuf.Add(' Device ' + AsmStrNum(mParams));
  end;
end;

{ General ACTION! to MADS source code command statement generation }
procedure sc_Command(i : LongInt; CmdName, Flag : String);
var
  n, n1, Cntxx : LongInt;
  Proc, mParams, Buffer : String;
begin
  Buffer := Strip(TextBuf[i], ' ');
  Proc := CmdName;

  n1 := System.Pos(UpperCase(Proc + '('), UpperCase(Buffer));
  if (n1 > 0) then
  begin    
    Buffer := TextBuf[i];
    
    (*
    for n := 0 to 10 do
    begin
      if Copy(Flag, n+1, 1) = '1' then
        lBoolFlag[n] := True
      else
        lBoolFlag[n] := False;
    end;
    *)
    
    Cntxx := GetParams(Buffer, True, False, Flag);
    mParams := mValues[0];
    
    for n := 1 to Cntxx do
      mParams := mParams + ', ' + mValues[n];
    
    CodeBuf.Add(' ' + Proc + ' ' + mParams);
  end;    
end;

{ Generate MADS ASM source code from ACTION! morphic Print procedure statement }
procedure sc_PrintX(i : LongInt; Proc : String; lEnter : Boolean);
var
  n, n1, n2, n3, p : LongInt;
  mValue, mValue2, mValue3, mLabel, VarIndex, Buffer : String;

procedure dta;
begin
  if lEnter then
    CodeBuf.Add(' dta c' + QuotedStr('%') + ',$9b,0')
  else
    CodeBuf.Add(' dta c' + QuotedStr('%') + ',0');

  if ((mValue3[1] > Chr(47)) and (mValue[1] < Chr(58))) or (mValue3[1] = '$') then
  begin
    CodeBuf.Add(' dta a(' + mLabel + ')');
    SData[Cnt] := mLabel + ' dta a(' + mValue3;
    Inc(Cnt);
  end
  else
  begin
    CodeBuf.Add(' dta a(' + mValue);
  end;
end;
  
// PrintCE(2000)
// PrintCE(data(i))

begin
  Buffer := Strip(TextBuf[i], ' ');

  n1 := System.Pos(UpperCase(Proc + '('), UpperCase(Buffer));
  if (n1 > 0) then
  begin
    n2 := System.Pos(')', Buffer);
    mLabel := '_' + Proc + '_' + IntToStr(i) + '_' + IntToStr(n1);
    n3 := Length(Proc) + 1;
    
    mValue := Copy(Buffer, n1+n3, n2-(n1+n3)+1);
    mValue3 := mValue;
     
    for n := 1 to GVarCnt2 do
    begin
      if Pos(UpperCase(GVar2[n].VarName), UpperCase(mValue)) > 0 then
      begin        
        mValue2 := Extract(mValue, '(', 1);      
        VarIndex := StrBetween(mValue, '(', ')');
        mValue := Replace(mValue, '(', '[');
        mValue := Replace(mValue, ')', ']');
        mValue := mValue + ')';
        
        if boolArray and ((ForFlag and (ForVar = varIndex)) or WhileFlag or UntilFlag) 
           and (UpperCase(GVar2[n].VarName) = UpperCase(mValue2)) then
        begin
          if System.Pos(GVar2[n].VarType, 'T7T8') > 0 then
          begin        
            CodeBuf.Add(' ldy array_index_' + GVar2[n].VarName);
            CodeBuf.Add(' lda ' + GVar2[n].VarName + ',y');
            CodeBuf.Add(' sta array_buffer_' + GVar2[n].VarName);
            CodeBuf.Add(' inc array_index_' + GVar2[n].VarName);
            CodeBuf.Add(' ldy array_index_' + GVar2[n].VarName);
            CodeBuf.Add(' lda ' + GVar2[n].VarName + ',y');
            CodeBuf.Add(' sta array_buffer_' + GVar2[n].VarName + '+1');
          end
          else
          begin
            CodeBuf.Add(' ldy array_index_' + GVar2[n].VarName);
            CodeBuf.Add(' lda ' + GVar2[n].VarName + ',y');
            CodeBuf.Add(' sta array_buffer_' + GVar2[n].VarName);
          end;
        end;
                       
        //if boolArray and ForFlag and (UpperCase(GVar2[n].VarName) = UpperCase(mValue2))
        //   and (ForVar = varIndex)then
        if boolArray and ((ForFlag and (ForVar = varIndex)) or WhileFlag or UntilFlag) 
           and (UpperCase(GVar2[n].VarName) = UpperCase(mValue2)) then
        begin
          CodeBuf.Add(' jsr printf');
          
          if lEnter then      
            CodeBuf.Add(' dta c''%''' + ',$9b,0')
          else
            CodeBuf.Add(' dta c''%''' + ',0');
           
          CodeBuf.Add(' dta a(array_buffer_' + GVar2[n].VarName +')');
        end
        
        else
        
        begin
          if System.Pos(GVar2[n].VarType, 'T10') > 0 then  // POINTER
          //if GVar2[n].VarType = 'POINTER' then
          begin
            if System.Pos(UpperCase(GVar2[n].VarName) + '.', UpperCase(mValue)) > 0 then
            begin
              VarIndex := Extract(mValue3, '.', 2);
              VarIndex := Copy(VarIndex, 1, Length(VarIndex)-1);
                           
              for p := 1 to GVarCnt do
              begin
                if UpperCase(GVar[p].VarName) = UpperCase(VarIndex) then
                begin
                  if System.Pos(GVar[p].VarType, 'T1T2') > 0 then  // BYTE, CHAR
                    CodeBuf.Add(' mva ' + PtrData + '[' + IntToStr(RecPtrVar.Dim) + '].' + VarIndex + ' struct_ptr_var')
                  else
                    CodeBuf.Add(' mwa ' + PtrData + '[' + IntToStr(RecPtrVar.Dim) + '].' + VarIndex + ' struct_ptr_var');
                  
                  Break;
                end;
              end;
              
              if lGr then
                CodeBuf.Add(' jsr printf')
              else
                CodeBuf.Add(' jsr printf');
                                      
              if lEnter then
                CodeBuf.Add(' dta c''%''' + ',$9b,0')
              else
                CodeBuf.Add(' dta c''%''' + ',0');
                
              CodeBuf.Add(' dta a(struct_ptr_var)'); 
            end
            else
            begin
              CodeBuf.Add(' jsr printf');
              
              if lEnter then                      
                CodeBuf.Add(' dta c''%''' + ',$9b,0')
              else
                CodeBuf.Add(' dta c''%''' + ',0');
                           
              for p := 1 to GVarCnt do
              begin
                if (System.Pos(GVar[p].ParentType, 'T10') > 0)
                   and (UpperCase(GVar[p].OrigType) = UpperCase(GVar2[n].VarName)) then
                //if (GVar[p].ParentType = 'POINTER') and (GVar[p].OrigType = GVar2[n].VarName) then
                begin
                  CodeBuf.Add(' dta a(' + GVar[p].VarName + ')');
                  Break;
                end;
              end;   
            end;            
          end
          else
          begin                 
            CodeBuf.Add(' jsr printf');
            dta;
          end;
        end;

        exit;
      end;      
    end;
    
    CodeBuf.Add(' jsr printf');
    dta;
  end;
end;

{ Generate MADS ASM source code from ACTION! SndRst procedure statement }
procedure sc_SndRst(i : LongInt);
var
  Proc, Buffer : String;
begin
  Buffer := Strip(TextBuf[i], ' ');
  Proc := 'SndRst';

  if (System.Pos(UpperCase(Proc + '('), UpperCase(Buffer)) > 0) then
    CodeBuf.Add(' ' + Proc);
end;

procedure sc_Func1(i : LongInt; Proc : String; Flag : String);
var
  n1, n2 : LongInt;
  Str1, Str2 : String;
  Buffer : String;
begin
  Buffer := Strip(TextBuf[i], ' ');

  n1 := System.Pos(UpperCase(Proc + '('), UpperCase(Buffer));
  if (n1 > 0) then
  begin
    Buffer := Trim(TextBuf[i]);    
    GetParams(Buffer, False, False, Flag);
    Split(Buffer, '=');
    Str1 := StrBuf[0];
    Str2 := StrBuf[1];
    
    for n2 := 1 to GVarCnt do
    begin
      if System.Pos(UpperCase(GVar[n2].VarName) + '=', UpperCase(Str1 + '=' + Str2)) > 0 then
      begin
        CodeBuf.Add(' ' + Proc + ' ' + mValues[0]);
        
        if System.Pos(GVar[n2].VarType, 'T1T2') > 0 then  // BYTE, CHAR
          CodeBuf.Add(' mva STORE1 ' + Str1)
        else
          CodeBuf.Add(' mwa STORE1 ' + Str1);
        
        Break;
      end;
    end;
  end;
end;

procedure sc_Func2(i : LongInt; Proc : String; Flag : String);
var
  n1, n2 : LongInt;
  mLabel, Str1 : String;
  Buffer : String;
begin
  Buffer := Strip(TextBuf[i], ' ');

  n1 := System.Pos(UpperCase(Proc + '('), UpperCase(Buffer));
  if (n1 > 0) then
  begin
    //lBoolFlag[0] := lBoolX;    
    GetParams(Buffer, True, True, Flag);
    Split(Buffer, '=');
    Str1 := StrBuf[0];

    for n2 := 1 to GVarCnt do
    begin
      if System.Pos(UpperCase(GVar[n2].VarName) + '=', UpperCase(Buffer)) > 0 then
      begin
        mLabel := '_' + Proc + '_' + IntToStr(i) + '_' + IntToStr(n1);
        SData[Cnt] := mLabel + ' dta a(' + mValues[0] + ')';
        Inc(Cnt);
        
        if UpperCase(Proc) = 'VALB' then
          CodeBuf.Add(' mva ' + mLabel + ' STORE1')
        else
          CodeBuf.Add(' mwa ' + mLabel + ' STORE1');
        
        if System.Pos(GVar[n2].VarType, 'T1T2') > 0 then  // BYTE, CHAR
          CodeBuf.Add(' mva STORE1 ' + Str1)
        else
          CodeBuf.Add(' mwa STORE1 ' + Str1);
        
        Break;        
      end;
    end;
  end;
end;

{ String routines }

{ Generate MADS ASM source code from ACTION! InputS procedure statement }
// InputS(name_str)
procedure sc_InputS(i : LongInt);
var
  Buffer, Proc : String;
begin
  Buffer := Strip(TextBuf[i], ' ');
  Proc := 'InputS';

  if System.Pos(UpperCase(Proc + '('), UpperCase(Buffer)) > 0 then
  begin
    Buffer := StrBetween(TextBuf[i], '(', ')');
    CodeBuf.Add(' getline #' + Trim(Buffer));
  end;  
end;

{ Generate MADS ASM source code from ACTION! SCopy procedure statement }
{ PROC SCopy(targetString, sourceString) }
{ 
SCopy(str1,"String1")
SCopy(str1,str2)
}
procedure sc_SCopy(i : LongInt);
var
  n : LongInt;
  Buffer, Proc, Str1, Str2 : String;
begin
  Buffer := Strip(TextBuf[i], ' ');
  Proc := 'SCopy';
    
  if (System.Pos(UpperCase(Proc + '('), UpperCase(Buffer)) > 0) then
  begin
    Str1 := StrBetween(TextBuf[i], '(', ')');
    Split(TextBuf[i], ',');
    
    if StrBuf.Count <> 2 then Exit;
    
    //CodeBuf.Add(Comments(TextBuf[i], Str1));
    Str1 := Extract(StrBuf[0], '(', 2);
    
    if System.Pos('"', StrBuf[1]) > 0 then
    begin
      Str2 := StrBetween(StrBuf[1], '"', '"');
      SData[Cnt] := '_SCOPY_buffer_' + IntToStr(i) + ' .byte ' + QuotedStr(Str2) + ', $9b';
      Inc(Cnt);
    end
    else
    begin
      Str2 := Copy(StrBuf[1], 1, Length(StrBuf[1]) - 1);
    end;
          
    CodeBuf.Add(' ldx #0');      
    CodeBuf.Add('for_loop_' + IntToStr(i));
    
    if System.Pos('"', StrBuf[1]) > 0 then
      CodeBuf.Add(' mva ' + '_SCOPY_buffer_' + IntToStr(i) + ',x ' + str1 + ',x')
    else
      CodeBuf.Add(' mva ' + str2 + ',x ' + str1 + ',x');
    
    CodeBuf.Add(' inx');
    
    if System.Pos('"', StrBuf[1]) > 0 then
    begin
      CodeBuf.Add(' cpx #' + IntToStr(Length(Str2)))
    end
    else
    begin
      for n := 1 to GVarCnt2 do
      begin
        if UpperCase(GVar2[n].VarName) = UpperCase(Str2) then
        begin
          CodeBuf.Add(' cpx #' + IntToStr(GVar2[n].Dim));
          Break;
        end;
      end;
    end;
    
    CodeBuf.Add(' jcc for_loop_' + IntToStr(i));
  end;  
end;

{
  PROC SCopyS(targetString, sourceString, BYTE start, stop)
  Examples:
    SCopyS(str1, "LATARIAN", 2, 6)
    SCopyS(str2, str1, 2, 4)
}
procedure sc_SCopyS(i : LongInt);
var
  n1 : LongInt;
  Buffer, Proc : String;
begin
  Buffer := Strip(TextBuf[i], ' ');
  Proc := 'SCopyS';
  n1 := System.Pos(UpperCase(Proc + '('), UpperCase(Buffer));
  if n1 > 0 then
  begin
    if GetParams(TextBuf[i], True, False, '1111') <> 3 then Exit;
    
    if System.Pos('#', mValues[1]) > 0 then
      mValues[1] := Extract(mValues[1], '#', 2);
    
    if System.Pos('#', mValues[3]) < 1 then
    begin
      CodeBuf.Add(' mva ' + mValues[3] + ' b_param1');
      CodeBuf.Add(' dec b_param1');
    end;
    
    CodeBuf.Add(' ldy ' + mValues[2]);
    CodeBuf.Add(' dey');
    CodeBuf.Add(' ldx #0');
    CodeBuf.Add('for_loop_' + IntToStr(i));  
    CodeBuf.Add(' lda ' + mValues[1] + ',y');
    CodeBuf.Add(' sta ' + mValues[0] + ',x');
    CodeBuf.Add(' iny');
    CodeBuf.Add(' inx');
    
    if System.Pos('#', mValues[3]) < 1 then
    begin
      CodeBuf.Add(' cpx b_param1')
    end
    else
    begin
      mValues[3] := Extract(mValues[3], '#', 2);
      CodeBuf.Add(' cpx #' + IntToStr(StrToInt(mValues[3]) - 1));
    end;
    
    CodeBuf.Add(' jcc for_loop_' + IntToStr(i));
  end;  
end;

procedure sc_SAssign(i : LongInt);
var
  n1 : LongInt;
  Buffer, Proc : String;
begin
  Buffer := Strip(TextBuf[i], ' ');
  Proc := 'SAssign';
  n1 := System.Pos(UpperCase(Proc + '('), UpperCase(Buffer));
  if n1 > 0 then
  begin
    if GetParams(TextBuf[i], True, False, '1111') <> 3 then Exit;
    
    if System.Pos('#', mValues[1]) > 0 then
      mValues[1] := Extract(mValues[1], '#', 2);
    
    CodeBuf.Add(' ldy ' + mValues[2]);
    CodeBuf.Add(' dey');
    CodeBuf.Add(' ldx #0');
    CodeBuf.Add('for_loop_' + IntToStr(i));  
    CodeBuf.Add(' lda ' + mValues[1] + ',y');
    CodeBuf.Add(' sta ' + mValues[0] + ',x');
    CodeBuf.Add(' iny');
    CodeBuf.Add(' inx');
    CodeBuf.Add(' cpx ' + mValues[3]);    
    CodeBuf.Add(' jcc for_loop_' + IntToStr(i));
  end;  
end;

{ Generate MADS ASM source code from ACTION! XIO procedure statement }
{ PROC XIO(BYTE channel, 0, command, aux1, aux2, fileString) }
procedure sc_XIO(i: LongInt);
var
  n, n1: LongInt;
  Proc, mParams, Buffer: String;
begin
  Buffer := Strip(TextBuf[i], ' ');
  Proc := 'XIO';
  
  n1 := System.Pos(UpperCase(Proc + '('), UpperCase(Buffer));
  if (n1 > 0) then
  begin
    //for n := 0 to 2 do lBoolFlag[n] := False;
    //for n := 3 to 10 do lBoolFlag[n] := True;
    Buffer := Trim(TextBuf[i]);
    
    GetParams(Buffer, False, False, '00011111111');  
    for n := 0 to n1 do
    begin
      case n of
        1: mParams := mValues[0];
        2: //
        else
          mParams := mParams + ', ' + mValues[n];
      end;
    end;
    CodeBuf.Add(' ' + Proc + ' ' + mParams);
  end;
end;

{ I/O routines }

{ Generate MADS ASM source code from ACTION! OPEN procedure statement }
{ PROC Open(BYTE channel, fileString, BYTE mode, aux2) }
procedure sc_Open(i : LongInt);
var
  n : LongInt;
  Proc, mParams : String[255];
  Buf : String;
  Num : Integer;
begin
  Buf := Strip(TextBuf[i], ' ');
  Proc := 'Open';

  n := System.Pos(UpperCase(Proc + '('), UpperCase(Buf));
  if (n > 0) then
  begin
    //for n := 0 to 10 do lBoolFlag[n] := True;
//    IO_device := '_IO_device_' + IntToStr(i);
    mParams := '';
    Buf := Trim(TextBuf[i]);

    GetParams(Buf, False, False, '211');
    mParams := mValues[0];
    mParams := mParams + ', ' + mValues[2];
    mParams := mParams + ', ' + mValues[1];

    Buf := Copy(mValues[0], 2, Length(mValues[0])-1);
    Num := 1;
    
    CodeBuf.Add(' ' + Proc + ' ' + mParams);
    
// BMI - short jump
// JMI - long jump
    l_IO_error[Num] := True;
    CodeBuf.Add(' jmi stop' + IntToStr(Num));    
  end;
end;

{ Generate MADS ASM source code from ACTION! OPEN procedure statement }
{ PROC Close(BYTE channel) }
procedure sc_Close(i : LongInt);
var
  n1 : LongInt;
  Proc, mParams : String[255];
  Buffer : String;
begin
  Buffer := Strip(TextBuf[i], ' ');
  Proc := 'Close';

  n1 := System.Pos(UpperCase(Proc + '('), UpperCase(Buffer));
  if (n1 > 0) then
  begin
    Buffer := Trim(TextBuf[i]);
    GetParams(Buffer, False, False, '2');    
    mParams := mValues[0];
    CodeBuf.Add(' ' + Proc + ' ' + mParams);
  end;
end;

{ Generate MADS ASM source code from ACTION! PrintDE procedure statement }
{ PROC PrintDE(BYTE channel, string) }
// PrintDE(1,text_buf)
// PRINTD(6,"hi, atariage")
procedure sc_PrintDX(boolCR: Boolean; i: LongInt);
var
  Buf, Str1, Str2, Str3 : String;
  n, Value, Code : Integer;
begin
  Str1 := Strip(TextBuf[i], ' ');
  
  if boolCR then
    Buf := 'PrintDE('
  else
    Buf := 'PrintD(';

  if (System.Pos(UpperCase(Buf), UpperCase(Str1)) > 0) then
  begin
    Str1 := Extract(TextBuf[i], '(', 2);
    Split(Str1, ',');
    
    //StrBuf[0] := Channel(StrBuf[0]);
    Buf := StrBuf[0];
    Val(Buf, Value, Code);    
    if Code = 0 then
    begin
      if Copy(Buf, 1, 1) = '$' then
      begin
        Buf := Copy(Buf, 2, Length(Buf)-1);
        n := StrToInt(Buf) * 10;
        StrBuf[0] := '#$' + IntToStr(n);
      end
      else
      begin
        Buf := '#$' + Buf + '0';
        StrBuf[0] := Buf;
      end;
    end;

    if System.Pos('"', Str1) > 0 then
    begin
      Str3 := StrBetween(Str1, '"', '"');
      Value := Length(Str3);     
      Str2 := '_str_buffer_' + IntToStr(i);
      
      if boolCR then
        SData[Cnt] := Str2 + ' .byte ' + QuotedStr(Str3) + ', $9b'
      else
        SData[Cnt] := Str2 + ' .byte ' + QuotedStr(Str3);
        
      Inc(Cnt);
      CodeBuf.Add(' Read ' + StrBuf[0] + ', #9, #' + Str2 + ', #' + IntToStr(Value));
    end
    //
    else
    //
    begin
      Str3 := Copy(StrBuf[1], 1, Length(StrBuf[1]) - 1);
      
      for n := 1 to GVarCnt2 do
      begin
        if UpperCase(GVar2[n].VarName) = UpperCase(Str3) then
        begin
          Value := GVar2[n].Dim;
          Break;
        end;
      end;
      
      CodeBuf.Add(' Read ' + StrBuf[0] + ', #9, #' + Str3 + ', #' + IntToStr(Value));
    end;
  end;
end;

{ Generate MADS ASM source code from ACTION! PutD procedure statement }
{ PROC PutD(BYTE channel, CHAR character) }
procedure sc_PutDX(Proc : String; i : LongInt);
var
  n1 : LongInt;
  mParams, Buf : String;
begin
  Buf := Strip(TextBuf[i], ' ');  
  n1 := System.Pos(UpperCase(Proc + '('), UpperCase(Buf));
  if (n1 > 0) then
  begin
    //lBoolFlag[0] := True;
    //lBoolFlag[1] := True;
    //lBoolParam := True;
    mParams := '';
    
    GetParams(Buf, False, False, '21');
    mParams := mValues[0];
    //mParams := Channel(mValues[0]);
    mParams := mParams + ', ' + mValues[1];
    (*
    for n := 0 to GetParams(Proc, Buf, False) do
    begin
      case n of
        0: 
        begin
          if Copy(mValues[n], 1, 1) <> '#' then
            mParams := mValues[n]
          else
          begin
            Buf := Copy(mValues[n], 2, Length(mValues[n])-1);
            if Buf[1] = '$' then
            begin
              Buf := Copy(Buf, 2, Length(Buf)-1);
              n1 := StrToInt(Buf) * 10;
              mParams := '#$' + IntToStr(n1);
            end
            else
            begin
              n1 := StrToInt(Buf) * 16;
              mParams := '#' + IntToStr(n1);
            end;
          end;
        end;
        1: mParams := mParams + ', ' + mValues[n];
      end;
    end;
    *)
    //lBoolParam := False;
    CodeBuf.Add(' ' + Proc + ' ' + mParams);
  end;
end;

{ Generate MADS ASM source code from ACTION! GetD procedure statement }
{ CHAR FUNC GetD(BYTE channel) }
procedure sc_GetD(i : LongInt);
var
  n1 : LongInt;
  mParams : String[255];
  Buf : String;
begin
  Buf := Strip(TextBuf[i], ' ');

  n1 := System.Pos(UpperCase('GetD('), UpperCase(Buf));
  if (n1 > 0) then
  begin
    //lBoolFlag[0] := True;
    mParams := '';
    
    GetParams(Buf, False, False, '2');
    mParams := mValues[0];
    
    CodeBuf.Add(' GetD ' + mParams);    
    CodeBuf.Add(' mwa Store1 ' + Trim(Extract(TextBuf[i], '=', 1)));    
  end;
end;

{ 
  Generate MADS ASM source code from ACTION! generic print device procedure statement
}
procedure sc_PrintXD(i : LongInt; Proc : String; lEnter : Boolean);
var
  n1 : LongInt;
  mLabel, mParams : String[255];
  Buf : String;
begin
  Buf := Strip(TextBuf[i], ' ');

  n1 := System.Pos(UpperCase(Proc + '('), UpperCase(Buf));
  if (n1 > 0) then
  begin
    //lBoolFlag[0] := True;
    //lBoolFlag[1] := True;
    mLabel := '_' + Proc + '_' + IntToStr(i) + '_' + IntToStr(n1);
    GetParams(Buf, False, False, '21');
    mParams := mValues[0];
    //
    (*
    if Copy(mValues[0], 2, 1) = '$' then
    begin
      Buf := Copy(mValues[0], 3, Length(mValues[0])-2);
      n1 := StrToInt(Buf) * 10;
      mParams := '#$' + IntToStr(n1);
    end
    else
    begin
      n1 := StrToInt(Copy(mValues[0], 2, Length(mValues[0])-1)) * 16;
      mParams := '#' + IntToStr(n1);
    end;
    *)
    //
    CodeBuf.Add(' printfd ' + mParams);
    
    if lEnter then
      CodeBuf.Add(' dta c' + QuotedStr('%') + ',$9b,0')
    else
      CodeBuf.Add(' dta c' + QuotedStr('%') + ',0');
    
    if Copy(mValues[1], 1, 1) = '#' then 
    begin
      Buf := Copy(mValues[1], 2, Length(mValues[1])-1);
      CodeBuf.Add(' dta a(' + mLabel + ')');
      SData[Cnt] := mLabel + ' dta a(' + Buf + ')';
      Inc(Cnt);
    end
    else
    begin
      Buf := mValues[1];
      CodeBuf.Add(' dta a(' + Buf + ')');
    end;
  end;
end;

{ Generate MADS ASM source code from ACTION! InputSD procedure statement }
{ PROC InputSD(BYTE channel, string) }
procedure sc_InputSD(i : LongInt);
var
  n1 : LongInt;
  mParams : String;
  Buf : String;
begin
  Buf := Strip(TextBuf[i], ' ');
  n1 := System.Pos(UpperCase('InputSD('), UpperCase(Buf));
  if (n1 > 0) then
  begin
    mParams := '';
    GetParams(Buf, False, False, '21');
    mParams := mValues[0];  // IOCB channel number        
    mParams := mParams + ', #5';  // Get record    
    mParams := mParams + ', ' + mValues[1];  // Get buffer    
    mParams := mParams + ', #120';  // Length of buffer
    CodeBuf.Add(' Read ' + mParams);    
  end;
end;

{ Generate MADS ASM source code from ACTION! Point procedure statement }
{ PROC Point(BYTE channel, CARD sector, BYTE offset) }
procedure sc_Point(i : LongInt);
var
  n1 : LongInt;
  Proc, mParams : String[255];
  Buffer : String;
begin
  Buffer := Strip(TextBuf[i], ' ');
  Proc := 'Point';

  n1 := System.Pos(UpperCase(Proc + '('), UpperCase(Buffer));
  if (n1 > 0) then
  begin
    GetParams(Buffer, False, False, '211');
    mParams := mValues[0];
    
    (*
    if mParams[1] = '#' then
    begin
      if mParams[2] = '$' then
      begin
        mParams := Copy(mParams, 3, Length(mParams)-2);
        n1 := StrToInt(mParams) * 10;
        mParams := ' #$' + IntToStr(n1);
      end
      else
      begin
        mParams := Copy(mParams, 2, Length(mParams)-1);
        n1 := StrToInt(mParams) * 16;
        mParams := ' #' + IntToStr(n1);
      end;
    end;
    *)
    
    CodeBuf.Add(' ' + Proc + ' ' + mParams + ', ' + mValues[1] + ', ' + mValues[2]);
  end;    
end;

{ Generate MADS ASM source code from ACTION! Note procedure statement }
{ PROC Note(BYTE channel, CARD POINTER sector, BYTE POINTER offset) }
procedure sc_Note(i : LongInt);
var
  n1 : LongInt;
  Proc, mParams : String[255];
  Buffer : String;
begin
  Buffer := Strip(TextBuf[i], ' ');
  Proc := 'Note';

  n1 := System.Pos(UpperCase(Proc + '('), UpperCase(Buffer));
  if (n1 > 0) then
  begin
    //for n := 0 to 2 do lBoolFlag[n] := True;
    
    GetParams(Buffer, False, False, '111');    
    mParams := mValues[0];
    
    (*
    if mParams[1] = '#' then
    begin
      if mParams[2] = '$' then
      begin
        mParams := Copy(mParams, 3, Length(mParams)-2);
        n1 := StrToInt(mParams) * 10;
        mParams := ' #$' + IntToStr(n1);
      end
      else
      begin
        mParams := Copy(mParams, 2, Length(mParams)-1);
        n1 := StrToInt(mParams) * 16;
        mParams := ' #' + IntToStr(n1);
      end;
    end;
    *)
    
    CodeBuf.Add(' ' + Proc + ' ' + mParams + ', ' + mValues[1] + ', ' + mValues[2]);
  end;    
end;

{ Generate MADS ASM source code from ACTION! Locate function statement }
{ BYTE FUNC Locate(CARD column, BYTE row) }
procedure sc_Locate(i : LongInt);
var
  n1 : LongInt;
  Proc, Buf : String;
begin
  Buf := Strip(TextBuf[i], ' ');
  Proc := 'Locate';

  n1 := System.Pos(UpperCase(Proc + '('), UpperCase(Buf));
  if (n1 > 0) then
  begin
    //lBoolFlag[0] := True;
    //lBoolFlag[1] := True;
    GetParams(Buf, False, False, '11');
    CodeBuf.Add(' Locate ' + mValues[0] + ', ' + mValues[1]);    
    n1 := System.Pos('=', TextBuf[i]) - 1;
    Buf := Trim(Copy(TextBuf[i], 1, n1));
    CodeBuf.Add(' mwa Store1 ' + Buf);    
  end;
end;

{ Generate MADS ASM source code from ACTION! StrB procedure statement }
{ PROC StrB(BYTE number, string) }
procedure sc_StrNum(Proc : String; i : LongInt);
var
  n : LongInt;
  Str1, Str2, Str3 : String;
begin
  Str1 := Strip(TextBuf[i], ' ');

  if System.Pos(UpperCase(Proc + '('), UpperCase(Str1)) > 0 then
  begin
    Str3 := StrBetween(TextBuf[i], '(', ')');
    Split(Str3, ',');
    
    if StrBuf.Count < 2 then Exit;
    
    Str1 := StrBuf[0];
    Str2 := StrBuf[1];
    CodeBuf.Add(' ldy #0');
    
    for n := 1 to Length(Str1) do
    begin
      CodeBuf.Add(' mva #''' + Str1[n] + '''' + ' ' + Str2 + ',y');
      CodeBuf.Add(' iny');
    end;    
  end;
end;

// Calculate dec/hex convention if necessary
function Channel(Value : String) : String;
var
  Buf : String;
  n1 : Byte;
begin
  if Copy(Value, 1, 1) <> '#' then
  begin
    Result := Value
  end
  else
  begin
    Buf := Copy(Value, 2, Length(Value)-1);
    if Buf[1] = '$' then
    begin
      Buf := Copy(Buf, 2, Length(Buf)-1);
      n1 := StrToInt(Buf) * 10;
      Result := '#$' + IntToStr(n1);
    end
    else
    begin
      n1 := StrToInt(Buf) * 16;
      Result := '#' + IntToStr(n1);
    end;
  end;
end;  

{ Retrieve procedure or function parameters }
function GetParams(StrBufX : String; lNum, lConv : Boolean; ParamTypes : String) : Integer;
//function GetParams(Proc, StrBufX : String; n1 : Integer; lNum : Boolean) : Integer;
var
  n, n3, CntX : Integer;
  mVal, Buf, StrBuffer : String;
  Flag : Boolean = False;
begin
  for n := 1 to 10 do
    mvalues[n] := '';
  
  StrBuffer := '_str_buffer_' + IntToStr(CurLine);
  Buf := StrBetweenEx(strbufx, '(', ')');
  
  // Check for Put(' ) command
  if Buf = ''' ' then
  begin
    CntX := 0;
    StrBuf.Clear;
    StrBuf.Add(Buf);
  end
  else
  // otherwise, normal flow is in place
  begin
    if System.Pos('(', Buf) > 0 then Buf := Replace(Buf, '(', '[');
    if System.Pos(')', Buf) > 0 then Buf := Replace(Buf, ')', ']');
  
    Split(Buf, ',');
    CntX := StrBuf.Count - 1;
  end;

  for n := 0 to CntX do
  begin
    mVal := StrBuf[n];
    
    if (((mVal[1] > Chr(47)) and (mVal[1] < Chr(58))) or (mVal[1] = '$'))
       and ((ParamTypes[n + 1] = '1') or (ParamTypes[n + 1] = '2')) then
      mValues[n] := Trim('#' + mVal)
    else if mVal[1] = '''' then
    begin
      mValues[n] := '#' + mVal + ''''
    end
    else
    begin
      Flag := False;
      
      for n3 := 1 to GVarCnt2 do
      begin
        if System.Pos(UpperCase(GVar2[n3].VarName), UpperCase(StrBufX)) > 0 then
        begin
          Flag := True;
            
          if not lNum then
            mValues[n] := '#' + Trim(mVal)
          else
            mValues[n] := Trim(mVal);
          
          break;
        end
      end;
      
      if not Flag then mValues[n] := mVal;
      
      //if mValues[n][1] = '"' then
      if Copy(mValues[n], 1, 1) = '"' then
      begin
        if lConv then
        //if lNum and not PrgVar.ParamStr then
          mValues[n] := StrBetweenEx(mValues[n], '"', '"')
          //mValues[n] := Copy(mValues[n], 2, Length(mValues[n])-2)
        else
        begin
          if Copy(mValues[n], 3, 1) = '"' then
            mValues[n] := '#' + QuotedStr(mValues[n][2])
          else
          begin
            SData[Cnt] := Strbuffer + ' .byte ' +
                          QuotedStr(Copy(mValues[n], 2, Length(mValues[n])-2)) + ', $9b';
            Inc(Cnt);
            mValues[n] := '#' + StrBuffer;
          end;
        end;
      end
      else
      begin
        if LowerCase(mValues[n]) = 'device' then
          mValues[n] := 'device.devscr';
      end
    end;
  end;
  
  // Calculate dec/hex convention if necessary  
  for n := 0 to CntX do
  begin
    if ParamTypes[n + 1] = '2' then
      mValues[n] := Channel(mValues[n]);
  end;
  
  //PrgVar.ParamStr := False;
  Result := CntX;  
end;

{ Generate MADS ASM source code from ACTION! PrintF procedure statement }
(*
format char	description for Action!:
%I	INT
%U	CARD (the U stands for Unsigned) and BYTE
%C	print as a character
%H	Hexdecimal number
%E	the RETURN character
%%	output the percent sign
%S	output as a string

Some examples:
PrintF("%EA%EB%E")
PrintF("%EThe sum of %U and %U is %U%E",a,b,a+b
PrintF("The letter %C.%E",65)
PrintF("Score %U: %U",player,score(player))

MADS method:
 jsr printf
 dta c'tekst #@%',$9b,0
 dta a(string)
 dta a(float)
 dta a(word)
*)
procedure sc_PrintF(i : LongInt);
var
  n, n1 : LongInt;
  Str1, Str2, Str3 : String;
  varx : Array[0..21] of string[10];
  VarxCnt : Integer = 0;
begin
  Str1 := Strip(TextBuf[i], ' ');

  n1 := System.Pos(UpperCase('PrintF("'), UpperCase(Str1));
  if (n1 > 0) then
  begin
    Str2 := StrBetween(TextBuf[i], '"', '"');
    //CodeBuf.Add(Comments(TextBuf[i], Str2)); 
    Str3 := StrBetween(Str1, '"', '"');
    Str1 := Copy(Str1, 8 + Length(Str3), Length(Str1)-(8+Length(Str3)));
    Str1 := Extract(Str1, '"', 2);
    Str1 := Copy(Str1, 2, Length(Str1)-2);    
    Split(Str1, ',');
    
    if StrBuf.Count = 0 then Varx[0] := Str1;
    
    for n := 0 to StrBuf.Count - 1 do      
      varx[n] := StrBuf[n];
     
    SplitEx(Str2, '%');
    for n := 0 to StrBuf.Count - 1 do
    begin      
      if Copy(StrBuf[n], 1, 1) = 'E' then
      begin
        Str2 := ExtractEx(StrBuf[n], 'E', 2);
        CodeBuf.Add(' PutE');
        
        if Str2 <> '' then
        begin
          CodeBuf.Add(' jsr printf');
          CodeBuf.Add(' dta c' + QuotedStr(Str2) + ',0');
        end;
      end
      else if Copy(StrBuf[n], 1, 1) = 'I' then
      begin
        CodeBuf.Add(' jsr printf');
        CodeBuf.Add(' dta c' + QuotedStr('%') + ',0');
        CodeBuf.Add(' dta a(' + Varx[VarxCnt] + ')');
        Inc(VarxCnt);
        
        Str2 := ExtractEx(StrBuf[n], 'I', 2);
        if Str2 <> '' then
        begin
          CodeBuf.Add(' jsr printf');
          CodeBuf.Add(' dta c' + QuotedStr(Str2) + ',0');
        end;
      end
      else if Copy(StrBuf[n], 1, 1) = 'U' then
      begin
        CodeBuf.Add(' jsr printf');
        CodeBuf.Add(' dta c' + QuotedStr('%') + ',0');
        CodeBuf.Add(' dta a(' + Varx[VarxCnt] + ')');
        Inc(VarxCnt);
        
        Str2 := ExtractEx(StrBuf[n], 'U', 2);
        if Str2 <> '' then
        begin
          CodeBuf.Add(' jsr printf');
          CodeBuf.Add(' dta c' + QuotedStr(Str2) + ',0');
        end;
      end
      else if Copy(StrBuf[n], 1, 1) = 'C' then
      begin
        Str2 := ExtractEx(StrBuf[n], 'C', 2);          
        //lBoolFlag[0] := True;          
        GetParams('Put(' + VarX[VarxCnt] + ')', False, False, '1');
        Inc(VarxCnt);
        CodeBuf.Add(' Put ' + mValues[0]);
        
        if Str2 <> '' then
        begin
          CodeBuf.Add(' jsr printf');
          CodeBuf.Add(' dta c' + QuotedStr(Str2) + ',0');
        end;
      end        
      else
      begin
        if StrBuf[n] <> '' then
        begin
          CodeBuf.Add(' jsr printf');
          CodeBuf.Add(' dta c' + QuotedStr(StrBuf[n]) + ',0');
        end;
      end;        
    end;
  end;
end;

end.