;
; Effectus / MADS equates
;
; Included and amended:

; ATARI 800 SYSTEM EQUATE LISTING
;
; Tranferred to ATASM format by JAC! on 2010-11-11 based on
; http://evilbill.org/old/orig/Atari/8-Bit/Refman/appendixB.html
; Formatted using tabs for a tab width of 8 characters.
; Last update on 2010-11-11.
; The latest version of this file is availble on
; http://www.wudsn.com/productions/atari800/ide/SystemEquates.asm
;
; This listing is based on the original release of Operating System,
; version A. The vectors shown here were not changed in version B.
; New equates for XL and XE models are included and noted. 
; Changes from version B to XL/XE are also noted.
;
; Most of the equate names given below are the official Atari names.
; They are in common use but are not mandatory.
;

;
;
;	DEVICE NAMES
;
;SCREDT = "E"	;SCREEN EDITOR
;KBD    = "K"	;KEYBOARD
;DISPLY = "S"	;DISPLAY
;PRINTR = "P"	;PRINTER
;CASSET = "C"	;CASSETTE
;DISK   = "D"	;DISK DRIVE
;
;
;	STATUS CODES
;
SUCCES equ $01	;  1
BRKABT equ $80	;128 BREAK KEY ABORT
PRVOPN equ $82	;130 IOCB ALREADY OPEN
NONDEV equ $82	;130 NONEXISTANT DEVICE
WRONLY equ $83	;131 OPENED FOR WRITE ONLY
NVALID equ $84	;132 INVALID COMMAND
NOTOPN equ $85	;133 DEVICE OR FILE NOT OPEN
BADIOC equ $86	;134 INVALID IOCB NUMBER
RDONLY equ $87	;135 OPENED FOR READ ONLY
EOFERR equ $88	;136 END OF FILE
TRNRCD equ $89	;137 TRUNCATED RECORD
TIMOUT equ $8A	;138 PERIPHERAL TIME OUT
DNACK  equ $8B	;139 DEVICE DOES NOT ACKNOWLEDGE
FRMERR equ $8C	;140 SERIAL BUS FRAMING ERROR
CRSROR equ $8D	;141 CURSOR OUT OF RANGE
OVRRUN equ $8E	;142 SERIAL BUS DATA OVERRUN
CHKERR equ $8F	;143 SERIAL BUS CHECKSUM ERROR
DERROR equ $90	;144 PERIPHERAL DEVICE ERROR
BADMOD equ $91	;145 NON EXISTANT SCREEN MODE
FNCNOT equ $92	;146 FUNCTION NOT IMPLEMENTED
SCRMEM equ $93	;147 NOT ENOUGH MEMORY FOR SCREEN MODE
;
;
;	COMMAND CODES FOR CIO
;
OPEN0  equ $03	;  3
OPREAD equ $04	;  4 OPEN FOR INPUT
GETREC equ $05	;  5 GET RECORD
OPDIR  equ $06	;  6 OPEN TO DISK DIRECTORY
GETCHR equ $07	;  7 GET BYTE
OWRITE equ $08	;  8 OPEN FOR OUTPUT
PUTREC equ $09	;  9 WRITE RECORD
APPEND equ $09	;  9 OPEN TO APPEND TO END OF DISK FILE
MXDMOD equ $10	; 16 OPEN TO SPLIT SCREEN (MIXED MODE)
PUTCHR equ $0B	; 11 PUT-BYTE
CLOSE0 equ $0C	; 12
OUPDAT equ $0C	; 12 OPEN FOR INPUT AND OUTPUT AT THE SAME TIME
STATUS equ $0D	; 13
SPECIL equ $0E	; 14 BEGINNING OF SPECIAL COMMANDS
DRAWLN equ $11	; 17 SCREEN DRAW
FILLIN equ $12	; 18 SCREEN FILL
RENAME equ $20	; 32
INSCLR equ $20	; 32 OPEN TO SCREEN BUT DON'T ERASE
DELETE equ $21	; 33
DFRMAT equ $21	; 33 FORMAT DISK (RESIDENT DISK HANDLER (RDH))
LOCK   equ $23	; 35
UNLOCK equ $24	; 36
POINT0 equ $25	; 37
NOTE0  equ $26	; 38
PTSECT equ $50	; 80 RDH PUT SECTOR
GTSECT equ $52	; 82 RDH GET SECTOR
DSTAT  equ $53	; 83 RDH GET STATUS
PSECTV equ $57	; 87 RDH PUT SECTOR AND VERIFY
NOIRG  equ $80	;128 NO GAP CASSETTE MODE
CR     equ $9B	;155 CARRIAGE RETURN (EOL)
;
IOCBSZ equ $10	; 16 IOCB SIZE
MAXIOC equ $80	;128 MAX IOCB BLOCK SIZE
IOCBF  equ $FF	;255 IOCB FREE
;
LEDGE  equ $02	;  2 DEFAULT LEFT MARGIN
REDGE  equ $27	; 39 DEFAULT RIGHT MARGIN
;
;
;	OS VARIABLES
;
;	PAGE 0
;
LINZBS equ $00	;  0 (800) FOR ORIGINAL DEBUGGER
;	 $00	;  0 (XL) RESERVED
NGFLAG equ $01	;  1 (XL) FOR POWER-UP SELF TEST
CASINI equ $02	;  2
RAMLO  equ $04	;  4 POINTER FOR SELF TEST
TRAMSZ equ $06	;  6 TEMPORARY RAM SIZE
TSTDAT equ $07	;  7 TEST DATA
WARMST equ $08	;  8
BOOT?  equ $09	;  9 SUCCESSFUL BOOT FLAG
DOSVEC equ $0A	; 10 PROGRAM RUN VECTOR
DOSINI equ $0C	; 12 PROGRAM INITIALIZATION
APPMHI equ $0E	; 14 DISPLAY LOW LIMIT
POKMSK equ $10	; 16 IRQ ENABLE FLAGS
BRKKEY equ $11	; 17 FLAG
RTCLOK equ $12	; 18 3 BYTES, MSB FIRST
BUFADR equ $15	; 21 INDIRECT BUFFER ADDRESS
ICCOMT equ $17	; 23 COMMAND FOR VECTOR
DSKFMS equ $18	; 24 DISK FILE MANAGER POINTER
DSKUTL equ $1A	; 26 DISK UTILITY POINTER (DUP.SYS)
PTIMOT0 equ $1C	; 28 (800) PRINTER TIME OUT REGISTER
ABUFPT equ $1C	; 28 (XL) RESERVED
PBPNT0 equ $1D	; 29 (800) PRINTER BUFFER POINTER
;	 $1D	; 29 (XL) RESERVED
PBUFSZ0 equ $1E	; 30 (800) PRINTER BUFFER SIZE
;	 $1E	; 30 (XL) RESERVED
PTEMP  equ $1F	; 31 (800) TEMPORARY REGISTER
;	 $1F	; 31 (XL) RESERVED
ZIOCB  equ $20	; 32 ZERO PAGE IOCB
ICHIDZ equ $20	; 32 HANDLER INDEX NUMBER (ID)
ICDNOZ equ $21	; 33 DEVICE NUMBER
ICCOMZ equ $22	; 34 COMMAND
ICSTAZ equ $23	; 35 STATUS
ICBALZ equ $24	; 36 BUFFER POINTER LOW BYTE
ICBAHZ equ $25	; 37 BUFFER POINTER HIGH BYTE
ICPTLZ equ $26	; 38 PUT ROUTINE POINTER LOW
ICPTHZ equ $27	; 39 PUT ROUTINE POINTER HIGH
ICBLLZ equ $28	; 40 BUFFER LENGTH LOW
ICBLHZ equ $29	; 41
ICAX1Z equ $2A	; 42 AUXILIARY INFORMATION BYTE 1
ICAX2Z equ $2B	; 43
ICSPRZ equ $2C	; 44 TWO SPARE BYTES (CIO USE)
ICIDNO equ $2E	; 46 IOCB NUMBER X 16
CIOCHR equ $2F	; 47 CHARACTER BYTE FOR CURRENT OPERATION
;
STATUS0 equ $30	; 48 STATUS STORAGE
CHKSUM equ $31	; 49 SUM WITH CARRY ADDED BACK
BUFRLO equ $32	; 50 DATA BUFFER LOW BYTE
BUFRHI equ $33	; 51
BFENLO equ $34	; 52 ADDRESS OF LAST BUFFER BYTE +1 (LOW)
BFENHI equ $35	; 53
CRETRY0 equ $36	; 54 (800) NUMBER OF COMMAND FRAME RETRIES
LTEMP  equ $36	; 54 (XL) LOADER TEMPORARY STORAGE, 2 BYTES
DRETRY0 equ $37	; 55 (800) DEVICE RETRIES
BUFRFL equ $38	; 56 BUFFER FULL FLAG
RECVDN equ $39	; 57 RECEIVE DONE FLAG
XMTDON equ $3A	; 58 TRANSMISSION DONE FLAG
CHKSNT equ $3B	; 59 CHECKSUM-SENT FLAG
NOCKSM equ $3C	; 60 CHECKSUM-DOES-NOT-FOLLOW-DATA FLAG
BPTR   equ $3D	; 61
FTYPE  equ $3E	; 62
FEOF   equ $3F	; 63
FREQ   equ $40	; 64
;
SOUNDR equ $41	; 65 0=QUIET I/O
CRITIC equ $42	; 66 CRITICAL FUNCTION FLAG, NO DEFFERED VBI
FMSZPG equ $43	; 67 DOS ZERO PAGE, 7 BYTES
CKEY0   equ $4A	; 74 (800) START KEY FLAG
ZCHAIN equ $4A	; 74 (XL) HANDLER LOADER TEMP, 2 BYTES
CASSBT0 equ $4B	; 75 (800) CASSETTE BOOT FLAG
DSTAT0  equ $4C	; 76 DISPLAY STATUS
;
ATRACT equ $4D	; 77
DRKMSK equ $4E	; 78 ATTRACT MASK
COLRSH equ $4F	; 79 ATTRACT COLOR SHIFTER (EORed WITH GRAPHICS)
;
TMPCHR equ $50	; 80
HOLD1  equ $51	; 81
LMARGN equ $52	; 82 SCREEN LEFT MARGIN REGISTER
RMARGN equ $53	; 83 SCREEN RIGHT MARGIN
ROWCRS equ $54	; 84 CURSOR ROW
COLCRS equ $55	; 85 CURSOR COLUMN, 2 BYTES
DINDEX equ $57	; 87 DISPLAY MODE
SAVMSC equ $58	; 88 SCREEN ADDRESS
OLDROW equ $5A	; 90 CURSOR BEFORE DRAW OR FILL
OLDCOL equ $5B	; 91
OLDCHR equ $5D	; 93 DATA UNDER CURSOR
OLDADR equ $5E	; 94 CURSOR ADDRESS
NEWROW0 equ $60	; 96 (800) DRAWTO DESTINATION
FKDEF  equ $60	; 96 (XL) FUNCTION KEY DEFINATION POINTER
NEWCOL0 equ $61	; 97 (800) DRAWTO DESTINATION, 2 BYTES
PALNTS equ $62	; 98 (XL) EUROPE/NORTH AMERICA TV FLAG
LOGCOL equ $63	; 99 LOGICAL LINE COLUMN POINTER
MLTTMP equ $66	;102
OPNTMP equ $66	;102 TEMPORARY STORAGE FOR CHANNEL OPEN
SAVADR equ $68	;104
RAMTOP equ $6A	;106 START OF ROM (END OF RAM + 1), HIGH BYTE ONLY

BUFCNT equ $6B	;107 BUFFER COUNT
BUFSTR equ $6C	;108 POINTER USED BY EDITOR
BITMSK equ $6E	;110 POINTER USED BY EDITOR
SHFAMT equ $6F	;111
ROWAC  equ $70	;112
COLAC  equ $72	;114
ENDPT  equ $74	;116
DELTAR equ $76	;118
DELTAC equ $77	;119
ROWINC0 equ $79	;121 (800)
KEYDEF equ $79	;121 (XL) KEY DEFINATION POINTER, 2 BYTES
COLINC0 equ $7A	;122 (800)
SWPFLG equ $7B	;123 NON 0 IF TEXT AND REGULAR RAM IS SWAPPED
HOLDCH equ $7C	;124 CH MOVED HERE BEFORE CTRL AND SHIFT
INSDAT equ $7D	;125
COUNTR equ $7E	;126
;
ZROFRE equ $80	;128 FREE ZERO PAGE, 84 BYTES
FPZRO  equ $D4	;212 FLOATING POINT RAM, 43 BYTES
FR0    equ $D4	;212 FP REGISTER 0
FRE    equ $DA	;218
FR1    equ $E0	;224 FP REGISTER 1
FR2    equ $E6	;230 FP REGISTER 2
FRX    equ $EC	;236 SPARE
EEXP   equ $ED	;237 VALUE OF E
NSIGN  equ $ED	;237 SIGN OF FP NUMBER
ESIGN  equ $EF	;239 SIGN OF FP EXPONENT
FCHFLG equ $F0	;240 FIRST CHARACTER FLAG
DIGRT  equ $F1	;241 NUMBER OF DIGITS RIGHT OF DECIMAL POINT
CIX    equ $F2	;242 INPUT INDEX
INBUFF equ $F3	;243 POINTER TO ASCII FP NUMBER
ZTEMP1 equ $F5	;245
ZTEMP4 equ $F7	;247
ZTEMP3 equ $F9	;249
DEGFLG equ $FB	;251
RADFLG equ $FB	;251 0=RADIANS, 6=DEGREES
FLPTR  equ $FC	;252 POINTER TO BCD FP NUMBER
FPTR2  equ $FE	;254
;
;
;	PAGE 1
;
;	65O2 STACK
;
;	PAGE 2
;
INTABS equ $0200	;512 INTERRUPT RAM
VDSLST equ $0200	;512 NMI VECTOR
VPRCED equ $0202	;514 PROCEED LINE IRQ VECTOR
VINTER equ $0204	;516 INTERRUPT LINE IRQ VECTOR
VBREAK equ $0206	;518
VKEYBD equ $0208	;520
VSERIN equ $020A	;522 SERIAL INPUT READY IRQ
VSEROR equ $020C	;524 SERIAL OUTPUT READY IRQ
VSEROC equ $020E	;526 SERIAL OUTPUT COMPLETE IRQ
VTIMR1 equ $0210	;528 TIMER 1 IRQ
VTIMR2 equ $0212	;530 TIMER 2 IRQ
VTIMR4 equ $0214	;532 TIMER 4 IRQ
VIMIRQ equ $0216	;534 IRQ VECTOR
CDTMV1 equ $0218	;536 DOWN TIMER 1
CDTMV2 equ $021A	;538 DOWN TIMER 2
CDTMV3 equ $021C	;540 DOWN TIMER 3
CDTMV4 equ $021E	;542 DOWN TIMER 4
CDTMV5 equ $0220	;544 DOWN TIMER 5
VVBLKI equ $0222	;546
VVBLKD equ $0224	;548
CDTMA1 equ $0226	;550 DOWN TIMER 1 JSR ADDRESS
CDTMA2 equ $0228	;552 DOWN TIMER 2 JSR ADDRESS
CDTMF3 equ $022A	;554 DOWN TIMER 3 FLAG
SRTIMR equ $022B	;555 REPEAT TIMER
CDTMF4 equ $022C	;556 DOWN TIMER 4 FLAG
INTEMP equ $022D	;557 IAN'S TEMP
CDTMF5 equ $022E	;558 DOWN TIMER FLAG 5
SDMCTL equ $022F	;559 DMACTL SHADOW
SDLSTL equ $0230	;560 DISPLAY LIST POINTER
SSKCTL equ $0232	;562 SKCTL SHADOW
;	 $0233	;563 (800) UNLISTED
LCOUNT equ $0233	;563 (XL) LOADER TEMP
LPENH  equ $0234	;564 LIGHT PEN HORIZONTAL
LPENV  equ $0235	;565 LIGHT PEN VERTICAL
;	 $0236	;566 2 SPARE BYTES
;	 $0238	;568 (800) SPARE, 2 BYTES
RELADR equ $0238	;568 (XL) LOADER
CDEVIC equ $023A	;570 DEVICE COMMAND FRAME BUFFER
CAUX1  equ $023C	;572 DEVICE COMMAND AUX 1
CAUX2  equ $023D	;573 DEVICE COMMAND AUX 2
TEMP0  equ $023E	;574 TEMPORARY STORAGE
ERRFLG equ $023F	;575 DEVICE ERROR FLAG (EXCEPT TIMEOUT)
DFLAGS equ $0240	;576 FLAGS FROM DISK SECTOR 1
DBSECT equ $0241	;577 NUMBER OF BOOT DISK SECTORS
BOOTAD equ $0242	;578 BOOT LOAD ADDRESS POINTER
COLDST equ $0244	;580 COLD START FLAG, 1 equ COLD START IN PROGRESS
;	 $0245	;581 (800) SPARE
RECLEN equ $0245	;581 (XL) LOADER
DSKTIM equ $0246	;582 (800) DISK TIME OUT REGISTER
;	;	;$0246	;582 (XL) RESERVED, 39 BYTES
LINBUF equ $0247	;583 (800) CHARACTER LINE BUFFER, 40 BYTES
CHSALT equ $026B	;619 (XL) CHARACTER SET POINTER
VSFLAG equ $026C	;620 (XL) FINE SCROLL TEMPORARY
KEYDIS equ $026D	;621 (XL) KEYBOARD DISABLE
FINE   equ $026E	;622 (XL) FINE SCROLL FLAG
GPRIOR equ $026F	;623 P/M PRIORITY AND GTIA MODES
GTIA   equ $026F	;623
PADDL0 equ $0270	;624 (XL) 3 MORE PADDLES, (800) 6 MORE PADDLES
PADDL1 equ $0271	;625 (XL) 3 MORE PADDLES, (800) 6 MORE PADDLES
PADDL2 equ $0272	;626 (XL) 3 MORE PADDLES, (800) 6 MORE PADDLES
PADDL3 equ $0273	;627 (XL) 3 MORE PADDLES, (800) 6 MORE PADDLES
STICK0 equ $0278	;632 (XL) 1 MORE STICK, (800) 3 MORE STICKS
STICK1 equ $0279	;633 (XL) 1 MORE STICK, (800) 3 MORE STICKS
PTRIG0 equ $027C	;636 (XL) 3 MORE PADDLE TRIGGERS, (800) 6 MORE
PTRIG1 equ $027D	;637 (XL) 3 MORE PADDLE TRIGGERS, (800) 6 MORE
PTRIG2 equ $027E	;638 (XL) 3 MORE PADDLE TRIGGERS, (800) 6 MORE
PTRIG3 equ $027F	;639 (XL) 3 MORE PADDLE TRIGGERS, (800) 6 MORE
STRIG0 equ $0284	;644 (XL) 1 MORE STICK TRIGGER, (800) 3 MORE
STRIG1 equ $0285	;645 (XL) 1 MORE STICK TRIGGER, (800) 3 MORE
CSTAT  equ $0288	;648 (800)
WMODE  equ $0289	;649
BLIM   equ $028A	;650
;	;	;$028B	;651 5 SPARE BYTES
NEWADR equ $028E	;654 (XL)  LOADER RAM
TXTROW equ $0290	;656
TXTCOL equ $0291	;657
TINDEX equ $0293	;659 TEXT INDEX
TXTMSC equ $0294	;660
TXTOLD equ $0296	;662 OLD ROW AND OLD COL FOR TEXT, 2 BYTES
;	;	;$0298	;664 4 SPARE BYTES
TMPX1  equ $029C	;668 (800)
CRETRY equ $029C	;668 (XL)  NUMBER OF COMMAND FRAME RETRIES
SUBTMP equ $029E	;670
HOLD2  equ $029F	;671
DMASK  equ $02A0	;672
TMPLBT equ $02A1	;673
ESCFLG equ $02A2	;674
TABMAP equ $02A3	;675 15 BYTE BIT MAP FOR TAB SETTINGS
LOGMAP equ $02B2	;690 4 BYTE LOGICAL LINE START BIT MAP
INVFLG equ $02B6	;694
FILFLG equ $02B7	;695 FILL DIRING DRAW FLAG
TMPROW equ $02B8	;696
TMPCOL equ $02B9	;697
SCRFLG equ $02BB	;699 SCROLL FLAG
HOLD4  equ $02BC	;700
HOLD5  equ $02BD	;701 (800)
DRETRY equ $02BD	;701 (XL)  NUMBER OF DEVICE RETRIES
SHFLOC equ $02BE	;702
BOTSCR equ $02BF	;703 24 NORM, 4 SPLIT
PCOLR0 equ $02C0	;704  Player 0 color register
PCOLR1 equ $02C1	;705  Player 1 color register
PCOLR2 equ $02C2	;706  Player 2 color register
PCOLR3 equ $02C3	;707  Player 3 color register
COLOR0 equ $02C4	;708  Color register 0
COLOR1 equ $02C5	;709  Color register 1
COLOR2 equ $02C6	;710  Color register 2
COLOR3 equ $02C7	;711  Color register 3
;	 $02C9	;713 (800) 23 SPARE BYTES
RUNADR equ $02C9	;713 (XL) LOADER VECTOR
HIUSED equ $02CB	;715 (XL) LOADER VECTOR
ZHIUSE equ $02CD	;717 (XL) LOADER VECTOR
GBYTEA equ $02CF	;719 (XL) LOADER VECTOR
LOADAD equ $02D1	;721 (XL) LOADER VECTOR
ZLOADA equ $02D3	;723 (XL) LOADER VECTOR
DSCTLN equ $02D5	;725 (XL) DISK SECTOR SIZ
ACMISR equ $02D7	;727 (XL) RESERVED
KRPDER equ $02D9	;729 (XL) KEY AUTO REPEAT DELAY
KEYREP equ $02DA	;730 (XL) KEY AUTO REPEAT RATE
NOCLIK equ $02DB	;731 (XL) KEY CLICK DISABLE
HELPFG equ $02DC	;732 (XL) HELP KEY FLAG
DMASAV equ $02DD	;733 (XL) SDMCTL (DMA) SAVE
PBPNT  equ $02DE	;734 (XL) PRINTER BUFFER POINTER
PBUFSZ equ $02DF	;735 (XL) PRINTER BUFFER SIZE
GLBABS equ $02E0	;736 GLOBAL VARIABLES, 4 SPARE BYTES
RAMSIZ equ $02E4	;740 PERMANENT START OF ROM POINTER
MEMTOP equ $02E5	;741 END OF FREE RAM
MEMLO  equ $02E7	;743
;	 $02E9	;745 (800) SPARE
HNDLOD equ $02E9	;745 (XL) HANDLER LOADER FLAG
DVSTAT equ $02EA	;746 DEVICE STATUS BUFFER, 4 BYTES
CBAUDL equ $02EE	;750 CASSETTE BAUD RATE, 2 BYTES
CRSINH equ $02F0	;752 1 = INHIBIT CURSOR
KEYDEL equ $02F1	;753 KEY DELAY AND RATE
CH1    equ $02F2	;754
CHACT  equ $02F3	;755
CHBAS  equ $02F4	;756 CHARACTER SET POINTER
NEWROW equ $02F5	;757 (XL) DRAW DESTINATION
NEWCOL equ $02F6	;758 (XL) DRAW DESTINATION
ROWINC equ $02F8	;760 (XL)
COLINC equ $02F9	;761 (XL)
CHAR   equ $02FA	;762
ATACHR equ $02FB	;763 ATASCII CHARACTER FOR CIO
CH     equ $02FC	;764
FILDAT equ $02FC	;764 COLOR FOR SCREEN FILL
DSPFLG equ $02FE	;766 DISPLAY CONTROL CHARACTERS FLAG
SSFLAG equ $02FF	;767 DISPLAY START/STOP FLAFG
;
;
;	PAGE 3
;
;	RESIDENT DISK HANDLER/SIO INTERFACE
;
DCB    equ $0300	;768 DEVICE CONTROL BLOCK
DDEVIC equ $0300	;768
DUNIT  equ $0301	;769
DCOMND equ $0302	;770
DSTATS equ $0303	;771
DBUFLO equ $0304	;772
DBUFHI equ $0305	;773
DTIMLO equ $0306	;774
DBYTLO equ $0308	;776
DBYTHI equ $0309	;777
DAUX1  equ $030A	;778
DAUX2  equ $030B	;779
TIMER1 equ $030C	;780 INITIAL TIMER VALUE
ADDCOR equ $030E	;782 (800) ADDITION CORRECTION
JMPERS equ $030E	;782 (XL) OPTION JUMPERS
CASFLG equ $030F	;783 CASSETTE MODE WHEN SET
TIMER2 equ $0310	;784 FINAL VALUE, TIMERS 1 & 2 DETERMINE BAUD RATE
TEMP1  equ $0312	;786
TEMP2  equ $0313	;787 (XL)
;TEMP2 equ $0314	;788 (800)
PTIMOT equ $0314	;788 (XL) PRINTER TIME OUT
TEMP3  equ $0315	;789
SAVIO  equ $0316	;790 SAVE SERIAL IN DATA PORT
TIMFLG equ $0317	;791 TIME OUT FLAG FOR BAUD RATE CORRECTION
STACKP equ $0318	;792 SIO STACK POINTER SAVE
TSTAT  equ $0319	;793 TEMPORARY STATUS HOLDER
HATABS equ $031A	;794 HANDLER ADDRESS TABLE, 38 BYTES
MAXDEV equ $0321	;801 MAXIMUM HANDLER ADDRESS INDEX
PUPBT1 equ $033D	;829 (XL) POWER-UP/RESET
PUPBT2 equ $033E	;830 (XL) POWER-UP/RESET
PUPBT3 equ $033F	;831 (XL) POWER-UP/RESET
;
;IOCB's
;
IOCB   equ $0340	;832
ICHID  equ $0340	;832
ICDNO  equ $0341	;833
ICCOM  equ $0342	;834
ICSTA  equ $0343	;835
ICBAL  equ $0344	;836
ICBAH  equ $0345	;837
ICPTL  equ $0346	;838
ICPTH  equ $0347	;839
ICBLL  equ $0348	;840
ICBLH  equ $0349	;841
ICAX1  equ $034A	;842
ICAX2  equ $034B	;843
ICAX3  equ $034C	;844
ICAX4  equ $034D	;845
ICAX5  equ $034E	;846
ICAX6  equ $034F	;847
;		 OTHER IOCB's, 112 BYTES

PRNBUF equ $03C0	;960 PRINTER BUFFER, 40 BYTES
;	 $03E8	;1000 (800) 21 SPARE BYTES
SUPERF equ $03E8	;1000 (XL) SCREEN EDITOR
CKEY   equ $03E9	;1001 (XL) START KEY FLAG
CASSBT equ $03EA	;1002 (XL) CASSETTE BOOT FLAG
CARTCK equ $03EB	;1003 (XL) CARTRIDGE CHECKSUM
ACMVAR equ $03ED	;1005 (XL) RESERVED, 6 BYTES
MINTLK equ $03F9	;1017 (XL) RESERVED
GINTLK equ $03FA	;1018 (XL) CARTRIDGE INTERLOCK
CHLINK equ $03FB	;1019 (XL) HANDLER CHAIN, 2 BYTES
CASBUF equ $03FD	;1021 CASSETTE BUFFER, 131 BYTES TO $047F
;
;
;	PAGE 4
;
USAREA equ $0480	;1152 128 SPARE BYTES
;
;	SEE APPENDIX C FOR PAGES 4 AND 5 USAGE
;
;
;	PAGE 5
;
PAGE5  equ $0500	;1280 127 FREE BYTES
;	 $057E	;1406 129 FREE BYTES IF FLOATING POINT ROUTINES NOT USED
;
;FLOATING POINT NON-ZERO PAGE RAM, NEEDED ONLY IF FP IS USED
;
LBPR1  equ $057E	;1406 LBUFF PREFIX 1
LBPR2  equ $05FE	;1534 LBUFF PREFIX 2
LBUFF  equ $0580	;1408 LINE BUFFER
PLYARG equ $05E0	;1504 POLYNOMIAL ARGUMENTS
FPSCR  equ $05E6	;1510 PLYARG+FPREC
FPSCR1 equ $05EC	;1516 FPSCR+FPREC
FSCR   equ $05E6	;1510 =FPSCR
FSCR1  equ $05EC	;1516 =FPSCR1
LBFEND equ $05FF	;1535 END OF LBUFF
;
;
;	PAGE 6
;
PAGE6  equ $0600	;1536 256 FREE BYTES
;
;
;	PAGE 7
;
BOOTRG equ $0700	;1792 PROGRAM AREA
;
;
;	UPPER ADDRESSES
;
RITCAR equ $8000	;32768 RAM IF NO CARTRIDGE
LFTCAR equ $A000	;40960 RAM IF NO CARTRIDGE
;C0PAGEequ $C000	;49152 (800) EMPTY, 4K BYTES
C0PAGE equ $C000	;49152 (XL) 2K FREE RAM IF NO CARTRIDGE
;	 $C800	;51200 (XL) START OF OS ROM
CHORG2 equ $CC00	;52224 (XL) INTERNATIONAL CHARACTER SET
;
;
;	HARDWARE REGISTERS
;
;	SEE REGISTER LIST FOR MORE INFORMATION
;
HPOSP0 equ $D000	;53248  Horizontal position of player 0
HPOSP1 equ $D001	;53249  Horizontal position of player 1
HPOSP2 equ $D002	;53250  Horizontal position of player 2
HPOSP3 equ $D003	;53251  Horizontal position of player 3
HPOSM0 equ $D004	;53252  Horizontal position of missile 0
HPOSM1 equ $D005	;53253  Horizontal position of missile 1
HPOSM2 equ $D006	;53254  Horizontal position of missile 2
HPOSM3 equ $D007	;53255  Horizontal position of missile 3
M0PF   equ $D000	;53248
SIZEP0 equ $D008	;53256  Size of player 0
SIZEP1 equ $D009	;53257  Size of player 1
SIZEP2 equ $D00a	;53258  Size of player 2
SIZEP3 equ $D00b	;53259  Size of player 3
M0PL   equ $D008	;53256
SIZEM  equ $D00C	;53260
GRAFP0 equ $D00D	;53261
GRAFM  equ $D011	;53265
COLPM0 equ $D012	;53266
COLPM1 equ $D013	;53267
COLPM2 equ $D014	;53268
COLPM3 equ $D015	;53269
COLPF0 equ $D016	;53270
COLPF1 equ $D017	;53271
COLPF2 equ $D018	;53272
COLPF3 equ $D019	;53273
PRIOR  equ $D01B	;53275
GTIAR  equ $D01B	;53275
VDELAY equ $D01C	;53276
GRACTL equ $D01D	;53277
HITCLR equ $D01E	;53278
CONSOL equ $D01F	;53279
AUDF1  equ $D200	;53760
AUDC1  equ $D201	;53761
AUDCTL equ $D208	;53768
RANDOM equ $D20A	;53770
IRQEN  equ $D20E	;53774
SKCTL  equ $D20F	;53775
PORTA  equ $D300	;54016
PORTB  equ $D301	;54017
PACTL  equ $D302	;54018
PBCTL  equ $D303	;54019
DMACLT equ $D400	;54272
DLISTL equ $D402	;54274
HSCROL equ $D404	;54276
VSCROL equ $D405	;54277
CHBASE equ $D409	;54281
WSYNC  equ $D40A	;54282
VCOUNT equ $D40B	;54283
NMIEN  equ $D40E	;54286
;
;
;	FLOATING POINT MATH ROUTINES
;
AFP    equ $D800	;55296
FASC   equ $D8E6	;55526
IFP    equ $D9AA	;55722
FPI    equ $D9D2	;55762
ZFR0   equ $DA44	;55876
ZF1    equ $DA46	;55878
FSUB   equ $DA60	;55904
FADD   equ $DA66	;55910
FMUL   equ $DADB	;56027
FDIV   equ $DB28	;56104
PLYEVL equ $DD40	;56640
FLD0R  equ $DD89	;56713
FLD0P  equ $DD8D	;56717
FLD1R  equ $DD98	;56728
FLD1P  equ $DD9C	;56732
FSTOR  equ $DDA7	;56743
FSTOP  equ $DDAB	;56747
FMOVE  equ $DDB6	;56758
EXP    equ $DDC0	;56768
EXP10  equ $DDCC	;56780
LOG    equ $DECD	;57037
LOG10  equ $DED1	;57041
;
;
;	OPERATING SYSTEM
;
;	MODULE ORIGIN TABLE
;
CHORG  equ $E000	;57344 CHARACTER SET, 1K
VECTBL equ $E400	;58368 VECTOR TABLE
VCTABL equ $E480	;58496 RAM VECTOR INITIAL VALUE TABLE
CIOORG equ $E4A6	;58534 CIO HANDLER
INTORG equ $E6D5	;59093 INTERRUPT HANDLER
SIOORG equ $E944	;59716 SIO DRIVER
DSKORT equ $EDEA	;60906 DISK HANDLER
PRNORG equ $EE78	;61048 PRINTER HANDLER
CASORG equ $EE78	;61048 CASSETTE HANDLER
MONORG equ $F0E3	;61667 MONITOR/POWER UP MODULE
KBDORG equ $F3E4	;62436 KEYBOARD/DISPLAY HANDLER
;
;
;  VECTOR TABLE, CONTAINS ADDRESSES OF CIO ROUTINES IN THE
;  FOLLOWING ORDER. THE ADDRESSES IN THE TABLE ARE TRUE ADDRESSES-1
;
;  ADDRESS + 0  OPEN
;	   + 2  CLOSE
;	   + 4  GET
;	   + 6  PUT
;	   + 8  STATUS
;	   + A  SPECIAL
;	   + C  JMP TO INITIALIZATION
;	   + F  NOT USED
;
EDITRV equ $E400	;58368 EDITOR
SCRENV equ $E410	;58384 SCREEN
KEYBDV equ $E420	;58400 KEYBOARD
PRINTV equ $E430	;58416 PRINTER
CASETV equ $E440	;58432 CASSETTE
;
;	ROM VECTORS
;
DSKINV equ $E453	;58451
CIOV   equ $E456	;58454
SIOV   equ $E459	;58457
SYSVBV equ $E45F	;58463
VBIVAL equ $E460	;58464 ADR AT VVBLKI
XITVBV equ $E462	;58466 EXIT VBI
VBIXVL equ $E463	;58467 ADR AT VVBLKD
BLKBDV equ $E471	;58481 MEMO PAD MODE
WARMSV equ $E474	;58484
COLDSV equ $E477	;58487

; ******************************
; Other equates
; ******************************
COLORO equ $02C4
STORE1 equ $CB   ; Temporary 8-bit variable
STORE2 equ $CC   ; Temporary 8-bit variable
STORE3 equ $CD   ; Temporary 8-bit variable
STORE4 equ $CE   ; Temporary 8-bit variable
eol    equ $9b   ; End of Line
eof    equ $88   ; End of File
maxlen equ $ff

byte1    equ $d0
byte2    equ $d1
plotc    equ $9    ; Narysuj punkt
drawc    equ $11   ; Narysuj linie

;
DVDL=$C0 ;LOW PART OF DIVIDEND
DVDH=$C1 ;HIGH PART OF DIVIDEND 
QUOT=$C2 ;QUOTIENT
DIVS=$C3 ;DIVISOR 
;
