{ 
  Program    : Effectus - Atari MADS cross-assembler/parser for Action! language
  Version    : 0.0.17

  Project file: effectus.pas
  
  Author: Bostjan Gorisek, Slovenia

  Program compiled with Free Pascal 2.6.2
  Reference: http://www.freepascal.org/
  
  This is cource code generator for MADS Assembler, which then generates
  executable files from parser of Action! language for 8-bit Atari home
  computers
  References:
  http://mads.atari8.info/
  http://gury.atari8.info/effectus/ 
  
  This is open source and freeware project!  
}
program Effectus;
{$APPTYPE CONSOLE}

uses
  Classes, SySutils, StrUtils, Crt,
  INIfiles, Common, Decl, Core, Routines;

procedure CloseApp;
begin
  DestroyLists;
end;

procedure Parameters;
var
  i: Integer;
begin
{$ifdef Unix}
  //writeln('unix');
  meditMADS_src_dir := GetCurrentDir + '/';
  meditMADS_bin_dir := GetCurrentDir + '/';
  meditMADS_output_dir := GetCurrentDir + '/output.txt';
{$else}
  //writeln('win32');
  meditMADS_src_dir := GetCurrentDir + '\';
  meditMADS_bin_dir := GetCurrentDir + '\';
  meditMADS_output_dir := GetCurrentDir + '\output.txt';
{$endif}

  if ParamCount = 0 then
  begin
    TextColor(LightCyan);
{$ifdef Unix}
    WriteLn('Effectus ' + VERSION + ' (Linux platform console version)');
{$else}
    WriteLn('Effectus ' + VERSION + ' (i386-win32 platform console version)');
{$endif}
    WriteLn('Atari MADS cross-assembler/parser for Action! language');
    TextColor(White);
    WriteLn('Written by Bostjan Gorisek');
    WriteLn('Page URL: http://gury.atari8.info/effectus/');
    WriteLn('');
    TextColor(LightCyan);
    WriteLn('MAD Assembler (MADS) is a product written by Tebe');
    TextColor(White);
    WriteLn('Page URL: http://mads.atari8.info/');
    WriteLn('');
    TextColor(LightGreen);
    WriteLn('Usage:');    
    WriteLn('effectus <filename> <parameters>');
    WriteLn('');  
    TextColor(White);
    WriteLn('Program options:');
    TextColor(LightCyan);
    Write('-md: ');
    TextColor(LightGray);
    Writeln('MADS cross-assembler directory');
    TextColor(LightCyan);
    Write('-sa: ');
    TextColor(LightGray);
    WriteLn('Program starting address');
    TextColor(LightCyan);
    Write('-ms: ');
    TextColor(LightGray);
    WriteLn('Output source directory');
    TextColor(LightCyan);
    Write('-mb: ');
    TextColor(LightGray);
    Writeln('Output binary directory');
    TextColor(LightCyan);
    Write('-se: ');
    TextColor(LightGray);
    Writeln('Output source extension');
    TextColor(LightCyan);
    Write('-be: ');
    TextColor(LightGray);
    Writeln('Output binary extension');
    TextColor(LightCyan);
    Write('-rl: ');
    TextColor(LightGray);
    Writeln('Effectus/MADS runtime library directory');
    TextColor(LightCyan);
    Write('-lo: ');
    TextColor(LightGray);
    Writeln('Log pathname (including filename)');
    TextColor(LightCyan);
    Write('-sm: ');
    TextColor(LightGray);
    WriteLn('Machine language starting address');
    CloseApp;
    Halt(0);
  end;

  for i := 1 to ParamCount do
  begin
    if ParamStr(i)[1] <> '-' then
      meditEff_src_filename := ParamStr(i)
    else if Copy(ParamStr(i), 1, 3) = '-ms' then
      meditMADS_src_dir := Copy(ParamStr(i), 5, Length(ParamStr(i))-4)
    else if Copy(ParamStr(i), 1, 3) = '-mb' then
      meditMADS_bin_dir := Copy(ParamStr(i), 5, Length(ParamStr(i))-4)
    else if Copy(ParamStr(i), 1, 3) = '-se' then
      meditMADS_src_ext := Copy(ParamStr(i), 5, Length(ParamStr(i))-4)
    else if Copy(ParamStr(i), 1, 3) = '-be' then
      meditMADS_bin_ext := Copy(ParamStr(i), 5, Length(ParamStr(i))-4)
    else if Copy(ParamStr(i), 1, 3) = '-rl' then
      meditMADS_rtl_dir := Copy(ParamStr(i), 5, Length(ParamStr(i))-4)
    else if Copy(ParamStr(i), 1, 3) = '-lo' then
      meditMADS_output_dir := Copy(ParamStr(i), 5, Length(ParamStr(i))-4)
    else if Copy(ParamStr(i), 1, 3) = '-md' then
      meditMADS_dir := Copy(ParamStr(i), 5, Length(ParamStr(i))-4)
    else if Copy(ParamStr(i), 1, 3) = '-sa' then
      meditAddr := StrToInt(Copy(ParamStr(i), 5, Length(ParamStr(i))-4))
    else if Copy(ParamStr(i), 1, 3) = '-sm' then
      meditMLAddr := StrToInt(Copy(ParamStr(i), 5, Length(ParamStr(i))-4));
  end;      
end;

procedure CheckCfg;
begin
{$ifdef Unix}
  if not FileExists(GetCurrentDir + '/config.ini') then
  begin
    WriteLn('Configuration file is missing!');
    CloseApp;
    Halt(0)
  end;
{$else}
  if not FileExists(GetCurrentDir + '\config.ini') then
  begin
    WriteLn('Configuration file is missing!');
    CloseApp;
    Halt(0)
  end;
{$endif}
end;

var
  boolVar : Boolean = False;
  n : Integer;
begin  
  ReadCfg;
  CreateLists;
  Parameters;
  Init;
  
  //boolXY := False;
  
  lInclude := False;
  lIncFlag := True;
  
  if not ReadOrig then
  begin
    CloseApp;
    Exit;
  end;
  
  GetFuncs;
//  GetProcs;
  lIncFlag := False;
  
  GenerateCode;  
  
{$ifdef Unix}
  RunMadsLinux(meditMADS_dir, meditMADS_src_dir, meditMADS_bin_dir, meditMADS_output_dir);
{$else}
  RunMads(meditMADS_dir, meditMADS_src_dir, meditMADS_bin_dir, meditMADS_output_dir);
{$endif}

  WriteLn(mStatusLog);
  WriteLn(mStatus);

  if boolVar then
  begin
    WriteLn('');    
    WriteLn('Variables 1:');
    
    for n := 1 to GVarCnt do
      writeln(GVar[n].VarType + ' * ' + GVar[n].ParentType + ' * ' + GVar[n].OrigType + ' * ' +
              GVar[n].VarName + ' * ' + GVar[n].Value + ' * ' + GVar[n].ML_type);
    
    WriteLn('');
    WriteLn('Variables 2:');
    
    for n := 1 to GVarCnt2 do
      writeln(GVar2[n].VarType + ' * ' + GVar2[n].OrigType + ' * ' + GVar2[n].VarName + ' * ' +
              IntToStr(GVar2[n].Dim) + ' * ' + (GVar2[n].Value));
    
    WriteLn('');
    WriteLn('PROCs and FUNCs:');
    
    for n := 0 to ProcCount do
      writeln(Copy(ProcBuf[n], 5, Length(ProcBuf[n])-4));

    for n := 1 to 255 do
      if SData[n] <> '' then writeln(SData[n]);
  end;
                
  CloseApp;
end.
