{ 
  Program    : Effectus - Atari MADS cross-assembler/parser for Action! language
  Version    : 0.0.18
  
  Unit file  : decl.pas
  Description: Declaration, initialization and destruction code
  
  Author: Bostjan Gorisek, Slovenia

  Program compiled with Free Pascal 2.6.2
  Reference: http://www.freepascal.org/
  
  This is cource code generator for MADS Assembler, which then generates
  executable files from parser of Action! language for 8-bit Atari home
  computers
  References:
  http://mads.atari8.info/
  http://gury.atari8.info/effectus/ 
  
  This is open source and freeware project!
}
unit Decl;
{$ifdef FPC}{$mode objfpc}{$h+}{$endif}

interface

Uses
  SySUtils, Classes, StrUtils;

type
  { Program indicators }
  TPrgVar = record
    Pointer : Word;  // Line pointer
    SB : Byte;  // Square bracket function
    //ParamStr : Boolean;  // Used by GetParams
  end;
    
  { Variable holder }
  TVar = record
    VarType : String;
    OrigType : String;
    ParentType : String;
    VarName : String;
    Location : String;
    Value : String;
    Dim : Integer;
    InitValue : Integer;
    ML_type : String;
    Scope : Char;
  end;

  { Record holder }
  TRecPtrVar = record
    Name : String;
    Dim : Integer;
    ArrayDim : Integer;
    Flag : Boolean;
  end;
  
  { Machine language holder }
  TProcML = record
    Name : String;
    ProcType : Byte;
    Code : String;
    Address : String[5];
  end;
  
const
  VERSION  = '0.0.18';

  MAX_LINE = 255;

  _VAR_TYPES  = 4;
  _VAR_TYPES2 = 6;

  VarTypes: Array[1.._VAR_TYPES] of String[4] =
    ('BYTE', 'CARD', 'INT', 'CHAR');
    
  VarTypes2: Array[1.._VAR_TYPES2] of String[10] =
    ('BYTE ARRAY', 'CHAR ARRAY', 'CARD ARRAY', 'INT ARRAY', ' POINTER ', 'TYPE ');
      
  Operators: Array[1..20] of String[2] =
    (
     '<=',  { Bitwise or }
     '>=',  { Bitwise xor }
     '==',  { Equal (same as =) }
     '<<',  { Arithmetic shift left }
     '>>',  { Arithmetic shift right }
     '<>',  { Not equal }
     '!=',  { Not equal (same as <>) }
     '|',   { Bitwise or }
     '^',   { Bitwise xor }
     '&&',  { Logical and }
     '||',  { Logical or }
     '+',   { Addition }
     '-',   { Subtraction }
     '=',   { Equal }
     '*',   { Multiplication }
     '/',   { Division }
     '%',   { Remainder }
     '&',   { Bitwise and }
     '<',   { Less than }
     '>'    { Greater than }
    );

  NotExpr: Array[1..9] of String[6] =
    ('BYTE ', 'CARD ', 'INT ', 'CHAR ', 'FOR ', ' THEN', 'WHILE ', 'IF ', 'UNTIL ');
  
  NotVarDecl: Array[1..4] of String[9] =
    (' ARRAY ', ' POINTER ', ' FUNC ', 'PROC ');
    
  { Variable types }
  _EFF_T1 = 'BYTE';
  _EFF_T2 = 'CHAR';
  _EFF_T3 = 'INT';
  _EFF_T4 = 'CARD';
  _EFF_T5 = 'BYTE ARRAY';
  _EFF_T6 = 'CHAR ARRAY';
  _EFF_T7 = 'INT ARRAY';
  _EFF_T8 = 'CARD ARRAY';
  _EFF_T9 = 'TYPE';
  _EFF_T10 = 'POINTER';
  
  { Square bracket function }
  _SB_NULL      = 0;
  _SB_ARRAY     = 1;
  _SB_ARRAY_SET = 2;
  _SB_PROC_ML   = 3;
  _SB_TYPE      = 4;
  _SB_ML        = 5;

var
  Cnt, Cnt2, Icl, word_Cnt, cntx, ProcML_cnt : LongInt;
  MemCnt, CntML : Integer;
  f : LongInt;  { File handler }
  ASM_count: LongInt;
  TextBuf: Array[1..255*255] of String[MAX_LINE]; 
  ASM_icl: Array[1..255] of String[MAX_LINE];
  ProcBuf: TStringList;  
  fASM, fASM_lib: TextFile; { source code file handlers }
  lMainProc, WhileFlag, ForFlag, UntilFlag,
  lGraphics, lSound, lPrintF, lIO, lPrintFD, lMath, lControllers,
  lInput: Boolean;
  boolType: Boolean = False;
  lIncludeX: Boolean = False;
  SData, word_Data, ProcML_data: Array[1..255] of String[MAX_LINE];
  CR_LF, { Number of ACTION! source code lines found }
  ProcCount, ProcCount2: LongInt; { PROC statement count }
  FuncCount: LongInt; { FUNC statement count }
  lInclude, lGraphicsFlag, lGr, lIncFlag: Boolean;
  FuncList, GrProcs, SoundProcs, PrintFProcs, PrintFDProcs, ControllerProcs, IOProcs: TStringList;  
  FilenameSrc, FilenameBin, FilenameOrig: String;
  ForVar1, ForVar2, ForVar3, ForVar4: String;
  ForLabels: Array[1..255] of String[MAX_LINE];
  ForCnt, cnt_InputS: LongInt;
  SCopy_buf, InputS_buf: Array[1..255] of String[MAX_LINE];
  bool_InputS: Array[1..255] of Boolean;
  CodeBuf, StrBuf, StrBuf2, StrBuf3: TStringList;
  mValues: Array[0..10] of String[255];
  //lBoolFlag: Array[0..10] of Boolean;
  GVar, GVar2: Array[1..255] of TVar;
  ProcML: Array[1..255] of TProcML;
  GVarCnt, GVarCnt2, CurLine: LongInt;
  l_IO_error: Array[0..7] of Boolean;
  mStatusLog, mStatus: String;
  aEOF: Array[0..7] of Integer;
  meditMADS_bin_ext,
  meditMADS_src_ext,                            
  meditMADS_src_dir,
  meditMADS_rtl_dir,
  meditMADS_dir,
  meditMADS_bin_dir,
  meditMADS_output_dir: String;
  meditAddr, meditMLAddr: Integer;  
  meditEff_src_filename: String = '';
  SrcLine: String;
  boolArray: Boolean = False;
  boolPtr: Boolean = False;
  PtrCnt: Integer = 0;
  ForVar: String;
  RecPtrVar: TRecPtrVar;
  TypeMemCnt: Integer = 0;
  TypeMemDim: Integer = 0;
  boolXY: Boolean = False;
  boolSCopy: Boolean = False;
  ProcML_start: Boolean = False;
  ML_start: Boolean = False;
  ArraySet_start: Boolean = False;
  PtrData: String;
  LoopIndex, WhileIndex, UntilIndex: LongInt;
  PrgVar : TPrgVar;
  ifElseIndex : LongInt;
  
function SetType(TypeParam : String) : String;
procedure Init;
procedure CreateLists;
procedure DestroyLists;

implementation

function SetType(TypeParam : String) : String;
begin
  if UpperCase(TypeParam) = _EFF_T1 then Result := 'T1'
  else if UpperCase(TypeParam) = _EFF_T2 then Result := 'T2'
  else if UpperCase(TypeParam) = _EFF_T3 then Result := 'T3'
  else if UpperCase(TypeParam) = _EFF_T4 then Result := 'T4'
  else if UpperCase(TypeParam) = _EFF_T5 then Result := 'T5'
  else if UpperCase(TypeParam) = _EFF_T6 then Result := 'T6'
  else if UpperCase(TypeParam) = _EFF_T7 then Result := 'T7'
  else if UpperCase(TypeParam) = _EFF_T8 then Result := 'T8'
  else if UpperCase(TypeParam) = _EFF_T9 then Result := 'T9'
  else if UpperCase(TypeParam) = _EFF_T10 then Result := 'T10'
  else Result := TypeParam;
end;  

procedure Init;
var
  i : LongInt;
begin
  cntx := 1;

  FuncList.Clear;
  //ProcList.Clear;
  GrProcs.Clear;
  SoundProcs.Clear;
  PrintFProcs.Clear;
  PrintFDProcs.Clear;
  ControllerProcs.Clear;
  CodeBuf.Clear;
  StrBuf.Clear;
  StrBuf2.Clear;
  StrBuf3.Clear;
  ProcBuf.Clear;

  PrgVar.Pointer := 0;
  PrgVar.SB := _SB_NULL;

  ProcCount := 0; FuncCount := 0; ProcCount2 := 0;
  cnt_InputS := 0;
  for i := 1 to 255 do
  begin
    SData[i] := '';
    word_Data[i] := '';
    SCopy_buf[i] := '';
    InputS_buf[i] := '';
    bool_InputS[i] := False;
    
    GVar[i].VarType  := '';
    GVar[i].OrigType  := '';
    GVar[i].ParentType  := '';
    GVar[i].VarName  := '';
    GVar[i].Location := '';
    GVar[i].Value    := '';
    GVar[i].Dim      := 0;
    GVar[i].InitValue := -1;
    GVar[i].Scope := 'G';
    
    GVar2[i].VarType  := '';
    GVar2[i].ParentType  := '';
    GVar2[i].OrigType  := '';
    GVar2[i].VarName  := '';
    GVar2[i].Location := '';
    GVar2[i].Value    := '';
    GVar2[i].Dim      := 0;
    GVar2[i].Scope := 'G';
  end;

  GVarCnt := 0; GVarCnt2 := 0;
  RecPtrVar.Name := '';
  RecPtrVar.Dim := 0;
  RecPtrVar.ArrayDim := 0;
  RecPtrVar.Flag := False;

  { inititalize library variables to False }
  lGraphics := False;
  lSound := False;
  lPrintF := False;
  lIO := False;
  lPrintFD := False;
  lMath := False;
  lControllers := False;
  
  { Graphics library routines }
  GrProcs.Add('Graphics');
  GrProcs.Add('Plot');
  GrProcs.Add('DrawTo');
  GrProcs.Add('Fill');
  GrProcs.Add('Color');
  GrProcs.Add('Position');
  GrProcs.Add('Locate');

  { Sound library routines }
  SoundProcs.Add('Sound');
  SoundProcs.Add('SndRst');

  { PrintF library routines }
  PrintFProcs.Add('Print');
  PrintFProcs.Add('PrintE');
  PrintFProcs.Add('PrintB');
  PrintFProcs.Add('PrintBE');
  PrintFProcs.Add('PrintI');
  PrintFProcs.Add('PrintIE');
  PrintFProcs.Add('PrintC');
  PrintFProcs.Add('PrintCE');
  PrintFProcs.Add('PrintF');

  { I/O library routines }
  IOProcs.Add('Open');
  IOProcs.Add('Close');
  IOProcs.Add('PrintDE');
  IOProcs.Add('PrintD');
  IOProcs.Add('PutDE');
  IOProcs.Add('PutD');
  IOProcs.Add('Point');
  IOProcs.Add('Note');
  IOProcs.Add('InputSD');
  
  { Print to device routines }
  PrintFDProcs.Add('PrintBDE');
  PrintFDProcs.Add('PrintBD');
  PrintFDProcs.Add('PrintCDE');
  PrintFDProcs.Add('PrintCD');
  PrintFDProcs.Add('PrintIDE');
  PrintFDProcs.Add('PrintID');
  
  { Game controller routines }
  ControllerProcs.Add('Stick');
  ControllerProcs.Add('Strig');
  ControllerProcs.Add('Paddle');
  ControllerProcs.Add('Ptrig');
    
  for i := 0 to 7 do
  begin
    l_IO_error[i] := False;
    aEOF[i] := 0;
  end;
end;

procedure CreateLists;
begin
  CodeBuf := TStringList.Create;
  FuncList := TStringList.Create;
  //ProcList := TStringList.Create;
  GrProcs := TStringList.Create;
  SoundProcs := TStringList.Create;
  PrintFProcs := TStringList.Create;
  IOProcs := TStringList.Create;
  PrintFDProcs := TStringList.Create;
  ControllerProcs := TStringList.Create;
  StrBuf := TStringList.Create;
  StrBuf2 := TStringList.Create;
  StrBuf3 := TStringList.Create;
  ProcBuf := TStringList.Create;  
end;

procedure DestroyLists;
begin
  FuncList.Free;
//  ProcList.Free;
  GrProcs.Free;
  SoundProcs.Free;
  PrintFProcs.Free;
  PrintFDProcs.Free;
  ControllerProcs.Free;
  CodeBuf.Free;
  StrBuf.Free;
  StrBuf2.Free;
  StrBuf3.Free;
  ProcBuf.Free;
  IOProcs.Free
end;

end.