/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Enumeration;
import java.util.Vector;

public class NVC {
    Vector<String> inputFiles;
    String suffix;
    final String[] invalid_names = new String[]{"PRN", "AUX", "CON", "NUL"};

    public static void main(String[] args) {
        if (args.length == 3) {
            NVC nvc = new NVC();
            nvc.restructure(args[0], args[1], args[2]);
        } else {
            System.out.println("Usage:\njava NVC from to suffix");
        }
    }

    void restructure(String from, String to, String su) {
        try {
            this.suffix = su;
            this.inputFiles = new Vector();
            this.getFileList(new File(from));
            Enumeration<String> e = this.inputFiles.elements();
            while (e.hasMoreElements()) {
                File input_file = new File(e.nextElement());
                String input_file_name = input_file.getName().toUpperCase();
                int input_file_name_length = input_file_name.length();
                StringBuffer output_path = new StringBuffer(to);
                StringBuffer tmp = new StringBuffer();
                int i = 0;
                int j = 0;
                while (i < input_file_name_length && j < 3) {
                    if (Character.isLetterOrDigit(input_file_name.charAt(i))) {
                        output_path.append('/');
                        tmp.append(input_file_name.charAt(i));
                        int inv = 0;
                        while (inv < this.invalid_names.length) {
                            if (tmp.toString().compareToIgnoreCase(this.invalid_names[inv]) == 0) {
                                tmp.append('_');
                            }
                            ++inv;
                        }
                        output_path.append(tmp);
                        ++j;
                    }
                    ++i;
                }
                File output_dir = new File(output_path.toString());
                output_dir.mkdirs();
                output_path.append('/');
                output_path.append(input_file_name);
                System.out.println(output_path);
                File output_file = new File(output_path.toString());
                output_file.createNewFile();
                this.BinFileCopy(input_file, output_file);
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            System.exit(1);
        }
    }

    private void getFileList(File f) throws Exception {
        if (!f.isDirectory()) {
            String tmp = f.getName();
            if (tmp.endsWith(this.suffix)) {
                this.inputFiles.add(f.getPath());
            }
        } else {
            File[] fList = f.listFiles();
            int i = 0;
            while (i < fList.length) {
                this.getFileList(fList[i]);
                ++i;
            }
        }
    }

    private void BinFileCopy(File inputFile, File outputFile) throws Exception {
        int count;
        FileInputStream in = new FileInputStream(inputFile);
        FileOutputStream out = new FileOutputStream(outputFile);
        byte[] b = new byte[65535];
        while ((count = in.read(b)) != -1) {
            out.write(b, 0, count);
        }
        in.close();
        out.close();
    }
}

