/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.thecart.common;

import com.wudsn.thecart.common.CoreException;
import com.wudsn.thecart.common.FileUtility;
import com.wudsn.thecart.common.ResourceUtility;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public final class Application {
    public static final String UNKNOWN_VERSION = "????-??-?? ??:??:??";
    private static Application instance = new Application();
    private String urlString;
    private String jarFileName;
    private String versionPath;

    static {
        Application.instance.urlString = "http://www.wudsn.com/productions/atari8000/thecartstudio/thecartstudio.zip";
        Application.instance.jarFileName = "TheCartStudio.jar";
        Application.instance.versionPath = "com/wudsn/thecart/TheCartStudio.version";
    }

    private Application() {
    }

    public static Application getInstance() {
        return instance;
    }

    public String getWebVersion() {
        String result;
        block14: {
            URL url;
            result = UNKNOWN_VERSION;
            try {
                url = new URL(this.urlString);
            }
            catch (MalformedURLException ex) {
                throw new RuntimeException(ex);
            }
            InputStream urlInputStream = null;
            ZipInputStream zipInputStream = null;
            try {
                ZipEntry zipEntry;
                urlInputStream = url.openStream();
                zipInputStream = new ZipInputStream(urlInputStream);
                ZipEntry jarZipEntry = null;
                while (jarZipEntry == null && (zipEntry = zipInputStream.getNextEntry()) != null) {
                    if (!zipEntry.getName().equals(this.jarFileName)) continue;
                    jarZipEntry = zipEntry;
                }
                if (jarZipEntry != null) {
                    JarInputStream jarInputStream = new JarInputStream(zipInputStream);
                    String versionResource = null;
                    while (versionResource == null && (zipEntry = jarInputStream.getNextEntry()) != null) {
                        if (!zipEntry.getName().equals(this.versionPath)) continue;
                        try {
                            versionResource = FileUtility.readString(this.versionPath, jarInputStream, 0x100000L);
                            result = versionResource.trim();
                        }
                        catch (CoreException coreException) {
                            // empty catch block
                        }
                    }
                }
            }
            catch (IOException ex) {
                if (zipInputStream != null) {
                    try {
                        zipInputStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (urlInputStream == null) break block14;
                try {
                    urlInputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    public String getLocalVersion() {
        String result = ResourceUtility.loadResourceAsString(this.versionPath);
        if (result == null) {
            result = UNKNOWN_VERSION;
        }
        result = result.trim();
        return result;
    }
}

