/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.thecart.common;

public final class HexUtility {
    public static final int AUTOMATIC_LENGTH = 0;
    private static final String[] hexStrings = new String[256];

    static {
        int i = 0;
        while (i < 256) {
            String s = Integer.toHexString(i).toUpperCase();
            HexUtility.hexStrings[i] = s.length() < 2 ? "0" + s : s;
            ++i;
        }
    }

    private HexUtility() {
    }

    public static String getByteValueHexString(int byteValue) {
        if (byteValue < 0 || byteValue > 255) {
            throw new IllegalArgumentException("Integer value " + byteValue + " is no byte value.");
        }
        return hexStrings[byteValue];
    }

    public static int getLongValueHexLength(long longValue) {
        if (longValue < 0L) {
            throw new RuntimeException("Parameter 'longValue' must not be negative. Specified value is " + longValue + ".");
        }
        int result = Long.toHexString(longValue).length();
        if ((result & 1) == 1) {
            ++result;
        }
        return result;
    }

    public static String getLongValueHexString(long longValue) {
        return HexUtility.getLongValueHexString(longValue, HexUtility.getLongValueHexLength(longValue));
    }

    public static String getLongValueHexString(long longValue, int length) {
        int difference;
        if (longValue < 0L) {
            throw new RuntimeException("Parameter 'longValue' must not be negative. Specified value is " + longValue + ".");
        }
        if (length < 0) {
            throw new IllegalArgumentException("Parameter 'length' must not be negative. Specified value is " + length + ".");
        }
        String result = Long.toHexString(longValue).toUpperCase();
        if (length > 0 && (difference = length - result.length()) > 0) {
            StringBuilder builder = new StringBuilder(length);
            int i = 0;
            while (i < difference) {
                builder.append('0');
                ++i;
            }
            builder.insert(difference, result);
            result = builder.toString();
        }
        return result;
    }

    public static char getChar(int byteValue) {
        char result = byteValue >= 32 && byteValue <= 127 ? (char)(byteValue & 0xFF) : (char)' ';
        return result;
    }
}

