/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.thecart.common;

import com.wudsn.thecart.common.TextUtility;

public abstract class Log {
    private Log() {
    }

    public static void logInfo(String message, Object[] parameters) {
        if (message == null) {
            throw new IllegalArgumentException("Parameter 'message' must not be null.");
        }
        message = Log.format(message, parameters);
        System.out.println(message);
    }

    public static void logError(String message, Object[] parameters, Throwable th) {
        if (message == null) {
            throw new IllegalArgumentException("Parameter 'message' must not be null.");
        }
        message = Log.format(message, parameters);
        if (th != null) {
            message = String.valueOf(message) + "\n" + th.getMessage();
        }
        System.err.println("ERROR: " + message);
        if (th != null) {
            th.printStackTrace(System.err);
            System.err.flush();
        }
    }

    private static String format(String message, Object ... parameters) {
        if (parameters == null) {
            parameters = new String[]{};
        }
        String[] stringParameters = new String[parameters.length];
        int i = 0;
        while (i < parameters.length) {
            Object parameter = parameters[i];
            String stringParameter = parameter == null ? "null" : parameter.toString();
            stringParameters[i] = stringParameter;
            ++i;
        }
        message = TextUtility.format(message, stringParameters);
        return message;
    }
}

