/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.thecart.common;

import com.wudsn.thecart.common.MessageQueueEntry;
import com.wudsn.thecart.common.MessageQueueRenderer;
import com.wudsn.thecart.repository.Attribute;
import com.wudsn.thecart.repository.Message;
import java.util.ArrayList;
import java.util.List;

public final class MessageQueue {
    private MessageQueueRenderer renderer = null;
    private List<MessageQueueEntry> entries = new ArrayList<MessageQueueEntry>();
    private boolean entriesChanged;
    private MessageQueueEntry firstErrorStatus;
    private MessageQueueEntry firstInfoStatus;

    public void setMessageQueueRenderer(MessageQueueRenderer renderer) {
        this.renderer = renderer;
    }

    public void clear() {
        this.entries.clear();
        this.entriesChanged = false;
        this.firstErrorStatus = null;
        this.firstInfoStatus = null;
    }

    public void sendMessage(Object owner, Attribute attribute, Message message, String ... parameters) {
        if (message == null) {
            throw new IllegalArgumentException("Parameter 'message' must not be null.");
        }
        MessageQueueEntry messageQueueEntry = new MessageQueueEntry(owner, attribute, message, parameters);
        this.sendMessage(messageQueueEntry);
    }

    public void sendMessage(MessageQueueEntry messageQueueEntry) {
        if (messageQueueEntry == null) {
            throw new IllegalArgumentException("Parameter 'status' must not be null.");
        }
        if (this.renderer != null && messageQueueEntry.getMessage().getSeverity() == 1) {
            this.renderer.displayStatusMessage(messageQueueEntry);
        } else {
            this.entries.add(messageQueueEntry);
            this.entriesChanged = true;
            if (this.firstErrorStatus == null && messageQueueEntry.getMessage().getSeverity() == 3) {
                this.firstErrorStatus = messageQueueEntry;
            }
            if (this.firstInfoStatus == null && messageQueueEntry.getMessage().getSeverity() == 2) {
                this.firstInfoStatus = messageQueueEntry;
            }
        }
    }

    public boolean containsError() {
        return this.firstErrorStatus != null;
    }

    public boolean areEntriesChanged() {
        boolean result = this.entriesChanged;
        this.entriesChanged = false;
        return result;
    }

    public MessageQueueEntry getFirstError() {
        return this.firstErrorStatus;
    }

    public boolean containsInfo() {
        return this.firstInfoStatus != null;
    }

    public MessageQueueEntry getFirstInfo() {
        return this.firstInfoStatus;
    }

    public List<MessageQueueEntry> getEntries() {
        return this.entries;
    }
}

