/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.thecart.common;

import com.wudsn.thecart.repository.Attribute;
import com.wudsn.thecart.repository.Message;

public final class MessageQueueEntry {
    private Object owner;
    private Attribute attribute;
    private int severity;
    private Message message;
    private String[] parameters;
    private Exception cause;

    public MessageQueueEntry(Object owner, Attribute attribute, Message message, String ... parameters) {
        if (message == null) {
            throw new IllegalArgumentException("Parameter 'message' must not be null.");
        }
        this.owner = owner;
        this.attribute = attribute;
        this.message = message;
        this.parameters = parameters;
        this.cause = null;
    }

    public Object getOwner() {
        return this.owner;
    }

    public Attribute getAttribute() {
        return this.attribute;
    }

    public Message getMessage() {
        return this.message;
    }

    public String getMessageText() {
        return this.message.format(this.parameters);
    }

    public Exception getCause() {
        return this.cause;
    }

    public String toString() {
        String messageText = this.getMessageText();
        switch (this.severity) {
            case 1: {
                return "INFO: " + messageText;
            }
            case 2: {
                return "INFO: " + messageText;
            }
            case 3: {
                return "ERROR: " + messageText;
            }
        }
        throw new IllegalStateException("Field 'severity' has illegal value " + this.severity + ".");
    }
}

