/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.thecart.common;

import com.wudsn.thecart.common.HexUtility;
import java.text.NumberFormat;

public final class TextUtility {
    private static final String[] PARAMETERS = new String[]{"{0}", "{1}", "{2}", "{3}", "{4}", "{5}", "{6}", "{7}", "{8}", "{9}"};

    private TextUtility() {
    }

    public static String format(String text, String ... parameters) {
        if (text == null) {
            throw new IllegalArgumentException("Parameter 'text' must not be null.");
        }
        if (parameters == null) {
            parameters = new String[]{};
        }
        int i = 0;
        while (i < parameters.length) {
            String parameter = parameters[i];
            if (parameter == null) {
                parameter = "";
            }
            text = text.replace(PARAMETERS[i], parameter);
            ++i;
        }
        return text;
    }

    public static String formatAsDecimal(long number) {
        return NumberFormat.getNumberInstance().format(number);
    }

    public static String formatAsDecimalPercent(long number, long totalNumber) {
        int percent = 0;
        if (totalNumber > 0L) {
            percent = (int)(1.0 * (double)number / (double)totalNumber * 100.0);
            if (number > 0L && percent == 0) {
                percent = 1;
            }
        }
        return String.valueOf(TextUtility.formatAsDecimal(percent)) + "%";
    }

    public static String formatAsMemorySize(long number) {
        String suffix = "B";
        if (number > 0L) {
            if (number % 0x100000L == 0L) {
                number /= 0x100000L;
                suffix = "MB";
            } else if (number % 1024L == 0L) {
                number /= 1024L;
                suffix = "KB";
            }
        }
        return String.valueOf(NumberFormat.getNumberInstance().format(number)) + " " + suffix;
    }

    public static String formatAsHexaDecimal(long number, long maxValue) {
        int length = Long.toHexString(maxValue).length();
        String result = "$" + HexUtility.getLongValueHexString(number, length);
        return result;
    }
}

