/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.thecart.console;

import com.wudsn.thecart.console.ConsoleCommandParameter;
import com.wudsn.thecart.repository.Action;
import com.wudsn.thecart.repository.Attribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class ConsoleCommand {
    private Action action;
    private String actionCommand;
    private List<ConsoleCommandParameter> parameters;
    private List<ConsoleCommandParameter> unmodifiableParameters;

    ConsoleCommand(Action action, String actionCommand) {
        if (action == null) {
            throw new IllegalArgumentException("Parameter 'action' must not be null.");
        }
        if (actionCommand == null) {
            throw new IllegalArgumentException("Parameter 'actionCommand' must not be null.");
        }
        this.action = action;
        this.actionCommand = actionCommand;
        this.parameters = new ArrayList<ConsoleCommandParameter>();
        this.unmodifiableParameters = Collections.unmodifiableList(this.parameters);
    }

    public void addParameter(Attribute attribute, int cardinality) {
        if (attribute == null) {
            throw new IllegalArgumentException("Parameter 'attribute' must not be null.");
        }
        this.parameters.add(new ConsoleCommandParameter(attribute, cardinality));
    }

    public Action getAction() {
        return this.action;
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    public List<ConsoleCommandParameter> getParameters() {
        return this.unmodifiableParameters;
    }
}

