/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.thecart.directory;

import com.wudsn.thecart.directory.CSVReader;
import com.wudsn.thecart.directory.DirectoryEntry;
import com.wudsn.thecart.directory.DirectoryLevel;
import com.wudsn.thecart.directory.DirectoryRecord;
import com.wudsn.thecart.directory.DirectoryWriter;
import com.wudsn.thecart.directory.HTMLWriter;
import com.wudsn.thecart.directory.RecordTitleComparator;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public final class Directory {
    public static final int RECORD_ID_OFFSET = 256;
    public static final int BANKS_FOR_BANK_AND_OFFSET = 3;
    private String indexedCharacters = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    private List<DirectoryRecord> records = new ArrayList<DirectoryRecord>();
    private int totalTitleLength;
    private int maximumTitleLength;
    private Set<String> allWordsSet = new TreeSet<String>();
    private int allWordsTotalLength;
    private int allWordsMaximumLength;
    private List<DirectoryLevel> levels = new ArrayList<DirectoryLevel>();
    private int bankSize = 8192;
    private int totalBankCount;
    private int totalPaddingBytes;

    public String getIndexedCharacters() {
        return this.indexedCharacters;
    }

    public void readRecords(String path, String titleColumnName) {
        if (path == null) {
            throw new IllegalArgumentException("Parameter 'path' must not be null.");
        }
        if (titleColumnName == null) {
            throw new IllegalArgumentException("Parameter 'titleColumnName' must not be null.");
        }
        this.records.clear();
        this.totalTitleLength = 0;
        this.maximumTitleLength = 0;
        this.allWordsSet.clear();
        this.allWordsTotalLength = 0;
        this.allWordsMaximumLength = 0;
        this.levels.clear();
        this.totalBankCount = 0;
        this.totalPaddingBytes = 0;
        CSVReader csvReader = new CSVReader();
        csvReader.open(new File(path), ',', Charset.defaultCharset().name());
        int titleIndex = csvReader.getColumnIndex(titleColumnName);
        StringBuilder builder = new StringBuilder();
        TreeMap<String, DirectoryRecord> allWordsMap = new TreeMap<String, DirectoryRecord>();
        while (csvReader.readNextRow()) {
            DirectoryRecord directoryRecord = new DirectoryRecord();
            String title = csvReader.getColumnValue(titleIndex);
            directoryRecord.setTitle(title);
            int titleLength = title.length();
            if (titleLength == 0) continue;
            this.totalTitleLength += titleLength;
            if (titleLength > this.maximumTitleLength) {
                this.maximumTitleLength = titleLength;
            }
            List<String> words = directoryRecord.getWords();
            int i = 0;
            while (i < titleLength) {
                char c = title.charAt(i);
                if (this.indexedCharacters.indexOf(c = Character.toUpperCase(c)) >= 0) {
                    builder.append(c);
                } else if (builder.length() > 0) {
                    words.add(builder.toString());
                    builder.setLength(0);
                }
                ++i;
            }
            if (builder.length() > 0) {
                words.add(builder.toString());
                builder.setLength(0);
            }
            Collections.sort(words);
            this.records.add(directoryRecord);
            for (String word : words) {
                if (this.allWordsSet.contains(word)) continue;
                this.allWordsSet.add(word);
                allWordsMap.put(word, directoryRecord);
                int wordLength = word.length();
                this.allWordsTotalLength += wordLength;
                if (wordLength <= this.allWordsMaximumLength) continue;
                this.allWordsMaximumLength = wordLength;
            }
        }
        Collections.sort(this.records, new RecordTitleComparator());
        int i = 0;
        while (i < this.records.size()) {
            this.records.get(i).setId(i + 256);
            ++i;
        }
    }

    public int getTotalTitleLength() {
        return this.totalTitleLength;
    }

    public int getMaximumTitleLength() {
        return this.maximumTitleLength;
    }

    public Set<String> getAllWordsSet() {
        return this.allWordsSet;
    }

    public int getAllWordsTotalLength() {
        return this.allWordsTotalLength;
    }

    public int getAllWordsMaximumLength() {
        return this.allWordsMaximumLength;
    }

    public List<DirectoryRecord> getRecords() {
        return this.records;
    }

    public void createLevels() {
        DirectoryLevel root = new DirectoryLevel();
        root.getWords().addAll(this.allWordsSet);
        root.getRecords().addAll(this.records);
        root.createChildren(this, 1);
    }

    DirectoryLevel createLevel() {
        DirectoryLevel level = new DirectoryLevel();
        this.levels.add(level);
        level.setId(this.levels.size());
        return level;
    }

    public List<DirectoryLevel> getLevels() {
        return this.levels;
    }

    public int writeAsBinary(String path) throws IOException {
        if (path == null) {
            throw new IllegalArgumentException("Parameter 'path' must not be null.");
        }
        FileOutputStream outputStream = new FileOutputStream(String.valueOf(path) + ".dir");
        DirectoryWriter directoryWriter = new DirectoryWriter();
        try {
            this.writeBanksAndOffsetsAsBinary(this.records, directoryWriter);
            this.writeBanksAndOffsetsAsBinary(this.levels, directoryWriter);
            for (DirectoryRecord record : this.records) {
                record.writeAsBinary(directoryWriter);
            }
            for (DirectoryLevel level : this.levels) {
                level.writeAsBinary(directoryWriter);
            }
            outputStream.write(directoryWriter.toByteArray());
            outputStream.close();
        }
        finally {
            try {
                outputStream.close();
            }
            catch (IOException iOException) {}
        }
        return directoryWriter.toByteArray().length;
    }

    private void writeBanksAndOffsetsAsBinary(List<? extends DirectoryEntry> entries, DirectoryWriter directoryWriter) {
        if (entries == null) {
            throw new IllegalArgumentException("Parameter 'entries' must not be null.");
        }
        if (directoryWriter == null) {
            throw new IllegalArgumentException("Parameter 'directoryWriter' must not be null.");
        }
        int paddingBytes = this.bankSize - entries.size();
        for (DirectoryEntry directoryEntry : entries) {
            directoryWriter.writeByte(directoryEntry.getOffset() & 0xFF);
        }
        directoryWriter.writePaddingBytes(paddingBytes);
        for (DirectoryEntry directoryEntry : entries) {
            directoryWriter.writeByte(directoryEntry.getOffset() >>> 8);
        }
        directoryWriter.writePaddingBytes(paddingBytes);
        for (DirectoryEntry directoryEntry : entries) {
            directoryWriter.writeByte(directoryEntry.getBank());
        }
        directoryWriter.writePaddingBytes(paddingBytes);
    }

    public void writeAsHTML(String path) throws IOException {
        FileOutputStream outputStream = new FileOutputStream(String.valueOf(path) + ".html");
        try {
            OutputStreamWriter writer = new OutputStreamWriter(outputStream);
            HTMLWriter htmlWriter = new HTMLWriter();
            htmlWriter.beginTable(true);
            htmlWriter.beginTableRow();
            htmlWriter.writeTableHeader("ID");
            htmlWriter.writeTableHeader("Bank");
            htmlWriter.writeTableHeader("Offset");
            htmlWriter.writeTableHeader("Raw Size");
            htmlWriter.writeTableHeader("Padding");
            htmlWriter.writeTableHeader("Title");
            htmlWriter.writeTableHeader("Words");
            htmlWriter.end();
            for (DirectoryRecord record : this.records) {
                htmlWriter.begin("tr", "id=\"record_" + record.getIdString() + "\"");
                record.writeAsHTML(htmlWriter);
                htmlWriter.end();
            }
            htmlWriter.end();
            htmlWriter.beginTable(true);
            htmlWriter.beginTableRow();
            htmlWriter.writeTableHeader("ID");
            htmlWriter.writeTableHeader("Bank");
            htmlWriter.writeTableHeader("Offset");
            htmlWriter.writeTableHeader("Raw Size");
            htmlWriter.writeTableHeader("Padding");
            htmlWriter.writeTableHeader("Prefix");
            htmlWriter.writeTableHeader("Children");
            htmlWriter.writeTableHeader("Records Count");
            htmlWriter.writeTableHeader("Records");
            htmlWriter.end();
            for (DirectoryLevel level : this.levels) {
                htmlWriter.begin("tr", "id=\"level_" + level.getIdString() + "\"");
                level.writeAsHTML(htmlWriter);
                htmlWriter.end();
            }
            htmlWriter.end();
            writer.write(htmlWriter.toHTML());
            writer.close();
        }
        finally {
            try {
                outputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public void alignToBankSize(int bankSize) {
        int paddingBytes;
        int newOffset;
        this.bankSize = bankSize;
        int offset = 0;
        int bank = 0;
        this.totalPaddingBytes = 0;
        DirectoryEntry lastEntry = null;
        for (DirectoryRecord record : this.records) {
            newOffset = offset + record.getRawSize();
            if (newOffset < bankSize) {
                record.setBankAndOffset(bank, offset);
                offset = newOffset;
            } else {
                paddingBytes = bankSize - offset;
                lastEntry.setPaddingBytes(paddingBytes);
                this.totalPaddingBytes += paddingBytes;
                record.setBankAndOffset(++bank, 0);
                offset = record.getRawSize();
            }
            lastEntry = record;
        }
        for (DirectoryLevel level : this.levels) {
            newOffset = offset + level.getRawSize();
            if (newOffset < bankSize) {
                level.setBankAndOffset(bank, offset);
                offset = newOffset;
            } else {
                paddingBytes = bankSize - offset;
                lastEntry.setPaddingBytes(paddingBytes);
                this.totalPaddingBytes += paddingBytes;
                level.setBankAndOffset(++bank, 0);
                offset = level.getRawSize();
            }
            lastEntry = level;
        }
        if (lastEntry != null && offset != 0) {
            paddingBytes = bankSize - offset;
            lastEntry.setPaddingBytes(paddingBytes);
            this.totalPaddingBytes += paddingBytes;
        }
        this.totalBankCount = bank;
    }

    public int getBankSize() {
        return this.bankSize;
    }

    public int getTotalBankCount() {
        return this.totalBankCount + 6;
    }

    public int getTotalPaddingBytes() {
        return this.totalPaddingBytes;
    }
}

