/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.thecart.gui;

import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public final class DynamicMenuItemList {
    private JMenu menu;
    private int startIndex;
    private int itemCount;

    public DynamicMenuItemList(JMenu menu) {
        if (menu == null) {
            throw new IllegalArgumentException("Parameter 'menu' must not be null.");
        }
        this.menu = menu;
        this.startIndex = menu.getItemCount();
        this.itemCount = 0;
    }

    public void setMenuItems(List<JMenuItem> menuItems, boolean enabled) {
        int i;
        if (menuItems == null) {
            throw new IllegalArgumentException("Parameter 'menuItems' must not be null.");
        }
        if (this.itemCount > 0) {
            i = 0;
            while (i < this.itemCount + 1) {
                this.menu.remove(this.startIndex);
                ++i;
            }
        }
        this.itemCount = menuItems.size();
        if (this.itemCount > 0) {
            this.menu.insertSeparator(this.startIndex);
            i = 0;
            while (i < this.itemCount) {
                JMenuItem menuItem = menuItems.get(i);
                menuItem.setEnabled(enabled);
                this.menu.insert(menuItem, this.startIndex + 1 + i);
                ++i;
            }
        }
    }
}

