/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.thecart.gui;

import com.wudsn.thecart.common.TextUtility;
import java.text.NumberFormat;
import java.text.ParsePosition;
import javax.swing.JTextField;

public final class MemorySizeField
extends JTextField {
    public void setValue(int value) {
        this.setText(TextUtility.formatAsMemorySize(value));
    }

    public int getValue() {
        ParsePosition parsePosition;
        String text = this.getText();
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        Number number = numberFormat.parse(text, parsePosition = new ParsePosition(0));
        if (number == null) {
            return 0;
        }
        int result = number.intValue();
        String suffix = text.substring(parsePosition.getIndex()).trim().toUpperCase();
        if (suffix.equals("KB")) {
            result *= 1024;
        } else if (suffix.equals("MB")) {
            result *= 0x100000;
        }
        return result;
    }
}

