/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.thecart.model;

import com.wudsn.thecart.common.DateUtility;
import com.wudsn.thecart.common.FileUtility;
import com.wudsn.thecart.common.MessageQueue;
import com.wudsn.thecart.common.XMLUtility;
import com.wudsn.thecart.model.Language;
import com.wudsn.thecart.repository.Attribute;
import java.awt.Dimension;
import java.awt.Point;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public final class Preferences {
    private static final String FOLDER_NAME = ".tcs";
    private static final String FILE_NAME = "preferences.xml";
    public static final int MAX_HISTORY_SIZE = 5;
    private File file = this.file.getAbsoluteFile();
    private Language language = Language.DEFAULT;
    private int mainWindowExtendedState;
    private Point mainWindowLocation = null;
    private Dimension mainWindowSize = new Dimension(640, 480);
    private String lastWorkbookFolderPath = "";
    private String lastEntryFolderPath = "";
    private String lastExportFolderPath = "";
    List<String> recentWorkbookFilePathsList = new ArrayList<String>();
    Map<String, String> layoutProperties = new TreeMap<String, String>();

    public void setLanguage(Language language) {
        if (language == null) {
            throw new IllegalArgumentException("Parameter 'locale' must not be null.");
        }
        this.language = language;
    }

    public Language getLanguage() {
        return this.language;
    }

    public Locale getLocale() {
        Language language = this.language;
        if (language.equals(Language.DEFAULT)) {
            String userLanguage = System.getProperty("user.language");
            language = userLanguage.toLowerCase().startsWith("de") ? Language.DE : Language.EN;
        }
        Locale result = language.equals(Language.DE) ? Locale.GERMAN : Locale.ENGLISH;
        return result;
    }

    public void setMainWindowExtendedState(int mainWindowExtendedState) {
        this.mainWindowExtendedState = mainWindowExtendedState;
    }

    public int getMainWindowExtendedState() {
        return this.mainWindowExtendedState;
    }

    public void setMainWindowLocation(Point mainWindowLocation) {
        if (mainWindowLocation == null) {
            throw new IllegalArgumentException("Parameter 'mainWindowLocation' must not be null.");
        }
        this.mainWindowLocation = mainWindowLocation;
    }

    public Point getMainWindowLocation() {
        return this.mainWindowLocation;
    }

    public void setMainWindowSize(Dimension mainWindowSize) {
        if (mainWindowSize == null) {
            throw new IllegalArgumentException("Parameter 'mainWindowSize' must not be null.");
        }
        this.mainWindowSize = mainWindowSize;
    }

    public Dimension getMainWindowSize() {
        return this.mainWindowSize;
    }

    public void setLastWorkbookFolderPath(String folderPath) {
        if (folderPath == null) {
            throw new IllegalArgumentException("Parameter 'folderPath' must not be null.");
        }
        this.lastWorkbookFolderPath = folderPath;
    }

    public String getLastWorkbookFolderPath() {
        return this.lastWorkbookFolderPath;
    }

    public void setLastEntryFolderPath(String folderPath) {
        if (folderPath == null) {
            throw new IllegalArgumentException("Parameter 'folderPath' must not be null.");
        }
        this.lastEntryFolderPath = folderPath;
    }

    public String getLastEntryFolderPath() {
        return this.lastEntryFolderPath;
    }

    public void setLastExportFolderPath(String folderPath) {
        if (folderPath == null) {
            throw new IllegalArgumentException("Parameter 'folderPath' must not be null.");
        }
        this.lastExportFolderPath = folderPath;
    }

    public String getLastExportFolderPath() {
        return this.lastExportFolderPath;
    }

    public List<String> getRecentWorkbookFilePathsList() {
        return Collections.unmodifiableList(this.recentWorkbookFilePathsList);
    }

    public Map<String, String> getLayoutProperties() {
        return this.layoutProperties;
    }

    public void updateRecentWorkBookFileList(File file) {
        if (file == null) {
            throw new IllegalArgumentException("Parameter 'file' must not be null.");
        }
        if (file.getName().isEmpty()) {
            return;
        }
        String filePath = FileUtility.getAbsolutePath(file.getPath());
        int index = this.recentWorkbookFilePathsList.indexOf(filePath);
        if (index != -1) {
            this.recentWorkbookFilePathsList.remove(index);
        }
        this.recentWorkbookFilePathsList.add(0, filePath);
        int i = this.recentWorkbookFilePathsList.size() - 1;
        while (i >= 5) {
            this.recentWorkbookFilePathsList.remove(i);
            --i;
        }
    }

    public void open(MessageQueue messageQueue) {
        if (messageQueue == null) {
            throw new IllegalArgumentException("Parameter 'messageQueue' must not be null.");
        }
        if (!this.file.exists()) {
            return;
        }
        if (!this.file.canRead()) {
            return;
        }
        XMLUtility.open(this.file, new XMLHandler(this), messageQueue);
    }

    public void save(MessageQueue messageQueue) {
        if (messageQueue == null) {
            throw new IllegalArgumentException("Parameter 'messageQueue' must not be null.");
        }
        XMLUtility.save(this.file, new XMLHandler(this), messageQueue);
    }

    public String toString() {
        return "lastWorkbookFolderPath=" + this.lastWorkbookFolderPath + " lastEntryFolderPath=" + this.lastEntryFolderPath + " lastExportFolderPath=" + this.lastExportFolderPath + " recentWorkbookFilePathsList=" + this.recentWorkbookFilePathsList;
    }

    private static final class Attributes {
        public static final Attribute LANGUAGE = new Attribute("language");
        public static final Attribute LAST_WORKBOOK_FOLDER_PATH = new Attribute("lastWorkbookFolderPath");
        public static final Attribute LAST_ENTRY_FOLDER_PATH = new Attribute("lastEntryFolderPath");
        public static final Attribute LAST_EXPORT_FOLDER_PATH = new Attribute("lastExportFolderPath");
        public static final Attribute MAIN_WINDOW_EXTENDED_STATE = new Attribute("mainWindowExtendedState");
        public static final Attribute MAIN_WINDOW_LOCATION = new Attribute("mainWindowLocation");
        public static final Attribute MAIN_WINDOW_SIZE = new Attribute("mainWindowSize");
        public static final Attribute FILE_PATH = new Attribute("filePath");
        public static final Attribute PROPERTY_KEY = new Attribute("key");
        public static final Attribute PROPERTY_VALUE = new Attribute("value");

        private Attributes() {
        }
    }

    private static final class XMLElements {
        public static final String PREFERENCES = "preferences";
        public static final String RECENT_WORKBOOK = "recentWorkoook";
        public static final String LAYOUT_PROPERTIES = "layoutProperties";

        private XMLElements() {
        }
    }

    private static final class XMLHandler
    extends com.wudsn.thecart.common.XMLHandler {
        private Preferences preferences;

        public XMLHandler(Preferences preferences) {
            if (preferences == null) {
                throw new IllegalArgumentException("Parameter 'preferences' must not be null.");
            }
            this.preferences = preferences;
        }

        @Override
        public void startOpen(MessageQueue messageQueue) {
            if (messageQueue == null) {
                throw new IllegalArgumentException("Parameter 'messageQueue' must not be null.");
            }
            this.preferences.recentWorkbookFilePathsList.clear();
        }

        @Override
        public void startElement(String uri, String localName, String qName, org.xml.sax.Attributes attributes) throws SAXException {
            if (qName == null) {
                throw new IllegalArgumentException("Parameter 'qName' must not be null.");
            }
            if (attributes == null) {
                throw new IllegalArgumentException("Parameter 'attributes' must not be null.");
            }
            if (qName.equals("preferences")) {
                String value;
                Dimension mainWindowSize;
                Language language = Attributes.LANGUAGE.deserializeValueSet(attributes, Language.class);
                if (language != null) {
                    this.preferences.setLanguage(language);
                }
                int mainWindowExtendedState = Attributes.MAIN_WINDOW_EXTENDED_STATE.deserializeInteger(attributes);
                this.preferences.setMainWindowExtendedState(mainWindowExtendedState);
                Point mainWindowLocation = Attributes.MAIN_WINDOW_LOCATION.deserializePoint(attributes);
                if (mainWindowLocation != null) {
                    this.preferences.setMainWindowLocation(mainWindowLocation);
                }
                if ((mainWindowSize = Attributes.MAIN_WINDOW_SIZE.deserializeDimension(attributes)) != null) {
                    this.preferences.setMainWindowSize(mainWindowSize);
                }
                if ((value = Attributes.LAST_WORKBOOK_FOLDER_PATH.deserializeString(attributes)) != null) {
                    this.preferences.setLastWorkbookFolderPath(value);
                }
                if ((value = Attributes.LAST_ENTRY_FOLDER_PATH.deserializeString(attributes)) != null) {
                    this.preferences.setLastEntryFolderPath(value);
                }
                if ((value = Attributes.LAST_EXPORT_FOLDER_PATH.deserializeString(attributes)) != null) {
                    this.preferences.setLastExportFolderPath(value);
                }
            } else if (qName.equals("recentWorkoook")) {
                List<String> recentWorkBookFilePathsList = this.preferences.recentWorkbookFilePathsList;
                String value = Attributes.FILE_PATH.deserializeString(attributes);
                if (value != null && recentWorkBookFilePathsList.size() < 5) {
                    recentWorkBookFilePathsList.add(value);
                }
            } else if (qName.equals("layoutProperties")) {
                Map<String, String> layoutProperties = this.preferences.layoutProperties;
                String key = Attributes.PROPERTY_KEY.deserializeString(attributes);
                String value = Attributes.PROPERTY_VALUE.deserializeString(attributes);
                if (key != null) {
                    layoutProperties.put(key, value);
                }
            }
        }

        @Override
        public void startSave(Document document, MessageQueue messageQueue) {
            if (document == null) {
                throw new IllegalArgumentException("Parameter 'document' must not be null.");
            }
            if (messageQueue == null) {
                throw new IllegalArgumentException("Parameter 'messageQueue' must not be null.");
            }
            String dateTime = DateUtility.getCurrentDateTimeString();
            Comment comment = document.createComment("The!Cart Studio Preferences - " + dateTime);
            document.appendChild(comment);
            Element rootElement = document.createElement("preferences");
            document.appendChild(rootElement);
            Attributes.LANGUAGE.serializeValueSet(rootElement, this.preferences.getLanguage());
            Attributes.MAIN_WINDOW_EXTENDED_STATE.serializeInteger(rootElement, this.preferences.getMainWindowExtendedState());
            Attributes.MAIN_WINDOW_LOCATION.serializePoint(rootElement, this.preferences.getMainWindowLocation());
            Attributes.MAIN_WINDOW_SIZE.serializeDimension(rootElement, this.preferences.getMainWindowSize());
            Attributes.LAST_WORKBOOK_FOLDER_PATH.serializeString(rootElement, this.preferences.getLastWorkbookFolderPath());
            Attributes.LAST_ENTRY_FOLDER_PATH.serializeString(rootElement, this.preferences.getLastEntryFolderPath());
            Attributes.LAST_EXPORT_FOLDER_PATH.serializeString(rootElement, this.preferences.getLastExportFolderPath());
            for (String filePath : this.preferences.getRecentWorkbookFilePathsList()) {
                Element recentWorkbookElement = document.createElement("recentWorkoook");
                rootElement.appendChild(recentWorkbookElement);
                Attributes.FILE_PATH.serializeString(recentWorkbookElement, filePath);
            }
            for (String key : this.preferences.getLayoutProperties().keySet()) {
                Element layoutPropertiesElement = document.createElement("layoutProperties");
                rootElement.appendChild(layoutPropertiesElement);
                Attributes.PROPERTY_KEY.serializeString(layoutPropertiesElement, key);
                Attributes.PROPERTY_VALUE.serializeString(layoutPropertiesElement, this.preferences.getLayoutProperties().get(key));
            }
        }
    }
}

