/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.thecart.model;

import com.wudsn.thecart.Messages;
import com.wudsn.thecart.Texts;
import com.wudsn.thecart.common.MessageQueue;
import com.wudsn.thecart.model.CartridgeMenu;
import com.wudsn.thecart.model.CartridgeMenuType;
import com.wudsn.thecart.model.CartridgeType;
import com.wudsn.thecart.model.ReservedContentProvider;
import com.wudsn.thecart.model.Workbook;
import com.wudsn.thecart.model.WorkbookRoot;

public final class ReservedContentProviderFactory {

    public static final class CheckSumContentProvider
    extends ReservedContentProvider {
        @Override
        public void init(WorkbookRoot root) {
            if (root == null) {
                throw new IllegalArgumentException("Parameter 'root' must not be null.");
            }
            int requiredBanksCount = 0;
            if (root.getCartridgeType().isIncrementalFlashingSupported()) {
                requiredBanksCount = 16;
            }
            this.init(Texts.ReservedContentProvider_CheckSums, 8192, 16, requiredBanksCount, true);
        }

        @Override
        public byte[] createContent(Workbook workbook, MessageQueue messageQueue) {
            return null;
        }
    }

    public static final class MenuContentProvider
    extends ReservedContentProvider {
        private CartridgeMenu cartridgeMenu;

        @Override
        public void init(WorkbookRoot root) {
            int requiredBanksCount;
            int bankSize;
            if (root == null) {
                throw new IllegalArgumentException("Parameter 'root' must not be null.");
            }
            CartridgeMenuType cartridgeMenuType = root.getCartridgeMenuType();
            this.cartridgeMenu = CartridgeMenu.createInstance(cartridgeMenuType);
            if (cartridgeMenuType == CartridgeMenuType.NONE) {
                bankSize = root.getBankSize();
                requiredBanksCount = 0;
            } else if (cartridgeMenuType == CartridgeMenuType.SIMPLE || cartridgeMenuType == CartridgeMenuType.EXTENDED) {
                bankSize = 8192;
                requiredBanksCount = 16;
            } else {
                throw new RuntimeException("Unknown cartridge menu type '" + cartridgeMenuType + "'.");
            }
            this.init(Texts.ReservedContentProvider_Menu, bankSize, 0, requiredBanksCount, true);
        }

        @Override
        public byte[] createContent(Workbook workbook, MessageQueue messageQueue) {
            if (workbook == null) {
                throw new IllegalArgumentException("Parameter 'workbook' must not be null.");
            }
            if (messageQueue == null) {
                throw new IllegalArgumentException("Parameter 'messageQueue' must not be null.");
            }
            WorkbookRoot root = workbook.getRoot();
            if (root.getCartridgeMenuType() == CartridgeMenuType.NONE) {
                return null;
            }
            if (!this.cartridgeMenu.isValid()) {
                messageQueue.sendMessage(root, WorkbookRoot.Attributes.CARTRDIGE_MENU_TYPE, Messages.E420, this.cartridgeMenu.getCartridgeMenuType().getText());
                return null;
            }
            byte[] result = this.cartridgeMenu.getContent(workbook, messageQueue);
            return result;
        }
    }

    public static final class MenuEntriesContentProvider
    extends ReservedContentProvider {
        @Override
        public void init(WorkbookRoot root) {
            if (root == null) {
                throw new IllegalArgumentException("Parameter 'root' must not be null.");
            }
            UserSpaceContentProvider userSpaceContentProvider = new UserSpaceContentProvider();
            userSpaceContentProvider.init(root);
            int requiredBanksCount = 0;
            if (root.getCartridgeMenuType() == CartridgeMenuType.EXTENDED) {
                int genresBankCount = 1;
                int entriesPerBank = root.getBankSize() / 64;
                requiredBanksCount = genresBankCount + (root.getBankCount() + entriesPerBank - 1) / entriesPerBank;
            }
            int startBankNumber = userSpaceContentProvider.getStartBankNumber() - requiredBanksCount;
            startBankNumber = Math.max(0, startBankNumber);
            this.init(Texts.ReservedContentProvider_MenuEntries, 8192, startBankNumber, requiredBanksCount, true);
        }

        @Override
        public byte[] createContent(Workbook workbook, MessageQueue messageQueue) {
            if (workbook == null) {
                throw new IllegalArgumentException("Parameter 'workbook' must not be null.");
            }
            if (messageQueue == null) {
                throw new IllegalArgumentException("Parameter 'messageQueue' must not be null.");
            }
            if (this.requiredBanksCount == 0) {
                return null;
            }
            int bankSize = workbook.getRoot().getBankSize();
            int requiredSize = this.requiredBanksCount * bankSize;
            byte[] result = new byte[requiredSize];
            CartridgeMenu.setMenuEntriesContent(workbook, result, messageQueue);
            return result;
        }
    }

    public static final class MenuStartupContentProvider
    extends ReservedContentProvider {
        private byte[] startupBankContent;

        @Override
        public void init(WorkbookRoot root) {
            if (root == null) {
                throw new IllegalArgumentException("Parameter 'root' must not be null.");
            }
            CartridgeMenuType cartridgeMenuType = root.getCartridgeMenuType();
            int bankSize = root.getBankSize();
            int requiredBanksCount = 0;
            if (cartridgeMenuType != CartridgeMenuType.NONE && (root.getCartridgeType().equals(CartridgeType.CARTRIDGE_ATMAX_128) || root.getCartridgeType().equals(CartridgeType.CARTRIDGE_ATMAX_1024))) {
                requiredBanksCount = 1;
                this.startupBankContent = new byte[bankSize];
                int[] nArray = new int[16];
                nArray[0] = 169;
                nArray[2] = 141;
                nArray[4] = 213;
                nArray[5] = 108;
                nArray[6] = 254;
                nArray[7] = 191;
                nArray[8] = 234;
                nArray[9] = 234;
                nArray[10] = 240;
                nArray[11] = 191;
                nArray[13] = 4;
                nArray[14] = 240;
                nArray[15] = 191;
                int[] startupCode = nArray;
                int offset = bankSize - startupCode.length;
                int i = 0;
                while (i < startupCode.length) {
                    this.startupBankContent[offset + i] = (byte)startupCode[i];
                    ++i;
                }
            }
            this.init(Texts.ReservedContentProvider_MenuStartup, bankSize, root.getBankCount() - requiredBanksCount, requiredBanksCount, true);
        }

        @Override
        public byte[] createContent(Workbook workbook, MessageQueue messageQueue) {
            return this.startupBankContent;
        }
    }

    public static final class UserSpaceContentProvider
    extends ReservedContentProvider {
        @Override
        public void init(WorkbookRoot root) {
            if (root == null) {
                throw new IllegalArgumentException("Parameter 'workbook' must not be null.");
            }
            MenuStartupContentProvider menuStartupContentProvider = new MenuStartupContentProvider();
            menuStartupContentProvider.init(root);
            int requiredBanksCount = root.getUserSpaceBanksCount();
            int startBankNumber = menuStartupContentProvider.getStartBankNumber() - requiredBanksCount;
            if (startBankNumber < 0) {
                startBankNumber = 0;
            }
            this.init(Texts.ReservedContentProvider_UserSpace, 0, startBankNumber, requiredBanksCount, false);
        }

        @Override
        public byte[] createContent(Workbook workbook, MessageQueue messageQueue) {
            return null;
        }
    }
}

