/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.thecart.model;

import com.wudsn.thecart.DataTypes;
import com.wudsn.thecart.model.ReservedContentProvider;
import com.wudsn.thecart.model.WorkbookEntry;
import com.wudsn.thecart.repository.Attribute;
import java.util.ArrayList;
import java.util.List;

public final class WorkbookBank {
    public static final byte UNUSED_BYTE = -1;
    private int number;
    private ReservedContentProvider reservedContentProvider;
    private List<WorkbookEntry> entries;

    WorkbookBank(int number) {
        if (number < 0) {
            throw new IllegalArgumentException("Bank number must not be negative. Specified value is " + number + ".");
        }
        this.number = number;
        this.reservedContentProvider = null;
        this.entries = new ArrayList<WorkbookEntry>();
    }

    public int getNumber() {
        return this.number;
    }

    public boolean isReserved() {
        return this.reservedContentProvider != null;
    }

    final void setReservedContentProvider(ReservedContentProvider reservedContentProvider) {
        this.reservedContentProvider = reservedContentProvider;
    }

    public ReservedContentProvider getReservedContentProvider() {
        return this.reservedContentProvider;
    }

    public List<WorkbookEntry> getEntries() {
        return this.entries;
    }

    public boolean isUsed() {
        return this.isReserved() || !this.entries.isEmpty();
    }

    public String toString() {
        return "number=" + this.number + " reservedContentProvider=[" + this.reservedContentProvider + "] entries=" + this.entries.toString();
    }

    public static final class Attributes {
        public static final String ELEMENT_NAME = "bank";
        public static final Attribute NUMBER = new Attribute("number", DataTypes.WorkbookBank_Number);

        private Attributes() {
        }
    }
}

