/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.thecart.model;

import com.wudsn.thecart.DataTypes;
import com.wudsn.thecart.Messages;
import com.wudsn.thecart.common.CoreException;
import com.wudsn.thecart.common.HexUtility;
import com.wudsn.thecart.common.StringUtility;
import com.wudsn.thecart.model.ContentType;
import com.wudsn.thecart.model.DisplayMode;
import com.wudsn.thecart.model.FileHeaderType;
import com.wudsn.thecart.model.WorkbookEntryType;
import com.wudsn.thecart.repository.Attribute;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public final class WorkbookEntry
implements Comparable<WorkbookEntry> {
    public static final int START_BANK_UNDEFINED = -1;
    public static final int TITLE_LENGTH = Attributes.TITLE.getDataType().getMaximumLength();
    private WorkbookEntryType type = WorkbookEntryType.FILE_ENTRY;
    private String title = "";
    private String genreName = "";
    private boolean favorite = false;
    private transient String filePath = "";
    private String fileName = "";
    private long fileSize = 0L;
    private FileHeaderType fileHeaderType = FileHeaderType.NONE;
    private int contentCRC32 = 0;
    private ContentType contentType = ContentType.UNKNOWN;
    private DisplayMode displayMode = DisplayMode.SINGLE_ENTRY;
    private String parameters = "";
    private transient List<Parameter> parametersList = null;
    private boolean startBankFixed;
    private int startBankNumber = -1;
    private int requiredBanksCount = 0;
    private transient boolean alignmentBanksCountValid = false;
    private transient int alignmentBanksCount = 0;
    private transient boolean banksAssigned = false;

    WorkbookEntry() {
    }

    public WorkbookEntryType getType() {
        return this.type;
    }

    public void setType(WorkbookEntryType type) {
        if (type == null) {
            throw new IllegalArgumentException("Parameter 'type' must not be null.");
        }
        this.type = type;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        if (title == null) {
            throw new IllegalArgumentException("Parameter 'title' must not be null.");
        }
        title = title.trim();
        int maximumLength = Attributes.TITLE.getDataType().getMaximumLength();
        if (title.length() > maximumLength) {
            title = title.substring(0, maximumLength);
        }
        this.title = title;
    }

    public String getGenreName() {
        return this.genreName;
    }

    public void setGenreName(String genreName) {
        if (genreName == null) {
            throw new IllegalArgumentException("Parameter 'genreName' must not be null.");
        }
        this.genreName = genreName;
    }

    public boolean isFavorite() {
        return this.favorite;
    }

    public void setFavoriteSelected(boolean favorite) {
        this.favorite = favorite;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        if (filePath == null) {
            throw new IllegalArgumentException("Parameter 'filePath' must not be null.");
        }
        this.filePath = filePath;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException("Parameter 'fileName' must not be null.");
        }
        this.fileName = fileName;
    }

    public String getInstanceString() {
        return String.valueOf(this.title) + " (" + this.filePath + ")";
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public void setFileSize(long fileSize) {
        this.fileSize = fileSize;
    }

    public FileHeaderType getFileHeaderType() {
        return this.fileHeaderType;
    }

    public void setFileHeaderType(FileHeaderType fileHeaderType) {
        if (fileHeaderType == null) {
            throw new IllegalArgumentException("Parameter 'fileHeaderType' must not be null.");
        }
        this.fileHeaderType = fileHeaderType;
    }

    public long getContentSize() {
        return this.fileSize - (long)this.fileHeaderType.getHeaderSize();
    }

    public int getContentCRC32() {
        return this.contentCRC32;
    }

    public void setContentCRC32(int contentCRC32) {
        this.contentCRC32 = contentCRC32;
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    public void setContentType(ContentType contentType) {
        if (contentType == null) {
            throw new IllegalArgumentException("Parameter 'contentType' must not be null.");
        }
        this.contentType = contentType;
        this.alignmentBanksCountValid = false;
    }

    public DisplayMode getDisplayMode() {
        return this.displayMode;
    }

    public void setDisplayMode(DisplayMode displayMode) {
        if (displayMode == null) {
            throw new IllegalArgumentException("Parameter 'displayMode' must not be null.");
        }
        this.displayMode = displayMode;
    }

    public void setParameters(String parameters) {
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter 'parameters' must not be null.");
        }
        this.parameters = parameters;
        this.parametersList = null;
    }

    public String getParameters() {
        return this.parameters;
    }

    public void setParametersList(List<Parameter> parametersList) {
        this.parametersList = parametersList;
    }

    public List<Parameter> getParametersList() {
        return this.parametersList;
    }

    public boolean isStartBankFixed() {
        return this.startBankFixed;
    }

    public void setStartBankFixed(boolean startBankFixed) {
        this.startBankFixed = startBankFixed;
    }

    public int getStartBankNumber() {
        return this.startBankNumber;
    }

    public void setStartBankNumber(int startBank) {
        this.startBankNumber = startBank;
    }

    public int getRequiredBanksCount() {
        return this.requiredBanksCount;
    }

    public void setRequiredBanksCount(int requiredBanks) {
        this.requiredBanksCount = requiredBanks;
        this.alignmentBanksCountValid = false;
    }

    public int getAlignmentBanksCount() {
        if (!this.alignmentBanksCountValid) {
            if (this.contentType == ContentType.UNKNOWN || this.contentType == ContentType.FILE_BINARY || this.contentType == ContentType.FILE_EXECUTABLE) {
                this.alignmentBanksCount = 1;
            }
            this.alignmentBanksCount = Integer.highestOneBit(this.requiredBanksCount);
            if (this.alignmentBanksCount != Integer.lowestOneBit(this.requiredBanksCount)) {
                this.alignmentBanksCount <<= 1;
            }
            if (this.alignmentBanksCount == 0) {
                this.alignmentBanksCount = 1;
            }
            this.alignmentBanksCountValid = true;
        }
        return this.alignmentBanksCount;
    }

    public boolean areBanksAssigned() {
        return this.banksAssigned;
    }

    public void setBanksAssigned(boolean banksAssigned) {
        this.banksAssigned = banksAssigned;
    }

    final void serialize(Element element) {
        if (element == null) {
            throw new IllegalArgumentException("Parameter 'element' must not be null.");
        }
        Attributes.TYPE.serializeValueSet(element, this.getType());
        Attributes.TITLE.serializeString(element, this.getTitle());
        Attributes.GENRE_NAME.serializeString(element, this.getGenreName());
        Attributes.FAVORITE_INDICATOR.serializeBoolean(element, this.isFavorite());
        Attributes.FILE_NAME.serializeString(element, this.getFileName());
        Attributes.FILE_SIZE.serializeLong(element, this.getFileSize());
        Attributes.FILE_HEADER_TYPE.serializeValueSet(element, this.getFileHeaderType());
        Attributes.CONTENT_CRC32.serializeLongAsHex(element, (long)this.getContentCRC32() & 0xFFFFFFFFL);
        Attributes.CONTENT_TYPE.serializeValueSet(element, this.getContentType());
        Attributes.DISPLAY_MODE.serializeValueSet(element, this.getDisplayMode());
        Attributes.PARAMETERS.serializeString(element, this.getParameters());
        Attributes.START_BANK_FIXED_INDICATOR.serializeBoolean(element, this.isStartBankFixed());
        Attributes.START_BANK.serializeInteger(element, this.getStartBankNumber());
        Attributes.REQUIRED_BANKS_COUNT.serializeInteger(element, this.getRequiredBanksCount());
    }

    final void deserialize(org.xml.sax.Attributes attributes) throws SAXException {
        String value;
        if (attributes == null) {
            throw new IllegalArgumentException("Parameter 'attributes' must not be null.");
        }
        WorkbookEntryType type = Attributes.TYPE.deserializeValueSet(attributes, WorkbookEntryType.class);
        if (type != null) {
            this.setType(type);
        }
        if ((value = Attributes.TITLE.deserializeString(attributes)) != null) {
            this.setTitle(value);
        }
        if ((value = Attributes.GENRE_NAME.deserializeString(attributes)) != null) {
            this.setGenreName(value);
        }
        this.setFavoriteSelected(Attributes.FAVORITE_INDICATOR.deserializeBoolean(attributes));
        value = Attributes.FILE_NAME.deserializeString(attributes);
        if (value != null) {
            this.setFileName(value);
        }
        this.setFileSize(Attributes.FILE_SIZE.deserializeLong(attributes));
        FileHeaderType fileHeaderType = Attributes.FILE_HEADER_TYPE.deserializeValueSet(attributes, FileHeaderType.class);
        if (fileHeaderType != null) {
            this.setFileHeaderType(fileHeaderType);
        }
        this.setContentCRC32((int)Attributes.CONTENT_CRC32.deserializeLongAsHex(attributes));
        ContentType contentType = Attributes.CONTENT_TYPE.deserializeValueSet(attributes, ContentType.class);
        if (contentType != null) {
            this.setContentType(contentType);
        }
        if ((value = attributes.getValue(Attributes.DISPLAY_MODE.getName())) != null) {
            if (value.equals("SINGLE_ENTRY_WITH_INDEX")) {
                value = DisplayMode.SINGLE_ENTRY.getId();
            } else if (value.equals("MANY_ENTRIES")) {
                value = DisplayMode.MULTIPLE_ENTRIES.getId();
            }
            DisplayMode displayMode = DisplayMode.getInstance(value);
            if (displayMode != null) {
                this.setDisplayMode(displayMode);
            }
        }
        if ((value = Attributes.PARAMETERS.deserializeString(attributes)) != null) {
            this.setParameters(value);
        }
        this.setStartBankFixed(Attributes.START_BANK_FIXED_INDICATOR.deserializeBoolean(attributes));
        this.setStartBankNumber(Attributes.START_BANK.deserializeInteger(attributes));
        this.setRequiredBanksCount(Attributes.REQUIRED_BANKS_COUNT.deserializeInteger(attributes));
    }

    public String toString() {
        return "type=" + this.type + " title=" + this.title + " filePath=" + this.filePath + " contentType=" + this.contentType + " fileSize=" + this.fileSize + " displayMode=" + this.displayMode + " startBankFixed=" + this.startBankFixed + " startBankNumber=" + this.startBankNumber + " requiredBanksCount=" + this.requiredBanksCount + " banksAssigned=" + this.banksAssigned;
    }

    public WorkbookEntry createCopy() {
        WorkbookEntry result = new WorkbookEntry();
        result.type = this.type;
        result.title = this.title;
        result.genreName = this.genreName;
        result.filePath = this.filePath;
        result.contentType = this.contentType;
        result.fileSize = this.fileSize;
        result.displayMode = this.displayMode;
        result.startBankNumber = this.startBankNumber;
        result.requiredBanksCount = this.requiredBanksCount;
        return result;
    }

    public boolean equals(WorkbookEntry other) {
        if (other == null) {
            throw new IllegalArgumentException("Parameter 'other' must not be null.");
        }
        return other.type.equals(this.type) && other.title.equals(this.title) && other.genreName.equals(this.genreName) && other.filePath.equals(this.filePath) && other.fileSize == this.fileSize && other.contentType.equals(this.contentType) && other.displayMode.equals(this.displayMode) && other.startBankNumber == this.startBankNumber && other.requiredBanksCount == this.requiredBanksCount;
    }

    @Override
    public int compareTo(WorkbookEntry o) {
        return this.getTitle().compareToIgnoreCase(o.getTitle());
    }

    public static final class Attributes {
        public static final String ELEMENT_NAME = "entry";
        public static final Attribute ID = new Attribute("id", DataTypes.WorkbookEntry_Id);
        public static final Attribute TYPE = new Attribute("type", DataTypes.WorkbookEntry_Type);
        public static final Attribute TITLE = new Attribute("title", DataTypes.WorkbookEntry_Title);
        public static final Attribute GENRE_NAME = new Attribute("genreName", DataTypes.WorkbookEntry_GenreName);
        public static final Attribute FAVORITE_INDICATOR = new Attribute("favoriteIndicator", DataTypes.WorkbookEntry_FavoriteIndicator);
        public static final Attribute FILE_PATH = new Attribute("filePath", DataTypes.WorkbookEntry_FilePath);
        public static final Attribute FILE_NAME = new Attribute("fileName", DataTypes.WorkbookEntry_FileName);
        public static final Attribute FILE_SIZE = new Attribute("fileSize", DataTypes.WorkbookEntry_FileSize);
        public static final Attribute FILE_HEADER_TYPE = new Attribute("fileHeaderType", DataTypes.WorkbookEntry_FileHeaderType);
        public static final Attribute CONTENT_SIZE = new Attribute("contentSize", DataTypes.WorkbookEntry_ContentSize);
        public static final Attribute CONTENT_CRC32 = new Attribute("contentCRC32", DataTypes.WorkbookEntry_ContentCRC32);
        public static final Attribute CONTENT_TYPE = new Attribute("contentType", DataTypes.WorkbookEntry_ContentType);
        public static final Attribute DISPLAY_MODE = new Attribute("displayMode", DataTypes.WorkbookEntry_DisplayMode);
        public static final Attribute PARAMETERS = new Attribute("parameters", DataTypes.WorkbookEntry_Parameters);
        public static final Attribute START_BANK_FIXED_INDICATOR = new Attribute("startBankFixedIndicator", DataTypes.WorkbookEntry_StartBankFixedIndicator);
        public static final Attribute START_BANK = new Attribute("startBankNumber", DataTypes.WorkbookEntry_StartBankNumber);
        public static final Attribute REQUIRED_BANKS_COUNT = new Attribute("requiredBanksCount", DataTypes.WorkbookEntry_RequiredBanksCount);
        public static final Attribute BANKS_ASSIGNED_INDICATOR = new Attribute("banksAssignedIndicator", DataTypes.WorkbookEntry_BanksAssignedIndicator);

        private Attributes() {
        }
    }

    public static final class Parameter
    implements Comparable<Parameter> {
        public final String key;
        public final String value;

        public Parameter(int key, String value) {
            this("$" + HexUtility.getLongValueHexString(key), value);
        }

        public Parameter(String key, int value) {
            this(key, "$" + HexUtility.getLongValueHexString(value));
        }

        public Parameter(String key, String value) {
            if (key == null) {
                throw new IllegalArgumentException("Parameter 'key' must not be null.");
            }
            if (StringUtility.isEmpty(key)) {
                throw new IllegalArgumentException("Parameter 'key' must not be empty.");
            }
            if (value == null) {
                throw new IllegalArgumentException("Parameter 'value' must not be null.");
            }
            if (StringUtility.isEmpty(value)) {
                throw new IllegalArgumentException("Parameter 'value' must not be empty.");
            }
            this.key = key.trim().toLowerCase();
            this.value = value.trim().toLowerCase();
        }

        public boolean isKeyInteger() {
            return this.isInteger(this.key);
        }

        public int getKeyAsInteger() {
            if (this.isKeyInteger()) {
                return Integer.parseInt(this.key.substring(1), 16);
            }
            return -1;
        }

        public boolean isValueInteger() {
            return this.isInteger(this.value);
        }

        public int getValueAsInteger() {
            if (this.isValueInteger()) {
                return Integer.parseInt(this.value.substring(1), 16);
            }
            return -1;
        }

        private boolean isInteger(String value) {
            if (value == null) {
                throw new IllegalArgumentException("Parameter 'value' must not be null.");
            }
            if (!value.startsWith("$")) {
                return false;
            }
            try {
                int result = Integer.parseInt(value.substring(1), 16);
                return result >= 0;
            }
            catch (NumberFormatException ignore) {
                return false;
            }
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        public boolean equals(Object o) {
            return this.key.equals(((Parameter)o).key);
        }

        @Override
        public int compareTo(Parameter o) {
            if (!this.isKeyInteger() && o.isKeyInteger()) {
                return -1;
            }
            if (this.isKeyInteger() && !o.isKeyInteger()) {
                return 1;
            }
            if (this.isKeyInteger()) {
                return this.getKeyAsInteger() - o.getKeyAsInteger();
            }
            return this.value.compareTo(o.value);
        }

        public String toString() {
            return String.valueOf(this.key) + "=" + this.value;
        }

        public static String getParametersString(List<Parameter> parameters) {
            if (parameters == null) {
                throw new IllegalArgumentException("Parameter 'parameters' must not be null.");
            }
            StringBuilder builder = new StringBuilder();
            for (Parameter parameter : parameters) {
                if (builder.length() > 0) {
                    builder.append(", ");
                }
                builder.append(parameter.key);
                builder.append("=");
                builder.append(parameter.value);
            }
            return builder.toString().toLowerCase();
        }

        public static List<Parameter> getParametersList(String parameters) throws CoreException {
            String[] parts;
            if (parameters == null) {
                throw new IllegalArgumentException("Parameter 'parameters' must not be null.");
            }
            ArrayList<Parameter> result = new ArrayList<Parameter>();
            String[] stringArray = parts = parameters.split(",");
            int n = parts.length;
            int n2 = 0;
            while (n2 < n) {
                String part = stringArray[n2];
                if (StringUtility.isSpecified(part)) {
                    String[] keyAndValue = part.split("=");
                    if (keyAndValue.length != 2) {
                        throw new CoreException(Messages.E424, part);
                    }
                    Parameter parameter = new Parameter(keyAndValue[0], keyAndValue[1]);
                    if (!parameter.isValid()) {
                        throw new CoreException(Messages.E424, part);
                    }
                    result.add(parameter);
                }
                ++n2;
            }
            return result;
        }

        private boolean isValid() {
            return this.isKeyInteger() ^ this.isValueInteger();
        }
    }
}

