/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.thecart.repository;

import com.wudsn.thecart.common.StringUtility;
import com.wudsn.thecart.repository.DataType;
import com.wudsn.thecart.repository.ValueSet;
import java.awt.Dimension;
import java.awt.Point;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public final class Attribute {
    private String name;
    private DataType dataType;

    public Attribute(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Parameter 'name' must not be null.");
        }
        this.name = name;
        this.dataType = null;
    }

    public Attribute(String name, DataType dataType) {
        if (name == null) {
            throw new IllegalArgumentException("Parameter 'name' must not be null.");
        }
        if (dataType == null) {
            throw new IllegalArgumentException("Parameter 'dataType' must not be null.");
        }
        this.name = name;
        this.dataType = dataType;
    }

    public String getName() {
        return this.name;
    }

    public DataType getDataType() {
        if (this.dataType == null) {
            throw new IllegalStateException("Attribute " + this.name + " has no data type.");
        }
        return this.dataType;
    }

    public void serializeBoolean(Element element, boolean value) {
        if (element == null) {
            throw new IllegalArgumentException("Parameter 'element' must not be null.");
        }
        element.setAttribute(this.name, Boolean.toString(value));
    }

    public boolean deserializeBoolean(Attributes attributes) {
        if (attributes == null) {
            throw new IllegalArgumentException("Parameter 'attributes' must not be null.");
        }
        String value = attributes.getValue(this.name);
        boolean result = false;
        if (value != null) {
            result = Boolean.parseBoolean(value);
        }
        return result;
    }

    public void serializeInteger(Element element, int value) {
        if (element == null) {
            throw new IllegalArgumentException("Parameter 'element' must not be null.");
        }
        element.setAttribute(this.name, Integer.toString(value));
    }

    private static int deserializeInteger(Attributes attributes, String name) throws SAXException {
        if (attributes == null) {
            throw new IllegalArgumentException("Parameter 'attributes' must not be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter 'name' must not be null.");
        }
        String value = attributes.getValue(name);
        int result = 0;
        if (value != null) {
            try {
                result = Integer.parseInt(value);
            }
            catch (NumberFormatException ex) {
                throw new SAXException("Attribute '" + name + "' cannot be deserialized, value '" + value + "' is not an integer.");
            }
        }
        return result;
    }

    public int deserializeInteger(Attributes attributes) throws SAXException {
        if (attributes == null) {
            throw new IllegalArgumentException("Parameter 'attributes' must not be null.");
        }
        return Attribute.deserializeInteger(attributes, this.name);
    }

    public void serializeLong(Element element, long value) {
        if (element == null) {
            throw new IllegalArgumentException("Parameter 'element' must not be null.");
        }
        element.setAttribute(this.name, Long.toString(value));
    }

    public long deserializeLong(Attributes attributes) throws SAXException {
        if (attributes == null) {
            throw new IllegalArgumentException("Parameter 'attributes' must not be null.");
        }
        String value = attributes.getValue(this.name);
        long result = 0L;
        if (value != null) {
            try {
                result = Long.parseLong(value);
            }
            catch (NumberFormatException ex) {
                throw new SAXException("Attribute '" + this.name + "' cannot be deserialized, value '" + value + "' is not a long.");
            }
        }
        return result;
    }

    public void serializeLongAsHex(Element element, long value) {
        if (element == null) {
            throw new IllegalArgumentException("Parameter 'element' must not be null.");
        }
        element.setAttribute(this.name, Long.toString(value, 16).toUpperCase());
    }

    public long deserializeLongAsHex(Attributes attributes) throws SAXException {
        if (attributes == null) {
            throw new IllegalArgumentException("Parameter 'attributes' must not be null.");
        }
        String value = attributes.getValue(this.name);
        long result = 0L;
        if (value != null) {
            try {
                result = Long.parseLong(value, 16);
            }
            catch (NumberFormatException ex) {
                throw new SAXException("Attribute '" + this.name + "' cannot be deserialized, value '" + value + "' is not a long.");
            }
        }
        return result;
    }

    public void serializeString(Element element, String value) {
        if (element == null) {
            throw new IllegalArgumentException("Parameter 'element' must not be null.");
        }
        if (value != null) {
            element.setAttribute(this.name, value);
        } else {
            element.removeAttribute(this.name);
        }
    }

    public String deserializeString(Attributes attributes) {
        if (attributes == null) {
            throw new IllegalArgumentException("Parameter 'attributes' must not be null.");
        }
        String result = attributes.getValue(this.name);
        return result;
    }

    public void serializeValueSet(Element element, ValueSet value) {
        if (element == null) {
            throw new IllegalArgumentException("Parameter 'element' must not be null.");
        }
        if (value == null) {
            throw new IllegalArgumentException("Parameter 'value' must not be null.");
        }
        element.setAttribute(this.name, value.getId());
    }

    public <E extends ValueSet> E deserializeValueSet(Attributes attributes, Class<E> valueSetClass) throws SAXException {
        if (attributes == null) {
            throw new IllegalArgumentException("Parameter 'attributes' must not be null.");
        }
        if (valueSetClass == null) {
            throw new IllegalArgumentException("Parameter 'valueSetClass' must not be null.");
        }
        String value = attributes.getValue(this.name);
        ValueSet result = null;
        if (value != null && StringUtility.isSpecified(value)) {
            try {
                Method getInstanceMethod = valueSetClass.getMethod("getInstance", String.class);
                Object objectResult = getInstanceMethod.invoke(null, value);
                result = (ValueSet)objectResult;
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
            catch (IllegalArgumentException ex) {
                throw new RuntimeException(ex);
            }
            catch (InvocationTargetException ex) {
                throw new RuntimeException(ex);
            }
            catch (NoSuchMethodException ex) {
                throw new RuntimeException(ex);
            }
            catch (SecurityException ex) {
                throw new RuntimeException(ex);
            }
            if (result == null) {
                throw new SAXException("Unknown value set id '" + value + "' for value set '" + valueSetClass.getName() + "' of atribute '" + this.name + "'.");
            }
        }
        return (E)result;
    }

    public void serializeDimension(Element element, Dimension value) {
        if (element == null) {
            throw new IllegalArgumentException("Parameter 'element' must not be null.");
        }
        String widthName = String.valueOf(this.name) + ".width";
        String heightName = String.valueOf(this.name) + ".height";
        if (value != null) {
            element.setAttribute(widthName, Integer.toString(value.width));
            element.setAttribute(heightName, Integer.toString(value.height));
        } else {
            element.removeAttribute(widthName);
            element.removeAttribute(heightName);
        }
    }

    public Dimension deserializeDimension(Attributes attributes) throws SAXException {
        String widthName = String.valueOf(this.name) + ".width";
        String heightName = String.valueOf(this.name) + ".height";
        Dimension result = null;
        if (attributes.getValue(widthName) != null && attributes.getValue(heightName) != null) {
            result = new Dimension();
            result.width = Attribute.deserializeInteger(attributes, widthName);
            result.height = Attribute.deserializeInteger(attributes, heightName);
        }
        return result;
    }

    public void serializePoint(Element element, Point value) {
        if (element == null) {
            throw new IllegalArgumentException("Parameter 'element' must not be null.");
        }
        String xName = String.valueOf(this.name) + ".x";
        String yName = String.valueOf(this.name) + ".y";
        if (value != null) {
            element.setAttribute(xName, Integer.toString(value.x));
            element.setAttribute(yName, Integer.toString(value.y));
        } else {
            element.removeAttribute(xName);
            element.removeAttribute(yName);
        }
    }

    public Point deserializePoint(Attributes attributes) throws SAXException {
        String xName = String.valueOf(this.name) + ".x";
        String yName = String.valueOf(this.name) + ".y";
        Point result = null;
        if (attributes.getValue(xName) != null && attributes.getValue(yName) != null) {
            result = new Point();
            result.x = Attribute.deserializeInteger(attributes, xName);
            result.y = Attribute.deserializeInteger(attributes, yName);
        }
        return result;
    }

    public String toString() {
        return "name=" + this.name + ", dataType=[" + this.dataType + "]";
    }
}

